/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.ChooseFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileEncodingConfigurable
extends PerFileConfigurableBase<Charset> {
    private JPanel myPanel;
    private JCheckBox myTransparentNativeToAsciiCheckBox;
    private JPanel myPropertiesFilesEncodingCombo;
    private JPanel myTablePanel;
    private ComboBox<EncodingProjectManagerImpl.BOMForNewUTF8Files> myBOMForUTF8Combo;
    private HyperlinkLabel myExplanationLabel;
    private Charset myPropsCharset;

    FileEncodingConfigurable(@NotNull Project project) {
        super(project, FileEncodingConfigurable.createMappings(project));
        this.$$$setupUI$$$();
        this.myBOMForUTF8Combo.setModel((ComboBoxModel)new EnumComboBoxModel(EncodingProjectManagerImpl.BOMForNewUTF8Files.class));
        this.myBOMForUTF8Combo.addItemListener(e -> this.updateExplanationLabelText());
        this.myExplanationLabel.setHyperlinkTarget("https://en.wikipedia.org/wiki/Byte_order_mark#UTF-8");
    }

    private void updateExplanationLabelText() {
        EncodingProjectManagerImpl.BOMForNewUTF8Files item = (EncodingProjectManagerImpl.BOMForNewUTF8Files)((Object)this.myBOMForUTF8Combo.getSelectedItem());
        String I = ApplicationNamesInfo.getInstance().getProductName();
        if (item != null) {
            switch (item) {
                case ALWAYS: {
                    this.myExplanationLabel.setHtmlText("<html>" + I + " will add <a>UTF-8 BOM</a> to every created file in UTF-8 encoding</html>");
                    break;
                }
                case NEVER: {
                    this.myExplanationLabel.setHtmlText("<html>" + I + " will NOT add <a>UTF-8 BOM</a> to every created file in UTF-8 encoding</html>");
                    break;
                }
                case WINDOWS_ONLY: {
                    this.myExplanationLabel.setHtmlText("<html>" + I + " will add <a>UTF-8 BOM</a> to every created UTF-8 file only when it's running under Windows.</html>");
                }
            }
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"file.encodings.configurable", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settingsdialog.project.file.encodings";
    }

    @Override
    @NotNull
    public String getId() {
        return "File.Encoding";
    }

    @Override
    protected <S> Object getParameter(@NotNull Key<S> key) {
        if (key == DESCRIPTION) {
            return IdeBundle.message((String)"encodings.dialog.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        }
        if (key == MAPPING_TITLE) {
            return "Encoding";
        }
        if (key == TARGET_TITLE) {
            return "Path";
        }
        if (key == OVERRIDE_QUESTION) {
            return null;
        }
        if (key == OVERRIDE_TITLE) {
            return null;
        }
        if (key == EMPTY_TEXT) {
            return IdeBundle.message((String)"file.encodings.not.configured", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    protected void renderValue(@Nullable Object target2, @NotNull Charset t, @NotNull ColoredTextContainer renderer2) {
        VirtualFile file2 = target2 instanceof VirtualFile ? (VirtualFile)target2 : null;
        EncodingUtil.FailReason result2 = file2 == null || file2.isDirectory() ? null : EncodingUtil.checkCanConvertAndReload(file2);
        String encodingText = t.displayName();
        SimpleTextAttributes attributes = result2 == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        renderer2.append(encodingText + (result2 == null ? "" : " (" + (Object)((Object)result2) + ")"), attributes);
    }

    @Override
    @NotNull
    protected ActionGroup createActionListGroup(@Nullable Object target2, final @NotNull Consumer<? super Charset> onChosen) {
        VirtualFile file2 = target2 instanceof VirtualFile ? (VirtualFile)target2 : null;
        byte[] b = null;
        try {
            b = file2 == null || file2.isDirectory() ? null : file2.contentsToByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] bytes = b;
        Document document = file2 == null ? null : FileDocumentManager.getInstance().getDocument(file2);
        return new ChangeFileEncodingAction(true){

            @Override
            protected boolean chosen(Document document, Editor editor, VirtualFile virtualFile, byte[] bytes, @NotNull Charset charset) {
                onChosen.consume((Object)charset);
                return true;
            }
        }.createActionGroup(file2, null, document, bytes, this.getClearValueText(target2));
    }

    @Override
    @Nullable
    protected String getClearValueText(@Nullable Object target2) {
        if (target2 == null) {
            return "<System Default>";
        }
        return super.getClearValueText(target2);
    }

    @Override
    @Nullable
    protected String getNullValueText(@Nullable Object target2) {
        if (target2 == null) {
            return IdeBundle.message((String)"encoding.name.system.default", (Object[])new Object[]{CharsetToolkit.getDefaultSystemCharset().displayName()});
        }
        return super.getNullValueText(target2);
    }

    @Override
    @NotNull
    protected Collection<Charset> getValueVariants(@Nullable Object target2) {
        return Arrays.asList(CharsetToolkit.getAvailableCharsets());
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        this.myTablePanel.add((Component)super.createComponent(), "Center");
        JPanel p = this.createActionPanel(null, new PerFileConfigurableBase.Value<Charset>(){

            @Override
            public void commit() {
            }

            public Charset get() {
                return FileEncodingConfigurable.this.myPropsCharset;
            }

            public void set(Charset value) {
                FileEncodingConfigurable.this.myPropsCharset = value;
            }
        });
        this.myPropertiesFilesEncodingCombo.add((Component)p, "Center");
        return this.myPanel;
    }

    @Override
    @NotNull
    protected List<Trinity<String, Producer<Charset>, Consumer<Charset>>> getDefaultMappings() {
        EncodingManager app = EncodingManager.getInstance();
        EncodingProjectManagerImpl prj = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        Trinity[] trinityArray = new Trinity[2];
        trinityArray[0] = Trinity.create((Object)"Global Encoding", () -> app.getDefaultCharsetName().isEmpty() ? null : app.getDefaultCharset(), o -> app.setDefaultCharsetName(FileEncodingConfigurable.getCharsetName(o)));
        trinityArray[1] = Trinity.create((Object)"Project Encoding", prj::getConfiguredDefaultCharset, o -> prj.setDefaultCharsetName(FileEncodingConfigurable.getCharsetName(o)));
        return Arrays.asList(trinityArray);
    }

    @Override
    protected Charset adjustChosenValue(@Nullable Object target2, Charset chosen) {
        return chosen == ChooseFileEncodingAction.NO_ENCODING ? null : chosen;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        boolean same = Comparing.equal((Object)encodingManager.getDefaultCharsetForPropertiesFiles(null), (Object)this.myPropsCharset) && encodingManager.isNative2AsciiForPropertiesFiles() == this.myTransparentNativeToAsciiCheckBox.isSelected() && encodingManager.getBOMForNewUTF8Files() == this.myBOMForUTF8Combo.getSelectedItem();
        return !same;
    }

    @NotNull
    private static String getCharsetName(@Nullable Charset c) {
        return c == null ? "" : c.name();
    }

    @Override
    public void apply() throws ConfigurationException {
        super.apply();
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        encodingManager.setDefaultCharsetForPropertiesFiles(null, this.myPropsCharset);
        encodingManager.setNative2AsciiForPropertiesFiles(null, this.myTransparentNativeToAsciiCheckBox.isSelected());
        EncodingProjectManagerImpl.BOMForNewUTF8Files option2 = (EncodingProjectManagerImpl.BOMForNewUTF8Files)((Object)ObjectUtils.notNull((Object)((Object)((EncodingProjectManagerImpl.BOMForNewUTF8Files)((Object)this.myBOMForUTF8Combo.getSelectedItem()))), (Object)((Object)EncodingProjectManagerImpl.BOMForNewUTF8Files.NEVER)));
        encodingManager.setBOMForNewUtf8Files(option2);
    }

    @Override
    public void reset() {
        EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject);
        this.myTransparentNativeToAsciiCheckBox.setSelected(encodingManager.isNative2AsciiForPropertiesFiles());
        this.myPropsCharset = encodingManager.getDefaultCharsetForPropertiesFiles(null);
        this.myBOMForUTF8Combo.setSelectedItem((Object)encodingManager.getBOMForNewUTF8Files());
        super.reset();
    }

    @Override
    protected boolean canEditTarget(@Nullable Object target2, Charset value) {
        return target2 == null || target2 instanceof VirtualFile && (((VirtualFile)target2).isDirectory() || EncodingUtil.checkCanConvertAndReload((VirtualFile)target2) == null);
    }

    @NotNull
    private static PerFileMappings<Charset> createMappings(@NotNull Project project) {
        final EncodingProjectManagerImpl prjManager = (EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)project);
        return new PerFileMappings<Charset>(){

            @NotNull
            public Map<VirtualFile, Charset> getMappings() {
                return prjManager.getAllMappings();
            }

            public void setMappings(@NotNull Map<VirtualFile, Charset> mappings) {
                prjManager.setMapping(mappings);
            }

            public void setMapping(@Nullable VirtualFile file2, Charset value) {
                throw new UnsupportedOperationException();
            }

            public Charset getMapping(@Nullable VirtualFile file2) {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public Charset getDefaultMapping(@Nullable VirtualFile file2) {
                return prjManager.getEncoding(file2, true);
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        ComboBox comboBox2;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Properties Files (*.properties)", (int)0, (int)0, null, null));
        this.myPropertiesFilesEncodingCombo = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.default.encoding.for.properties.files"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTransparentNativeToAsciiCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.transparent.native.to.ascii.conversion"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"BOM for new UTF-8 files", (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Create UTF-8 files:");
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBOMForUTF8Combo = comboBox2 = new ComboBox();
        jPanel5.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        this.myExplanationLabel = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setText("");
        jPanel5.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 2, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

