/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDataImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDirectoryImpl;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyFileSystem
extends DeprecatedVirtualFileSystem
implements NonPhysicalFileSystem {
    @NonNls
    public static final String PROTOCOL = "dummy";
    private VirtualFileDirectoryImpl myRoot;

    public static DummyFileSystem getInstance() {
        return (DummyFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DummyFileSystem() {
        this.startEventPropagation();
    }

    public VirtualFile createRoot(String name) {
        this.myRoot = new VirtualFileDirectoryImpl(this, null, name);
        this.fireFileCreated(null, this.myRoot);
        return this.myRoot;
    }

    @Nullable
    public VirtualFile findById(int id) {
        return DummyFileSystem.findById(id, this.myRoot);
    }

    @Nullable
    private static VirtualFile findById(int id, VirtualFileImpl r) {
        if (r == null) {
            return null;
        }
        if (r.getId() == id) {
            return r;
        }
        VirtualFile[] children2 = r.getChildren();
        if (children2 != null) {
            for (VirtualFile f : children2) {
                VirtualFile child2 = DummyFileSystem.findById(id, (VirtualFileImpl)f);
                if (child2 == null) continue;
                return child2;
            }
        }
        return null;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        return null;
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        return path;
    }

    public void refresh(boolean asynchronous) {
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        this.fireBeforeFileDeletion(requestor, vFile);
        VirtualFileDirectoryImpl parent = (VirtualFileDirectoryImpl)vFile.getParent();
        if (parent == null) {
            throw new IOException(VfsBundle.message((String)"file.delete.root.error", (Object[])new Object[]{vFile.getPresentableUrl()}));
        }
        parent.removeChild((VirtualFileImpl)vFile);
        this.fireFileDeleted(requestor, vFile, vFile.getName(), parent);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        String oldName = vFile.getName();
        this.fireBeforePropertyChange(requestor, vFile, "name", oldName, newName);
        ((VirtualFileImpl)vFile).setName(newName);
        this.firePropertyChanged(requestor, vFile, "name", oldName, newName);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName2) throws IOException {
        VirtualFileDirectoryImpl dir = (VirtualFileDirectoryImpl)vDir;
        VirtualFileDataImpl child2 = new VirtualFileDataImpl(this, dir, fileName2);
        dir.addChild(child2);
        this.fireFileCreated(requestor, child2);
        return child2;
    }

    public void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file2) {
        super.fireBeforeContentsChange(requestor, file2);
    }

    public void fireContentsChanged(Object requestor, @NotNull VirtualFile file2, long oldModificationStamp) {
        super.fireContentsChanged(requestor, file2, oldModificationStamp);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        VirtualFileDirectoryImpl dir = (VirtualFileDirectoryImpl)vDir;
        VirtualFileDirectoryImpl child2 = new VirtualFileDirectoryImpl(this, dir, dirName);
        dir.addChild(child2);
        this.fireFileCreated(requestor, child2);
        return child2;
    }
}

