/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFileManagerImpl");
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector = new KeyedExtensionCollector<VirtualFileSystem, String>("com.intellij.virtualFileSystem", (Disposable)this){

        @NotNull
        protected String keyToString(@NotNull String key) {
            return key;
        }
    };
    private final VirtualFileSystem[] myPhysicalFileSystems;
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
    private final List<VirtualFileManagerListener> myVirtualFileManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myRefreshCount;

    public VirtualFileManagerImpl(@NotNull VirtualFileSystem[] fileSystems, @NotNull MessageBus bus) {
        this.myPhysicalFileSystems = fileSystems;
        for (VirtualFileSystem fileSystem : fileSystems) {
            this.myCollector.addExplicitExtension((Object)fileSystem.getProtocol(), (Object)fileSystem);
            if (fileSystem instanceof CachingVirtualFileSystem) continue;
            fileSystem.addVirtualFileListener((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        if (LOG.isDebugEnabled() && !ApplicationInfoImpl.isInStressTest()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    public void dispose() {
    }

    public long getStructureModificationCount() {
        return 0L;
    }

    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List systems = this.myCollector.forKey((Object)protocol);
        int size = systems.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            LOG.error(protocol + ": " + systems);
        }
        return (VirtualFileSystem)systems.get(0);
    }

    public long syncRefresh() {
        return this.doRefresh(false, null);
    }

    public long asyncRefresh(@Nullable Runnable postAction) {
        return this.doRefresh(true, postAction);
    }

    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        for (VirtualFileSystem fileSystem : this.myPhysicalFileSystems) {
            if (fileSystem instanceof CachingVirtualFileSystem) continue;
            fileSystem.refresh(asynchronous);
        }
        return 0L;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        for (VirtualFileSystem fileSystem : this.myPhysicalFileSystems) {
            if (fileSystem instanceof CachingVirtualFileSystem) {
                ((CachingVirtualFileSystem)fileSystem).refreshWithoutFileWatcher(asynchronous);
                continue;
            }
            fileSystem.refresh(asynchronous);
        }
    }

    public VirtualFile findFileByUrl(@NotNull String url) {
        VirtualFileSystem fileSystem = this.getFileSystemForUrl(url);
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.findFileByPath(VirtualFileManagerImpl.extractPath((String)url));
    }

    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        VirtualFileSystem fileSystem = this.getFileSystemForUrl(url);
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.refreshAndFindFileByPath(VirtualFileManagerImpl.extractPath((String)url));
    }

    @Nullable
    private VirtualFileSystem getFileSystemForUrl(String url) {
        String protocol = VirtualFileManagerImpl.extractProtocol((String)url);
        if (protocol == null) {
            return null;
        }
        return this.getFileSystem(protocol);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener2);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        this.myVirtualFileListenerMulticaster.removeListener((EventListener)listener2);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2) {
        this.myVirtualFileManagerListeners.add(listener2);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.addVirtualFileManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeVirtualFileManagerListener(listener2));
    }

    public void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener2) {
        this.myVirtualFileManagerListeners.remove(listener2);
    }

    public void notifyPropertyChanged(@NotNull VirtualFile virtualFile, @VirtualFile.PropName @NotNull String property, Object oldValue, Object newValue) {
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> {
            if (virtualFile.isValid() && !app.isDisposed()) {
                app.runWriteAction(() -> {
                    List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, virtualFile, property, oldValue, newValue, false));
                    BulkFileListener listener2 = (BulkFileListener)app.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                    listener2.before(events);
                    listener2.after(events);
                });
            }
        }, ModalityState.NON_MODAL);
    }

    @Override
    public void fireBeforeRefreshStart(boolean asynchronous) {
        if (this.myRefreshCount++ == 0) {
            for (VirtualFileManagerListener listener2 : this.myVirtualFileManagerListeners) {
                try {
                    listener2.beforeRefreshStart(asynchronous);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public void fireAfterRefreshFinish(boolean asynchronous) {
        if (--this.myRefreshCount == 0) {
            for (VirtualFileManagerListener listener2 : this.myVirtualFileManagerListeners) {
                try {
                    listener2.afterRefreshFinish(asynchronous);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public long getModificationCount() {
        return 0L;
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            LOG.debug("propertyChanged: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            LOG.debug("contentsChanged: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            LOG.debug("fileCreated: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            LOG.debug("fileDeleted: file = " + event.getFile() + ", parent = " + event.getParent() + ", requestor = " + event.getRequestor());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            LOG.debug("fileMoved: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            LOG.debug("fileCopied: file = " + event.getFile() + "originalFile = " + event.getOriginalFile() + ", requestor = " + event.getRequestor());
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            LOG.debug("beforeContentsChange: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            LOG.debug("beforePropertyChange: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            LOG.debug("beforeFileDeletion: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            LOG.debug("beforeFileMovement: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }
    }
}

