/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerContainerImpl
extends TraceableDisposable
implements VirtualFilePointerContainer,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer");
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myList = ContainerUtil.createConcurrentList();
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myJarDirectories = ContainerUtil.createConcurrentList();
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myJarRecursiveDirectories = ContainerUtil.createConcurrentList();
    @NotNull
    private final VirtualFilePointerManager myVirtualFilePointerManager;
    @NotNull
    private final Disposable myParent;
    private final VirtualFilePointerListener myListener;
    private volatile Trinity<String[], VirtualFile[], VirtualFile[]> myCachedThings;
    private volatile long myTimeStampOfCachedThings = -1L;
    @NonNls
    public static final String URL_ATTR = "url";
    private boolean myDisposed;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    @NonNls
    public static final String JAR_DIRECTORY_ELEMENT = "jarDirectory";
    @NonNls
    public static final String RECURSIVE_ATTR = "recursive";
    private static final Trinity<String[], VirtualFile[], VirtualFile[]> EMPTY = Trinity.create((Object)ArrayUtil.EMPTY_STRING_ARRAY, (Object)VirtualFile.EMPTY_ARRAY, (Object)VirtualFile.EMPTY_ARRAY);

    VirtualFilePointerContainerImpl(@NotNull VirtualFilePointerManager manager, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        super(TRACE_CREATION && !ApplicationInfoImpl.isInStressTest());
        this.myVirtualFilePointerManager = manager;
        this.myParent = parentDisposable;
        this.myListener = listener2;
    }

    public void readExternal(@NotNull Element rootChild, @NotNull String childName, boolean externalizeJarDirectories) throws InvalidDataException {
        List urls = rootChild.getChildren(childName);
        this.addAll(ContainerUtil.map((Collection)urls, url -> url.getAttributeValue(URL_ATTR)));
        if (externalizeJarDirectories) {
            List jarDirs = rootChild.getChildren(JAR_DIRECTORY_ELEMENT);
            for (Element jarDir : jarDirs) {
                String url2 = jarDir.getAttributeValue(URL_ATTR);
                if (url2 == null) {
                    throw new InvalidDataException("path element without url: " + JDOMUtil.getValue((Object)jarDir));
                }
                boolean recursive = Boolean.valueOf(jarDir.getAttributeValue(RECURSIVE_ATTR, "false"));
                this.addJarDirectory(url2, recursive);
            }
        }
    }

    public void writeExternal(@NotNull Element element, @NotNull String childElementName, boolean externalizeJarDirectories) {
        for (VirtualFilePointer pointer : this.myList) {
            String url = pointer.getUrl();
            Element rootPathElement = new Element(childElementName);
            rootPathElement.setAttribute(URL_ATTR, url);
            element.addContent(rootPathElement);
        }
        if (externalizeJarDirectories) {
            VirtualFilePointerContainerImpl.writeJarDirs(this.myJarDirectories, element, false);
            VirtualFilePointerContainerImpl.writeJarDirs(this.myJarRecursiveDirectories, element, true);
        }
    }

    private static void writeJarDirs(@NotNull List<VirtualFilePointer> myJarDirectories, @NotNull Element element, boolean recursive) {
        ArrayList<VirtualFilePointer> jarDirectories = new ArrayList<VirtualFilePointer>(myJarDirectories);
        Collections.sort(jarDirectories, Comparator.comparing(VirtualFilePointer::getUrl, String.CASE_INSENSITIVE_ORDER));
        for (VirtualFilePointer pointer : jarDirectories) {
            String url = pointer.getUrl();
            Element jarDirElement = new Element(JAR_DIRECTORY_ELEMENT);
            jarDirElement.setAttribute(URL_ATTR, url);
            jarDirElement.setAttribute(RECURSIVE_ATTR, Boolean.toString(recursive));
            element.addContent(jarDirElement);
        }
    }

    public void moveUp(@NotNull String url) {
        int index = this.indexOf(url);
        if (index <= 0) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)(index - 1), (int)index);
    }

    public void moveDown(@NotNull String url) {
        int index = this.indexOf(url);
        if (index < 0 || index + 1 >= this.myList.size()) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, (int)index, (int)(index + 1));
    }

    private int indexOf(@NotNull String url) {
        for (int i = 0; i < this.myList.size(); ++i) {
            VirtualFilePointer pointer = (VirtualFilePointer)this.myList.get(i);
            if (!url.equals(pointer.getUrl())) continue;
            return i;
        }
        return -1;
    }

    public void killAll() {
        this.myList.clear();
    }

    public void add(@NotNull VirtualFile file2) {
        assert (!this.myDisposed);
        this.dropCaches();
        this.myList.addIfAbsent((Object)this.create(file2));
    }

    public void add(@NotNull String url) {
        assert (!this.myDisposed);
        this.dropCaches();
        this.myList.addIfAbsent((Object)this.create(url));
    }

    public void remove(@NotNull VirtualFilePointer pointer) {
        assert (!this.myDisposed);
        this.dropCaches();
        boolean result2 = this.myList.remove((Object)pointer);
        LOG.assertTrue(result2);
    }

    @NotNull
    public List<VirtualFilePointer> getList() {
        assert (!this.myDisposed);
        return Collections.unmodifiableList(this.myList);
    }

    public void addAll(@NotNull VirtualFilePointerContainer that) {
        assert (!this.myDisposed);
        this.dropCaches();
        this.addAll(Arrays.asList(that.getUrls()));
        List jarDups = ContainerUtil.map(((VirtualFilePointerContainerImpl)that).myJarDirectories, this::duplicate);
        List jarRecursiveDups = ContainerUtil.map(((VirtualFilePointerContainerImpl)that).myJarRecursiveDirectories, this::duplicate);
        this.myJarDirectories.addAllAbsent((Collection)jarDups);
        this.myJarRecursiveDirectories.addAllAbsent((Collection)jarRecursiveDups);
    }

    public void addAll(@NotNull Collection<String> urls) {
        this.myList.addAllAbsent((Collection)ContainerUtil.map(urls, url -> this.create((String)url)));
    }

    private void dropCaches() {
        this.myTimeStampOfCachedThings = -1L;
        this.myCachedThings = EMPTY;
    }

    @NotNull
    public String[] getUrls() {
        return (String[])this.getOrCache().first;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> getOrCache() {
        assert (!this.myDisposed);
        long timeStamp = this.myTimeStampOfCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> cached = this.myCachedThings;
        return timeStamp == this.myVirtualFilePointerManager.getModificationCount() ? cached : this.cacheThings();
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> cacheThings() {
        Trinity result2;
        if (this.myList.isEmpty() && this.myJarDirectories.isEmpty() && this.myJarRecursiveDirectories.isEmpty()) {
            result2 = EMPTY;
        } else {
            VirtualFile jarDirectory;
            final ArrayList<VirtualFile> cachedFiles = new ArrayList<VirtualFile>(this.myList.size());
            ArrayList<String> cachedUrls = new ArrayList<String>(this.myList.size());
            final ArrayList<VirtualFile> cachedDirectories = new ArrayList<VirtualFile>(this.myList.size() / 3);
            boolean allFilesAreDirs = true;
            for (VirtualFilePointer v : this.myList) {
                VirtualFile file2 = v.getFile();
                String url = v.getUrl();
                cachedUrls.add(url);
                if (file2 == null) continue;
                cachedFiles.add(file2);
                if (file2.isDirectory()) {
                    cachedDirectories.add(file2);
                    continue;
                }
                allFilesAreDirs = false;
            }
            for (VirtualFilePointer jarDirectoryPtr : this.myJarDirectories) {
                VirtualFile[] children2;
                jarDirectory = jarDirectoryPtr.getFile();
                if (jarDirectory == null) continue;
                cachedDirectories.remove(jarDirectory);
                for (VirtualFile file3 : children2 = jarDirectory.getChildren()) {
                    VirtualFile jarRoot;
                    if (file3.isDirectory() || FileTypeRegistry.getInstance().getFileTypeByFileName(file3.getNameSequence()) != ArchiveFileType.INSTANCE || (jarRoot = StandardFileSystems.jar().findFileByPath(file3.getPath() + "!/")) == null) continue;
                    cachedFiles.add(jarRoot);
                    cachedDirectories.add(jarRoot);
                }
            }
            for (VirtualFilePointer jarDirectoryPtr : this.myJarRecursiveDirectories) {
                jarDirectory = jarDirectoryPtr.getFile();
                if (jarDirectory == null) continue;
                cachedDirectories.remove(jarDirectory);
                VfsUtilCore.visitChildrenRecursively((VirtualFile)jarDirectory, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file2) {
                        VirtualFile jarRoot;
                        if (!file2.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file2.getPath() + "!/")) != null) {
                            cachedFiles.add(jarRoot);
                            cachedDirectories.add(jarRoot);
                            return false;
                        }
                        return true;
                    }
                });
            }
            VirtualFile[] directories = VfsUtilCore.toVirtualFileArray(cachedDirectories);
            VirtualFile[] files2 = allFilesAreDirs ? directories : VfsUtilCore.toVirtualFileArray(cachedFiles);
            String[] urlsArray = ArrayUtil.toStringArray(cachedUrls);
            result2 = Trinity.create((Object)urlsArray, (Object)files2, (Object)directories);
        }
        this.myCachedThings = result2;
        this.myTimeStampOfCachedThings = this.myVirtualFilePointerManager.getModificationCount();
        return result2;
    }

    @NotNull
    public VirtualFile[] getFiles() {
        return (VirtualFile[])this.getOrCache().second;
    }

    @NotNull
    public VirtualFile[] getDirectories() {
        return (VirtualFile[])this.getOrCache().third;
    }

    @Nullable
    public VirtualFilePointer findByUrl(@NotNull String url) {
        assert (!this.myDisposed);
        for (VirtualFilePointer pointer : ContainerUtil.concat((List[])new List[]{this.myList, this.myJarDirectories, this.myJarRecursiveDirectories})) {
            if (!url.equals(pointer.getUrl())) continue;
            return pointer;
        }
        return null;
    }

    public void clear() {
        this.dropCaches();
        this.killAll();
    }

    public int size() {
        return this.myList.size() + this.myJarDirectories.size() + this.myJarRecursiveDirectories.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFilePointerContainerImpl)) {
            return false;
        }
        VirtualFilePointerContainerImpl impl = (VirtualFilePointerContainerImpl)((Object)o);
        return this.myList.equals(impl.myList) && this.myJarDirectories.equals(impl.myJarDirectories) && this.myJarRecursiveDirectories.equals(impl.myJarRecursiveDirectories);
    }

    public int hashCode() {
        return this.myList.hashCode();
    }

    @NotNull
    protected VirtualFilePointer create(@NotNull VirtualFile file2) {
        return this.myVirtualFilePointerManager.create(file2, this.myParent, this.myListener);
    }

    @NotNull
    protected VirtualFilePointer create(@NotNull String url) {
        return this.myVirtualFilePointerManager.create(url, this.myParent, this.myListener);
    }

    @NotNull
    protected VirtualFilePointer duplicate(@NotNull VirtualFilePointer virtualFilePointer) {
        return this.myVirtualFilePointerManager.duplicate(virtualFilePointer, this.myParent, this.myListener);
    }

    @NotNull
    @NonNls
    public String toString() {
        return "VFPContainer: " + this.myList + (this.myJarDirectories.isEmpty() ? "" : ", jars: " + this.myJarDirectories) + (this.myJarRecursiveDirectories.isEmpty() ? "" : ", jars(recursively): " + this.myJarRecursiveDirectories);
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent) {
        return this.clone(parent, null);
    }

    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        assert (!this.myDisposed);
        VirtualFilePointerContainerImpl clone = (VirtualFilePointerContainerImpl)this.myVirtualFilePointerManager.createContainer(parent, listener2);
        List toAdd = ContainerUtil.map(this.myList, p -> clone.create(p.getUrl()));
        clone.myList.addAll((Collection)toAdd);
        clone.addAllJarDirectories(ContainerUtil.map(this.myJarDirectories, VirtualFilePointer::getUrl), false);
        clone.addAllJarDirectories(ContainerUtil.map(this.myJarRecursiveDirectories, VirtualFilePointer::getUrl), true);
        return clone;
    }

    public void dispose() {
        assert (!this.myDisposed);
        this.myDisposed = true;
        this.kill(null);
        this.clear();
    }

    public void addJarDirectory(@NotNull String directoryUrl, boolean recursively) {
        VirtualFilePointer pointer = this.myVirtualFilePointerManager.createDirectoryPointer(directoryUrl, recursively, this.myParent, this.myListener);
        (recursively ? this.myJarRecursiveDirectories : this.myJarDirectories).addIfAbsent((Object)pointer);
        this.myList.addIfAbsent((Object)pointer);
        this.dropCaches();
    }

    public void addAllJarDirectories(@NotNull Collection<String> directoryUrls, boolean recursively) {
        if (directoryUrls.isEmpty()) {
            return;
        }
        List pointers = ContainerUtil.map(directoryUrls, url -> this.myVirtualFilePointerManager.createDirectoryPointer(url, recursively, this.myParent, this.myListener));
        (recursively ? this.myJarRecursiveDirectories : this.myJarDirectories).addAllAbsent((Collection)pointers);
        this.myList.addAllAbsent((Collection)pointers);
        this.dropCaches();
    }

    public boolean removeJarDirectory(@NotNull String directoryUrl) {
        this.dropCaches();
        Predicate<VirtualFilePointer> filter = ptr -> FileUtil.pathsEqual((String)ptr.getUrl(), (String)directoryUrl);
        boolean removed0 = this.myList.removeIf(filter);
        boolean removed1 = this.myJarDirectories.removeIf(filter);
        boolean removed2 = this.myJarRecursiveDirectories.removeIf(filter);
        return removed0 || removed1 || removed2;
    }

    @NotNull
    public List<Pair<String, Boolean>> getJarDirectories() {
        List jars = ContainerUtil.map(this.myJarDirectories, ptr -> Pair.create((Object)ptr.getUrl(), (Object)false));
        List recJars = ContainerUtil.map(this.myJarRecursiveDirectories, ptr -> Pair.create((Object)ptr.getUrl(), (Object)true));
        return ContainerUtil.concat((List)jars, (List)recJars);
    }
}

