/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfpCapableArchiveFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.FilePointerPartNode;
import com.intellij.openapi.vfs.impl.IdentityVirtualFilePointer;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFilePointerManagerImpl
extends VirtualFilePointerManager
implements Disposable,
BulkFileListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl");
    private static final Comparator<String> URL_COMPARATOR = SystemInfo.isFileSystemCaseSensitive ? String::compareTo : String::compareToIgnoreCase;
    static final boolean IS_UNDER_UNIT_TEST = ApplicationManager.getApplication().isUnitTestMode();
    private final TempFileSystem TEMP_FILE_SYSTEM;
    private final LocalFileSystem LOCAL_FILE_SYSTEM;
    private static final VirtualFilePointerListener NULL_LISTENER = new VirtualFilePointerListener(){};
    private final Map<VirtualFilePointerListener, FilePointerPartNode> myPointers = ContainerUtil.newIdentityTroveMap();
    private final Set<VirtualFilePointerContainerImpl> myContainers = ContainerUtil.newIdentityTroveSet();
    @NotNull
    private final VirtualFileManager myVirtualFileManager;
    @NotNull
    private final MessageBus myBus;
    @NotNull
    private final FileTypeManager myFileTypeManager;
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity = new THashMap();
    private List<EventDescriptor> myEvents = Collections.emptyList();
    private List<FilePointerPartNode> myNodesToUpdateUrl = Collections.emptyList();
    private List<FilePointerPartNode> myNodesToFire = Collections.emptyList();

    VirtualFilePointerManagerImpl(@NotNull VirtualFileManager virtualFileManager, @NotNull MessageBus bus, @NotNull TempFileSystem tempFileSystem, @NotNull LocalFileSystem localFileSystem2, @NotNull FileTypeManager fileTypeManager) {
        this.myVirtualFileManager = virtualFileManager;
        this.myBus = bus;
        this.myFileTypeManager = fileTypeManager;
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        this.TEMP_FILE_SYSTEM = tempFileSystem;
        this.LOCAL_FILE_SYSTEM = localFileSystem2;
    }

    public void dispose() {
        this.assertAllPointersDisposed();
    }

    @NotNull
    private static VirtualFilePointer[] toPointers(@NotNull List<? extends FilePointerPartNode> nodes) {
        if (nodes.isEmpty()) {
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        ArrayList list2 = new ArrayList(nodes.size());
        for (FilePointerPartNode filePointerPartNode : nodes) {
            filePointerPartNode.addAllPointersTo(list2);
        }
        return list2.toArray(VirtualFilePointer.EMPTY_ARRAY);
    }

    @NotNull
    synchronized VirtualFilePointer[] getPointersUnder(@NotNull VirtualFile parent, @NotNull String childName) {
        ArrayList nodes = new ArrayList();
        this.addRelevantPointers(parent, true, childName, nodes, true);
        return VirtualFilePointerManagerImpl.toPointers(nodes);
    }

    private void addRelevantPointers(VirtualFile parent, boolean separator, @NotNull CharSequence childName, @NotNull List<? super FilePointerPartNode> out, boolean addSubdirectoryPointers) {
        for (FilePointerPartNode root : this.myPointers.values()) {
            root.addRelevantPointersFrom(parent, separator, childName, out, addSubdirectoryPointers);
        }
    }

    @NotNull
    public VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        return this.create(null, url, parent, listener2, false);
    }

    @NotNull
    public VirtualFilePointer create(@NotNull VirtualFile file2, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        return this.create(file2, null, parent, listener2, false);
    }

    @NotNull
    private VirtualFilePointer create(@Nullable(value="null means the pointer will be created from the (not null) url") VirtualFile file2, @Nullable(value="null means url has to be computed from the (not-null) file path") String url, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2, boolean recursive) {
        String path;
        VirtualFileSystem fileSystem;
        String protocol;
        if (file2 == null) {
            int protocolEnd = url.indexOf("://");
            if (protocolEnd == -1) {
                protocol = null;
                fileSystem = null;
                path = url;
            } else {
                protocol = url.substring(0, protocolEnd);
                fileSystem = this.myVirtualFileManager.getFileSystem(protocol);
                path = url.substring(protocolEnd + "://".length());
            }
        } else {
            fileSystem = file2.getFileSystem();
            protocol = fileSystem.getProtocol();
            path = file2.getPath();
            url = VirtualFileManager.constructUrl((String)protocol, (String)path);
        }
        if (fileSystem == this.TEMP_FILE_SYSTEM) {
            VirtualFile found = file2 == null ? VirtualFileManager.getInstance().findFileByUrl(url) : file2;
            return found == null ? new LightFilePointer(url) : new LightFilePointer(found);
        }
        boolean isJar = fileSystem instanceof VfpCapableArchiveFileSystem;
        if (fileSystem != this.LOCAL_FILE_SYSTEM && !isJar) {
            VirtualFile found = fileSystem == null ? null : (file2 != null ? file2 : VirtualFileManager.getInstance().findFileByUrl(url));
            return this.getOrCreateIdentity(url, found, recursive, parentDisposable, listener2);
        }
        if (file2 == null) {
            String cleanPath = VirtualFilePointerManagerImpl.cleanupPath(path, isJar);
            if (cleanPath != path) {
                url = VirtualFileManager.constructUrl((String)protocol, (String)cleanPath);
                path = cleanPath;
            }
            if (url.contains("..") && (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) != null) {
                url = file2.getUrl();
                path = file2.getPath();
            }
        }
        return this.getOrCreate(path, file2, url, recursive, parentDisposable, listener2);
    }

    @NotNull
    private synchronized IdentityVirtualFilePointer getOrCreateIdentity(final @NotNull String url, @Nullable VirtualFile found, boolean recursive, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        IdentityVirtualFilePointer pointer = this.myUrlToIdentity.get(url);
        if (pointer == null) {
            pointer = new IdentityVirtualFilePointer(found, url, listener2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void dispose() {
                    VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = VirtualFilePointerManagerImpl.this;
                    synchronized (virtualFilePointerManagerImpl) {
                        super.dispose();
                        VirtualFilePointerManagerImpl.this.myUrlToIdentity.remove(url);
                    }
                }
            };
            this.myUrlToIdentity.put(url, pointer);
            DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        }
        pointer.incrementUsageCount(1);
        pointer.recursive = recursive;
        return pointer;
    }

    @NotNull
    private static String cleanupPath(@NotNull String path, boolean isJar) {
        path = FileUtil.normalize((String)path);
        path = VirtualFilePointerManagerImpl.trimTrailingSeparators(path, isJar);
        return path;
    }

    private static String trimTrailingSeparators(@NotNull String path, boolean isJar) {
        while (!(!StringUtil.endsWithChar((CharSequence)path, (char)'/') || isJar && path.endsWith("!/"))) {
            path = StringUtil.trimEnd((String)path, (String)"/");
        }
        return path;
    }

    @NotNull
    private synchronized VirtualFilePointerImpl getOrCreate(@NotNull String path, @Nullable VirtualFile file2, @NotNull String url, boolean recursive, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        FilePointerPartNode node;
        VirtualFilePointerListener nl = (VirtualFilePointerListener)ObjectUtils.notNull((Object)listener2, (Object)NULL_LISTENER);
        FilePointerPartNode root = this.myPointers.get(nl);
        Pair fileAndUrl = Pair.create((Object)file2, (Object)url);
        if (root == null) {
            root = new FilePointerPartNode(path, null, (Pair<VirtualFile, String>)fileAndUrl, 1);
            this.myPointers.put(nl, root);
            node = root;
        } else {
            node = root.findPointerOrCreate(path, 0, (Pair<VirtualFile, String>)fileAndUrl, 1);
        }
        VirtualFilePointerImpl pointer = node.getAnyPointer();
        if (pointer == null) {
            pointer = new VirtualFilePointerImpl(listener2);
            node.associate((Object)pointer, (Pair<VirtualFile, String>)fileAndUrl);
        }
        pointer.incrementUsageCount(1);
        pointer.recursive = recursive;
        root.checkConsistency();
        DelegatingDisposable.registerDisposable(parentDisposable, pointer);
        return pointer;
    }

    @NotNull
    public VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        VirtualFile file2 = pointer.getFile();
        return file2 == null ? this.create(pointer.getUrl(), parent, listener2) : this.create(file2, parent, listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void assertAllPointersDisposed() {
        for (FilePointerPartNode root : this.myPointers.values()) {
            ArrayList left = new ArrayList();
            root.addRelevantPointersFrom(null, false, "", left, true);
            ArrayList pointers = new ArrayList();
            for (FilePointerPartNode node : left) {
                node.addAllPointersTo(pointers);
            }
            if (pointers.isEmpty()) continue;
            VirtualFilePointerImpl p = (VirtualFilePointerImpl)((Object)pointers.get(0));
            try {
                p.throwDisposalError("Not disposed pointer: " + (Object)((Object)p));
            }
            finally {
                for (VirtualFilePointerImpl pointer : pointers) {
                    pointer.dispose();
                }
            }
        }
        Set<VirtualFilePointerContainerImpl> set2 = this.myContainers;
        synchronized (set2) {
            if (!this.myContainers.isEmpty()) {
                VirtualFilePointerContainerImpl container = this.myContainers.iterator().next();
                container.throwDisposalError("Not disposed container");
            }
        }
    }

    synchronized void addAllPointersTo(@NotNull Collection<? super VirtualFilePointerImpl> pointers) {
        ArrayList out = new ArrayList();
        this.addRelevantPointers(null, false, "", out, true);
        for (FilePointerPartNode node : out) {
            node.addAllPointersTo(pointers);
        }
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        return this.createContainer(parent, null);
    }

    @NotNull
    public synchronized VirtualFilePointerContainer createContainer(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        return this.registerContainer(parent, new VirtualFilePointerContainerImpl(this, parent, listener2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VirtualFilePointerContainer registerContainer(@NotNull Disposable parent, final @NotNull VirtualFilePointerContainerImpl container) {
        Set<VirtualFilePointerContainerImpl> set2 = this.myContainers;
        synchronized (set2) {
            this.myContainers.add(container);
        }
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                boolean removed;
                Disposer.dispose((Disposable)container);
                Set set2 = VirtualFilePointerManagerImpl.this.myContainers;
                synchronized (set2) {
                    removed = VirtualFilePointerManagerImpl.this.myContainers.remove((Object)container);
                }
                if (!IS_UNDER_UNIT_TEST) assert (removed);
            }

            public String toString() {
                return "Disposing container " + (Object)((Object)container);
            }
        });
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before(@NotNull List<? extends VFileEvent> events) {
        Object[] toFirePointers;
        ArrayList<EventDescriptor> eventList;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FilePointerPartNode> toFireEvents = new ArrayList<FilePointerPartNode>();
        ArrayList<FilePointerPartNode> toUpdateUrl = new ArrayList<FilePointerPartNode>();
        Object object = this;
        synchronized (object) {
            this.incModificationCount();
            for (VFileEvent vFileEvent : events) {
                VFilePropertyChangeEvent change;
                VirtualFile eventFile;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                    this.addRelevantPointers(deleteEvent.getFile(), false, "", toFireEvents, true);
                    continue;
                }
                if (vFileEvent instanceof VFileCreateEvent) {
                    boolean fireSubdirectoryPointers;
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    String createdFileName = createEvent.getChildName();
                    if (createEvent.isDirectory()) {
                        fireSubdirectoryPointers = !createEvent.isEmptyDirectory();
                    } else {
                        FileType fileType = this.myFileTypeManager.getFileTypeByExtension(FileUtilRt.getExtension((String)createdFileName));
                        fireSubdirectoryPointers = fileType instanceof ArchiveFileType;
                    }
                    this.addRelevantPointers(createEvent.getParent(), true, createdFileName, toFireEvents, fireSubdirectoryPointers);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.addRelevantPointers(copyEvent.getNewParent(), true, copyEvent.getNewChildName(), toFireEvents, true);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    eventFile = moveEvent.getFile();
                    this.addRelevantPointers(moveEvent.getNewParent(), true, eventFile.getName(), toFireEvents, true);
                    ArrayList nodes = new ArrayList();
                    this.addRelevantPointers(eventFile, false, "", nodes, true);
                    toFireEvents.addAll(nodes);
                    VirtualFilePointerManagerImpl.collectNodes(nodes, toUpdateUrl);
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((change = (VFilePropertyChangeEvent)vFileEvent).getPropertyName()) || Comparing.equal((Object)change.getOldValue(), (Object)change.getNewValue())) continue;
                eventFile = change.getFile();
                VirtualFile parent = eventFile.getParent();
                this.addRelevantPointers(parent, true, change.getNewValue().toString(), toFireEvents, true);
                ArrayList nodes = new ArrayList();
                this.addRelevantPointers(eventFile, false, "", nodes, true);
                VirtualFilePointerManagerImpl.collectNodes(nodes, toUpdateUrl);
            }
            eventList = new ArrayList<EventDescriptor>();
            this.myEvents = eventList;
            toFirePointers = VirtualFilePointerManagerImpl.toPointers(toFireEvents);
            if (toFirePointers.length != 0) {
                for (VirtualFilePointerListener virtualFilePointerListener : this.myPointers.keySet()) {
                    List filtered;
                    if (virtualFilePointerListener == NULL_LISTENER || (filtered = ContainerUtil.filter((Object[])toFirePointers, pointer -> ((VirtualFilePointerImpl)((Object)((Object)pointer))).getListener() == listener2)).isEmpty()) continue;
                    eventList.add(new EventDescriptor(virtualFilePointerListener, filtered.toArray(VirtualFilePointer.EMPTY_ARRAY)));
                }
            }
        }
        for (EventDescriptor descriptor : eventList) {
            descriptor.fireBefore();
        }
        if (!toFireEvents.isEmpty()) {
            ((VirtualFilePointerListener)this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).beforeValidityChanged((VirtualFilePointer[])toFirePointers);
        }
        object = this;
        synchronized (object) {
            this.myNodesToFire = toFireEvents;
            this.myNodesToUpdateUrl = toUpdateUrl;
        }
        this.assertConsistency();
    }

    private static void collectNodes(List<? extends FilePointerPartNode> nodes, List<? super FilePointerPartNode> toUpdateUrl) {
        for (FilePointerPartNode filePointerPartNode : nodes) {
            VirtualFile file2;
            VirtualFilePointerImpl pointer = filePointerPartNode.getAnyPointer();
            if (pointer == null || (file2 = pointer.getFile()) == null) continue;
            toUpdateUrl.add(filePointerPartNode);
        }
    }

    synchronized void assertConsistency() {
        if (IS_UNDER_UNIT_TEST && !ApplicationInfoImpl.isInStressTest()) {
            for (FilePointerPartNode root : this.myPointers.values()) {
                root.checkConsistency();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.incModificationCount();
        Object object = this;
        synchronized (this) {
            for (FilePointerPartNode node : this.myNodesToUpdateUrl) {
                String urlBefore = (String)node.myFileAndUrl.second;
                Pair<VirtualFile, String> after = node.update();
                assert (after != null) : "can't invalidate inside modification";
                String urlAfter = (String)after.second;
                if (URL_COMPARATOR.compare(urlBefore, urlAfter) == 0 && StringUtil.endsWith((CharSequence)urlAfter, (CharSequence)node.part)) continue;
                SmartList myPointers = new SmartList();
                node.addAllPointersTo((Collection<? super VirtualFilePointerImpl>)myPointers);
                int useCount = node.useCount;
                FilePointerPartNode root = node.remove();
                FilePointerPartNode newNode = root.findPointerOrCreate(VfsUtilCore.urlToPath((String)urlAfter), 0, after, myPointers.size());
                VirtualFilePointerImpl existingPointer = newNode.getAnyPointer();
                if (existingPointer != null) {
                    FilePointerPartNode n = newNode;
                    while (n != null) {
                        n.pointersUnder += myPointers.size();
                        n = n.parent;
                    }
                }
                newNode.addAllPointersTo((Collection<? super VirtualFilePointerImpl>)myPointers);
                Object newMyPointers = myPointers.size() == 1 ? myPointers.get(0) : myPointers.toArray(new VirtualFilePointerImpl[0]);
                newNode.associate(newMyPointers, after);
                newNode.incrementUsageCount(useCount);
            }
            VirtualFilePointer[] pointersToFireArray = VirtualFilePointerManagerImpl.toPointers(this.myNodesToFire);
            List<EventDescriptor> eventList = this.myEvents;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            for (VirtualFilePointer pointer : pointersToFireArray) {
                ((VirtualFilePointerImpl)pointer).myNode.update();
            }
            for (EventDescriptor event : eventList) {
                event.fireAfter();
            }
            if (pointersToFireArray.length != 0) {
                ((VirtualFilePointerListener)this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).validityChanged(pointersToFireArray);
            }
            object = this;
            synchronized (this) {
                this.myNodesToUpdateUrl = Collections.emptyList();
                this.myEvents = Collections.emptyList();
                this.myNodesToFire = Collections.emptyList();
                // ** MonitorExit[var4_2] (shouldn't be in output)
                this.assertConsistency();
                return;
            }
        }
    }

    synchronized void removeNodeFrom(@NotNull VirtualFilePointerImpl pointer) {
        boolean rootNodeEmpty;
        FilePointerPartNode root = pointer.myNode.remove();
        boolean bl = rootNodeEmpty = root.children.length == 0;
        if (rootNodeEmpty) {
            this.myPointers.remove(ObjectUtils.notNull((Object)pointer.getListener(), (Object)NULL_LISTENER));
        }
        pointer.myNode = null;
        this.assertConsistency();
    }

    public long getModificationCount() {
        return super.getModificationCount() + (long)PersistentFS.getInstance().getStructureModificationCount();
    }

    @NotNull
    public VirtualFilePointer createDirectoryPointer(@NotNull String url, boolean recursively, @NotNull Disposable parent, @NotNull VirtualFilePointerListener listener2) {
        return this.create(null, url, parent, listener2, true);
    }

    synchronized int numberOfPointers() {
        int number = 0;
        for (FilePointerPartNode root : this.myPointers.values()) {
            number = root.numberOfPointersUnder();
        }
        return number;
    }

    synchronized int numberOfListeners() {
        return this.myPointers.keySet().size();
    }

    synchronized int numberOfCachedUrlToIdentity() {
        return this.myUrlToIdentity.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shelveAllPointersIn(@NotNull Runnable runnable2) {
        LinkedHashMap<VirtualFilePointerListener, FilePointerPartNode> shelvedPointers;
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this;
        synchronized (virtualFilePointerManagerImpl) {
            shelvedPointers = new LinkedHashMap<VirtualFilePointerListener, FilePointerPartNode>(this.myPointers);
            this.myPointers.clear();
        }
        try {
            runnable2.run();
        }
        finally {
            virtualFilePointerManagerImpl = this;
            synchronized (virtualFilePointerManagerImpl) {
                this.myPointers.clear();
                this.myPointers.putAll(shelvedPointers);
            }
        }
    }

    synchronized Collection<VirtualFilePointer> dumpPointers() {
        THashSet result2 = new THashSet();
        for (FilePointerPartNode node : this.myPointers.values()) {
            VirtualFilePointerManagerImpl.dumpPointersTo(node, (Collection<? super VirtualFilePointer>)result2);
        }
        return result2;
    }

    private static void dumpPointersTo(FilePointerPartNode node, Collection<? super VirtualFilePointer> result2) {
        node.addAllPointersTo(result2);
        for (FilePointerPartNode child2 : node.children) {
            VirtualFilePointerManagerImpl.dumpPointersTo(child2, result2);
        }
    }

    private static class DelegatingDisposable
    implements Disposable {
        private static final ConcurrentMap<Disposable, DelegatingDisposable> ourInstances = ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy());
        private final TObjectIntHashMap<VirtualFilePointerImpl> myCounts = new TObjectIntHashMap(ContainerUtil.identityStrategy());
        private final Disposable myParent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DelegatingDisposable(@NotNull Disposable parent, @NotNull VirtualFilePointerImpl firstPointer) {
            this.myParent = parent;
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                this.myCounts.put((Object)firstPointer, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void registerDisposable(@NotNull Disposable parentDisposable, @NotNull VirtualFilePointerImpl pointer) {
            DelegatingDisposable newDisposable;
            DelegatingDisposable result2 = (DelegatingDisposable)ourInstances.get(parentDisposable);
            if (result2 == null && (result2 = (DelegatingDisposable)ConcurrencyUtil.cacheOrGet(ourInstances, (Object)parentDisposable, (Object)(newDisposable = new DelegatingDisposable(parentDisposable, pointer)))) == newDisposable) {
                Disposer.register((Disposable)parentDisposable, (Disposable)result2);
                return;
            }
            DelegatingDisposable delegatingDisposable = result2;
            synchronized (delegatingDisposable) {
                if (!result2.myCounts.increment((Object)pointer)) {
                    result2.myCounts.put((Object)pointer, 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ourInstances.remove(this.myParent);
            DelegatingDisposable delegatingDisposable = this;
            synchronized (delegatingDisposable) {
                this.myCounts.forEachEntry((pointer, disposeCount) -> {
                    int after = pointer.incrementUsageCount(-disposeCount + 1);
                    LOG.assertTrue(after > 0, (Object)after);
                    pointer.dispose();
                    return true;
                });
            }
        }
    }

    private static class EventDescriptor {
        @NotNull
        private final VirtualFilePointerListener myListener;
        @NotNull
        private final VirtualFilePointer[] myPointers;

        private EventDescriptor(@NotNull VirtualFilePointerListener listener2, @NotNull VirtualFilePointer[] pointers) {
            this.myListener = listener2;
            this.myPointers = pointers;
            if (pointers.length == 0) {
                throw new IllegalArgumentException();
            }
        }

        private void fireBefore() {
            this.myListener.beforeValidityChanged(this.myPointers);
        }

        private void fireAfter() {
            this.myListener.validityChanged(this.myPointers);
        }
    }
}

