/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.vfs.impl.ZipHandlerBase;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.ResourceHandle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ZipHandler
extends ZipHandlerBase {
    private volatile String myCanonicalPathToZip;
    private volatile long myFileStamp;
    private volatile long myFileLength;
    private static final FileAccessorCache<ZipHandler, ZipFile> ourZipFileFileAccessorCache = new FileAccessorCache<ZipHandler, ZipFile>(20, 10){

        @NotNull
        protected ZipFile createAccessor(ZipHandler handler2) throws IOException {
            String canonicalPathToZip = handler2.getCanonicalPathToZip();
            ZipHandler.setFileAttributes(handler2, canonicalPathToZip);
            return new ZipFile(canonicalPathToZip);
        }

        protected void disposeAccessor(@NotNull ZipFile fileAccessor) throws IOException {
            fileAccessor.close();
        }

        public boolean isEqual(ZipHandler val1, ZipHandler val2) {
            return val1 == val2;
        }
    };

    public ZipHandler(@NotNull String path) {
        super(path);
    }

    protected static synchronized void setFileAttributes(@NotNull ZipHandler zipHandler, @NotNull String pathToZip) {
        FileAttributes attributes = FileSystemUtil.getAttributes((String)pathToZip);
        zipHandler.myFileStamp = attributes != null ? attributes.lastModified : -1L;
        zipHandler.myFileLength = attributes != null ? attributes.length : 0L;
    }

    private static synchronized boolean isSameFileAttributes(@NotNull ZipHandler zipHandler, @NotNull FileAttributes attributes) {
        return attributes.lastModified == zipHandler.myFileStamp && attributes.length == zipHandler.myFileLength;
    }

    @NotNull
    private String getCanonicalPathToZip() throws IOException {
        String value = this.myCanonicalPathToZip;
        if (value == null) {
            this.myCanonicalPathToZip = value = this.getFileToUse().getCanonicalPath();
        }
        return value;
    }

    @Contract(value="true -> !null")
    protected FileAccessorCache.Handle<ZipFile> getCachedZipFileHandle(boolean createIfNeeded) throws IOException {
        try {
            FileAccessorCache.Handle handle;
            FileAccessorCache.Handle handle2 = handle = createIfNeeded ? ourZipFileFileAccessorCache.get((Object)this) : ourZipFileFileAccessorCache.getIfCached((Object)this);
            if (handle != null && this.getFile() == this.getFileToUse()) {
                FileAttributes attributes = FileSystemUtil.getAttributes((String)this.getCanonicalPathToZip());
                if (attributes == null) {
                    throw new FileNotFoundException(this.getCanonicalPathToZip());
                }
                if (ZipHandler.isSameFileAttributes(this, attributes)) {
                    return handle;
                }
                this.clearCaches();
                handle.release();
                handle = ourZipFileFileAccessorCache.get((Object)this);
            }
            return handle;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    protected void clearCaches() {
        ourZipFileFileAccessorCache.remove((Object)this);
        super.clearCaches();
    }

    @NotNull
    protected File getFileToUse() {
        return this.getFile();
    }

    @Override
    protected long getEntryFileStamp() {
        return this.myFileStamp;
    }

    @Override
    @NotNull
    protected ResourceHandle<ZipFile> acquireZipHandle() throws IOException {
        return this.getCachedZipFileHandle(true);
    }

    public static void clearFileAccessorCache() {
        ourZipFileFileAccessorCache.clear();
    }
}

