/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.ResourceHandle;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZipHandlerBase
extends ArchiveHandler {
    public ZipHandlerBase(@NotNull String path) {
        super(path);
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        try (ResourceHandle<ZipFile> existingZipRef = this.acquireZipHandle();){
            Map<String, ArchiveHandler.EntryInfo> map2 = this.buildEntryMapForZipFile((ZipFile)existingZipRef.get());
            return map2;
        }
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(ZipFile zip) {
        ZipEntryMap map2 = new ZipEntryMap(zip.size());
        map2.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries2 = zip.entries();
        while (entries2.hasMoreElements()) {
            this.getOrCreate(entries2.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map2, zip);
        }
        return map2;
    }

    public void dispose() {
        super.dispose();
        this.clearCaches();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar((CharSequence)entryName, (char)'/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map2.get(entryName)) != null) {
            return info;
        }
        Pair path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip);
        if (".".equals(path.second)) {
            return parentInfo;
        }
        info = ZipHandlerBase.store(map2, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), this.getEntryFileStamp(), entryName);
        return info;
    }

    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map2, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String entryName) {
        CharSequence sequence = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence, isDirectory, size, time, parentInfo);
        map2.put(entryName, info);
        return info;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map2, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info = map2.get(entryName);
        if (info == null) {
            ZipEntry entry = zip.getEntry(entryName + "/");
            if (entry != null) {
                return this.getOrCreate(entry, map2, zip);
            }
            Pair path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map2, zip);
            info = ZipHandlerBase.store(map2, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(((Object)((Object)this)).getClass()).info(zip.getName() + ": " + entryName + " should be a directory");
            info = ZipHandlerBase.store(map2, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        return info;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block31: {
            try (ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();){
                ZipFile zip = (ZipFile)zipRef.get();
                ZipEntry entry = zip.getEntry(relativePath);
                if (entry == null) break block31;
                long length = entry.getSize();
                if (FileUtilRt.isTooLarge((long)length)) {
                    throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                }
                try (InputStream stream = zip.getInputStream(entry);){
                    if (stream != null) {
                        byte[] byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)length));
                        return byArray;
                    }
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        boolean release2 = true;
        ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();
        try {
            InputStream stream;
            ZipFile zip = (ZipFile)zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry != null && (stream = zip.getInputStream(entry)) != null) {
                long length = entry.getSize();
                if (!FileUtilRt.isTooLarge((long)length)) {
                    try {
                        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(FileUtil.loadBytes((InputStream)stream, (int)((int)length)));
                        return bufferExposingByteArrayInputStream;
                    }
                    finally {
                        stream.close();
                    }
                }
                release2 = false;
                InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(stream, zipRef);
                return inputStreamWrapper;
            }
        }
        finally {
            if (release2) {
                zipRef.close();
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    protected abstract long getEntryFileStamp();

    @NotNull
    protected abstract ResourceHandle<ZipFile> acquireZipHandle() throws IOException;

    private static class InputStreamWrapper
    extends InputStream {
        private final InputStream myStream;
        private final ResourceHandle<ZipFile> myZipRef;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        InputStreamWrapper(InputStream stream, ResourceHandle<ZipFile> zipRef) {
            this.myStream = stream;
            this.myZipRef = zipRef;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            return this.myStream.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.myStream.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                try {
                    this.myStream.close();
                }
                finally {
                    this.myZipRef.close();
                }
            }
        }
    }
}

