/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarHandler
extends ZipHandler {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    public CoreJarHandler(@NotNull CoreJarFileSystem fileSystem, @NotNull String path) {
        super(path);
        this.myFileSystem = fileSystem;
        HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries2 = new HashMap<ArchiveHandler.EntryInfo, CoreJarVirtualFile>();
        Map entriesMap = this.getEntriesMap();
        Map childrenMap = FactoryMap.create(key -> new ArrayList());
        for (ArchiveHandler.EntryInfo info : entriesMap.values()) {
            CoreJarVirtualFile file2 = this.getOrCreateFile(info, entries2);
            VirtualFile parent = file2.getParent();
            if (parent == null) continue;
            ((List)childrenMap.get(parent)).add(file2);
        }
        ArchiveHandler.EntryInfo rootInfo = this.getEntryInfo("");
        this.myRoot = rootInfo != null ? this.getOrCreateFile(rootInfo, entries2) : null;
        for (Map.Entry entry : childrenMap.entrySet()) {
            List childList = (List)entry.getValue();
            ((CoreJarVirtualFile)((Object)entry.getKey())).setChildren(childList.toArray(VirtualFile.EMPTY_ARRAY));
        }
    }

    @NotNull
    private CoreJarVirtualFile getOrCreateFile(@NotNull ArchiveHandler.EntryInfo info, @NotNull Map<ArchiveHandler.EntryInfo, CoreJarVirtualFile> entries2) {
        CoreJarVirtualFile file2 = entries2.get(info);
        if (file2 == null) {
            ArchiveHandler.EntryInfo parent = info.parent;
            file2 = new CoreJarVirtualFile(this, info.shortName, info.isDirectory ? -1L : info.length, info.timestamp, parent != null ? this.getOrCreateFile(parent, entries2) : null);
            entries2.put(info, file2);
        }
        return file2;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String pathInJar) {
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    @NotNull
    public CoreJarFileSystem getFileSystem() {
        return this.myFileSystem;
    }
}

