/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;

public final class LocalFileSystemImpl
extends LocalFileSystemBase
implements Disposable {
    private static final String FS_ROOT = "/";
    private static final int STATUS_UPDATE_PERIOD = 1000;
    private final ManagingFS myManagingFS;
    private final FileWatcher myWatcher;
    private final Object myLock = new Object();
    private final Set<WatchRequestImpl> myRootsToWatch = new THashSet();
    private TreeNode myNormalizedTree;

    public LocalFileSystemImpl(@NotNull Application app, @NotNull ManagingFS managingFS) {
        this.myManagingFS = managingFS;
        this.myWatcher = new FileWatcher(this.myManagingFS);
        if (this.myWatcher.isOperational()) {
            JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
                if (!app.isDisposed()) {
                    this.storeRefreshStatusToFiles();
                }
            }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    @NotNull
    public FileWatcher getFileWatcher() {
        return this.myWatcher;
    }

    public void dispose() {
        this.myWatcher.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<WatchRequestImpl> normalizeRootsForRefresh() {
        ArrayList<WatchRequestImpl> result2 = new ArrayList<WatchRequestImpl>();
        Object object = this.myLock;
        synchronized (object) {
            TreeNode rootNode = new TreeNode();
            for (WatchRequestImpl request : this.myRootsToWatch) {
                request.myDominated = false;
                String rootPath = request.getRootPath();
                TreeNode currentNode = rootNode;
                for (String subPath : LocalFileSystemImpl.splitPath(rootPath)) {
                    TreeNode nextNode = (TreeNode)currentNode.nodes.get(subPath);
                    if (nextNode != null) {
                        currentNode = nextNode;
                        if (currentNode.watchRequest == null || !currentNode.watchRequest.isToWatchRecursively()) continue;
                        request.myDominated = true;
                        break;
                    }
                    TreeNode newNode = new TreeNode();
                    currentNode.nodes.put(subPath, newNode);
                    currentNode = newNode;
                }
                if (currentNode.watchRequest == null) {
                    currentNode.watchRequest = request;
                } else if (!currentNode.watchRequest.isToWatchRecursively()) {
                    currentNode.watchRequest.myDominated = true;
                    currentNode.watchRequest = request;
                } else {
                    request.myDominated = true;
                }
                if (!currentNode.watchRequest.isToWatchRecursively() || currentNode.nodes.isEmpty()) continue;
                LocalFileSystemImpl.visitTree(currentNode, (Consumer<? super TreeNode>)((Consumer)node -> {
                    if (((TreeNode)node).watchRequest != null) {
                        ((TreeNode)node).watchRequest.myDominated = true;
                    }
                }));
                currentNode.nodes.clear();
            }
            LocalFileSystemImpl.visitTree(rootNode, (Consumer<? super TreeNode>)((Consumer)node -> {
                if (((TreeNode)node).watchRequest != null) {
                    result2.add(((TreeNode)node).watchRequest);
                }
            }));
            this.myNormalizedTree = rootNode;
        }
        return result2;
    }

    @NotNull
    private static List<String> splitPath(@NotNull String path) {
        if (path.isEmpty()) {
            return Collections.emptyList();
        }
        if (FS_ROOT.equals(path)) {
            return Collections.singletonList(FS_ROOT);
        }
        List parts = StringUtil.split((String)path, (String)FS_ROOT);
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            parts.add(0, FS_ROOT);
        }
        return parts;
    }

    private static void visitTree(@NotNull TreeNode rootNode, @NotNull Consumer<? super TreeNode> consumer) {
        for (TreeNode node : rootNode.nodes.values()) {
            consumer.consume((Object)node);
            LocalFileSystemImpl.visitTree(node, consumer);
        }
    }

    private boolean isAlreadyWatched(@NotNull WatchRequestImpl request) {
        if (this.myNormalizedTree == null) {
            this.normalizeRootsForRefresh();
        }
        String rootPath = request.getRootPath();
        TreeNode currentNode = this.myNormalizedTree;
        for (String subPath : LocalFileSystemImpl.splitPath(rootPath)) {
            TreeNode nextNode = (TreeNode)currentNode.nodes.get(subPath);
            if (nextNode == null) {
                return false;
            }
            currentNode = nextNode;
            if (currentNode.watchRequest == null || !currentNode.watchRequest.isToWatchRecursively()) continue;
            return true;
        }
        return !request.isToWatchRecursively() && currentNode.watchRequest != null;
    }

    private void storeRefreshStatusToFiles() {
        if (this.myWatcher.isOperational()) {
            FileWatcher.DirtyPaths dirtyPaths = this.myWatcher.getDirtyPaths();
            this.markPathsDirty(dirtyPaths.dirtyPaths);
            this.markFlatDirsDirty(dirtyPaths.dirtyDirectories);
            this.markRecursiveDirsDirty(dirtyPaths.dirtyPathsRecursive);
        }
    }

    private void markPathsDirty(@NotNull Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file2 = this.findFileByPathIfCached(dirtyPath);
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markDirty();
        }
    }

    private void markFlatDirsDirty(@NotNull Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirty();
                for (VirtualFile child2 : ((NewVirtualFile)pair.first).getCachedChildren()) {
                    ((NewVirtualFile)child2).markDirty();
                }
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    private void markRecursiveDirsDirty(@NotNull Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirtyRecursively();
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    public void markSuspiciousFilesDirty(@NotNull List<? extends VirtualFile> files2) {
        this.storeRefreshStatusToFiles();
        if (this.myWatcher.isOperational()) {
            for (String string : this.myWatcher.getManualWatchRoots()) {
                VirtualFile suspiciousRoot = this.findFileByPathIfCached(string);
                if (suspiciousRoot == null) continue;
                ((NewVirtualFile)suspiciousRoot).markDirtyRecursively();
            }
        } else {
            for (VirtualFile virtualFile : files2) {
                if (virtualFile.getFileSystem() != this) continue;
                ((NewVirtualFile)virtualFile).markDirtyRecursively();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        recursiveRoots = (Collection)ObjectUtils.notNull(recursiveRoots, Collections.emptyList());
        flatRoots = (Collection)ObjectUtils.notNull(flatRoots, Collections.emptyList());
        HashSet<String> recursiveWatches = new HashSet<String>();
        HashSet flatWatches = new HashSet();
        for (LocalFileSystem.WatchRequest watch : watchRequests) {
            (watch.isToWatchRecursively() ? recursiveWatches : flatWatches).add(watch.getRootPath());
        }
        if (recursiveWatches.equals(recursiveRoots) && flatWatches.equals(flatRoots)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("same requests: " + recursiveRoots.size() + '/' + flatRoots.size());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("recursive " + recursiveRoots);
                    LOG.trace("flat " + flatRoots);
                }
            }
            return watchRequests instanceof Set ? (Set<Object>)watchRequests : new HashSet<LocalFileSystem.WatchRequest>(watchRequests);
        }
        HashSet<LocalFileSystem.WatchRequest> result2 = new HashSet<LocalFileSystem.WatchRequest>();
        Object object = this.myLock;
        synchronized (object) {
            boolean update = this.doAddRootsToWatch(recursiveRoots, flatRoots, result2);
            if (update |= this.doRemoveWatchedRoots(watchRequests)) {
                this.myNormalizedTree = null;
                this.setUpFileWatcher();
            }
        }
        return result2;
    }

    private boolean doAddRootsToWatch(@NotNull Collection<String> recursiveRoots, @NotNull Collection<String> flatRoots, @NotNull Set<LocalFileSystem.WatchRequest> result2) {
        boolean update = false;
        for (String root : recursiveRoots) {
            update |= this.watch(root, true, result2);
        }
        for (String root : flatRoots) {
            update |= this.watch(root, false, result2);
        }
        return update;
    }

    private boolean watch(@NotNull String rootPath, boolean recursively, @NotNull Set<LocalFileSystem.WatchRequest> result2) {
        File rootFile;
        int index = rootPath.indexOf("!/");
        if (index >= 0) {
            rootPath = rootPath.substring(0, index);
        }
        if (!(rootFile = new File(FileUtil.toSystemDependentName((String)rootPath))).isAbsolute()) {
            LOG.warn("Invalid path: " + rootPath);
            return false;
        }
        WatchRequestImpl request = new WatchRequestImpl(rootFile.getAbsolutePath(), recursively);
        request.myDominated = this.isAlreadyWatched(request);
        this.myRootsToWatch.add(request);
        result2.add(request);
        return !request.myDominated;
    }

    private boolean doRemoveWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests) {
        boolean update = false;
        for (LocalFileSystem.WatchRequest watchRequest : watchRequests) {
            WatchRequestImpl impl = (WatchRequestImpl)watchRequest;
            boolean wasWatched = this.myRootsToWatch.remove(impl) && !impl.myDominated;
            update |= wasWatched;
        }
        return update;
    }

    private void setUpFileWatcher() {
        if (!ApplicationManager.getApplication().isDisposeInProgress() && this.myWatcher.isOperational()) {
            ArrayList<String> recursiveRoots = new ArrayList<String>();
            ArrayList<String> flatRoots = new ArrayList<String>();
            for (WatchRequestImpl request : this.normalizeRootsForRefresh()) {
                (request.isToWatchRecursively() ? recursiveRoots : flatRoots).add(request.myFSRootPath);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up file watcher. Recursive roots: " + recursiveRoots.size() + ", flat roots: " + flatRoots.size());
            }
            this.myWatcher.setWatchRoots(recursiveRoots, flatRoots);
        }
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        Runnable heavyRefresh = () -> {
            for (VirtualFile root : this.myManagingFS.getRoots((NewVirtualFileSystem)this)) {
                ((NewVirtualFile)root).markDirtyRecursively();
            }
            this.refresh(asynchronous);
        };
        if (asynchronous && this.myWatcher.isOperational()) {
            RefreshQueue.getInstance().refresh(true, true, heavyRefresh, this.myManagingFS.getRoots((NewVirtualFileSystem)this));
        } else {
            heavyRefresh.run();
        }
    }

    public String toString() {
        return "LocalFileSystem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        FileDocumentManager.getInstance().saveAllDocuments();
        PersistentFS.getInstance().clearIdCache();
        Object object = this.myLock;
        synchronized (object) {
            this.myRootsToWatch.clear();
            this.myNormalizedTree = null;
        }
    }

    private static class TreeNode {
        private WatchRequestImpl watchRequest;
        private final Map<String, TreeNode> nodes = new THashMap(1, FileUtil.PATH_HASHING_STRATEGY);

        private TreeNode() {
        }
    }

    private static class WatchRequestImpl
    implements LocalFileSystem.WatchRequest {
        private final String myFSRootPath;
        private final boolean myWatchRecursively;
        private boolean myDominated;

        WatchRequestImpl(@NotNull @SystemDependent String rootPath, boolean watchRecursively) {
            this.myFSRootPath = rootPath;
            this.myWatchRecursively = watchRecursively;
        }

        @NotNull
        public @SystemIndependent String getRootPath() {
            return FileUtil.toSystemIndependentName((String)this.myFSRootPath);
        }

        public boolean isToWatchRecursively() {
            return this.myWatchRecursively;
        }

        public String toString() {
            return this.getRootPath();
        }
    }
}

