/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.VfsImplUtil");
    private static final String FILE_SEPARATORS = "/" + File.separator;
    private static final AtomicBoolean ourSubscribed = new AtomicBoolean(false);
    private static final Object ourLock = new Object();
    private static final Map<String, Pair<ArchiveFileSystem, ArchiveHandler>> ourHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private static final Map<String, Set<String>> ourDominatorsMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);

    private VfsImplUtil() {
    }

    @Nullable
    public static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file2 = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            NewVirtualFile canonicalFile;
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            file2 = "..".equals(pathElement) ? (file2.is(VFileProperty.SYMLINK) ? ((canonicalFile = file2.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : file2.getParent()) : file2.findChild(pathElement);
            if (file2 != null) continue;
            return null;
        }
        return file2;
    }

    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        return (NewVirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)vfs, (String)path).first;
    }

    @NotNull
    public static Pair<NewVirtualFile, NewVirtualFile> findCachedFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return Pair.empty();
        }
        NewVirtualFile file2 = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            NewVirtualFile last = file2;
            if ("..".equals(pathElement)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file2.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? (NewVirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)vfs, (String)canonicalPath).first : null;
                    file2 = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file2 = file2.getParent();
                }
            } else {
                file2 = file2.findChildIfCached(pathElement);
            }
            if (file2 != null) continue;
            return Pair.pair(null, (Object)last);
        }
        return Pair.pair((Object)file2, null);
    }

    @Nullable
    public static NewVirtualFile refreshAndFindFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data = VfsImplUtil.prepare(vfs, path);
        if (data == null) {
            return null;
        }
        NewVirtualFile file2 = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file2.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.refreshAndFindFileByPath(vfs, canonicalPath) : null;
                    file2 = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file2 = file2.getParent();
                }
            } else {
                file2 = file2.refreshAndFindChild(pathElement);
            }
            if (file2 != null) continue;
            return null;
        }
        return file2;
    }

    @Nullable
    private static Pair<NewVirtualFile, Iterable<String>> prepare(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        String normalizedPath = VfsImplUtil.normalize(vfs, path);
        if (StringUtil.isEmptyOrSpaces((String)normalizedPath)) {
            return null;
        }
        String basePath = vfs.extractRootPath(normalizedPath);
        if (basePath.length() > normalizedPath.length() || basePath.isEmpty()) {
            LOG.warn(vfs + " failed to extract root path '" + basePath + "' from '" + normalizedPath + "' (original '" + path + "')");
            return null;
        }
        NewVirtualFile root = ManagingFS.getInstance().findRoot(basePath, vfs);
        if (root == null || !root.exists()) {
            return null;
        }
        Iterable parts = StringUtil.tokenize((String)normalizedPath.substring(basePath.length()), (String)FILE_SEPARATORS);
        return Pair.create((Object)root, (Object)parts);
    }

    public static void refresh(@NotNull NewVirtualFileSystem vfs, boolean asynchronous) {
        VirtualFile[] roots = ManagingFS.getInstance().getRoots(vfs);
        if (roots.length > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, null, roots);
        }
    }

    public static String normalize(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        return vfs.normalize(path);
    }

    public static void forceSyncRefresh(@NotNull VirtualFile file2) {
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static <T extends ArchiveHandler> T getHandler(@NotNull ArchiveFileSystem vfs, @NotNull VirtualFile entryFile, @NotNull Function<? super String, ? extends T> producer) {
        ArchiveHandler handler2;
        String localPath = vfs.extractLocalPath(vfs.extractRootPath(entryFile.getPath()));
        VfsImplUtil.checkSubscription();
        Object object = ourLock;
        synchronized (object) {
            ArchiveHandler t;
            Pair record = ourHandlers.get(localPath);
            if (record == null) {
                handler2 = (ArchiveHandler)producer.fun((Object)localPath);
                record = Pair.create((Object)vfs, (Object)handler2);
                ourHandlers.put(localPath, (Pair<ArchiveFileSystem, ArchiveHandler>)record);
                VfsImplUtil.forEachDirectoryComponent(localPath, containingDirectoryPath -> {
                    Set handlers = ourDominatorsMap.computeIfAbsent((String)containingDirectoryPath, __ -> ContainerUtil.newTroveSet());
                    handlers.add(localPath);
                });
            }
            handler2 = t = (ArchiveHandler)record.second;
        }
        return (T)handler2;
    }

    private static void forEachDirectoryComponent(String rootPath, Consumer<? super String> consumer) {
        int index = rootPath.lastIndexOf(47);
        while (index > 0) {
            String containingDirectoryPath = rootPath.substring(0, index);
            consumer.accept(containingDirectoryPath);
            index = rootPath.lastIndexOf(47, index - 1);
        }
    }

    private static void checkSubscription() {
        if (ourSubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDisposeInProgress()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                InvalidationState state = null;
                Object object = ourLock;
                synchronized (object) {
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFilePropertyChangeEvent && !"name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) continue;
                        String path = vFileEvent.getPath();
                        if (vFileEvent instanceof VFilePropertyChangeEvent) {
                            path = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                        } else if (vFileEvent instanceof VFileMoveEvent) {
                            path = ((VFileMoveEvent)vFileEvent).getOldPath();
                        }
                        VirtualFile file2 = vFileEvent.getFile();
                        if (file2 == null || !file2.isDirectory()) {
                            state = VfsImplUtil.invalidate(state, path);
                            continue;
                        }
                        Collection affectedPaths = (Collection)ourDominatorsMap.get(path);
                        if (affectedPaths == null) continue;
                        affectedPaths = ContainerUtil.newArrayList((Iterable)affectedPaths);
                        for (String affectedPath : affectedPaths) {
                            state = VfsImplUtil.invalidate(state, affectedPath);
                        }
                    }
                }
                if (state != null) {
                    state.scheduleRefresh();
                }
            }
        });
    }

    @Nullable
    private static InvalidationState invalidate(@Nullable InvalidationState state, String path) {
        Pair<ArchiveFileSystem, ArchiveHandler> handlerPair = ourHandlers.remove(path);
        if (handlerPair != null) {
            ((ArchiveHandler)handlerPair.second).dispose();
            VfsImplUtil.forEachDirectoryComponent(path, containingDirectoryPath -> {
                Set<String> handlers = ourDominatorsMap.get(containingDirectoryPath);
                if (handlers != null && handlers.remove(path) && handlers.isEmpty()) {
                    ourDominatorsMap.remove(containingDirectoryPath);
                }
            });
            if (state == null) {
                state = new InvalidationState();
            }
            state.registerPathToRefresh(path, (ArchiveFileSystem)handlerPair.first);
        }
        return state;
    }

    private static class InvalidationState {
        private Set<NewVirtualFile> myRootsToRefresh;

        private InvalidationState() {
        }

        private void registerPathToRefresh(String path, ArchiveFileSystem vfs) {
            NewVirtualFile root = ManagingFS.getInstance().findRoot(vfs.composeRootPath(path), (NewVirtualFileSystem)vfs);
            if (root != null) {
                if (this.myRootsToRefresh == null) {
                    this.myRootsToRefresh = ContainerUtil.newHashSet();
                }
                this.myRootsToRefresh.add(root);
            }
        }

        private void scheduleRefresh() {
            if (this.myRootsToRefresh != null) {
                for (NewVirtualFile root : this.myRootsToRefresh) {
                    root.markDirtyRecursively();
                }
                boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                RefreshQueue.getInstance().refresh(async, true, null, this.myRootsToRefresh);
            }
        }
    }
}

