/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.impl.VfsData");
    private static final int SEGMENT_BITS = 9;
    private static final int SEGMENT_SIZE = 512;
    private static final int OFFSET_MASK = 511;
    private final Object myDeadMarker = ObjectUtils.sentinel((String)"dead file");
    private final ConcurrentIntObjectMap<Segment> mySegments = ContainerUtil.createConcurrentIntObjectMap();
    private final ConcurrentBitSet myInvalidatedIds = new ConcurrentBitSet();
    private TIntHashSet myDyingIds = new TIntHashSet();
    private final IntObjectMap<VirtualDirectoryImpl> myChangedParents = ContainerUtil.createConcurrentIntObjectMap();

    public VfsData() {
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void writeActionFinished(@NotNull Object action) {
                if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    VfsData.this.killInvalidatedFiles();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killInvalidatedFiles() {
        Object object = this.myDeadMarker;
        synchronized (object) {
            if (!this.myDyingIds.isEmpty()) {
                for (int id : this.myDyingIds.toArray()) {
                    Segment segment = (Segment)ObjectUtils.assertNotNull((Object)this.getSegment(id, false));
                    segment.myObjectArray.set(VfsData.getOffset(id), this.myDeadMarker);
                    this.myChangedParents.remove(id);
                }
                this.myDyingIds = new TIntHashSet();
            }
        }
    }

    @Nullable
    VirtualFileSystemEntry getFileById(int id, @NotNull VirtualDirectoryImpl parent) {
        PersistentFSImpl persistentFS = (PersistentFSImpl)PersistentFS.getInstance();
        VirtualFileSystemEntry dir = persistentFS.getCachedDir(id);
        if (dir != null) {
            return dir;
        }
        Segment segment = this.getSegment(id, false);
        if (segment == null) {
            return null;
        }
        int offset = VfsData.getOffset(id);
        Object o = segment.myObjectArray.get(offset);
        if (o == null) {
            return null;
        }
        if (o == this.myDeadMarker) {
            throw VfsData.reportDeadFileAccess(new VirtualFileImpl(id, segment, parent));
        }
        int nameId = segment.getNameId(id);
        if (nameId <= 0) {
            FSRecords.invalidateCaches();
            throw new AssertionError((Object)("nameId=" + nameId + "; data=" + o + "; parent=" + (Object)((Object)parent) + "; parent.id=" + parent.getId() + "; db.parent=" + FSRecords.getParent(id)));
        }
        return o instanceof DirectoryData ? persistentFS.getOrCacheDir(id, segment, (DirectoryData)o, parent) : new VirtualFileImpl(id, segment, parent);
    }

    private static InvalidVirtualFileAccessException reportDeadFileAccess(VirtualFileSystemEntry file2) {
        return new InvalidVirtualFileAccessException("Accessing dead virtual file: " + file2.getUrl());
    }

    private static int getOffset(int id) {
        return id & 0x1FF;
    }

    @Nullable
    @Contract(value="_,true->!null")
    public Segment getSegment(int id, boolean create2) {
        int key = id >>> 9;
        Segment segment = (Segment)this.mySegments.get(key);
        if (segment != null || !create2) {
            return segment;
        }
        return (Segment)this.mySegments.cacheOrGet(key, (Object)new Segment(this));
    }

    public boolean hasLoadedFile(int id) {
        Segment segment = this.getSegment(id, false);
        return segment != null && segment.myObjectArray.get(VfsData.getOffset(id)) != null;
    }

    public static void initFile(int id, Segment segment, int nameId, @NotNull Object data) throws FileAlreadyCreatedException {
        assert (id > 0);
        int offset = VfsData.getOffset(id);
        segment.setNameId(id, nameId);
        Object existingData = segment.myObjectArray.get(offset);
        if (existingData != null) {
            FSRecords.invalidateCaches();
            int parent = FSRecords.getParent(id);
            String msg = "File already created: " + nameId + ", data=" + existingData + "; parentId=" + parent;
            if (parent > 0) {
                msg = msg + "; parent.name=" + FSRecords.getName(parent);
                msg = msg + "; parent.children=" + Arrays.toString(FSRecords.listAll(id));
            }
            throw new FileAlreadyCreatedException(msg);
        }
        segment.myObjectArray.set(offset, data);
    }

    CharSequence getNameByFileId(int id) {
        return FileNameCache.getVFileName(((Segment)ObjectUtils.assertNotNull((Object)this.getSegment(id, false))).getNameId(id));
    }

    boolean isFileValid(int id) {
        return !this.myInvalidatedIds.get(id);
    }

    @Nullable
    VirtualDirectoryImpl getChangedParent(int id) {
        return (VirtualDirectoryImpl)((Object)this.myChangedParents.get(id));
    }

    void changeParent(int id, VirtualDirectoryImpl parent) {
        this.myChangedParents.put(id, (Object)parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateFile(int id) {
        this.myInvalidatedIds.set(id);
        Object object = this.myDeadMarker;
        synchronized (object) {
            this.myDyingIds.add(id);
        }
    }

    public static class DirectoryData {
        private static final AtomicFieldUpdater<DirectoryData, KeyFMap> MY_USER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(DirectoryData.class, KeyFMap.class);
        @NotNull
        volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
        @NotNull
        volatile int[] myChildrenIds = ArrayUtil.EMPTY_INT_ARRAY;
        private volatile Set<CharSequence> myAdoptedNames;

        @NotNull
        VirtualFileSystemEntry[] getFileChildren(@NotNull VirtualDirectoryImpl parent) {
            int[] ids = this.myChildrenIds;
            VirtualFileSystemEntry[] children2 = new VirtualFileSystemEntry[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                int childId = ids[i];
                VirtualFileSystemEntry child2 = parent.mySegment.vfsData.getFileById(childId, parent);
                if (child2 == null) {
                    throw new AssertionError((Object)("No file for id " + childId + ", parentId = " + parent.myId));
                }
                children2[i] = child2;
            }
            return children2;
        }

        boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
            return MY_USER_MAP_UPDATER.compareAndSet((Object)this, (Object)oldMap, (Object)newMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAdoptedName(@NotNull CharSequence name) {
            Set<CharSequence> adopted = this.myAdoptedNames;
            if (adopted == null) {
                return false;
            }
            Set<CharSequence> set2 = adopted;
            synchronized (set2) {
                return adopted.contains(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAdoptedName(@NotNull CharSequence name) {
            Set<CharSequence> adopted = this.myAdoptedNames;
            if (adopted == null) {
                return;
            }
            Set<CharSequence> set2 = adopted;
            synchronized (set2) {
                boolean removed = adopted.remove(name);
                if (removed && adopted.isEmpty()) {
                    this.myAdoptedNames = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedName(@NotNull CharSequence name, boolean caseSensitive) {
            Set<CharSequence> adopted = this.getOrCreateAdoptedNames(caseSensitive);
            CharSequence sequence = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)name);
            Set<CharSequence> set2 = adopted;
            synchronized (set2) {
                adopted.add(sequence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addAdoptedNames(@NotNull Collection<? extends CharSequence> names, boolean caseSensitive) {
            Set<CharSequence> adopted;
            Set<CharSequence> set2 = adopted = this.getOrCreateAdoptedNames(caseSensitive);
            synchronized (set2) {
                adopted.addAll(names);
            }
        }

        @NotNull
        private Set<CharSequence> getOrCreateAdoptedNames(boolean caseSensitive) {
            THashSet adopted = this.myAdoptedNames;
            if (adopted == null) {
                this.myAdoptedNames = adopted = new THashSet(0, (TObjectHashingStrategy)(caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE));
            }
            return adopted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        List<String> getAdoptedNames() {
            Set<CharSequence> adopted = this.myAdoptedNames;
            if (adopted == null) {
                return Collections.emptyList();
            }
            Set<CharSequence> set2 = adopted;
            synchronized (set2) {
                return ContainerUtil.map(adopted, (Function)Functions.TO_STRING());
            }
        }

        void clearAdoptedNames() {
            this.myAdoptedNames = null;
        }

        public String toString() {
            return "DirectoryData{myUserMap=" + this.myUserMap + ", myChildrenIds=" + Arrays.toString(this.myChildrenIds) + ", myAdoptedNames=" + this.myAdoptedNames + '}';
        }
    }

    public static class Segment {
        private final AtomicReferenceArray<Object> myObjectArray = new AtomicReferenceArray(512);
        private final AtomicIntegerArray myIntArray = new AtomicIntegerArray(1024);
        final VfsData vfsData;

        Segment(VfsData vfsData) {
            this.vfsData = vfsData;
        }

        int getNameId(int fileId) {
            return this.myIntArray.get(VfsData.getOffset(fileId) * 2);
        }

        void setNameId(int fileId, int nameId) {
            this.myIntArray.set(VfsData.getOffset(fileId) * 2, nameId);
        }

        void setUserMap(int fileId, @NotNull KeyFMap map2) {
            this.myObjectArray.set(VfsData.getOffset(fileId), map2);
        }

        KeyFMap getUserMap(VirtualFileSystemEntry file2, int id) {
            Object o = this.myObjectArray.get(VfsData.getOffset(id));
            if (!(o instanceof KeyFMap)) {
                throw VfsData.reportDeadFileAccess(file2);
            }
            return (KeyFMap)o;
        }

        boolean changeUserMap(int fileId, KeyFMap oldMap, KeyFMap newMap) {
            return this.myObjectArray.compareAndSet(VfsData.getOffset(fileId), oldMap, newMap);
        }

        boolean getFlag(int id, int mask) {
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            return (this.myIntArray.get(VfsData.getOffset(id) * 2 + 1) & mask) != 0;
        }

        void setFlag(int id, int mask, boolean value) {
            int updated;
            int oldInt;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set flag " + Integer.toHexString(mask) + "=" + value + " for id=" + id);
            }
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            int offset = VfsData.getOffset(id) * 2 + 1;
            while (!this.myIntArray.compareAndSet(offset, oldInt = this.myIntArray.get(offset), updated = BitUtil.set((int)oldInt, (int)mask, (boolean)value))) {
            }
        }

        long getModificationStamp(int id) {
            return this.myIntArray.get(VfsData.getOffset(id) * 2 + 1) & 0xFFFFFF;
        }

        void setModificationStamp(int id, long stamp) {
            int updated;
            int oldInt;
            int offset = VfsData.getOffset(id) * 2 + 1;
            while (!this.myIntArray.compareAndSet(offset, oldInt = this.myIntArray.get(offset), updated = oldInt & 0xFF000000 | (int)stamp & 0xFFFFFF)) {
            }
        }
    }

    public static class FileAlreadyCreatedException
    extends Exception {
        private FileAlreadyCreatedException(String message) {
            super(message);
        }
    }
}

