/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsRootAccess {
    private static final boolean SHOULD_PERFORM_ACCESS_CHECK = System.getenv("NO_FS_ROOTS_ACCESS_CHECK") == null;
    private static final Set<String> ourAdditionalRoots = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
    private static boolean insideGettingRoots;

    static void assertAccessInTests(@NotNull VirtualFileSystemEntry child2, @NotNull NewVirtualFileSystem delegate) {
        Application application = ApplicationManager.getApplication();
        if (SHOULD_PERFORM_ACCESS_CHECK && application.isUnitTestMode() && application instanceof ApplicationImpl && ((ApplicationImpl)application).isComponentsCreated() && !ApplicationInfoImpl.isInStressTest()) {
            boolean isUnder2;
            if (delegate != LocalFileSystem.getInstance() && delegate != JarFileSystem.getInstance()) {
                return;
            }
            if (child2.getParent() == null || child2.getParent().getParent() == null) {
                return;
            }
            Set allowed = (Set)ReadAction.compute(VfsRootAccess::allowedRoots);
            boolean bl = isUnder2 = allowed == null || allowed.isEmpty();
            if (!isUnder2) {
                String childPath = child2.getPath();
                if (delegate == JarFileSystem.getInstance()) {
                    VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar((VirtualFile)child2);
                    assert (local != null) : child2;
                    childPath = local.getPath();
                }
                for (String root : allowed) {
                    String rootLocalPath;
                    if (FileUtil.startsWith((String)childPath, (String)root)) {
                        isUnder2 = true;
                        break;
                    }
                    if (!root.startsWith("jar://") || !(isUnder2 = FileUtil.startsWith((String)childPath, (String)(rootLocalPath = FileUtil.toSystemIndependentName((String)PathUtil.toPresentableUrl((String)root)))))) continue;
                    break;
                }
            }
            assert (isUnder2) : "File accessed outside allowed roots: " + (Object)((Object)child2) + ";\nAllowed roots: " + new ArrayList(allowed);
        }
    }

    private static Set<String> allowedRoots() {
        if (insideGettingRoots) {
            return null;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        THashSet allowed = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        allowed.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()));
        String homePath2 = PathManager.getHomePathFor(Application.class);
        if (homePath2 != null) {
            allowed.add(FileUtil.toSystemIndependentName((String)homePath2));
        }
        try {
            URL outUrl = Application.class.getResource("/");
            if (outUrl != null) {
                String output = new File(outUrl.toURI()).getParentFile().getParentFile().getPath();
                allowed.add(FileUtil.toSystemIndependentName((String)output));
            }
        }
        catch (URISyntaxException outUrl) {
            // empty catch block
        }
        try {
            String javaHome = SystemProperties.getJavaHome();
            allowed.add(FileUtil.toSystemIndependentName((String)javaHome));
            allowed.add(FileUtil.toSystemIndependentName((String)new File(FileUtil.getTempDirectory()).getParent()));
            allowed.add(FileUtil.toSystemIndependentName((String)System.getProperty("java.io.tmpdir")));
            allowed.add(FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome()));
            ContainerUtil.addAllNotNull((Collection)allowed, (Object[])new String[]{VfsRootAccess.findInUserHome(".m2")});
            ContainerUtil.addAllNotNull((Collection)allowed, (Object[])new String[]{VfsRootAccess.findInUserHome(".gradle")});
            allowed.add("/etc");
            allowed.add("/private/etc");
            for (Project project : openProjects) {
                if (!project.isInitialized()) {
                    return null;
                }
                for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                    allowed.add(root.getPath());
                }
                for (VirtualFile root : VfsRootAccess.getAllRoots(project)) {
                    allowed.add(StringUtil.trimEnd((String)root.getPath(), (String)"!/"));
                }
                String location = project.getBasePath();
                assert (location != null) : project;
                allowed.add(FileUtil.toSystemIndependentName((String)location));
            }
            allowed.addAll(ourAdditionalRoots);
        }
        catch (Error error) {
            // empty catch block
        }
        return allowed;
    }

    @Nullable
    private static String findInUserHome(@NotNull String path) {
        try {
            return FileUtil.toSystemIndependentName((String)new File(SystemProperties.getUserHome(), path).getCanonicalPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static VirtualFile[] getAllRoots(@NotNull Project project) {
        insideGettingRoots = true;
        THashSet roots = new THashSet();
        OrderEnumerator enumerator2 = ProjectRootManager.getInstance((Project)project).orderEntries();
        ContainerUtil.addAll((Collection)roots, (Object[])enumerator2.getClassesRoots());
        ContainerUtil.addAll((Collection)roots, (Object[])enumerator2.getSourceRoots());
        insideGettingRoots = false;
        return VfsUtilCore.toVirtualFileArray((Collection)roots);
    }

    public static void allowRootAccess(@NotNull Disposable disposable, String ... roots) {
        if (roots.length == 0) {
            return;
        }
        VfsRootAccess.allowRootAccess(roots);
        Disposer.register((Disposable)disposable, () -> VfsRootAccess.disallowRootAccess(roots));
    }

    @Deprecated
    public static void allowRootAccess(String ... roots) {
        for (String root : roots) {
            ourAdditionalRoots.add(StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (char)'/'));
        }
    }

    @Deprecated
    public static void disallowRootAccess(String ... roots) {
        for (String root : roots) {
            ourAdditionalRoots.remove(StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (char)'/'));
        }
    }
}

