/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileLoadingTracker;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.impl.PsiCachedValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private static final Logger LOG = Logger.getInstance(VirtualDirectoryImpl.class);
    private static final boolean CHECK = ApplicationManager.getApplication().isUnitTestMode();
    private static final VirtualDirectoryImpl NULL_VIRTUAL_FILE = new VirtualDirectoryImpl(-42, new VfsData.Segment(null), new VfsData.DirectoryData(), null, (NewVirtualFileSystem)LocalFileSystem.getInstance()){

        @Override
        public String toString() {
            return "NULL";
        }
    };
    private final VfsData.DirectoryData myData;
    private final NewVirtualFileSystem myFs;

    public VirtualDirectoryImpl(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data, @Nullable VirtualDirectoryImpl parent, @NotNull NewVirtualFileSystem fs) {
        super(id, segment, parent);
        this.myData = data;
        this.myFs = fs;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        return this.myFs;
    }

    @Nullable
    private VirtualFileSystemEntry findChild(@NotNull String name, boolean doRefresh, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate) {
        boolean caseSensitive = delegate.isCaseSensitive();
        VirtualFileSystemEntry result2 = this.doFindChild(name, ensureCanonicalName, delegate, caseSensitive);
        if (result2 == NULL_VIRTUAL_FILE) {
            result2 = doRefresh ? this.createAndFindChildWithEventFire(name, delegate) : null;
        } else if (result2 != null && doRefresh && delegate.isDirectory((VirtualFile)result2) != result2.isDirectory()) {
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{result2});
            result2 = this.findChild(name, false, ensureCanonicalName, delegate);
        }
        return result2;
    }

    @Nullable
    private VirtualFileSystemEntry doFindChildInArray(@NotNull String name, boolean caseSensitive) {
        if (this.myData.isAdoptedName(name)) {
            return NULL_VIRTUAL_FILE;
        }
        int[] array = this.myData.myChildrenIds;
        int indexInReal = this.findIndex(array, name, caseSensitive);
        if (indexInReal >= 0) {
            return this.mySegment.vfsData.getFileById(array[indexInReal], this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry doFindChild(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate, boolean caseSensitive) {
        VirtualFileSystemEntry child2;
        FakeVirtualFile fake;
        if (name.isEmpty()) {
            return null;
        }
        if (!this.isValid()) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        VirtualFileSystemEntry found = this.doFindChildInArray(name, caseSensitive);
        if (found != null) {
            return found;
        }
        if (ensureCanonicalName) {
            String trimmedName = VirtualDirectoryImpl.deSlash(name);
            if (trimmedName == null) {
                return null;
            }
            if (!trimmedName.equals(name)) {
                found = this.doFindChildInArray(trimmedName, caseSensitive);
                if (found != null) {
                    return found;
                }
                name = trimmedName;
            }
        }
        if (this.allChildrenLoaded()) {
            return NULL_VIRTUAL_FILE;
        }
        if (ensureCanonicalName && (name = delegate.getCanonicallyCasedName((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)this, name)))).isEmpty()) {
            return null;
        }
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            child2 = this.doFindChildInArray(name, caseSensitive);
            if (child2 != null) {
                return child2;
            }
            if (this.allChildrenLoaded()) {
                return null;
            }
            int id = ourPersistence.getId((VirtualFile)this, name, delegate);
            if (id <= 0) {
                this.myData.addAdoptedName(name, caseSensitive);
                return null;
            }
            FileAttributes attributes = PersistentFS.toFileAttributes(ourPersistence.getFileAttributes(id));
            boolean isEmptyDirectory = attributes.isDirectory() && !ourPersistence.mayHaveChildren(id);
            child2 = this.createChild(FileNameCache.storeName(name), id, delegate, attributes, isEmptyDirectory);
            this.addChild(child2);
            ((PersistentFSImpl)ourPersistence).incStructuralModificationCount();
        }
        if (!child2.isDirectory()) {
            VfsRootAccess.assertAccessInTests(child2, this.getFileSystem());
        }
        return child2;
    }

    private static String deSlash(@NotNull String name) {
        int startTrimmed = -1;
        int endTrimmed = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (startTrimmed == -1) {
                if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
                startTrimmed = i;
                continue;
            }
            if (endTrimmed == -1) {
                if (!VirtualDirectoryImpl.isFileSeparator(c)) continue;
                endTrimmed = i;
                continue;
            }
            if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
            return null;
        }
        if (startTrimmed == -1) {
            return null;
        }
        if (endTrimmed == -1) {
            return name.substring(startTrimmed);
        }
        if (startTrimmed == endTrimmed) {
            return null;
        }
        return name.substring(startTrimmed, endTrimmed);
    }

    private static boolean isFileSeparator(char c) {
        return c == '/' || c == '\\';
    }

    @NotNull
    private VirtualFileSystemEntry[] getArraySafely() {
        if (this.myId < 0) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        return this.myData.getFileChildren(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VirtualFileSystemEntry createChild(@NotNull String name, int id, @NotNull NewVirtualFileSystem delegate, @NotNull FileAttributes attributes, boolean isEmptyDirectory) {
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            return this.createChild(FileNameCache.storeName(name), id, delegate, attributes, isEmptyDirectory);
        }
    }

    @NotNull
    private VirtualFileSystemEntry createChild(int nameId, int id, @NotNull NewVirtualFileSystem delegate, @NotNull FileAttributes attributes, boolean isEmptyDirectory) {
        FileLoadingTracker.fileLoaded(this, nameId);
        VfsData.Segment segment = this.mySegment.vfsData.getSegment(id, true);
        try {
            VfsData.initFile(id, segment, nameId, attributes.isDirectory() ? new VfsData.DirectoryData() : KeyFMap.EMPTY_MAP);
        }
        catch (VfsData.FileAlreadyCreatedException e) {
            throw new RuntimeException("dir=" + this.myId + "; dir.children=" + Arrays.toString(FSRecords.listAll(this.myId)), e);
        }
        LOG.assertTrue(!(this.getFileSystem() instanceof Win32LocalFileSystem));
        VirtualFileSystemEntry child2 = this.mySegment.vfsData.getFileById(id, this);
        assert (child2 != null);
        segment.setFlag(id, 0x20000000, attributes.isSymLink());
        segment.setFlag(id, Integer.MIN_VALUE, attributes.isSpecial());
        segment.setFlag(id, 0x1000000, attributes.isWritable());
        segment.setFlag(id, 0x2000000, attributes.isHidden());
        child2.updateLinkStatus();
        if (delegate.markNewFilesAsDirty()) {
            child2.markDirty();
        }
        if (attributes.isDirectory() && child2 instanceof VirtualDirectoryImpl && isEmptyDirectory) {
            ((VirtualDirectoryImpl)child2).setChildrenLoaded();
            PersistentFSImpl.setChildrenCached(id);
        }
        return child2;
    }

    @Nullable
    private VirtualFileSystemEntry createAndFindChildWithEventFire(@NotNull String name, @NotNull NewVirtualFileSystem delegate) {
        FakeVirtualFile fake = new FakeVirtualFile((VirtualFile)this, name);
        FileAttributes attributes = delegate.getAttributes((VirtualFile)fake);
        if (attributes == null) {
            return null;
        }
        String realName = delegate.getCanonicallyCasedName((VirtualFile)fake);
        boolean isDirectory = attributes.isDirectory();
        boolean isEmptyDirectory = isDirectory && !delegate.hasChildren((VirtualFile)fake);
        String symlinkTarget = attributes.isSymLink() ? delegate.resolveSymLink((VirtualFile)fake) : null;
        VFileCreateEvent event = new VFileCreateEvent(null, (VirtualFile)this, realName, isDirectory, attributes, symlinkTarget, true, isEmptyDirectory);
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)event);
        return this.findChild(realName);
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        return this.findChild(name, true, true, this.getFileSystem());
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VirtualFileSystemEntry found = this.doFindChildInArray(name, caseSensitive);
        return found == NULL_VIRTUAL_FILE ? null : found;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            return Collections.emptyList();
        }
        if (ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            return Arrays.asList(this.getChildren());
        }
        this.loadPersistedChildren();
        return this.getCachedChildren();
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildrenWithoutLoadingVfsFromOtherProjects() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            return Collections.emptyList();
        }
        if (!ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            this.loadPersistedChildren();
        }
        return this.getCachedChildren();
    }

    private void loadPersistedChildren() {
        String[] names = ourPersistence.listPersisted((VirtualFile)this);
        NewVirtualFileSystem delegate = PersistentFS.replaceWithNativeFS(this.getFileSystem());
        for (String name : names) {
            this.findChild(name, false, false, delegate);
        }
    }

    @NotNull
    public VirtualFile[] getChildren() {
        if (!this.isValid()) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        if (this.allChildrenLoaded()) {
            return this.getArraySafely();
        }
        return this.loadAllChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private VirtualFile[] loadAllChildren() {
        NewVirtualFileSystem delegate = this.getFileSystem();
        boolean caseSensitive = delegate.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            VirtualFile[] files2;
            boolean wasChildrenLoaded = ourPersistence.areChildrenLoaded((VirtualFile)this);
            FSRecords.NameId[] childrenIds = ourPersistence.listAll((VirtualFile)this);
            int[] result2 = ArrayUtil.newIntArray((int)childrenIds.length);
            VirtualFile[] virtualFileArray = files2 = childrenIds.length == 0 ? VirtualFile.EMPTY_ARRAY : new VirtualFile[childrenIds.length];
            if (childrenIds.length != 0) {
                Arrays.sort(childrenIds, (o1, o2) -> {
                    CharSequence name1 = o1.name;
                    CharSequence name2 = o2.name;
                    int cmp = VirtualDirectoryImpl.compareNames(name1, name2, caseSensitive);
                    if (cmp == 0 && name1 != name2) {
                        LOG.error((Object)((Object)ourPersistence) + " returned duplicate file names(" + name1 + "," + name2 + ") caseSensitive: " + caseSensitive + " SystemInfo.isFileSystemCaseSensitive: " + SystemInfo.isFileSystemCaseSensitive + " SystemInfo.OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " wasChildrenLoaded: " + wasChildrenLoaded + " in the dir: " + (Object)((Object)this) + "; children: " + Arrays.toString(childrenIds));
                    }
                    return cmp;
                });
                TIntHashSet prevChildren = new TIntHashSet(this.myData.myChildrenIds);
                for (int i = 0; i < childrenIds.length; ++i) {
                    FSRecords.NameId child2 = childrenIds[i];
                    result2[i] = child2.id;
                    assert (child2.id > 0) : child2;
                    prevChildren.remove(child2.id);
                    VirtualFileSystemEntry file2 = this.mySegment.vfsData.getFileById(child2.id, this);
                    if (file2 == null) {
                        FileAttributes attributes = PersistentFS.toFileAttributes(ourPersistence.getFileAttributes(child2.id));
                        boolean isEmptyDirectory = attributes.isDirectory() && !ourPersistence.mayHaveChildren(child2.id);
                        file2 = this.createChild(child2.nameId, child2.id, delegate, attributes, isEmptyDirectory);
                    }
                    files2[i] = file2;
                }
                if (!prevChildren.isEmpty()) {
                    LOG.error("Loaded child disappeared: parent=" + VirtualDirectoryImpl.verboseToString(this) + "; child=" + VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(prevChildren.toArray()[0], this)));
                }
            }
            this.myData.clearAdoptedNames();
            this.myData.myChildrenIds = result2;
            this.setChildrenLoaded();
            if (CHECK) {
                this.assertConsistency(caseSensitive, Arrays.asList(childrenIds));
            }
            return files2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertConsistency(boolean caseSensitive, @NotNull Object details) {
        if (!CHECK || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        int[] childrenIds = this.myData.myChildrenIds;
        if (childrenIds.length == 0) {
            return;
        }
        CharSequence prevName = this.mySegment.vfsData.getNameByFileId(childrenIds[0]);
        for (int i = 1; i < childrenIds.length; ++i) {
            int id = childrenIds[i];
            int prev2 = childrenIds[i - 1];
            CharSequence name = this.mySegment.vfsData.getNameByFileId(id);
            int cmp = VirtualDirectoryImpl.compareNames(name, prevName, caseSensitive);
            prevName = name;
            if (cmp <= 0) {
                VirtualDirectoryImpl.error(VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(prev2, this)) + " is wrongly placed before " + VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(id, this)), this.getArraySafely(), details);
            }
            VfsData.DirectoryData directoryData = this.myData;
            synchronized (directoryData) {
                if (this.myData.isAdoptedName(name)) {
                    try {
                        VirtualDirectoryImpl.error("In " + VirtualDirectoryImpl.verboseToString(this) + " file '" + name + "' is both child and adopted", this.getArraySafely(), "Adopted: " + this.myData.getAdoptedNames() + ";\n " + details);
                    }
                    finally {
                        this.myData.removeAdoptedName(name);
                    }
                }
                continue;
            }
        }
    }

    @NotNull
    private static String verboseToString(VirtualFileSystemEntry file2) {
        if (file2 == null) {
            return "null";
        }
        return (Object)((Object)file2) + " (name: '" + file2.getName() + "', " + ((Object)((Object)file2)).getClass() + ", parent: " + (Object)((Object)file2.getParent()) + "; id: " + file2.getId() + "; FS: " + file2.getFileSystem() + "; delegate.attrs: " + file2.getFileSystem().getAttributes((VirtualFile)file2) + "; caseSensitive: " + file2.getFileSystem().isCaseSensitive() + "; canonical: " + file2.getFileSystem().getCanonicallyCasedName((VirtualFile)file2) + ") ";
    }

    private static void error(String message, VirtualFileSystemEntry[] array, Object ... details) {
        String children2 = StringUtil.join((Object[])array, VirtualDirectoryImpl::verboseToString, (String)"\n");
        String detailsStr = StringUtil.join((Iterable)ContainerUtil.map((Object[])details, o -> o instanceof Object[] ? Arrays.toString((Object[])o) : o), (String)"\n");
        throw new AssertionError((Object)(message + "; children: " + children2 + "\nDetails: " + detailsStr));
    }

    @Nullable
    public VirtualFileSystemEntry findChild(@NotNull String name) {
        return this.findChild(name, false, true, this.getFileSystem());
    }

    public VirtualFileSystemEntry findChildById(int id) {
        int i = ArrayUtil.indexOf((int[])this.myData.myChildrenIds, (int)id);
        if (i >= 0) {
            return this.mySegment.vfsData.getFileById(id, this);
        }
        String name = ourPersistence.getName(id);
        return this.findChild(name, false, false, this.getFileSystem());
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of directory: " + (Object)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndAddChildren(@NotNull List<? extends PersistentFSImpl.ChildInfo> added) {
        if (added.size() <= 1) {
            for (int i = 0; i < added.size(); ++i) {
                PersistentFSImpl.ChildInfo pair2 = added.get(i);
                FileAttributes attributes = pair2.attributes;
                String name = pair2.name;
                boolean isEmptyDirectory = pair2.isEmptyDirectory;
                VirtualFileSystemEntry file2 = this.createChild(name, pair2.id, this.getFileSystem(), attributes, isEmptyDirectory);
                this.addChild(file2);
            }
            return;
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        Comparator pairComparator = (p1, p2) -> VirtualDirectoryImpl.compareNames(p1.name, p2.name, caseSensitive);
        added.sort(pairComparator);
        TIntArrayList mergedIds = new TIntArrayList(this.myData.myChildrenIds.length + added.size());
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            for (int i = 0; i < added.size(); ++i) {
                PersistentFSImpl.ChildInfo pair3 = added.get(i);
                FileAttributes attributes = pair3.attributes;
                String name = pair3.name;
                boolean isEmptyDirectory = pair3.isEmptyDirectory;
                this.myData.removeAdoptedName(name);
                this.createChild(name, pair3.id, this.getFileSystem(), attributes, isEmptyDirectory);
            }
            AbstractList<PersistentFSImpl.ChildInfo> existingChildren = new AbstractList<PersistentFSImpl.ChildInfo>(){

                @Override
                public PersistentFSImpl.ChildInfo get(int index) {
                    int id = ((VirtualDirectoryImpl)VirtualDirectoryImpl.this).myData.myChildrenIds[index];
                    CharSequence name = (CharSequence)ObjectUtils.assertNotNull((Object)VirtualDirectoryImpl.this.mySegment.vfsData.getNameByFileId(id));
                    return new PersistentFSImpl.ChildInfo(id, name.toString(), null, false);
                }

                @Override
                public int size() {
                    return ((VirtualDirectoryImpl)VirtualDirectoryImpl.this).myData.myChildrenIds.length;
                }
            };
            ContainerUtil.processSortedListsInOrder(added, (List)existingChildren, (Comparator)pairComparator, (boolean)true, pair -> mergedIds.add(pair.id));
            this.myData.myChildrenIds = mergedIds.toNativeArray();
            this.assertConsistency(caseSensitive, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull VirtualFileSystemEntry child2) {
        CharSequence childName = child2.getNameSequence();
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            this.myData.removeAdoptedName(childName);
            int indexInReal = this.findIndex(this.myData.myChildrenIds, childName, caseSensitive);
            if (indexInReal < 0) {
                this.insertChildAt(child2, indexInReal);
            }
            this.assertConsistency(caseSensitive, (Object)child2);
        }
    }

    private void insertChildAt(@NotNull VirtualFileSystemEntry file2, int negativeIndex) {
        int i = -negativeIndex - 1;
        int id = file2.getId();
        assert (id > 0) : file2;
        this.myData.myChildrenIds = ArrayUtil.insert((int[])this.myData.myChildrenIds, (int)i, (int)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull VirtualFile file2) {
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        String name = file2.getName();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int indexInReal = this.findIndex(this.myData.myChildrenIds, name, caseSensitive);
            if (indexInReal >= 0) {
                this.myData.myChildrenIds = ArrayUtil.remove((int[])this.myData.myChildrenIds, (int)indexInReal);
            }
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedName(name, caseSensitive);
            }
            this.assertConsistency(caseSensitive, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(@NotNull TIntHashSet idsToRemove, @NotNull List<? extends CharSequence> namesToRemove) {
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int[] newIds = new int[this.myData.myChildrenIds.length];
            int[] oldIds = this.myData.myChildrenIds;
            int o = 0;
            for (int oldId : oldIds) {
                if (idsToRemove.contains(oldId)) continue;
                newIds[o++] = oldId;
            }
            if (o != newIds.length) {
                newIds = o == 0 ? ArrayUtil.EMPTY_INT_ARRAY : Arrays.copyOf(newIds, o);
            }
            this.myData.myChildrenIds = newIds;
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedNames(namesToRemove, caseSensitive);
            }
            this.assertConsistency(caseSensitive, namesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateChildrenToCreate(@NotNull List<? extends VFileCreateEvent> childrenToCreate) {
        if (childrenToCreate.size() <= 1) {
            for (int i = childrenToCreate.size() - 1; i >= 0; --i) {
                VFileCreateEvent event = childrenToCreate.get(i);
                if (event.isValid()) continue;
                childrenToCreate.remove(i);
            }
            return;
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        CharSequenceHashingStrategy strategy = caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE;
        THashSet existingNames = new THashSet(this.myData.myChildrenIds.length, (TObjectHashingStrategy)strategy);
        for (int id : this.myData.myChildrenIds) {
            existingNames.add(this.mySegment.vfsData.getNameByFileId(id));
        }
        int id = this.getId();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            if (id >= 0) {
                FSRecords.NameId[] persistentIds;
                for (FSRecords.NameId nameId : persistentIds = FSRecords.listAll(id)) {
                    existingNames.add(nameId.name);
                }
            }
            this.validateAgainst(childrenToCreate, (Set<CharSequence>)existingNames);
            if (!childrenToCreate.isEmpty() && !this.allChildrenLoaded()) {
                int beforeSize = existingNames.size();
                String[] names = this.getFileSystem().list((VirtualFile)this);
                existingNames.addAll(Arrays.asList(names));
                if (beforeSize != existingNames.size()) {
                    this.validateAgainst(childrenToCreate, (Set<CharSequence>)existingNames);
                }
            }
        }
    }

    private void validateAgainst(@NotNull List<? extends VFileCreateEvent> childrenToCreate, @NotNull Set<CharSequence> existingNames) {
        for (int i = childrenToCreate.size() - 1; i >= 0; --i) {
            boolean childExists;
            VFileCreateEvent event = childrenToCreate.get(i);
            String childName = event.getChildName();
            boolean bl = childExists = !this.myData.isAdoptedName(childName) && existingNames.contains(childName);
            if (!childExists) continue;
            childrenToCreate.remove(i);
        }
    }

    public boolean allChildrenLoaded() {
        return this.getFlagInt(0x8000000);
    }

    private void setChildrenLoaded() {
        this.setFlagInt(0x8000000, true);
    }

    @NotNull
    public List<String> getSuspiciousNames() {
        return this.myData.getAdoptedNames();
    }

    private int findIndex(@NotNull int[] ids, @NotNull CharSequence name, boolean caseSensitive) {
        return ObjectUtils.binarySearch((int)0, (int)ids.length, mid -> VirtualDirectoryImpl.compareNames(this.mySegment.vfsData.getNameByFileId(ids[mid]), name, caseSensitive));
    }

    private static int compareNames(@NotNull CharSequence name1, @NotNull CharSequence name2, boolean caseSensitive) {
        int d = name1.length() - name2.length();
        if (d != 0) {
            return d;
        }
        for (int i = 0; i < name1.length(); ++i) {
            d = StringUtil.compare((char)name1.charAt(i), (char)name2.charAt(i), (!caseSensitive ? 1 : 0) != 0);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public List<VirtualFile> getCachedChildren() {
        return Arrays.asList(this.getArraySafely());
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }

    @Override
    public void markDirtyRecursively() {
        this.markDirty();
        this.markDirtyRecursivelyInternal();
    }

    private void markDirtyRecursivelyInternal() {
        for (VirtualFileSystemEntry child2 : this.getArraySafely()) {
            child2.markDirtyInternal();
            if (!(child2 instanceof VirtualDirectoryImpl)) continue;
            ((VirtualDirectoryImpl)child2).markDirtyRecursivelyInternal();
        }
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        this.myData.myUserMap = map2;
    }

    @NotNull
    protected KeyFMap getUserMap() {
        return this.myData.myUserMap;
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.myData.changeUserMap(oldMap, UserDataInterner.internUserData(newMap));
    }

    static void checkLeaks(KeyFMap newMap) {
        for (Key key : newMap.getKeys()) {
            if (key != null && newMap.get(key) instanceof PsiCachedValue) {
                throw new AssertionError((Object)"Don't store CachedValue in VFS user data, since it leads to memory leaks");
            }
        }
    }
}

