/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.CompactRecordsTable;
import com.intellij.openapi.vfs.newvfs.persistent.ContentHashesUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.io.storage.RefCountingStorage;
import com.intellij.util.io.storage.Storage;
import gnu.trove.TIntArrayList;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FSRecords {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.vfs.persistent.FSRecords");
    public static final boolean WE_HAVE_CONTENT_HASHES = SystemProperties.getBooleanProperty((String)"idea.share.contents", (boolean)true);
    static final String VFS_FILES_EXTENSION = System.getProperty("idea.vfs.files.extension", ".dat");
    private static final boolean lazyVfsDataCleaning = SystemProperties.getBooleanProperty((String)"idea.lazy.vfs.data.cleaning", (boolean)true);
    private static final boolean backgroundVfsFlush = SystemProperties.getBooleanProperty((String)"idea.background.vfs.flush", (boolean)true);
    private static final boolean inlineAttributes = SystemProperties.getBooleanProperty((String)"idea.inline.vfs.attributes", (boolean)true);
    private static final boolean bulkAttrReadSupport = SystemProperties.getBooleanProperty((String)"idea.bulk.attr.read", (boolean)false);
    private static final boolean useCompressionUtil = SystemProperties.getBooleanProperty((String)"idea.use.lightweight.compression.for.vfs", (boolean)false);
    private static final boolean useSmallAttrTable = SystemProperties.getBooleanProperty((String)"idea.use.small.attr.table.for.vfs", (boolean)true);
    private static final boolean ourStoreRootsSeparately = SystemProperties.getBooleanProperty((String)"idea.store.roots.separately", (boolean)false);
    private static final int VERSION = 53 + (WE_HAVE_CONTENT_HASHES ? 16 : 0) + (IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER ? 55 : 0) + (bulkAttrReadSupport ? 39 : 0) + (inlineAttributes ? 49 : 0) + (ourStoreRootsSeparately ? 99 : 0) + (useCompressionUtil ? 127 : 0) + (useSmallAttrTable ? 49 : 0) + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 21 : 0);
    private static final int PARENT_OFFSET = 0;
    private static final int PARENT_SIZE = 4;
    private static final int NAME_OFFSET = 4;
    private static final int NAME_SIZE = 4;
    private static final int FLAGS_OFFSET = 8;
    private static final int FLAGS_SIZE = 4;
    private static final int ATTR_REF_OFFSET = 12;
    private static final int ATTR_REF_SIZE = 4;
    private static final int CONTENT_OFFSET = 16;
    private static final int CONTENT_SIZE = 4;
    private static final int TIMESTAMP_OFFSET = 20;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int MOD_COUNT_OFFSET = 28;
    private static final int MOD_COUNT_SIZE = 4;
    private static final int LENGTH_OFFSET = 32;
    private static final int LENGTH_SIZE = 8;
    private static final int RECORD_SIZE = 40;
    private static final byte[] ZEROES = new byte[40];
    private static final int HEADER_VERSION_OFFSET = 0;
    private static final int HEADER_GLOBAL_MOD_COUNT_OFFSET = 8;
    private static final int HEADER_CONNECTION_STATUS_OFFSET = 12;
    private static final int HEADER_TIMESTAMP_OFFSET = 16;
    private static final int HEADER_SIZE = 24;
    private static final int CONNECTED_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190095;
    private static final int CORRUPTED_MAGIC = -1412464769;
    private static final FileAttribute ourChildrenAttr = new FileAttribute("FsRecords.DIRECTORY_CHILDREN");
    private static final FileAttribute ourSymlinkTargetAttr = new FileAttribute("FsRecords.SYMLINK_TARGET_2");
    private static final FileAttribute ourSymlinkTargetAttr_old = new FileAttribute("FsRecords.SYMLINK_TARGET");
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock r = lock.readLock();
    private static final ReentrantReadWriteLock.WriteLock w = lock.writeLock();
    private static volatile int ourLocalModificationCount;
    private static volatile boolean ourIsDisposed;
    private static final int FREE_RECORD_FLAG = 256;
    private static final int ALL_VALID_FLAGS = 383;
    private static final int ROOT_RECORD_ID = 1;
    private static final int MAX_SMALL_ATTR_SIZE = 64;
    private static final MessageDigest myDigest;
    private static final boolean DUMP_STATISTICS;
    private static long totalContents;
    private static long totalReuses;
    private static long time;
    private static int contents;
    private static int reuses;

    static void writeAttributesToRecord(int id, int parentId, @NotNull FileAttributes attributes, @NotNull String name) {
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.setName(id, name);
            FSRecords.setTimestamp(id, attributes.lastModified);
            FSRecords.setLength(id, attributes.isDirectory() ? -1L : attributes.length);
            FSRecords.setFlags(id, (attributes.isDirectory() ? 2 : 0) | (attributes.isWritable() ? 0 : 4) | (attributes.isSymLink() ? 16 : 0) | (attributes.isSpecial() ? 32 : 0) | (attributes.isHidden() ? 64 : 0), true);
            FSRecords.setParent(id, parentId);
        });
    }

    @Contract(value="_->fail")
    static void requestVfsRebuild(@NotNull Throwable e) {
        DbConnection.handleError(e);
    }

    @NotNull
    static File basePath() {
        return new File(DbConnection.getCachesDir());
    }

    private FSRecords() {
    }

    static void connect() {
        DbConnection.connect();
    }

    public static long getCreationTimestamp() {
        return (Long)FSRecords.readAndHandleErrors(() -> DbConnection.getTimestamp());
    }

    private static ResizeableMappedFile getRecords() {
        ResizeableMappedFile records = DbConnection.myRecords;
        assert (records != null) : "Vfs must be initialized";
        return records;
    }

    private static PersistentBTreeEnumerator<byte[]> getContentHashesEnumerator() {
        return DbConnection.myContentHashesEnumerator;
    }

    private static RefCountingStorage getContentStorage() {
        return DbConnection.myContents;
    }

    private static Storage getAttributesStorage() {
        return DbConnection.myAttributes;
    }

    private static PersistentStringEnumerator getNames() {
        return DbConnection.getNames();
    }

    public static int createRecord() {
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            int free = DbConnection.getFreeRecord();
            if (free == 0) {
                int fileLength = FSRecords.length();
                LOG.assertTrue(fileLength % 40 == 0);
                int newRecord = fileLength / 40;
                DbConnection.cleanRecord(newRecord);
                assert (fileLength + 40 == FSRecords.length());
                return newRecord;
            }
            if (lazyVfsDataCleaning) {
                FSRecords.deleteContentAndAttributes(free);
            }
            DbConnection.cleanRecord(free);
            return free;
        });
    }

    private static int length() {
        return (int)FSRecords.getRecords().length();
    }

    public static int getMaxId() {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.length() / 40);
    }

    static void deleteRecordRecursively(int id) {
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id);
            if (lazyVfsDataCleaning) {
                FSRecords.markAsDeletedRecursively(id);
            } else {
                FSRecords.doDeleteRecursively(id);
            }
        });
    }

    private static void markAsDeletedRecursively(int id) {
        for (int subRecord : FSRecords.list(id)) {
            FSRecords.markAsDeletedRecursively(subRecord);
        }
        FSRecords.markAsDeleted(id);
    }

    private static void markAsDeleted(int id) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            FSRecords.addToFreeRecordsList(id);
        });
    }

    private static void doDeleteRecursively(int id) {
        for (int subRecord : FSRecords.list(id)) {
            FSRecords.doDeleteRecursively(subRecord);
        }
        FSRecords.deleteRecord(id);
    }

    private static void deleteRecord(int id) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            FSRecords.deleteContentAndAttributes(id);
            DbConnection.cleanRecord(id);
            FSRecords.addToFreeRecordsList(id);
        });
    }

    private static void deleteContentAndAttributes(int id) throws IOException {
        int att_page;
        int content_page = FSRecords.getContentRecordId(id);
        if (content_page != 0) {
            if (WE_HAVE_CONTENT_HASHES) {
                FSRecords.getContentStorage().releaseRecord(content_page, false);
            } else {
                FSRecords.getContentStorage().releaseRecord(content_page);
            }
        }
        if ((att_page = FSRecords.getAttributeRecordId(id)) != 0) {
            try (DataInputStream attStream = FSRecords.getAttributesStorage().readStream(att_page);){
                if (bulkAttrReadSupport) {
                    FSRecords.skipRecordHeader(attStream, DbConnection.RESERVED_ATTR_ID, id);
                }
                while (attStream.available() > 0) {
                    DataInputOutputUtil.readINT((DataInput)attStream);
                    int attAddressOrSize = DataInputOutputUtil.readINT((DataInput)attStream);
                    if (inlineAttributes) {
                        if (attAddressOrSize < 64) {
                            attStream.skipBytes(attAddressOrSize);
                            continue;
                        }
                        attAddressOrSize -= 64;
                    }
                    FSRecords.getAttributesStorage().deleteRecord(attAddressOrSize);
                }
            }
            FSRecords.getAttributesStorage().deleteRecord(att_page);
        }
    }

    private static void addToFreeRecordsList(int id) {
        FSRecords.setFlags(id, 256, false);
    }

    @NotNull
    static int[] listRoots() {
        return (int[])FSRecords.readAndHandleErrors(() -> {
            if (ourStoreRootsSeparately) {
                TIntArrayList result2 = new TIntArrayList();
                try (LineNumberReader stream = new LineNumberReader(new BufferedReader(new InputStreamReader(new FileInputStream(DbConnection.myRootsFile))));){
                    String str;
                    while ((str = stream.readLine()) != null) {
                        int index = str.indexOf(32);
                        int id = Integer.parseInt(str.substring(0, index));
                        result2.add(id);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return result2.toNativeArray();
            }
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                if (input == null) {
                    int[] nArray = ArrayUtil.EMPTY_INT_ARRAY;
                    return nArray;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                int[] result3 = ArrayUtil.newIntArray((int)count);
                int prevId = 0;
                for (int i = 0; i < count; ++i) {
                    DataInputOutputUtil.readINT((DataInput)input);
                    prevId = result3[i] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                }
                int[] nArray = result3;
                return nArray;
            }
        });
    }

    static void force() {
        FSRecords.writeAndHandleErrors(() -> DbConnection.doForce());
    }

    static boolean isDirty() {
        return (Boolean)FSRecords.readAndHandleErrors(DbConnection::isDirty);
    }

    private static void saveNameIdSequenceWithDeltas(int[] names, int[] ids, DataOutputStream output) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)output, (int)names.length);
        int prevId = 0;
        int prevNameId = 0;
        for (int i = 0; i < names.length; ++i) {
            DataInputOutputUtil.writeINT((DataOutput)output, (int)(names[i] - prevNameId));
            DataInputOutputUtil.writeINT((DataOutput)output, (int)(ids[i] - prevId));
            prevId = ids[i];
            prevNameId = names[i];
        }
    }

    static int findRootRecord(@NotNull String rootUrl) {
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            int id;
            if (ourStoreRootsSeparately) {
                Throwable throwable;
                Closeable stream2;
                try {
                    stream2 = new LineNumberReader(new BufferedReader(new InputStreamReader(new FileInputStream(DbConnection.myRootsFile))));
                    throwable = null;
                    try {
                        String str;
                        while ((str = ((LineNumberReader)stream2).readLine()) != null) {
                            int index = str.indexOf(32);
                            if (!str.substring(index + 1).equals(rootUrl)) continue;
                            Integer n = Integer.parseInt(str.substring(0, index));
                            return n;
                        }
                    }
                    catch (Throwable str) {
                        throwable = str;
                        throw str;
                    }
                    finally {
                        if (stream2 != null) {
                            if (throwable != null) {
                                try {
                                    ((BufferedReader)stream2).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                ((BufferedReader)stream2).close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException stream2) {
                    // empty catch block
                }
                DbConnection.markDirty();
                stream2 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(DbConnection.myRootsFile, true)));
                throwable = null;
                try {
                    int id2 = FSRecords.createRecord();
                    ((Writer)stream2).write(id2 + " " + rootUrl + "\n");
                    Integer index = id2;
                    return index;
                }
                catch (Throwable id2) {
                    throwable = id2;
                    throw id2;
                }
                finally {
                    if (stream2 != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)stream2).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((Writer)stream2).close();
                        }
                    }
                }
            }
            int root = FSRecords.getNames().tryEnumerate((Object)rootUrl);
            int[] names = ArrayUtil.EMPTY_INT_ARRAY;
            int[] ids = ArrayUtil.EMPTY_INT_ARRAY;
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                if (input != null) {
                    int count = DataInputOutputUtil.readINT((DataInput)input);
                    names = ArrayUtil.newIntArray((int)count);
                    ids = ArrayUtil.newIntArray((int)count);
                    int prevId = 0;
                    int prevNameId = 0;
                    for (int i = 0; i < count; ++i) {
                        int name = DataInputOutputUtil.readINT((DataInput)input) + prevNameId;
                        int id3 = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                        if (name == root) {
                            Integer n = id3;
                            return n;
                        }
                        prevNameId = names[i] = name;
                        prevId = ids[i] = id3;
                    }
                }
            }
            DbConnection.markDirty();
            root = FSRecords.getNames().enumerate(rootUrl);
            try (DataOutputStream output = FSRecords.writeAttribute(1, ourChildrenAttr);){
                id = FSRecords.createRecord();
                int index = Arrays.binarySearch(ids, id);
                ids = ArrayUtil.insert((int[])ids, (int)(-index - 1), (int)id);
                names = ArrayUtil.insert((int[])names, (int)(-index - 1), (int)root);
                FSRecords.saveNameIdSequenceWithDeltas(names, ids, output);
            }
            return id;
        });
    }

    static void deleteRootRecord(int id) {
        FSRecords.writeAndHandleErrors(() -> {
            int[] ids;
            int[] names;
            DbConnection.markDirty();
            if (ourStoreRootsSeparately) {
                Throwable throwable;
                ArrayList<Object> rootsThatLeft = new ArrayList<Object>();
                try {
                    throwable = null;
                    try (LineNumberReader stream2 = new LineNumberReader(new BufferedReader(new InputStreamReader(new FileInputStream(DbConnection.myRootsFile))));){
                        Object str;
                        while ((str = stream2.readLine()) != null) {
                            int n = ((String)str).indexOf(32);
                            int rootId = Integer.parseInt(((String)str).substring(0, n));
                            if (rootId == id) continue;
                            rootsThatLeft.add(str);
                        }
                    }
                    catch (Throwable str) {
                        throwable = str;
                        throw str;
                    }
                }
                catch (FileNotFoundException stream2) {
                    // empty catch block
                }
                throwable = null;
                try (BufferedWriter stream = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(DbConnection.myRootsFile)));){
                    for (String string : rootsThatLeft) {
                        stream.write(string);
                        stream.write("\n");
                    }
                }
                catch (Throwable str) {
                    throwable = str;
                    throw str;
                }
                return;
            }
            try (DataInputStream input = FSRecords.readAttribute(1, ourChildrenAttr);){
                assert (input != null);
                int n = DataInputOutputUtil.readINT((DataInput)input);
                names = ArrayUtil.newIntArray((int)n);
                ids = ArrayUtil.newIntArray((int)n);
                int prevId = 0;
                int prevNameId = 0;
                for (int i = 0; i < n; ++i) {
                    names[i] = DataInputOutputUtil.readINT((DataInput)input) + prevNameId;
                    ids[i] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                    prevId = ids[i];
                    prevNameId = names[i];
                }
            }
            int index = ArrayUtil.find((int[])ids, (int)id);
            assert (index >= 0);
            names = ArrayUtil.remove((int[])names, (int)index);
            ids = ArrayUtil.remove((int[])ids, (int)index);
            Throwable throwable = null;
            try (DataOutputStream output = FSRecords.writeAttribute(1, ourChildrenAttr);){
                FSRecords.saveNameIdSequenceWithDeltas(names, ids, output);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        });
    }

    @NotNull
    static int[] list(int id) {
        return (int[])FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream input = FSRecords.readAttribute(id, ourChildrenAttr);){
                if (input == null) {
                    int[] nArray = ArrayUtil.EMPTY_INT_ARRAY;
                    return nArray;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                int[] result2 = ArrayUtil.newIntArray((int)count);
                int prevId = id;
                for (int i = 0; i < count; ++i) {
                    prevId = result2[i] = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                }
                int[] nArray = result2;
                return nArray;
            }
        });
    }

    static boolean mayHaveChildren(int id) {
        return (Boolean)FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream input = FSRecords.readAttribute(id, ourChildrenAttr);){
                if (input == null) {
                    Boolean bl = true;
                    return bl;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                Boolean bl = count != 0;
                return bl;
            }
        });
    }

    @NotNull
    public static NameId[] listAll(int parentId) {
        return (NameId[])FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream input = FSRecords.readAttribute(parentId, ourChildrenAttr);){
                if (input == null) {
                    NameId[] nameIdArray = NameId.EMPTY_ARRAY;
                    return nameIdArray;
                }
                int count = DataInputOutputUtil.readINT((DataInput)input);
                NameId[] result2 = count == 0 ? NameId.EMPTY_ARRAY : new NameId[count];
                int prevId = parentId;
                for (int i = 0; i < count; ++i) {
                    int id;
                    prevId = id = DataInputOutputUtil.readINT((DataInput)input) + prevId;
                    int nameId = FSRecords.doGetNameId(id);
                    result2[i] = new NameId(id, nameId, FileNameCache.getVFileName(nameId, FSRecords::doGetNameByNameId));
                }
                NameId[] nameIdArray = result2;
                return nameIdArray;
            }
        });
    }

    static boolean wereChildrenAccessed(int id) {
        return (Boolean)FSRecords.readAndHandleErrors(() -> FSRecords.findAttributePage(id, ourChildrenAttr, false) != 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readAndHandleErrors(@NotNull ThrowableComputable<T, ?> action) {
        assert (lock.getReadHoldCount() == 0);
        try {
            r.lock();
            try {
                Object object = action.compute();
                return (T)object;
            }
            finally {
                r.unlock();
            }
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
    }

    private static <T> T writeAndHandleErrors(@NotNull ThrowableComputable<T, ?> action) {
        try {
            w.lock();
            Object object = action.compute();
            return (T)object;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
        finally {
            w.unlock();
        }
    }

    private static void writeAndHandleErrors(@NotNull ThrowableRunnable<?> action) {
        try {
            w.lock();
            action.run();
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            throw new RuntimeException(e);
        }
        finally {
            w.unlock();
        }
    }

    static void updateList(int id, @NotNull int[] childIds) {
        Arrays.sort(childIds);
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            try (DataOutputStream record = FSRecords.writeAttribute(id, ourChildrenAttr);){
                DataInputOutputUtil.writeINT((DataOutput)record, (int)childIds.length);
                int prevId = id;
                for (int childId : childIds) {
                    assert (childId > 0) : childId;
                    if (childId == id) {
                        LOG.error("Cyclic parent child relations");
                        continue;
                    }
                    int delta = childId - prevId;
                    DataInputOutputUtil.writeINT((DataOutput)record, (int)delta);
                    prevId = childId;
                }
            }
        });
    }

    @Nullable
    static String readSymlinkTarget(int id) {
        return (String)FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream stream = FSRecords.readAttribute(id, ourSymlinkTargetAttr);){
                if (stream != null) {
                    String string = StringUtil.nullize((String)IOUtil.readUTF((DataInput)stream));
                    return string;
                }
            }
            stream = FSRecords.readAttribute(id, ourSymlinkTargetAttr_old);
            var2_2 = null;
            try {
                if (stream != null) {
                    String string = StringUtil.nullize((String)stream.readUTF());
                    return string;
                }
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (var2_2 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            return null;
        });
    }

    static void storeSymlinkTarget(int id, @Nullable String symlinkTarget) {
        FSRecords.writeAndHandleErrors(() -> {
            DbConnection.markDirty();
            try (DataOutputStream stream = FSRecords.writeAttribute(id, ourSymlinkTargetAttr);){
                IOUtil.writeUTF((DataOutput)stream, (String)StringUtil.notNullize((String)symlinkTarget));
            }
        });
    }

    private static void incModCount(int id) {
        FSRecords.incLocalModCount();
        int count = FSRecords.doGetModCount() + 1;
        FSRecords.getRecords().putInt(8L, count);
        FSRecords.setModCount(id, count);
    }

    private static void incLocalModCount() {
        DbConnection.markDirty();
        ++ourLocalModificationCount;
    }

    static int getLocalModCount() {
        return ourLocalModificationCount;
    }

    static int getModCount() {
        return (Integer)FSRecords.readAndHandleErrors(FSRecords::doGetModCount);
    }

    private static int doGetModCount() {
        return FSRecords.getRecords().getInt(8L);
    }

    public static int getParent(int id) {
        return (Integer)FSRecords.readAndHandleErrors(() -> {
            int parentId = FSRecords.getRecordInt(id, 0);
            if (parentId == id) {
                LOG.error("Cyclic parent child relations in the database. id = " + id);
                return 0;
            }
            return parentId;
        });
    }

    @Nullable
    static VirtualFileSystemEntry findFileById(final int id, final @NotNull ConcurrentIntObjectMap<VirtualFileSystemEntry> idToDirCache) {
        class ParentFinder
        implements ThrowableComputable<Void, Throwable> {
            @Nullable
            private TIntArrayList path;
            private VirtualFileSystemEntry foundParent;

            ParentFinder() {
            }

            public Void compute() {
                int parentId;
                int currentId = id;
                while ((parentId = FSRecords.getRecordInt(currentId, 0)) != 0) {
                    if (parentId == currentId || this.path != null && this.path.size() % 128 == 0 && this.path.contains(parentId)) {
                        LOG.error("Cyclic parent child relations in the database. id = " + parentId);
                        break;
                    }
                    this.foundParent = (VirtualFileSystemEntry)((Object)idToDirCache.get(parentId));
                    if (this.foundParent != null) break;
                    currentId = parentId;
                    if (this.path == null) {
                        this.path = new TIntArrayList();
                    }
                    this.path.add(currentId);
                }
                return null;
            }

            private VirtualFileSystemEntry findDescendantByIdPath() {
                VirtualFileSystemEntry parent = this.foundParent;
                if (this.path != null) {
                    for (int i = this.path.size() - 1; i >= 0; --i) {
                        parent = this.findChild(parent, this.path.get(i));
                    }
                }
                return this.findChild(parent, id);
            }

            private VirtualFileSystemEntry findChild(VirtualFileSystemEntry parent, int childId) {
                VirtualFileSystemEntry old;
                if (!(parent instanceof VirtualDirectoryImpl)) {
                    return null;
                }
                VirtualFileSystemEntry child2 = ((VirtualDirectoryImpl)parent).findChildById(childId);
                if (child2 instanceof VirtualDirectoryImpl && (old = (VirtualFileSystemEntry)((Object)idToDirCache.putIfAbsent(childId, (Object)child2))) != null) {
                    child2 = old;
                }
                return child2;
            }
        }
        ParentFinder finder = new ParentFinder();
        FSRecords.readAndHandleErrors(finder);
        return finder.findDescendantByIdPath();
    }

    static void setParent(int id, int parentId) {
        if (id == parentId) {
            LOG.error("Cyclic parent/child relations");
            return;
        }
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id);
            FSRecords.putRecordInt(id, 0, parentId);
        });
    }

    static int getNameId(int id) {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameId(id));
    }

    private static int doGetNameId(int id) {
        return FSRecords.getRecordInt(id, 4);
    }

    public static int getNameId(String name) {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.getNames().enumerate(name));
    }

    public static String getName(int id) {
        return FSRecords.getNameSequence(id).toString();
    }

    @NotNull
    static CharSequence getNameSequence(int id) {
        return (CharSequence)FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameSequence(id));
    }

    @NotNull
    private static CharSequence doGetNameSequence(int id) throws IOException {
        int nameId = FSRecords.getRecordInt(id, 4);
        return nameId == 0 ? "" : FileNameCache.getVFileName(nameId, FSRecords::doGetNameByNameId);
    }

    public static String getNameByNameId(int nameId) {
        return (String)FSRecords.readAndHandleErrors(() -> FSRecords.doGetNameByNameId(nameId));
    }

    private static String doGetNameByNameId(int nameId) throws IOException {
        return nameId == 0 ? "" : FSRecords.getNames().valueOf(nameId);
    }

    static void setName(int id, @NotNull String name) {
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.incModCount(id);
            int nameId = FSRecords.getNames().enumerate(name);
            FSRecords.putRecordInt(id, 4, nameId);
        });
    }

    static int getFlags(int id) {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.doGetFlags(id));
    }

    private static int doGetFlags(int id) {
        return FSRecords.getRecordInt(id, 8);
    }

    static void setFlags(int id, int flags, boolean markAsChange) {
        FSRecords.writeAndHandleErrors(() -> {
            if (markAsChange) {
                FSRecords.incModCount(id);
            }
            FSRecords.putRecordInt(id, 8, flags);
        });
    }

    static long getLength(int id) {
        return (Long)FSRecords.readAndHandleErrors(() -> FSRecords.getRecords().getLong((long)FSRecords.getOffset(id, 32)));
    }

    static void setLength(int id, long len) {
        FSRecords.writeAndHandleErrors(() -> {
            int lengthOffset;
            ResizeableMappedFile records = FSRecords.getRecords();
            if (records.getLong((long)(lengthOffset = FSRecords.getOffset(id, 32))) != len) {
                FSRecords.incModCount(id);
                records.putLong((long)lengthOffset, len);
            }
        });
    }

    static long getTimestamp(int id) {
        return (Long)FSRecords.readAndHandleErrors(() -> FSRecords.getRecords().getLong((long)FSRecords.getOffset(id, 20)));
    }

    static void setTimestamp(int id, long value) {
        FSRecords.writeAndHandleErrors(() -> {
            int timeStampOffset = FSRecords.getOffset(id, 20);
            ResizeableMappedFile records = FSRecords.getRecords();
            if (records.getLong((long)timeStampOffset) != value) {
                FSRecords.incModCount(id);
                records.putLong((long)timeStampOffset, value);
            }
        });
    }

    static int getModCount(int id) {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.getRecordInt(id, 28));
    }

    private static void setModCount(int id, int value) {
        FSRecords.putRecordInt(id, 28, value);
    }

    private static int getContentRecordId(int fileId) {
        return FSRecords.getRecordInt(fileId, 16);
    }

    private static void setContentRecordId(int id, int value) {
        FSRecords.putRecordInt(id, 16, value);
    }

    private static int getAttributeRecordId(int id) {
        return FSRecords.getRecordInt(id, 12);
    }

    private static void setAttributeRecordId(int id, int value) {
        FSRecords.putRecordInt(id, 12, value);
    }

    private static int getRecordInt(int id, int offset) {
        return FSRecords.getRecords().getInt((long)FSRecords.getOffset(id, offset));
    }

    private static void putRecordInt(int id, int offset, int value) {
        FSRecords.getRecords().putInt((long)FSRecords.getOffset(id, offset), value);
    }

    private static int getOffset(int id, int offset) {
        return id * 40 + offset;
    }

    @Nullable
    static DataInputStream readContent(int fileId) {
        int page = (Integer)FSRecords.readAndHandleErrors(() -> {
            FSRecords.checkFileIsValid(fileId);
            return FSRecords.getContentRecordId(fileId);
        });
        if (page == 0) {
            return null;
        }
        try {
            return FSRecords.doReadContentById(page);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return null;
        }
    }

    @NotNull
    static DataInputStream readContentById(int contentId) {
        try {
            return FSRecords.doReadContentById(contentId);
        }
        catch (Throwable e) {
            DbConnection.handleError(e);
            return null;
        }
    }

    @NotNull
    private static DataInputStream doReadContentById(int contentId) throws IOException {
        DataInputStream stream = FSRecords.getContentStorage().readStream(contentId);
        if (useCompressionUtil) {
            byte[] bytes = CompressionUtil.readCompressed((DataInput)stream);
            stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
        }
        return stream;
    }

    @Nullable
    public static DataInputStream readAttributeWithLock(int fileId, @NotNull FileAttribute att) {
        return (DataInputStream)FSRecords.readAndHandleErrors(() -> {
            try (DataInputStream stream = FSRecords.readAttribute(fileId, att);){
                if (stream != null && att.isVersioned()) {
                    try {
                        int actualVersion = DataInputOutputUtil.readINT((DataInput)stream);
                        if (actualVersion != att.getVersion()) {
                            DataInputStream dataInputStream = null;
                            return dataInputStream;
                        }
                    }
                    catch (IOException e) {
                        DataInputStream dataInputStream = null;
                        return dataInputStream;
                    }
                }
                DataInputStream dataInputStream = stream;
                return dataInputStream;
            }
        });
    }

    @Nullable
    private static DataInputStream readAttribute(int fileId, @NotNull FileAttribute attribute) throws IOException {
        FSRecords.checkFileIsValid(fileId);
        int recordId = FSRecords.getAttributeRecordId(fileId);
        if (recordId == 0) {
            return null;
        }
        int encodedAttrId = DbConnection.getAttributeId(attribute.getId());
        Storage storage2 = FSRecords.getAttributesStorage();
        int page = 0;
        try (DataInputStream attrRefs = storage2.readStream(recordId);){
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(attrRefs, DbConnection.RESERVED_ATTR_ID, fileId);
            }
            while (attrRefs.available() > 0) {
                int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                if (attIdOnPage != encodedAttrId) {
                    if (!inlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                    continue;
                }
                if (inlineAttributes && attrAddressOrSize < 64) {
                    byte[] b = new byte[attrAddressOrSize];
                    attrRefs.readFully(b);
                    DataInputStream dataInputStream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(b));
                    return dataInputStream;
                }
                page = inlineAttributes ? attrAddressOrSize - 64 : attrAddressOrSize;
                break;
            }
        }
        if (page == 0) {
            return null;
        }
        DataInputStream stream = FSRecords.getAttributesStorage().readStream(page);
        if (bulkAttrReadSupport) {
            FSRecords.skipRecordHeader(stream, encodedAttrId, fileId);
        }
        return stream;
    }

    /*
     * Loose catch block
     */
    private static int findAttributePage(int fileId, @NotNull FileAttribute attr, boolean toWrite) throws IOException {
        Throwable throwable;
        FSRecords.checkFileIsValid(fileId);
        int recordId = FSRecords.getAttributeRecordId(fileId);
        int encodedAttrId = DbConnection.getAttributeId(attr.getId());
        boolean directoryRecord = false;
        Storage storage2 = FSRecords.getAttributesStorage();
        if (recordId == 0) {
            if (!toWrite) {
                return 0;
            }
            recordId = storage2.createNewRecord();
            FSRecords.setAttributeRecordId(fileId, recordId);
            directoryRecord = true;
        } else {
            throwable = null;
            try (DataInputStream attrRefs = storage2.readStream(recordId);){
                if (bulkAttrReadSupport) {
                    FSRecords.skipRecordHeader(attrRefs, DbConnection.RESERVED_ATTR_ID, fileId);
                }
                while (attrRefs.available() > 0) {
                    int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                    int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                    if (attIdOnPage == encodedAttrId) {
                        if (inlineAttributes) {
                            int n = attrAddressOrSize < 64 ? -recordId : attrAddressOrSize - 64;
                            return n;
                        }
                        int n = attrAddressOrSize;
                        return n;
                    }
                    if (!inlineAttributes || attrAddressOrSize >= 64) continue;
                    attrRefs.skipBytes(attrAddressOrSize);
                }
            }
            catch (Throwable attIdOnPage) {
                throwable = attIdOnPage;
                throw attIdOnPage;
            }
        }
        if (toWrite) {
            try {
                throwable = null;
                try (AbstractStorage.AppenderStream appender = storage2.appendStream(recordId);){
                    if (bulkAttrReadSupport && directoryRecord) {
                        DataInputOutputUtil.writeINT((DataOutput)appender, (int)DbConnection.RESERVED_ATTR_ID);
                        DataInputOutputUtil.writeINT((DataOutput)appender, (int)fileId);
                    }
                    DataInputOutputUtil.writeINT((DataOutput)appender, (int)encodedAttrId);
                    int attrAddress = storage2.createNewRecord();
                    DataInputOutputUtil.writeINT((DataOutput)appender, (int)(inlineAttributes ? attrAddress + 64 : attrAddress));
                    DbConnection.REASONABLY_SMALL.myAttrPageRequested = true;
                    int n = attrAddress;
                    return n;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                {
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
            finally {
                DbConnection.REASONABLY_SMALL.myAttrPageRequested = false;
            }
        }
        return 0;
    }

    private static void skipRecordHeader(DataInputStream refs, int expectedRecordTag, int expectedFileId) throws IOException {
        int attId = DataInputOutputUtil.readINT((DataInput)refs);
        assert (attId == expectedRecordTag || expectedRecordTag == 0);
        int fileId = DataInputOutputUtil.readINT((DataInput)refs);
        assert (expectedFileId == fileId || expectedFileId == 0);
    }

    private static void writeRecordHeader(int recordTag, int fileId, @NotNull DataOutputStream appender) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)appender, (int)recordTag);
        DataInputOutputUtil.writeINT((DataOutput)appender, (int)fileId);
    }

    private static void checkFileIsValid(int fileId) throws IOException {
        assert (fileId > 0) : fileId;
        if (!lazyVfsDataCleaning) assert (!BitUtil.isSet((int)FSRecords.doGetFlags(fileId), (int)256)) : "Accessing attribute of a deleted page: " + fileId + ":" + FSRecords.doGetNameSequence(fileId);
    }

    static int acquireFileContent(int fileId) {
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            int record = FSRecords.getContentRecordId(fileId);
            if (record > 0) {
                FSRecords.getContentStorage().acquireRecord(record);
            }
            return record;
        });
    }

    static void releaseContent(int contentId) {
        FSRecords.writeAndHandleErrors(() -> FSRecords.getContentStorage().releaseRecord(contentId, !WE_HAVE_CONTENT_HASHES));
    }

    static int getContentId(int fileId) {
        return (Integer)FSRecords.readAndHandleErrors(() -> FSRecords.getContentRecordId(fileId));
    }

    @NotNull
    static DataOutputStream writeContent(int fileId, boolean readOnly) {
        return new ContentOutputStream(fileId, readOnly);
    }

    static void writeContent(int fileId, ByteArraySequence bytes, boolean readOnly) {
        new ContentOutputStream(fileId, readOnly).writeBytes(bytes);
    }

    static int storeUnlinkedContent(byte[] bytes) {
        return (Integer)FSRecords.writeAndHandleErrors(() -> {
            int recordId;
            if (WE_HAVE_CONTENT_HASHES) {
                recordId = FSRecords.findOrCreateContentRecord(bytes, 0, bytes.length);
                if (recordId > 0) {
                    return recordId;
                }
                recordId = -recordId;
            } else {
                recordId = FSRecords.getContentStorage().acquireNewRecord();
            }
            try (AbstractStorage.StorageDataOutput output = FSRecords.getContentStorage().writeStream(recordId, true);){
                output.write(bytes);
            }
            return recordId;
        });
    }

    @NotNull
    public static DataOutputStream writeAttribute(int fileId, @NotNull FileAttribute att) {
        AttributeOutputStream stream = new AttributeOutputStream(fileId, att);
        if (att.isVersioned()) {
            try {
                DataInputOutputUtil.writeINT((DataOutput)((Object)stream), (int)att.getVersion());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return stream;
    }

    private static int findOrCreateContentRecord(byte[] bytes, int offset, int length) throws IOException {
        assert (WE_HAVE_CONTENT_HASHES);
        long started = DUMP_STATISTICS ? System.nanoTime() : 0L;
        myDigest.reset();
        myDigest.update(String.valueOf(length - offset).getBytes(Charset.defaultCharset()));
        myDigest.update("\u0000".getBytes(Charset.defaultCharset()));
        myDigest.update(bytes, offset, length);
        byte[] digest = myDigest.digest();
        long done = DUMP_STATISTICS ? System.nanoTime() - started : 0L;
        time += done;
        totalContents += (long)length;
        if (DUMP_STATISTICS && (++contents & 0x3FFF) == 0) {
            LOG.info("Contents:" + contents + " of " + totalContents + ", reuses:" + reuses + " of " + totalReuses + " for " + time / 1000000L);
        }
        PersistentBTreeEnumerator<byte[]> hashesEnumerator = FSRecords.getContentHashesEnumerator();
        int largestId = hashesEnumerator.getLargestId();
        int page = hashesEnumerator.enumerate((Object)digest);
        if (page <= largestId) {
            ++reuses;
            FSRecords.getContentStorage().acquireRecord(page);
            totalReuses += (long)length;
            return page;
        }
        int newRecord = FSRecords.getContentStorage().acquireNewRecord();
        assert (page == newRecord) : "Unexpected content storage modification: page=" + page + "; newRecord=" + newRecord;
        return -page;
    }

    static void dispose() {
        FSRecords.writeAndHandleErrors(() -> {
            try {
                DbConnection.doForce();
                DbConnection.closeFiles();
            }
            finally {
                ourIsDisposed = true;
            }
        });
    }

    public static void invalidateCaches() {
        DbConnection.createBrokenMarkerFile(null);
    }

    static void checkSanity() {
        long t = System.currentTimeMillis();
        int recordCount = (Integer)FSRecords.readAndHandleErrors(() -> {
            int fileLength = FSRecords.length();
            assert (fileLength % 40 == 0);
            return fileLength / 40;
        });
        IntArrayList usedAttributeRecordIds = new IntArrayList();
        IntArrayList validAttributeIds = new IntArrayList();
        for (int id = 2; id < recordCount; ++id) {
            int flags = FSRecords.getFlags(id);
            LOG.assertTrue((flags & 0xFFFFFE80) == 0, (Object)("Invalid flags: 0x" + Integer.toHexString(flags) + ", id: " + id));
            int currentId = id;
            boolean isFreeRecord = (Boolean)FSRecords.readAndHandleErrors(() -> DbConnection.myFreeRecords.contains(currentId));
            if (BitUtil.isSet((int)flags, (int)256)) {
                LOG.assertTrue(isFreeRecord, (Object)("Record, marked free, not in free list: " + id));
                continue;
            }
            LOG.assertTrue(!isFreeRecord, (Object)("Record, not marked free, in free list: " + id));
            FSRecords.checkRecordSanity(id, recordCount, usedAttributeRecordIds, validAttributeIds);
        }
        t = System.currentTimeMillis() - t;
        LOG.info("Sanity check took " + t + " ms");
    }

    private static void checkRecordSanity(int id, int recordCount, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) {
        int parentId = FSRecords.getParent(id);
        assert (parentId >= 0 && parentId < recordCount);
        if (parentId > 0 && FSRecords.getParent(parentId) > 0) {
            int parentFlags = FSRecords.getFlags(parentId);
            assert (!BitUtil.isSet((int)parentFlags, (int)256)) : parentId + ": " + Integer.toHexString(parentFlags);
            assert (BitUtil.isSet((int)parentFlags, (int)2)) : parentId + ": " + Integer.toHexString(parentFlags);
        }
        CharSequence name = FSRecords.getNameSequence(id);
        LOG.assertTrue(parentId == 0 || name.length() != 0, (Object)("File with empty name found under " + FSRecords.getNameSequence(parentId) + ", id=" + id));
        FSRecords.writeAndHandleErrors(() -> {
            FSRecords.checkContentsStorageSanity(id);
            FSRecords.checkAttributesStorageSanity(id, usedAttributeRecordIds, validAttributeIds);
        });
        long length = FSRecords.getLength(id);
        assert (length >= -1L) : "Invalid file length found for " + name + ": " + length;
    }

    private static void checkContentsStorageSanity(int id) {
        int recordId = FSRecords.getContentRecordId(id);
        assert (recordId >= 0);
        if (recordId > 0) {
            FSRecords.getContentStorage().checkSanity(recordId);
        }
    }

    private static void checkAttributesStorageSanity(int id, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) {
        int attributeRecordId = FSRecords.getAttributeRecordId(id);
        assert (attributeRecordId >= 0);
        if (attributeRecordId > 0) {
            try {
                FSRecords.checkAttributesSanity(attributeRecordId, usedAttributeRecordIds, validAttributeIds);
            }
            catch (IOException ex) {
                DbConnection.handleError(ex);
            }
        }
    }

    private static void checkAttributesSanity(int attributeRecordId, IntArrayList usedAttributeRecordIds, IntArrayList validAttributeIds) throws IOException {
        assert (!usedAttributeRecordIds.contains(attributeRecordId));
        usedAttributeRecordIds.add(attributeRecordId);
        try (DataInputStream dataInputStream = FSRecords.getAttributesStorage().readStream(attributeRecordId);){
            if (bulkAttrReadSupport) {
                FSRecords.skipRecordHeader(dataInputStream, 0, 0);
            }
            while (dataInputStream.available() > 0) {
                int attId = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (!validAttributeIds.contains(attId)) {
                    validAttributeIds.add(attId);
                }
                int attDataRecordIdOrSize = DataInputOutputUtil.readINT((DataInput)dataInputStream);
                if (inlineAttributes) {
                    if (attDataRecordIdOrSize < 64) {
                        dataInputStream.skipBytes(attDataRecordIdOrSize);
                        continue;
                    }
                    attDataRecordIdOrSize -= 64;
                }
                assert (!usedAttributeRecordIds.contains(attDataRecordIdOrSize));
                usedAttributeRecordIds.add(attDataRecordIdOrSize);
                FSRecords.getAttributesStorage().checkSanity(attDataRecordIdOrSize);
            }
        }
    }

    @Contract(value="_->fail")
    public static void handleError(Throwable e) throws RuntimeException, Error {
        DbConnection.handleError(e);
    }

    static {
        myDigest = ContentHashesUtil.createHashDigest();
        DUMP_STATISTICS = WE_HAVE_CONTENT_HASHES;
    }

    private static class AttributeOutputStream
    extends DataOutputStream {
        @NotNull
        private final FileAttribute myAttribute;
        private final int myFileId;

        private AttributeOutputStream(int fileId, @NotNull FileAttribute attribute) {
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myAttribute = attribute;
        }

        public void close() throws IOException {
            super.close();
            FSRecords.writeAndHandleErrors(() -> {
                BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
                if (inlineAttributes && _out.size() < 64) {
                    this.rewriteDirectoryRecordWithAttrContent(_out);
                    FSRecords.incLocalModCount();
                } else {
                    FSRecords.incLocalModCount();
                    int page = FSRecords.findAttributePage(this.myFileId, this.myAttribute, true);
                    if (inlineAttributes && page < 0) {
                        this.rewriteDirectoryRecordWithAttrContent(new BufferExposingByteArrayOutputStream());
                        page = FSRecords.findAttributePage(this.myFileId, this.myAttribute, true);
                    }
                    if (bulkAttrReadSupport) {
                        BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream();
                        this.out = stream;
                        FSRecords.writeRecordHeader(DbConnection.getAttributeId(this.myAttribute.getId()), this.myFileId, this);
                        this.write(_out.getInternalBuffer(), 0, _out.size());
                        FSRecords.getAttributesStorage().writeBytes(page, stream.toByteArraySequence(), this.myAttribute.isFixedSize());
                    } else {
                        FSRecords.getAttributesStorage().writeBytes(page, _out.toByteArraySequence(), this.myAttribute.isFixedSize());
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rewriteDirectoryRecordWithAttrContent(@NotNull BufferExposingByteArrayOutputStream _out) throws IOException {
            Throwable throwable;
            int recordId = FSRecords.getAttributeRecordId(this.myFileId);
            assert (inlineAttributes);
            int encodedAttrId = DbConnection.getAttributeId(this.myAttribute.getId());
            Storage storage2 = FSRecords.getAttributesStorage();
            BufferExposingByteArrayOutputStream unchangedPreviousDirectoryStream = null;
            boolean directoryRecord = false;
            if (recordId == 0) {
                recordId = storage2.createNewRecord();
                FSRecords.setAttributeRecordId(this.myFileId, recordId);
                directoryRecord = true;
            } else {
                throwable = null;
                try (DataInputStream attrRefs = storage2.readStream(recordId);
                     DataOutputStream dataStream = null;){
                    int remainingAtStart = attrRefs.available();
                    if (bulkAttrReadSupport) {
                        unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                        dataStream = new DataOutputStream((OutputStream)unchangedPreviousDirectoryStream);
                        int attId = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        assert (attId == DbConnection.RESERVED_ATTR_ID);
                        int fileId = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        assert (this.myFileId == fileId);
                        FSRecords.writeRecordHeader(attId, fileId, dataStream);
                    }
                    while (attrRefs.available() > 0) {
                        int attIdOnPage = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        int attrAddressOrSize = DataInputOutputUtil.readINT((DataInput)attrRefs);
                        if (attIdOnPage != encodedAttrId) {
                            if (dataStream == null) {
                                unchangedPreviousDirectoryStream = new BufferExposingByteArrayOutputStream();
                                dataStream = new DataOutputStream((OutputStream)unchangedPreviousDirectoryStream);
                            }
                            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)attIdOnPage);
                            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)attrAddressOrSize);
                            if (attrAddressOrSize >= 64) continue;
                            byte[] b = new byte[attrAddressOrSize];
                            attrRefs.readFully(b);
                            dataStream.write(b);
                            continue;
                        }
                        if (attrAddressOrSize >= 64) continue;
                        if (_out.size() == attrAddressOrSize) {
                            int remaining = attrRefs.available();
                            storage2.replaceBytes(recordId, remainingAtStart - remaining, _out.toByteArraySequence());
                            return;
                        }
                        attrRefs.skipBytes(attrAddressOrSize);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (AbstractStorage.StorageDataOutput directoryStream = storage2.writeStream(recordId);){
                if (directoryRecord && bulkAttrReadSupport) {
                    FSRecords.writeRecordHeader(DbConnection.RESERVED_ATTR_ID, this.myFileId, (DataOutputStream)directoryStream);
                }
                if (unchangedPreviousDirectoryStream != null) {
                    directoryStream.write(unchangedPreviousDirectoryStream.getInternalBuffer(), 0, unchangedPreviousDirectoryStream.size());
                }
                if (_out.size() > 0) {
                    DataInputOutputUtil.writeINT((DataOutput)directoryStream, (int)encodedAttrId);
                    DataInputOutputUtil.writeINT((DataOutput)directoryStream, (int)_out.size());
                    directoryStream.write(_out.getInternalBuffer(), 0, _out.size());
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    private static class ContentOutputStream
    extends DataOutputStream {
        final int myFileId;
        final boolean myFixedSize;

        private ContentOutputStream(int fileId, boolean readOnly) {
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            this.myFileId = fileId;
            this.myFixedSize = readOnly;
        }

        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
            this.writeBytes(_out.toByteArraySequence());
        }

        private void writeBytes(ByteArraySequence bytes) {
            FSRecords.writeAndHandleErrors(() -> {
                ByteArraySequence newBytes;
                boolean fixedSize;
                int page;
                RefCountingStorage contentStorage = FSRecords.getContentStorage();
                FSRecords.checkFileIsValid(this.myFileId);
                if (WE_HAVE_CONTENT_HASHES) {
                    page = FSRecords.findOrCreateContentRecord(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
                    if (page < 0 || FSRecords.getContentId(this.myFileId) != page) {
                        FSRecords.incModCount(this.myFileId);
                        FSRecords.setContentRecordId(this.myFileId, page > 0 ? page : -page);
                    }
                    FSRecords.setContentRecordId(this.myFileId, page > 0 ? page : -page);
                    if (page > 0) {
                        return;
                    }
                    page = -page;
                    fixedSize = true;
                } else {
                    FSRecords.incModCount(this.myFileId);
                    page = FSRecords.getContentRecordId(this.myFileId);
                    if (page == 0 || contentStorage.getRefCount(page) > 1) {
                        page = contentStorage.acquireNewRecord();
                        FSRecords.setContentRecordId(this.myFileId, page);
                    }
                    fixedSize = this.myFixedSize;
                }
                if (useCompressionUtil) {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    try (DataOutputStream outputStream = new DataOutputStream((OutputStream)out);){
                        CompressionUtil.writeCompressed((DataOutput)outputStream, (byte[])bytes.getBytes(), (int)bytes.getOffset(), (int)bytes.getLength());
                    }
                    newBytes = out.toByteArraySequence();
                } else {
                    newBytes = bytes;
                }
                contentStorage.writeBytes(page, newBytes, fixedSize);
            });
        }
    }

    public static class NameId {
        public static final NameId[] EMPTY_ARRAY = new NameId[0];
        public final int id;
        public final CharSequence name;
        public final int nameId;

        public NameId(int id, int nameId, @NotNull CharSequence name) {
            this.id = id;
            this.nameId = nameId;
            this.name = name;
        }

        public String toString() {
            return this.name + " (" + this.id + ")";
        }
    }

    private static class DbConnection {
        private static boolean ourInitialized;
        private static PersistentStringEnumerator myNames;
        private static Storage myAttributes;
        private static RefCountingStorage myContents;
        private static ResizeableMappedFile myRecords;
        private static PersistentBTreeEnumerator<byte[]> myContentHashesEnumerator;
        private static File myRootsFile;
        private static final VfsDependentEnum<String> myAttributesList;
        private static final TIntArrayList myFreeRecords;
        private static volatile boolean myDirty;
        private static ScheduledFuture<?> myFlushingFuture;
        private static boolean myCorrupted;
        private static final AttrPageAwareCapacityAllocationPolicy REASONABLY_SMALL;
        private static final int RESERVED_ATTR_ID;
        private static final int FIRST_ATTR_ID_OFFSET;

        private DbConnection() {
        }

        public static void connect() {
            FSRecords.writeAndHandleErrors(() -> {
                if (!DbConnection.ourInitialized) {
                    DbConnection.init();
                    DbConnection.setupFlushing();
                    DbConnection.ourInitialized = true;
                }
            });
        }

        private static void scanFreeRecords() {
            int fileLength = (int)myRecords.length();
            LOG.assertTrue(fileLength % 40 == 0, (Object)("invalid file size: " + fileLength));
            int count = fileLength / 40;
            for (int n = 2; n < count; ++n) {
                if (!BitUtil.isSet((int)FSRecords.getFlags(n), (int)256)) continue;
                myFreeRecords.add(n);
            }
        }

        static int getFreeRecord() {
            return myFreeRecords.isEmpty() ? 0 : myFreeRecords.remove(myFreeRecords.size() - 1);
        }

        private static void createBrokenMarkerFile(@Nullable Throwable reason) {
            File brokenMarker = DbConnection.getCorruptionMarkerFile();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (PrintStream stream = new PrintStream(out);){
                new Exception().printStackTrace(stream);
                if (reason != null) {
                    stream.print("\nReason:\n");
                    reason.printStackTrace(stream);
                }
            }
            LOG.info("Creating VFS corruption marker; Trace=\n" + out);
            try {
                var4_5 = null;
                try (FileWriter writer = new FileWriter(brokenMarker);){
                    writer.write("These files are corrupted and must be rebuilt from the scratch on next startup");
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static File getCorruptionMarkerFile() {
            return new File(FSRecords.basePath(), "corruption.marker");
        }

        private static void init() {
            File basePath = FSRecords.basePath().getAbsoluteFile();
            if (!basePath.isDirectory() && !basePath.mkdirs()) {
                throw new RuntimeException("Cannot create storage directory: " + basePath);
            }
            File namesFile = new File(basePath, "names" + VFS_FILES_EXTENSION);
            File attributesFile = new File(basePath, "attrib" + VFS_FILES_EXTENSION);
            File contentsFile = new File(basePath, "content" + VFS_FILES_EXTENSION);
            File contentsHashesFile = new File(basePath, "contentHashes" + VFS_FILES_EXTENSION);
            File recordsFile = new File(basePath, "records" + VFS_FILES_EXTENSION);
            myRootsFile = ourStoreRootsSeparately ? new File(basePath, "roots" + VFS_FILES_EXTENSION) : null;
            File vfsDependentEnumBaseFile = VfsDependentEnum.getBaseFile();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                for (File f : new File[]{namesFile, attributesFile, contentsFile, contentsHashesFile, recordsFile, vfsDependentEnumBaseFile}) {
                    if (f.exists()) {
                        System.out.println(String.format("Cache file: %s from: %s", f, new Date(f.lastModified())));
                        continue;
                    }
                    for (File other : f.getParentFile().listFiles()) {
                        if (!other.getName().startsWith(f.getName())) continue;
                        System.out.println(String.format("Cache file: %s ts: %s", other, new Date(other.lastModified())));
                    }
                }
            }
            if (!namesFile.exists()) {
                DbConnection.invalidateIndex("'" + namesFile.getPath() + "' does not exist");
            }
            try {
                int version2;
                boolean initial;
                boolean aligned;
                if (DbConnection.getCorruptionMarkerFile().exists()) {
                    DbConnection.invalidateIndex("corruption marker found");
                    throw new IOException("Corruption marker file found");
                }
                PagedFileStorage.StorageLockContext storageLockContext = new PagedFileStorage.StorageLockContext(false);
                myNames = new PersistentStringEnumerator(namesFile, storageLockContext);
                myAttributes = new Storage(attributesFile.getPath(), REASONABLY_SMALL){

                    protected AbstractRecordsTable createRecordsTable(PagePool pool, File recordsFile) throws IOException {
                        return inlineAttributes && useSmallAttrTable ? new CompactRecordsTable(recordsFile, pool, false) : super.createRecordsTable(pool, recordsFile);
                    }
                };
                myContents = new RefCountingStorage(contentsFile.getPath(), CapacityAllocationPolicy.FIVE_PERCENT_FOR_GROWTH, useCompressionUtil){

                    @NotNull
                    protected ExecutorService createExecutor() {
                        return SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FSRecords Pool");
                    }
                };
                myContentHashesEnumerator = WE_HAVE_CONTENT_HASHES ? new ContentHashesUtil.HashEnumerator(contentsHashesFile, storageLockContext) : null;
                boolean bl = aligned = PagedFileStorage.BUFFER_SIZE % 40 == 0;
                if (!aligned) {
                    LOG.error("Buffer size " + PagedFileStorage.BUFFER_SIZE + " is not aligned for record size " + 40);
                }
                boolean bl2 = initial = (myRecords = new ResizeableMappedFile(recordsFile, 20480, storageLockContext, PagedFileStorage.BUFFER_SIZE, aligned, IOUtil.BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER)).length() == 0L;
                if (initial) {
                    DbConnection.cleanRecord(0);
                    DbConnection.cleanRecord(1);
                    DbConnection.setCurrentVersion();
                }
                if ((version2 = DbConnection.getVersion()) != VERSION) {
                    throw new IOException("FS repository version mismatch: actual=" + version2 + " expected=" + VERSION);
                }
                if (myRecords.getInt(12L) != 523190095) {
                    throw new IOException("FS repository wasn't safely shut down");
                }
                if (initial) {
                    DbConnection.markDirty();
                }
                DbConnection.scanFreeRecords();
                DbConnection.getAttributeId(ourChildrenAttr.getId());
            }
            catch (Exception e) {
                LOG.info("Filesystem storage is corrupted or does not exist. [Re]Building. Reason: " + e.getMessage());
                try {
                    DbConnection.closeFiles();
                    boolean deleted = FileUtil.delete((File)DbConnection.getCorruptionMarkerFile());
                    deleted &= IOUtil.deleteAllFilesStartingWith((File)namesFile);
                    deleted &= AbstractStorage.deleteFiles((String)attributesFile.getPath());
                    deleted &= AbstractStorage.deleteFiles((String)contentsFile.getPath());
                    deleted &= IOUtil.deleteAllFilesStartingWith((File)contentsHashesFile);
                    deleted &= IOUtil.deleteAllFilesStartingWith((File)recordsFile);
                    deleted &= IOUtil.deleteAllFilesStartingWith((File)vfsDependentEnumBaseFile);
                    if (!(deleted &= myRootsFile == null || IOUtil.deleteAllFilesStartingWith((File)myRootsFile))) {
                        throw new IOException("Cannot delete filesystem storage files");
                    }
                }
                catch (IOException e1) {
                    Runnable warnAndShutdown = () -> {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            e1.printStackTrace();
                        } else {
                            String message = "Files in " + basePath.getPath() + " are locked.\n" + ApplicationNamesInfo.getInstance().getProductName() + " will not be able to start up.";
                            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message, "Fatal Error", 0);
                            } else {
                                System.err.println(message);
                            }
                        }
                        Runtime.getRuntime().halt(1);
                    };
                    if (EventQueue.isDispatchThread()) {
                        warnAndShutdown.run();
                    } else {
                        SwingUtilities.invokeLater(warnAndShutdown);
                    }
                    throw new RuntimeException("Can't rebuild filesystem storage ", e1);
                }
                DbConnection.init();
            }
        }

        private static void invalidateIndex(@NotNull String reason) {
            String[] children2;
            LOG.info("Marking VFS as corrupted: " + reason);
            File indexRoot = PathManager.getIndexRoot();
            if (indexRoot.exists() && (children2 = indexRoot.list()) != null && children2.length > 0) {
                FileUtil.createIfDoesntExist((File)new File(PathManager.getIndexRoot(), "corruption.marker"));
            }
        }

        @NotNull
        private static String getCachesDir() {
            String dir = System.getProperty("caches_dir");
            return dir == null ? PathManager.getSystemPath() + "/caches/" : dir;
        }

        private static void markDirty() {
            assert (lock.isWriteLocked());
            if (!myDirty) {
                myDirty = true;
                myRecords.putInt(12L, 313341156);
            }
        }

        private static void setupFlushing() {
            if (!backgroundVfsFlush) {
                return;
            }
            myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                private int lastModCount;

                @Override
                public void run() {
                    if (this.lastModCount == ourLocalModificationCount) {
                        DbConnection.flush();
                    }
                    this.lastModCount = ourLocalModificationCount;
                }
            });
        }

        private static void doForce() {
            if (myNames != null && myFlushingFuture != null) {
                myNames.force();
                myAttributes.force();
                myContents.force();
                if (myContentHashesEnumerator != null) {
                    myContentHashesEnumerator.force();
                }
                DbConnection.markClean();
                myRecords.force();
            }
        }

        private static void flush() {
            if (DbConnection.isDirty() && !HeavyProcessLatch.INSTANCE.isRunning()) {
                FSRecords.readAndHandleErrors(() -> {
                    DbConnection.doForce();
                    return null;
                });
            }
        }

        public static boolean isDirty() {
            return myDirty || myNames.isDirty() || myAttributes.isDirty() || myContents.isDirty() || myRecords.isDirty() || myContentHashesEnumerator != null && myContentHashesEnumerator.isDirty();
        }

        private static int getVersion() {
            int recordsVersion = myRecords.getInt(0L);
            if (myAttributes.getVersion() != recordsVersion || myContents.getVersion() != recordsVersion) {
                return -1;
            }
            return recordsVersion;
        }

        private static long getTimestamp() {
            return myRecords.getLong(16L);
        }

        private static void setCurrentVersion() {
            myRecords.putInt(0L, VERSION);
            myRecords.putLong(16L, System.currentTimeMillis());
            myAttributes.setVersion(VERSION);
            myContents.setVersion(VERSION);
            myRecords.putInt(12L, 523190095);
        }

        static void cleanRecord(int id) {
            myRecords.put((long)id * 40L, ZEROES, 0, 40);
        }

        private static PersistentStringEnumerator getNames() {
            return myNames;
        }

        private static void closeFiles() throws IOException {
            if (myFlushingFuture != null) {
                myFlushingFuture.cancel(false);
                myFlushingFuture = null;
            }
            if (myNames != null) {
                myNames.close();
                myNames = null;
            }
            if (myAttributes != null) {
                Disposer.dispose((Disposable)myAttributes);
                myAttributes = null;
            }
            if (myContents != null) {
                Disposer.dispose((Disposable)myContents);
                myContents = null;
            }
            if (myContentHashesEnumerator != null) {
                myContentHashesEnumerator.close();
                myContentHashesEnumerator = null;
            }
            if (myRecords != null) {
                DbConnection.markClean();
                myRecords.close();
                myRecords = null;
            }
            ourInitialized = false;
        }

        private static void markClean() {
            assert (lock.isWriteLocked() || lock.getReadHoldCount() != 0);
            if (myDirty) {
                myDirty = false;
                myRecords.putInt(12L, myCorrupted ? -1412464769 : 523190095);
            }
        }

        private static int getAttributeId(@NotNull String attId) throws IOException {
            return myAttributesList.getIdRaw(attId, false) + FIRST_ATTR_ID_OFFSET;
        }

        @Contract(value="_->fail")
        private static void handleError(@NotNull Throwable e) throws RuntimeException, Error {
            assert (lock.getReadHoldCount() == 0);
            if (!ourIsDisposed) {
                w.lock();
                try {
                    if (!myCorrupted) {
                        DbConnection.createBrokenMarkerFile(e);
                        myCorrupted = true;
                        DbConnection.doForce();
                    }
                }
                finally {
                    w.unlock();
                }
            }
            ExceptionUtil.rethrow((Throwable)e);
        }

        static {
            myAttributesList = new VfsDependentEnum("attrib", EnumeratorStringDescriptor.INSTANCE, 1);
            myFreeRecords = new TIntArrayList();
            REASONABLY_SMALL = new AttrPageAwareCapacityAllocationPolicy();
            RESERVED_ATTR_ID = bulkAttrReadSupport ? 1 : 0;
            FIRST_ATTR_ID_OFFSET = bulkAttrReadSupport ? RESERVED_ATTR_ID : 0;
        }

        private static class AttrPageAwareCapacityAllocationPolicy
        extends CapacityAllocationPolicy {
            boolean myAttrPageRequested;

            private AttrPageAwareCapacityAllocationPolicy() {
            }

            public int calculateCapacity(int requiredLength) {
                return Math.max(this.myAttrPageRequested ? 8 : 32, Math.min((int)((double)requiredLength * 1.2), (requiredLength / 1024 + 1) * 1024));
            }
        }
    }
}

