/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.VfsEventGenerationHelper;
import com.intellij.util.Function;
import com.intellij.util.containers.Queue;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LocalFileSystemRefreshWorker {
    private final boolean myIsRecursive;
    private final Queue<NewVirtualFile> myRefreshQueue = new Queue(100);
    private final VfsEventGenerationHelper myHelper = new VfsEventGenerationHelper();
    private volatile boolean myCancelled;
    private static final AtomicInteger myRequests = new AtomicInteger();
    private static final AtomicLong myTime = new AtomicLong();
    private static Function<? super VirtualFile, Boolean> ourCancellingCondition;

    LocalFileSystemRefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast((Object)refreshRoot);
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        return this.myHelper.getEvents();
    }

    public void cancel() {
        this.myCancelled = true;
    }

    public void scan() {
        NewVirtualFile root = (NewVirtualFile)this.myRefreshQueue.pullFirst();
        boolean rootDirty = root.isDirty();
        if (VfsEventGenerationHelper.LOG.isDebugEnabled()) {
            VfsEventGenerationHelper.LOG.debug("root=" + root + " dirty=" + rootDirty);
        }
        if (!rootDirty) {
            return;
        }
        NewVirtualFileSystem fs = root.getFileSystem();
        FileAttributes rootAttributes = fs.getAttributes((VirtualFile)root);
        if (rootAttributes == null) {
            this.myHelper.scheduleDeletion((VirtualFile)root);
            root.markClean();
            return;
        }
        if (rootAttributes.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        this.myRefreshQueue.addLast((Object)root);
        try {
            this.processQueue(fs, PersistentFS.getInstance());
        }
        catch (RefreshCancelledException e) {
            VfsEventGenerationHelper.LOG.debug("refresh cancelled");
        }
    }

    private void processQueue(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence) throws RefreshCancelledException {
        TObjectHashingStrategy strategy = FilePathHashingStrategy.create((boolean)fs.isCaseSensitive());
        while (!this.myRefreshQueue.isEmpty()) {
            NewVirtualFile file2 = (NewVirtualFile)this.myRefreshQueue.pullFirst();
            if (!this.myHelper.checkDirty(file2)) continue;
            this.checkCancelled(file2);
            if (file2.isDirectory()) {
                boolean fullSync = ((VirtualDirectoryImpl)file2).allChildrenLoaded();
                if (fullSync) {
                    this.fullDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                } else {
                    this.partialDirRefresh(fs, persistence, (TObjectHashingStrategy<String>)strategy, (VirtualDirectoryImpl)file2);
                }
            } else {
                this.refreshFile(fs, persistence, (TObjectHashingStrategy<String>)strategy, file2);
            }
            if (!this.myIsRecursive && file2.isDirectory()) continue;
            file2.markClean();
        }
    }

    private void refreshFile(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull NewVirtualFile file2) {
        RefreshingFileVisitor refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)file2, persistence, fs, null, Collections.singletonList(file2), strategy);
        refreshingFileVisitor.visit((VirtualFile)file2);
        this.myHelper.addAllEventsFrom(refreshingFileVisitor.getHelper());
    }

    private void fullDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        RefreshingFileVisitor refreshingFileVisitor;
        VirtualFile[] children2;
        String[] currentNames;
        boolean hasEvents;
        do {
            Pair<String[], VirtualFile[]> result2;
            if ((result2 = LocalFileSystemRefreshWorker.getDirectorySnapshot(persistence, dir)) == null) {
                return;
            }
            currentNames = (String[])result2.getFirst();
            children2 = (VirtualFile[])result2.getSecond();
            refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)dir, persistence, fs, null, Arrays.asList(children2), strategy);
            refreshingFileVisitor.visit((VirtualFile)dir);
        } while (!(hasEvents = ((Boolean)ReadAction.compute(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                return true;
            }
            if (!Arrays.equals(currentNames, persistence.list((VirtualFile)dir)) || !Arrays.equals(children2, dir.getChildren())) {
                if (VfsEventGenerationHelper.LOG.isDebugEnabled()) {
                    VfsEventGenerationHelper.LOG.debug("retry: " + (Object)((Object)dir));
                }
                return false;
            }
            this.myHelper.addAllEventsFrom(refreshingFileVisitor.getHelper());
            return true;
        })).booleanValue()));
    }

    static Pair<String[], VirtualFile[]> getDirectorySnapshot(@NotNull PersistentFS persistence, @NotNull VirtualDirectoryImpl dir) {
        return (Pair)ReadAction.compute(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                return null;
            }
            return Pair.create((Object)persistence.list((VirtualFile)dir), (Object)dir.getChildren());
        });
    }

    private void partialDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull TObjectHashingStrategy<String> strategy, @NotNull VirtualDirectoryImpl dir) {
        RefreshingFileVisitor refreshingFileVisitor;
        List wanted;
        List cached;
        boolean hasEvents;
        do {
            Pair result2 = (Pair)ReadAction.compute(() -> Pair.create((Object)dir.getCachedChildren(), dir.getSuspiciousNames()));
            cached = (List)result2.getFirst();
            wanted = (List)result2.getSecond();
            if (cached.isEmpty() && wanted.isEmpty()) {
                return;
            }
            refreshingFileVisitor = new RefreshingFileVisitor((VirtualFile)dir, persistence, fs, wanted, cached, strategy);
            refreshingFileVisitor.visit((VirtualFile)dir);
        } while (!(hasEvents = ((Boolean)ReadAction.compute(() -> {
            if (!cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames())) {
                if (VfsEventGenerationHelper.LOG.isDebugEnabled()) {
                    VfsEventGenerationHelper.LOG.debug("retry: " + (Object)((Object)dir));
                }
                return false;
            }
            this.myHelper.addAllEventsFrom(refreshingFileVisitor.getHelper());
            return true;
        })).booleanValue()));
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) {
        if (this.myCancelled || ourCancellingCondition != null && ((Boolean)ourCancellingCondition.fun((Object)stopAt)).booleanValue()) {
            LocalFileSystemRefreshWorker.forceMarkDirty(stopAt);
            while (!this.myRefreshQueue.isEmpty()) {
                NewVirtualFile next = (NewVirtualFile)this.myRefreshQueue.pullFirst();
                LocalFileSystemRefreshWorker.forceMarkDirty(next);
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(@NotNull NewVirtualFile file2) {
        file2.markClean();
        file2.markDirty();
    }

    static void setCancellingCondition(@Nullable Function<? super VirtualFile, Boolean> condition) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourCancellingCondition = condition;
    }

    private static boolean isEmptyDir(Path path, BasicFileAttributes a) {
        return a.isDirectory() && !LocalFileSystemBase.hasChildren(path);
    }

    private static FileAttributes convert(Path path, BasicFileAttributes a) throws IOException {
        boolean isSymlink;
        boolean bl = isSymlink = a.isSymbolicLink() || SystemInfo.isWindows && a.isOther() && a.isDirectory();
        if (isSymlink) {
            Class schema = SystemInfo.isWindows ? DosFileAttributes.class : PosixFileAttributes.class;
            try {
                a = Files.readAttributes(path, schema, new LinkOption[0]);
            }
            catch (AccessDeniedException | NoSuchFileException e) {
                return FileAttributes.BROKEN_SYMLINK;
            }
        }
        long lastModified = a.lastModifiedTime().toMillis();
        if (SystemInfo.isWindows) {
            boolean hidden = path.getParent() != null && ((DosFileAttributes)a).isHidden();
            boolean writable = a.isDirectory() || !((DosFileAttributes)a).isReadOnly();
            return new FileAttributes(a.isDirectory(), a.isOther(), isSymlink, hidden, a.size(), lastModified, writable);
        }
        boolean writable = Files.isWritable(path);
        return new FileAttributes(a.isDirectory(), a.isOther(), isSymlink, false, a.size(), lastModified, writable);
    }

    private class RefreshingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final VfsEventGenerationHelper myHelper = new VfsEventGenerationHelper();
        private final Map<String, VirtualFile> myPersistentChildren;
        private final Set<String> myChildrenWeAreInterested;
        private final VirtualFile myFileOrDir;
        private final PersistentFS myPersistence;
        private final NewVirtualFileSystem myFs;

        RefreshingFileVisitor(@NotNull VirtualFile fileOrDir, @NotNull PersistentFS persistence, @Nullable(value="null means all") NewVirtualFileSystem fs, @NotNull Collection<String> childrenToRefresh, @NotNull Collection<VirtualFile> existingPersistentChildren, TObjectHashingStrategy<String> strategy) {
            this.myFileOrDir = fileOrDir;
            this.myPersistence = persistence;
            this.myFs = fs;
            this.myPersistentChildren = new THashMap(existingPersistentChildren.size(), strategy);
            this.myChildrenWeAreInterested = childrenToRefresh != null ? new THashSet(childrenToRefresh, strategy) : null;
            for (VirtualFile child2 : existingPersistentChildren) {
                String name = child2.getName();
                this.myPersistentChildren.put(name, child2);
                if (this.myChildrenWeAreInterested == null) continue;
                this.myChildrenWeAreInterested.add(name);
            }
        }

        @Override
        public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
            String name = file2.getName(file2.getNameCount() - 1).toString();
            if (this.acceptsFileName(name)) {
                boolean isWritable;
                NewVirtualFile child2 = (NewVirtualFile)this.myPersistentChildren.remove(name);
                boolean directory = attrs.isDirectory();
                if (child2 == null) {
                    VirtualFile parent = this.myFileOrDir.isDirectory() ? this.myFileOrDir : this.myFileOrDir.getParent();
                    String symlinkTarget = attrs.isSymbolicLink() ? file2.toRealPath(new LinkOption[0]).toString() : null;
                    this.myHelper.scheduleCreation(parent, name, LocalFileSystemRefreshWorker.convert(file2, attrs), LocalFileSystemRefreshWorker.isEmptyDir(file2, attrs), symlinkTarget);
                    return FileVisitResult.CONTINUE;
                }
                LocalFileSystemRefreshWorker.this.checkCancelled(child2);
                if (!child2.isDirty()) {
                    return FileVisitResult.CONTINUE;
                }
                boolean oldIsDirectory = child2.isDirectory();
                boolean oldIsSymlink = child2.is(VFileProperty.SYMLINK);
                boolean oldIsSpecial = child2.is(VFileProperty.SPECIAL);
                boolean isSpecial = attrs.isOther();
                boolean isLink = attrs.isSymbolicLink();
                if (isSpecial && directory && SystemInfo.isWindows) {
                    isSpecial = false;
                    isLink = true;
                }
                if (oldIsDirectory != directory || oldIsSymlink != isLink || oldIsSpecial != isSpecial) {
                    this.myHelper.scheduleDeletion((VirtualFile)child2);
                    VirtualFile parent = this.myFileOrDir.isDirectory() ? this.myFileOrDir : this.myFileOrDir.getParent();
                    String symlinkTarget = isLink ? file2.toRealPath(new LinkOption[0]).toString() : null;
                    this.myHelper.scheduleCreation(parent, child2.getName(), LocalFileSystemRefreshWorker.convert(file2, attrs), LocalFileSystemRefreshWorker.isEmptyDir(file2, attrs), symlinkTarget);
                    child2.markClean();
                    return FileVisitResult.CONTINUE;
                }
                String currentName = child2.getName();
                if (!currentName.equals(name)) {
                    this.myHelper.scheduleAttributeChange((VirtualFile)child2, "name", currentName, name);
                }
                if (!directory) {
                    this.myHelper.checkContentChanged((VirtualFile)child2, this.myPersistence.getTimeStamp((VirtualFile)child2), attrs.lastModifiedTime().toMillis(), this.myPersistence.getLastRecordedLength((VirtualFile)child2), attrs.size());
                } else if (LocalFileSystemRefreshWorker.this.myIsRecursive) {
                    LocalFileSystemRefreshWorker.this.myRefreshQueue.addLast((Object)child2);
                }
                boolean currentWritable = this.myPersistence.isWritable((VirtualFile)child2);
                if (attrs instanceof DosFileAttributes) {
                    DosFileAttributes dosFileAttributes = (DosFileAttributes)attrs;
                    isWritable = directory || !dosFileAttributes.isReadOnly();
                } else {
                    isWritable = attrs instanceof PosixFileAttributes ? ((PosixFileAttributes)attrs).permissions().contains((Object)PosixFilePermission.OWNER_WRITE) : file2.toFile().canWrite();
                }
                this.myHelper.checkWritableAttributeChange((VirtualFile)child2, currentWritable, isWritable);
                if (attrs instanceof DosFileAttributes) {
                    this.myHelper.checkHiddenAttributeChange((VirtualFile)child2, child2.is(VFileProperty.HIDDEN), ((DosFileAttributes)attrs).isHidden());
                }
                if (isLink) {
                    this.myHelper.checkSymbolicLinkChange((VirtualFile)child2, child2.getCanonicalPath(), this.myFs.resolveSymLink((VirtualFile)child2));
                }
                if (!child2.isDirectory()) {
                    child2.markClean();
                }
            }
            return FileVisitResult.CONTINUE;
        }

        boolean acceptsFileName(String name) {
            return !VfsUtil.isBadName((String)name);
        }

        public void visit(@NotNull VirtualFile fileOrDir) {
            long started = System.nanoTime();
            try {
                Path path = Paths.get(fileOrDir.getPath(), new String[0]);
                if (fileOrDir.isDirectory()) {
                    if (this.myChildrenWeAreInterested == null) {
                        Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 1, this);
                    } else {
                        for (String child2 : this.myChildrenWeAreInterested) {
                            try {
                                Path subPath = path.resolve(child2).toRealPath(LinkOption.NOFOLLOW_LINKS);
                                BasicFileAttributes attributes = Files.readAttributes(subPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                                this.visitFile(subPath, attributes);
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    this.visitFile(path.toRealPath(LinkOption.NOFOLLOW_LINKS), Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS));
                }
            }
            catch (AccessDeniedException | NoSuchFileException path) {
            }
            catch (IOException ex) {
                VfsEventGenerationHelper.LOG.error((Throwable)ex);
            }
            int requests = myRequests.incrementAndGet();
            long l = myTime.addAndGet(System.nanoTime() - started);
            if (requests % 1000 == 0) {
                System.out.println("refresh:" + myRequests + " for " + TimeUnit.NANOSECONDS.toMillis(l) + "ms");
            }
        }

        @NotNull
        VfsEventGenerationHelper getHelper() {
            if (!this.myPersistentChildren.isEmpty()) {
                for (VirtualFile child2 : this.myPersistentChildren.values()) {
                    this.myHelper.scheduleDeletion(child2);
                }
                this.myPersistentChildren.clear();
            }
            return this.myHelper;
        }
    }

    private static class RefreshCancelledException
    extends RuntimeException {
        private RefreshCancelledException() {
        }
    }
}

