/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ReplicatorInputStream;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentFSImpl
extends PersistentFS
implements BaseComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.PersistentFS");
    private final Map<String, VirtualFileSystemEntry> myRoots = ConcurrentCollectionFactory.createMap(10, 0.4f, JobSchedulerImpl.getCPUCoresCount(), FileUtil.PATH_HASHING_STRATEGY);
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myIdToDirCache = ContainerUtil.createConcurrentIntObjectSoftValueMap();
    private final Object myInputLock = new Object();
    private final AtomicBoolean myShutDown = new AtomicBoolean(false);
    private final AtomicInteger myStructureModificationCount = new AtomicInteger();
    private final BulkFileListener myPublisher;
    private final VfsData myVfsData = new VfsData();
    private static final int INNER_ARRAYS_THRESHOLD = 1024;

    public PersistentFSImpl(@NotNull MessageBus bus) {
        ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown);
        LowMemoryWatcher.register(this::clearIdCache, (Disposable)this);
        this.myPublisher = (BulkFileListener)bus.syncPublisher(VirtualFileManager.VFS_CHANGES);
    }

    public void initComponent() {
        FSRecords.connect();
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    public void dispose() {
    }

    private void performShutdown() {
        if (this.myShutDown.compareAndSet(false, true)) {
            LOG.info("VFS dispose started");
            FSRecords.dispose();
            LOG.info("VFS dispose completed");
        }
    }

    public boolean areChildrenLoaded(@NotNull VirtualFile dir) {
        return PersistentFSImpl.areChildrenLoaded(PersistentFSImpl.getFileId(dir));
    }

    public long getCreationTimestamp() {
        return FSRecords.getCreationTimestamp();
    }

    @NotNull
    public VirtualFileSystemEntry getOrCacheDir(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData o, @NotNull VirtualDirectoryImpl parent) {
        VirtualFileSystemEntry dir = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
        if (dir != null) {
            return dir;
        }
        dir = new VirtualDirectoryImpl(id, segment, o, parent, parent.getFileSystem());
        return (VirtualFileSystemEntry)((Object)this.myIdToDirCache.cacheOrGet(id, (Object)dir));
    }

    public VirtualFileSystemEntry getCachedDir(int id) {
        return (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
    }

    @NotNull
    private static NewVirtualFileSystem getDelegate(@NotNull VirtualFile file2) {
        return (NewVirtualFileSystem)file2.getFileSystem();
    }

    public boolean wereChildrenAccessed(@NotNull VirtualFile dir) {
        return FSRecords.wereChildrenAccessed(PersistentFSImpl.getFileId(dir));
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        int id = PersistentFSImpl.getFileId(file2);
        Object[] nameIds = FSRecords.listAll(id);
        if (!PersistentFSImpl.areChildrenLoaded(id)) {
            nameIds = PersistentFSImpl.persistAllChildren(file2, id, (FSRecords.NameId[])nameIds);
        }
        return (String[])ContainerUtil.map2Array((Object[])nameIds, String.class, id1 -> id1.name.toString());
    }

    @Override
    @NotNull
    public String[] listPersisted(@NotNull VirtualFile parent) {
        return PersistentFSImpl.listPersisted(FSRecords.list(PersistentFSImpl.getFileId(parent)));
    }

    @NotNull
    private static String[] listPersisted(@NotNull int[] childrenIds) {
        String[] names = ArrayUtil.newStringArray((int)childrenIds.length);
        for (int i = 0; i < childrenIds.length; ++i) {
            names[i] = FSRecords.getName(childrenIds[i]);
        }
        return names;
    }

    @NotNull
    private static FSRecords.NameId[] persistAllChildren(@NotNull VirtualFile file2, int id, @NotNull FSRecords.NameId[] current) {
        NewVirtualFileSystem fs = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate(file2));
        Object[] delegateNames = VfsUtil.filterNames((String[])fs.list(file2));
        if (delegateNames.length == 0 && current.length > 0) {
            return current;
        }
        HashSet toAdd = ContainerUtil.newHashSet((Object[])delegateNames);
        for (FSRecords.NameId nameId : current) {
            toAdd.remove(nameId.name.toString());
        }
        TIntArrayList childrenIds = new TIntArrayList(current.length + toAdd.size());
        ArrayList nameIds = ContainerUtil.newArrayListWithCapacity((int)(current.length + toAdd.size()));
        for (FSRecords.NameId nameId : current) {
            childrenIds.add(nameId.id);
            nameIds.add(nameId);
        }
        for (String newName : toAdd) {
            Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, file2, newName, null, null);
            if (childData == null) continue;
            int childId = PersistentFSImpl.makeChildRecord(id, newName, childData, fs);
            childrenIds.add(childId);
            nameIds.add(new FSRecords.NameId(childId, FileNameCache.storeName(newName), newName));
        }
        FSRecords.updateList(id, childrenIds.toNativeArray());
        PersistentFSImpl.setChildrenCached(id);
        return nameIds.toArray(FSRecords.NameId.EMPTY_ARRAY);
    }

    public static void setChildrenCached(int id) {
        int flags = FSRecords.getFlags(id);
        FSRecords.setFlags(id, flags | 1, true);
    }

    @Override
    @NotNull
    public FSRecords.NameId[] listAll(@NotNull VirtualFile parent) {
        int parentId = PersistentFSImpl.getFileId(parent);
        FSRecords.NameId[] nameIds = FSRecords.listAll(parentId);
        if (!PersistentFSImpl.areChildrenLoaded(parentId)) {
            return PersistentFSImpl.persistAllChildren(parent, parentId, nameIds);
        }
        return nameIds;
    }

    private static boolean areChildrenLoaded(int parentId) {
        return BitUtil.isSet((int)FSRecords.getFlags(parentId), (int)1);
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        return FSRecords.readAttributeWithLock(PersistentFSImpl.getFileId(file2), att);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        return FSRecords.writeAttribute(PersistentFSImpl.getFileId(file2), att);
    }

    @Nullable
    private static DataInputStream readContent(@NotNull VirtualFile file2) {
        return FSRecords.readContent(PersistentFSImpl.getFileId(file2));
    }

    @NotNull
    private static DataInputStream readContentById(int contentId) {
        return FSRecords.readContentById(contentId);
    }

    @NotNull
    private static DataOutputStream writeContent(@NotNull VirtualFile file2, boolean readOnly) {
        return FSRecords.writeContent(PersistentFSImpl.getFileId(file2), readOnly);
    }

    private static void writeContent(@NotNull VirtualFile file2, ByteArraySequence content, boolean readOnly) {
        FSRecords.writeContent(PersistentFSImpl.getFileId(file2), content, readOnly);
    }

    @Override
    public int storeUnlinkedContent(@NotNull byte[] bytes) {
        return FSRecords.storeUnlinkedContent(bytes);
    }

    public int getModificationCount(@NotNull VirtualFile file2) {
        return FSRecords.getModCount(PersistentFSImpl.getFileId(file2));
    }

    public int getModificationCount() {
        return FSRecords.getLocalModCount();
    }

    public int getStructureModificationCount() {
        return this.myStructureModificationCount.get();
    }

    public void incStructuralModificationCount() {
        this.myStructureModificationCount.incrementAndGet();
    }

    public int getFilesystemModificationCount() {
        return FSRecords.getModCount();
    }

    private static boolean writeAttributesToRecord(int id, int parentId, @NotNull CharSequence name, @NotNull NewVirtualFileSystem fs, @NotNull FileAttributes attributes, @Nullable String symlinkTarget) {
        assert (id > 0) : id;
        if (name.length() != 0 ? PersistentFSImpl.namesEqual((VirtualFileSystem)fs, name, FSRecords.getNameSequence(id)) : PersistentFSImpl.areChildrenLoaded(id)) {
            return false;
        }
        FSRecords.writeAttributesToRecord(id, parentId, attributes, name.toString());
        if (attributes.isSymLink()) {
            FSRecords.storeSymlinkTarget(id, symlinkTarget);
        }
        return true;
    }

    @Override
    public int getFileAttributes(int id) {
        assert (id > 0);
        return FSRecords.getFlags(id);
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        return PersistentFSImpl.isDirectory(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    private static boolean namesEqual(@NotNull VirtualFileSystem fs, @NotNull CharSequence n1, CharSequence n2) {
        return Comparing.equal((CharSequence)n1, (CharSequence)n2, (boolean)fs.isCaseSensitive());
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        return fileOrDirectory.exists();
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        return FSRecords.getTimestamp(PersistentFSImpl.getFileId(file2));
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long modStamp) throws IOException {
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.setTimestamp(id, modStamp);
        PersistentFSImpl.getDelegate(file2).setTimeStamp(file2, modStamp);
    }

    private static int getFileId(@NotNull VirtualFile file2) {
        int id = ((VirtualFileWithId)file2).getId();
        if (id <= 0) {
            throw new InvalidVirtualFileAccessException(file2);
        }
        return id;
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        return PersistentFSImpl.isSymLink(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        return FSRecords.readSymlinkTarget(PersistentFSImpl.getFileId(file2));
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        return !BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)4);
    }

    @Override
    public boolean isHidden(@NotNull VirtualFile file2) {
        return BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)64);
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        PersistentFSImpl.getDelegate(file2).setWritable(file2, writableFlag);
        boolean oldWritable = this.isWritable(file2);
        if (oldWritable != writableFlag) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, file2, "writable", (Object)oldWritable, (Object)writableFlag, false));
        }
    }

    @Override
    public int getId(@NotNull VirtualFile parent, @NotNull String childName, @NotNull NewVirtualFileSystem fs) {
        int parentId = PersistentFSImpl.getFileId(parent);
        int[] children2 = FSRecords.list(parentId);
        if (children2.length > 0) {
            int nameId = FSRecords.getNameId(childName);
            int[] nArray = children2;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int childId = nArray[i];
                if (nameId != FSRecords.getNameId(childId)) continue;
                return childId;
            }
        }
        for (int childId : children2) {
            if (!PersistentFSImpl.namesEqual((VirtualFileSystem)fs, childName, FSRecords.getNameSequence(childId))) continue;
            return childId;
        }
        Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, parent, childName, null, null);
        if (childData != null) {
            int childId = PersistentFSImpl.makeChildRecord(parentId, childName, childData, fs);
            FSRecords.updateList(parentId, ArrayUtil.append((int[])children2, (int)childId));
            return childId;
        }
        return 0;
    }

    public long getLength(@NotNull VirtualFile file2) {
        long length = PersistentFSImpl.getLengthIfUpToDate(file2);
        return length == -1L ? PersistentFSImpl.reloadLengthFromDelegate(file2, PersistentFSImpl.getDelegate(file2)) : length;
    }

    @Override
    public long getLastRecordedLength(@NotNull VirtualFile file2) {
        int id = PersistentFSImpl.getFileId(file2);
        return FSRecords.getLength(id);
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile parent, @NotNull String name) throws IOException {
        PersistentFSImpl.getDelegate(file2).copyFile(requestor, file2, parent, name);
        this.processEvent((VFileEvent)new VFileCopyEvent(requestor, file2, parent, name));
        VirtualFile child2 = parent.findChild(name);
        if (child2 == null) {
            throw new IOException("Cannot create child");
        }
        return child2;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        PersistentFSImpl.getDelegate(parent).createChildDirectory(requestor, parent, dir);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, dir, true, null, null, false, true));
        VirtualFile child2 = parent.findChild(dir);
        if (child2 == null) {
            throw new IOException("Cannot create child directory '" + dir + "' at " + parent.getPath());
        }
        return child2;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        PersistentFSImpl.getDelegate(parent).createChildFile(requestor, parent, file2);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, file2, false, null, null, false, false));
        VirtualFile child2 = parent.findChild(file2);
        if (child2 == null) {
            throw new IOException("Cannot create child file '" + file2 + "' at " + parent.getPath());
        }
        if (child2.getCharset().equals(CharsetToolkit.UTF8_CHARSET)) {
            EncodingManager encodingManager;
            Project project = ProjectLocator.getInstance().guessProjectForFile(child2);
            Object object = encodingManager = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
            if (encodingManager.shouldAddBOMForNewUtf8File()) {
                child2.setBOM(CharsetToolkit.UTF8_BOM);
            }
        }
        return child2;
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        delegate.deleteFile(requestor, file2);
        if (!delegate.exists(file2)) {
            this.processEvent((VFileEvent)new VFileDeleteEvent(requestor, file2, false));
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        PersistentFSImpl.getDelegate(file2).renameFile(requestor, file2, newName);
        String oldName = file2.getName();
        if (!newName.equals(oldName)) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent(requestor, file2, "name", (Object)oldName, (Object)newName, false));
        }
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        return this.contentsToByteArray(file2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2, boolean cacheContent) throws IOException {
        boolean reloadFromDelegate;
        boolean outdated;
        long length;
        int fileId;
        DataInputStream contentStream = null;
        Object object = this.myInputLock;
        synchronized (object) {
            fileId = PersistentFSImpl.getFileId(file2);
            length = PersistentFSImpl.getLengthIfUpToDate(file2);
            outdated = length == -1L;
            reloadFromDelegate = outdated || (contentStream = PersistentFSImpl.readContent(file2)) == null;
        }
        if (reloadFromDelegate) {
            byte[] content;
            NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
            if (outdated) {
                FSRecords.setLength(fileId, delegate.getLength(file2));
                content = delegate.contentsToByteArray(file2);
            } else {
                content = delegate.contentsToByteArray(file2);
                FSRecords.setLength(fileId, content.length);
            }
            Application application = ApplicationManager.getApplication();
            if ((!delegate.isReadOnly() || cacheContent && !application.isInternal() && !application.isUnitTestMode()) && (long)content.length <= PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
                Object object2 = this.myInputLock;
                synchronized (object2) {
                    PersistentFSImpl.writeContent(file2, new ByteArraySequence(content), delegate.isReadOnly());
                    PersistentFSImpl.setFlag(file2, 8, false);
                }
            }
            return content;
        }
        try {
            assert (length >= 0L) : file2;
            return FileUtil.loadBytes((InputStream)contentStream, (int)((int)length));
        }
        catch (IOException e) {
            FSRecords.handleError(e);
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(int contentId) throws IOException {
        DataInputStream stream = PersistentFSImpl.readContentById(contentId);
        return FileUtil.loadBytes((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        Object object = this.myInputLock;
        synchronized (object) {
            DataInputStream contentStream;
            if (PersistentFSImpl.getLengthIfUpToDate(file2) == -1L || FileUtilRt.isTooLarge((long)file2.getLength()) || (contentStream = PersistentFSImpl.readContent(file2)) == null) {
                NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                long len = PersistentFSImpl.reloadLengthFromDelegate(file2, delegate);
                InputStream nativeStream = delegate.getInputStream(file2);
                if (len > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
                    return nativeStream;
                }
                return this.createReplicator(file2, nativeStream, len, delegate.isReadOnly());
            }
            return contentStream;
        }
    }

    private static long reloadLengthFromDelegate(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem delegate) {
        long len = delegate.getLength(file2);
        FSRecords.setLength(PersistentFSImpl.getFileId(file2), len);
        return len;
    }

    @NotNull
    private InputStream createReplicator(final @NotNull VirtualFile file2, @NotNull InputStream nativeStream, final long fileLength, final boolean readOnly) {
        if (nativeStream instanceof BufferExposingByteArrayInputStream) {
            BufferExposingByteArrayInputStream byteStream = (BufferExposingByteArrayInputStream)nativeStream;
            byte[] bytes = byteStream.getInternalBuffer();
            this.storeContentToStorage(fileLength, file2, readOnly, bytes, bytes.length);
            return nativeStream;
        }
        final BufferExposingByteArrayOutputStream cache = new BufferExposingByteArrayOutputStream((int)fileLength);
        return new ReplicatorInputStream(nativeStream, cache){

            public void close() throws IOException {
                super.close();
                PersistentFSImpl.this.storeContentToStorage(fileLength, file2, readOnly, cache.getInternalBuffer(), cache.size());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeContentToStorage(long fileLength, @NotNull VirtualFile file2, boolean readOnly, @NotNull byte[] bytes, int bytesLength) {
        Object object = this.myInputLock;
        synchronized (object) {
            if ((long)bytesLength == fileLength) {
                PersistentFSImpl.writeContent(file2, new ByteArraySequence(bytes, 0, bytesLength), readOnly);
                PersistentFSImpl.setFlag(file2, 8, false);
            } else {
                PersistentFSImpl.setFlag(file2, 8, true);
            }
        }
    }

    private static long getLengthIfUpToDate(@NotNull VirtualFile file2) {
        int fileId = PersistentFSImpl.getFileId(file2);
        return PersistentFSImpl.checkFlag(fileId, 8) ? -1L : FSRecords.getLength(fileId);
    }

    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, final Object requestor, final long modStamp, final long timeStamp) {
        return new ByteArrayOutputStream(){
            private boolean closed;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                Throwable throwable;
                if (this.closed) {
                    return;
                }
                super.close();
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file2, file2.getModificationStamp(), modStamp, false);
                List<VFileContentChangeEvent> events = Collections.singletonList(event);
                PersistentFSImpl.this.myPublisher.before(events);
                NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                try {
                    throwable = null;
                    try (DataOutputStream persistenceStream = PersistentFSImpl.writeContent(file2, delegate.isReadOnly());){
                        ((OutputStream)persistenceStream).write(this.buf, 0, this.count);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        try (OutputStream ioFileStream = delegate.getOutputStream(file2, requestor, modStamp, timeStamp);){
                            ioFileStream.write(this.buf, 0, this.count);
                        }
                        this.closed = true;
                    }
                    catch (Throwable throwable4) {
                        this.closed = true;
                        FileAttributes attributes = delegate.getAttributes(file2);
                        PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                        PersistentFSImpl.this.myPublisher.after(events);
                        throw throwable4;
                    }
                    FileAttributes attributes = delegate.getAttributes(file2);
                    PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                    PersistentFSImpl.this.myPublisher.after(events);
                    throw throwable3;
                }
                try {
                    throwable = null;
                    try (OutputStream ioFileStream = delegate.getOutputStream(file2, requestor, modStamp, timeStamp);){
                        ioFileStream.write(this.buf, 0, this.count);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    this.closed = true;
                }
                catch (Throwable throwable6) {
                    this.closed = true;
                    FileAttributes attributes = delegate.getAttributes(file2);
                    PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                    PersistentFSImpl.this.myPublisher.after(events);
                    throw throwable6;
                }
                FileAttributes attributes = delegate.getAttributes(file2);
                PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp(), attributes != null ? attributes.length : 0L, attributes != null ? attributes.lastModified : 0L);
                PersistentFSImpl.this.myPublisher.after(events);
            }
        };
    }

    @Override
    public int acquireContent(@NotNull VirtualFile file2) {
        return FSRecords.acquireFileContent(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public void releaseContent(int contentId) {
        FSRecords.releaseContent(contentId);
    }

    @Override
    public int getCurrentContentId(@NotNull VirtualFile file2) {
        return FSRecords.getContentId(PersistentFSImpl.getFileId(file2));
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        PersistentFSImpl.getDelegate(file2).moveFile(requestor, file2, newParent);
        this.processEvent((VFileEvent)new VFileMoveEvent(requestor, file2, newParent));
    }

    private void processEvent(@NotNull VFileEvent event) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (event.isValid()) {
            List<VFileEvent> events = Collections.singletonList(event);
            this.myPublisher.before(events);
            this.applyEvent(event);
            this.myPublisher.after(events);
        }
    }

    private static int groupByPath(@NotNull List<? extends VFileEvent> inEvents, int startIndex, @NotNull Set<? super String> files2, @NotNull Set<? super String> middleDirs) {
        VFileEvent event;
        String path;
        int i;
        for (i = startIndex; i < inEvents.size() && !PersistentFSImpl.checkIfConflictingEvent(path = (event = inEvents.get(i)).getPath(), files2, middleDirs); ++i) {
            String path2 = null;
            if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name")) {
                VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
                VirtualFile parent = pce.getFile().getParent();
                String newName = (String)pce.getNewValue();
                path2 = parent == null ? newName : parent.getPath() + "/" + newName;
            } else if (event instanceof VFileCopyEvent) {
                path2 = ((VFileCopyEvent)event).getFile().getPath();
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent vme = (VFileMoveEvent)event;
                String newName = vme.getFile().getName();
                path2 = vme.getNewParent().getPath() + "/" + newName;
            }
            if (path2 != null && !FileUtil.PATH_HASHING_STRATEGY.equals((Object)path2, (Object)path) && PersistentFSImpl.checkIfConflictingEvent(path2, files2, middleDirs)) break;
        }
        return i;
    }

    private static boolean checkIfConflictingEvent(@NotNull String path, @NotNull Set<? super String> files2, @NotNull Set<? super String> middleDirs) {
        int liPrev;
        if (!files2.add(path) || middleDirs.contains(path)) {
            return true;
        }
        int li = path.length();
        while ((liPrev = path.lastIndexOf(47, li - 1)) != -1) {
            String parentDir = path.substring(0, liPrev);
            if (files2.contains(parentDir)) {
                return true;
            }
            if (!middleDirs.add(parentDir)) break;
            li = liPrev;
        }
        return false;
    }

    private int groupAndValidate(@NotNull List<? extends VFileEvent> events, int startIndex, @NotNull List<? super Runnable> outApplyEvents, @NotNull List<? super VFileEvent> outValidatedEvents, @NotNull Set<? super String> files2, @NotNull Set<? super String> middleDirs) {
        int endIndex = PersistentFSImpl.groupByPath(events, startIndex, files2, middleDirs);
        assert (endIndex > startIndex) : events.get(startIndex) + "; files: " + files2 + "; middleDirs: " + middleDirs;
        this.groupCreations(events, startIndex, endIndex, outValidatedEvents, outApplyEvents);
        this.groupDeletions(events, startIndex, endIndex, outValidatedEvents, outApplyEvents);
        this.groupOthers(events, startIndex, endIndex, outValidatedEvents, outApplyEvents);
        return endIndex;
    }

    private void groupCreations(@NotNull List<? extends VFileEvent> events, final int start2, final int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents) {
        MultiMap<VirtualDirectoryImpl, VFileCreateEvent> grouped = null;
        for (int i = start2; i < end; ++i) {
            VFileEvent e = events.get(i);
            if (!(e instanceof VFileCreateEvent)) continue;
            VFileCreateEvent event = (VFileCreateEvent)e;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)event.getParent();
            if (grouped == null) {
                grouped = new MultiMap<VirtualDirectoryImpl, VFileCreateEvent>(){

                    @NotNull
                    protected Map<VirtualDirectoryImpl, Collection<VFileCreateEvent>> createMap() {
                        return new THashMap(end - start2);
                    }
                };
            }
            grouped.putValue((Object)parent, (Object)event);
        }
        if (grouped != null) {
            boolean hasValidEvents = false;
            for (Map.Entry entry : grouped.entrySet()) {
                VirtualDirectoryImpl directory = (VirtualDirectoryImpl)((Object)entry.getKey());
                List createEvents = (List)entry.getValue();
                directory.validateChildrenToCreate(createEvents);
                hasValidEvents |= !createEvents.isEmpty();
                outValidated.addAll(createEvents);
            }
            if (hasValidEvents) {
                MultiMap<VirtualDirectoryImpl, VFileCreateEvent> finalGrouped = grouped;
                outApplyEvents.add(() -> {
                    this.applyCreations(finalGrouped);
                    this.incStructuralModificationCount();
                });
            }
        }
    }

    private void groupDeletions(@NotNull List<? extends VFileEvent> events, final int start2, final int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents) {
        MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> grouped = null;
        boolean hasValidEvents = false;
        for (int i = start2; i < end; ++i) {
            VFileEvent event = events.get(i);
            if (!(event instanceof VFileDeleteEvent) || !event.isValid()) continue;
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)de.getFile().getParent();
            if (grouped == null) {
                grouped = new MultiMap<VirtualDirectoryImpl, VFileDeleteEvent>(){

                    @NotNull
                    protected Map<VirtualDirectoryImpl, Collection<VFileDeleteEvent>> createMap() {
                        return new HashMap<VirtualDirectoryImpl, Collection<VFileDeleteEvent>>(end - start2);
                    }
                };
            }
            grouped.putValue((Object)parent, (Object)de);
            outValidated.add((VFileEvent)event);
            hasValidEvents = true;
        }
        if (hasValidEvents) {
            MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> finalGrouped = grouped;
            outApplyEvents.add(() -> {
                this.clearIdCache();
                this.applyDeletions(finalGrouped);
                this.incStructuralModificationCount();
            });
        }
    }

    private void groupOthers(@NotNull List<? extends VFileEvent> events, int start2, int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyEvents) {
        for (int i = start2; i < end; ++i) {
            VFileEvent event = events.get(i);
            if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || !event.isValid()) continue;
            outValidated.add((VFileEvent)event);
            outApplyEvents.add(() -> this.applyEvent(event));
        }
    }

    @Override
    public void processEvents(@NotNull List<VFileEvent> events) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        int startIndex = 0;
        int cappedInitialSize = Math.min(events.size(), 1024);
        ArrayList applyEvents = new ArrayList(cappedInitialSize);
        THashSet files2 = new THashSet(cappedInitialSize, FileUtil.PATH_HASHING_STRATEGY);
        THashSet middleDirs = new THashSet(cappedInitialSize, FileUtil.PATH_HASHING_STRATEGY);
        ArrayList validated = new ArrayList(cappedInitialSize);
        while (startIndex != events.size()) {
            applyEvents.clear();
            files2.clear();
            middleDirs.clear();
            validated.clear();
            startIndex = this.groupAndValidate(events, startIndex, applyEvents, validated, (Set<? super String>)files2, (Set<? super String>)middleDirs);
            if (validated.isEmpty()) continue;
            ImmutableList toSend = ContainerUtil.immutableList((Object[])validated.toArray(new VFileEvent[0]));
            this.myPublisher.before((List)toSend);
            applyEvents.forEach(Runnable::run);
            this.myPublisher.after((List)toSend);
        }
    }

    private void applyDeletions(@NotNull MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> deletions) {
        for (Map.Entry entry : deletions.entrySet()) {
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)((Object)entry.getKey());
            Collection deleteEvents = (Collection)entry.getValue();
            if (parent == null || !parent.isValid()) {
                deleteEvents.forEach(this::applyEvent);
                return;
            }
            int parentId = PersistentFSImpl.getFileId((VirtualFile)parent);
            int[] oldIds = FSRecords.list(parentId);
            TIntHashSet parentChildrenIds = new TIntHashSet(Math.max(deleteEvents.size(), oldIds.length));
            parentChildrenIds.addAll(oldIds);
            ArrayList<CharSequence> childrenNamesDeleted = new ArrayList<CharSequence>(deleteEvents.size());
            TIntHashSet childrenIdsDeleted = new TIntHashSet(deleteEvents.size());
            for (VFileDeleteEvent event : deleteEvents) {
                VirtualFile file2 = event.getFile();
                int id = PersistentFSImpl.getFileId(file2);
                childrenNamesDeleted.add(file2.getNameSequence());
                childrenIdsDeleted.add(id);
                FSRecords.deleteRecordRecursively(id);
                PersistentFSImpl.invalidateSubtree(file2);
                parentChildrenIds.remove(id);
            }
            parent.removeChildren(childrenIdsDeleted, childrenNamesDeleted);
            FSRecords.updateList(parentId, parentChildrenIds.toArray());
        }
    }

    private void applyCreations(@NotNull MultiMap<VirtualDirectoryImpl, VFileCreateEvent> creations) {
        for (Map.Entry entry : creations.entrySet()) {
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)((Object)entry.getKey());
            Collection createEvents = (Collection)entry.getValue();
            int parentId = PersistentFSImpl.getFileId((VirtualFile)parent);
            int[] oldIds = FSRecords.list(parentId);
            TIntHashSet parentChildrenIds = new TIntHashSet(Math.max(createEvents.size(), oldIds.length));
            parentChildrenIds.addAll(oldIds);
            ArrayList<ChildInfo> childrenAdded = new ArrayList<ChildInfo>(createEvents.size());
            NewVirtualFileSystem delegate = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate((VirtualFile)parent));
            delegate.list((VirtualFile)parent);
            for (VFileCreateEvent createEvent : createEvents) {
                createEvent.resetCache();
                String name = createEvent.getChildName();
                Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate, (VirtualFile)parent, name, createEvent.getAttributes(), createEvent.getSymlinkTarget());
                if (childData == null) continue;
                int childId = PersistentFSImpl.makeChildRecord(parentId, name, childData, delegate);
                childrenAdded.add(new ChildInfo(childId, name, (FileAttributes)childData.first, createEvent.isEmptyDirectory()));
                parentChildrenIds.add(childId);
            }
            parent.createAndAddChildren(childrenAdded);
            if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest()) {
                long count = Arrays.stream(parentChildrenIds.toArray()).mapToObj(this::findFileById).filter(Objects::nonNull).map(VirtualFile::getName).distinct().count();
                assert (count == (long)parentChildrenIds.size());
            }
            FSRecords.updateList(parentId, parentChildrenIds.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFileSystemEntry findRoot(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        boolean mark;
        String rootPath;
        CharSequence rootName;
        if (path.isEmpty()) {
            LOG.error("Invalid root, fs=" + fs);
            return null;
        }
        String rootUrl = PersistentFSImpl.normalizeRootUrl(path, fs);
        VirtualFileSystemEntry root = this.myRoots.get(rootUrl);
        if (root != null) {
            return root;
        }
        if (fs instanceof ArchiveFileSystem) {
            ArchiveFileSystem afs = (ArchiveFileSystem)fs;
            VirtualFile localFile = afs.findLocalByRootPath(path);
            if (localFile == null) {
                return null;
            }
            rootName = localFile.getNameSequence();
            rootPath = afs.getRootPathByLocal(localFile);
        } else {
            rootName = rootPath = path;
        }
        FileAttributes attributes = fs.getAttributes((VirtualFile)new StubVirtualFile(){

            @NotNull
            public String getPath() {
                return rootPath;
            }

            @Nullable
            public VirtualFile getParent() {
                return null;
            }
        });
        if (attributes == null || !attributes.isDirectory()) {
            return null;
        }
        int rootId = FSRecords.findRootRecord(rootUrl);
        VfsData.Segment segment = this.myVfsData.getSegment(rootId, true);
        VfsData.DirectoryData directoryData = new VfsData.DirectoryData();
        FsRoot newRoot = new FsRoot(rootId, segment, directoryData, fs, rootName, StringUtil.trimTrailing((String)rootPath, (char)'/'));
        Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
        synchronized (map2) {
            root = this.myRoots.get(rootUrl);
            if (root != null) {
                return root;
            }
            try {
                VfsData.initFile(rootId, segment, -1, directoryData);
            }
            catch (VfsData.FileAlreadyCreatedException e) {
                for (Map.Entry<String, VirtualFileSystemEntry> entry : this.myRoots.entrySet()) {
                    VirtualFileSystemEntry existingRoot = entry.getValue();
                    if (existingRoot.getId() != rootId) continue;
                    String message = "Duplicate FS roots: " + rootUrl + " / " + entry.getKey() + " id=" + rootId + " valid=" + existingRoot.isValid();
                    throw new RuntimeException(message, e);
                }
                throw new RuntimeException("No root duplication, roots=" + Arrays.toString(FSRecords.listAll(1)), e);
            }
            this.incStructuralModificationCount();
            mark = PersistentFSImpl.writeAttributesToRecord(rootId, 0, rootName, fs, attributes, null);
            this.myRoots.put(rootUrl, newRoot);
            this.myIdToDirCache.put(rootId, (Object)newRoot);
        }
        if (!mark && attributes.lastModified != FSRecords.getTimestamp(rootId)) {
            ((VirtualFileSystemEntry)newRoot).markDirtyRecursively();
        }
        LOG.assertTrue(rootId == newRoot.getId(), (Object)("root=" + (Object)((Object)newRoot) + " expected=" + rootId + " actual=" + newRoot.getId()));
        return newRoot;
    }

    @NotNull
    private static String normalizeRootUrl(@NotNull String basePath, @NotNull NewVirtualFileSystem fs) {
        String normalized = VfsImplUtil.normalize(fs, FileUtil.toCanonicalPath((String)basePath));
        String protocol = fs.getProtocol();
        StringBuilder result2 = new StringBuilder(protocol.length() + "://".length() + normalized.length());
        result2.append(protocol).append("://").append(normalized);
        return StringUtil.endsWithChar((CharSequence)result2, (char)'/') ? UriUtil.trimTrailingSlashes(result2.toString()) : result2.toString();
    }

    @Override
    public void clearIdCache() {
        this.myIdToDirCache.entrySet().removeIf(e -> ((VirtualFileSystemEntry)((Object)((Object)e.getValue()))).getParent() != null);
    }

    @Nullable
    public NewVirtualFile findFileById(int id) {
        VirtualFileSystemEntry cached = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
        return cached != null ? cached : FSRecords.findFileById(id, this.myIdToDirCache);
    }

    @Override
    public NewVirtualFile findFileByIdIfCached(int id) {
        return this.myVfsData.hasLoadedFile(id) ? this.findFileById(id) : null;
    }

    @NotNull
    public VirtualFile[] getRoots() {
        Collection<VirtualFileSystemEntry> roots = this.myRoots.values();
        return VfsUtilCore.toVirtualFileArray(roots);
    }

    @NotNull
    public VirtualFile[] getRoots(@NotNull NewVirtualFileSystem fs) {
        ArrayList<NewVirtualFile> roots = new ArrayList<NewVirtualFile>();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (newVirtualFile.getFileSystem() != fs) continue;
            roots.add(newVirtualFile);
        }
        return VfsUtilCore.toVirtualFileArray(roots);
    }

    @NotNull
    public VirtualFile[] getLocalRoots() {
        List roots = ContainerUtil.newSmartList();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (!newVirtualFile.isInLocalFileSystem() || newVirtualFile.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(newVirtualFile);
        }
        return VfsUtilCore.toVirtualFileArray((Collection)roots);
    }

    private void applyEvent(@NotNull VFileEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Applying " + event);
        }
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent ce = (VFileCreateEvent)event;
                this.executeCreateChild(ce.getParent(), ce.getChildName(), ce.getAttributes(), ce.getSymlinkTarget(), ce.isEmptyDirectory());
            } else if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent.getFile());
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                VirtualFile file2 = contentUpdateEvent.getFile();
                long length = contentUpdateEvent.getNewLength();
                long timestamp = contentUpdateEvent.getNewTimestamp();
                if (!contentUpdateEvent.isLengthAndTimestampDiffProvided()) {
                    NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                    FileAttributes attributes = delegate.getAttributes(file2);
                    length = attributes != null ? attributes.length : 0L;
                    timestamp = attributes != null ? attributes.lastModified : 0L;
                }
                PersistentFSImpl.executeTouch(file2, contentUpdateEvent.isFromRefresh(), contentUpdateEvent.getModificationStamp(), length, timestamp);
            } else if (event instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)event;
                this.executeCreateChild(ce.getNewParent(), ce.getNewChildName(), null, null, ce.getFile().getChildren().length == 0);
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
            } else if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                VirtualFile file3 = propertyChangeEvent.getFile();
                Object newValue = propertyChangeEvent.getNewValue();
                switch (propertyChangeEvent.getPropertyName()) {
                    case "name": {
                        PersistentFSImpl.executeRename(file3, (String)newValue);
                        break;
                    }
                    case "writable": {
                        PersistentFSImpl.executeSetWritable(file3, (Boolean)newValue);
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("File " + file3 + " writable=" + file3.isWritable() + " id=" + PersistentFSImpl.getFileId(file3));
                        break;
                    }
                    case "HIDDEN": {
                        PersistentFSImpl.executeSetHidden(file3, (Boolean)newValue);
                        break;
                    }
                    case "symlink": {
                        PersistentFSImpl.executeSetTarget(file3, (String)newValue);
                        this.markForContentReloadRecursively(PersistentFSImpl.getFileId(file3));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    @NonNls
    public String toString() {
        return "PersistentFS";
    }

    private void executeCreateChild(@NotNull VirtualFile parent, @NotNull String name, @Nullable FileAttributes attributes, @Nullable String symlinkTarget, boolean isEmptyDirectory) {
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(parent);
        int parentId = PersistentFSImpl.getFileId(parent);
        Pair<FileAttributes, String> childData = PersistentFSImpl.getChildData(delegate, parent, name, attributes, symlinkTarget);
        if (childData != null) {
            int childId = PersistentFSImpl.makeChildRecord(parentId, name, childData, delegate);
            PersistentFSImpl.appendIdToParentList(parentId, childId);
            assert (parent instanceof VirtualDirectoryImpl) : parent;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
            VirtualFileSystemEntry child2 = dir.createChild(name, childId, dir.getFileSystem(), (FileAttributes)childData.first, isEmptyDirectory);
            dir.addChild(child2);
            this.incStructuralModificationCount();
        }
    }

    private static int makeChildRecord(int parentId, @NotNull String name, @NotNull Pair<FileAttributes, String> childData, @NotNull NewVirtualFileSystem fs) {
        int childId = FSRecords.createRecord();
        PersistentFSImpl.writeAttributesToRecord(childId, parentId, name, fs, (FileAttributes)childData.first, (String)childData.second);
        assert (childId > 0) : childId;
        return childId;
    }

    private static Pair<FileAttributes, String> getChildData(@NotNull NewVirtualFileSystem fs, @NotNull VirtualFile parent, @NotNull String name, @Nullable FileAttributes attributes, @Nullable String symlinkTarget) {
        if (attributes == null) {
            attributes = fs.getAttributes((VirtualFile)new FakeVirtualFile(parent, name));
            symlinkTarget = attributes != null && attributes.isSymLink() ? fs.resolveSymLink((VirtualFile)new FakeVirtualFile(parent, name)) : null;
        }
        return attributes == null ? null : Pair.pair((Object)attributes, (Object)symlinkTarget);
    }

    private static void appendIdToParentList(int parentId, int childId) {
        int[] childrenList = FSRecords.list(parentId);
        childrenList = ArrayUtil.append((int[])childrenList, (int)childId);
        FSRecords.updateList(parentId, childrenList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(@NotNull VirtualFile file2) {
        int parentId;
        if (!file2.exists()) {
            LOG.error("Deleting a file which does not exist: " + ((VirtualFileWithId)file2).getId() + " " + file2.getPath());
            return;
        }
        this.clearIdCache();
        int id = PersistentFSImpl.getFileId(file2);
        VirtualFile parent = file2.getParent();
        int n = parentId = parent == null ? 0 : PersistentFSImpl.getFileId(parent);
        if (parentId == 0) {
            String rootUrl = PersistentFSImpl.normalizeRootUrl(file2.getPath(), (NewVirtualFileSystem)file2.getFileSystem());
            Map<String, VirtualFileSystemEntry> map2 = this.myRoots;
            synchronized (map2) {
                this.myRoots.remove(rootUrl);
                this.myIdToDirCache.remove(id);
                FSRecords.deleteRootRecord(id);
            }
        } else {
            PersistentFSImpl.removeIdFromParentList(parentId, id, parent, file2);
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file2.getParent();
            assert (directory != null) : file2;
            directory.removeChild(file2);
        }
        FSRecords.deleteRecordRecursively(id);
        PersistentFSImpl.invalidateSubtree(file2);
        this.incStructuralModificationCount();
    }

    private static void invalidateSubtree(@NotNull VirtualFile file2) {
        VirtualFileSystemEntry impl = (VirtualFileSystemEntry)file2;
        impl.invalidate();
        for (VirtualFile child2 : impl.getCachedChildren()) {
            PersistentFSImpl.invalidateSubtree(child2);
        }
    }

    private static void removeIdFromParentList(int parentId, int id, @NotNull VirtualFile parent, VirtualFile file2) {
        int[] childList = FSRecords.list(parentId);
        int index = ArrayUtil.indexOf((int[])childList, (int)id);
        if (index == -1) {
            throw new RuntimeException("Cannot find child (" + id + ")" + file2 + "\n\tin (" + parentId + ")" + parent + "\n\tactual children:" + Arrays.toString(childList));
        }
        childList = ArrayUtil.remove((int[])childList, (int)index);
        FSRecords.updateList(parentId, childList);
    }

    private static void executeRename(@NotNull VirtualFile file2, @NotNull String newName) {
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.setName(id, newName);
        ((VirtualFileSystemEntry)file2).setNewName(newName);
    }

    private static void executeSetWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        PersistentFSImpl.setFlag(file2, 4, !writableFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("writable", writableFlag);
    }

    private static void executeSetHidden(@NotNull VirtualFile file2, boolean hiddenFlag) {
        PersistentFSImpl.setFlag(file2, 64, hiddenFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("HIDDEN", hiddenFlag);
    }

    private static void executeSetTarget(@NotNull VirtualFile file2, @Nullable String target2) {
        FSRecords.storeSymlinkTarget(PersistentFSImpl.getFileId(file2), target2);
    }

    private static void setFlag(@NotNull VirtualFile file2, int mask, boolean value) {
        PersistentFSImpl.setFlag(PersistentFSImpl.getFileId(file2), mask, value);
    }

    private static void setFlag(int id, int mask, boolean value) {
        int flags;
        int oldFlags = FSRecords.getFlags(id);
        int n = flags = value ? oldFlags | mask : oldFlags & ~mask;
        if (oldFlags != flags) {
            FSRecords.setFlags(id, flags, true);
        }
    }

    private static boolean checkFlag(int fileId, int mask) {
        return BitUtil.isSet((int)FSRecords.getFlags(fileId), (int)mask);
    }

    private static void executeTouch(@NotNull VirtualFile file2, boolean reloadContentFromDelegate, long newModificationStamp, long newLength, long newTimestamp) {
        if (reloadContentFromDelegate) {
            PersistentFSImpl.setFlag(file2, 8, true);
        }
        int fileId = PersistentFSImpl.getFileId(file2);
        FSRecords.setLength(fileId, newLength);
        FSRecords.setTimestamp(fileId, newTimestamp);
        ((VirtualFileSystemEntry)file2).setModificationStamp(newModificationStamp);
    }

    private void executeMove(@NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        this.clearIdCache();
        int fileId = PersistentFSImpl.getFileId(file2);
        int newParentId = PersistentFSImpl.getFileId(newParent);
        int oldParentId = PersistentFSImpl.getFileId(file2.getParent());
        PersistentFSImpl.removeIdFromParentList(oldParentId, fileId, file2.getParent(), file2);
        FSRecords.setParent(fileId, newParentId);
        PersistentFSImpl.appendIdToParentList(newParentId, fileId);
        ((VirtualFileSystemEntry)file2).setParent(newParent);
    }

    @Override
    public String getName(int id) {
        assert (id > 0);
        return FSRecords.getName(id);
    }

    public void cleanPersistedContent(int id) {
        PersistentFSImpl.doCleanPersistedContent(id);
    }

    public void cleanPersistedContents() {
        int[] roots;
        for (int root : roots = FSRecords.listRoots()) {
            this.markForContentReloadRecursively(root);
        }
    }

    private void markForContentReloadRecursively(int id) {
        if (PersistentFSImpl.isDirectory(this.getFileAttributes(id))) {
            for (int child2 : FSRecords.list(id)) {
                this.markForContentReloadRecursively(child2);
            }
        } else {
            PersistentFSImpl.doCleanPersistedContent(id);
        }
    }

    private static void doCleanPersistedContent(int id) {
        PersistentFSImpl.setFlag(id, 8, true);
    }

    private static boolean looksCanonical(@NotNull String pathBeforeSlash) {
        int i;
        if (pathBeforeSlash.endsWith("/")) {
            return false;
        }
        int start2 = 0;
        while ((i = pathBeforeSlash.indexOf("..", start2)) != -1) {
            if (i != 0 && pathBeforeSlash.charAt(i - 1) == '/') {
                return false;
            }
            if (i < pathBeforeSlash.length() - 2 && pathBeforeSlash.charAt(i + 2) == '/') {
                return false;
            }
            start2 = i + 1;
        }
        return true;
    }

    @Override
    public boolean mayHaveChildren(int id) {
        return FSRecords.mayHaveChildren(id);
    }

    private static class FsRoot
    extends VirtualDirectoryImpl {
        private final CharSequence myName;
        private final String myPathWithOneSlash;

        private FsRoot(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data, @NotNull NewVirtualFileSystem fs, @NotNull CharSequence name, @NotNull String pathBeforeSlash) {
            super(id, segment, data, null, fs);
            this.myName = name;
            if (!PersistentFSImpl.looksCanonical(pathBeforeSlash)) {
                throw new IllegalArgumentException("path must be canonical but got: '" + pathBeforeSlash + "'");
            }
            this.myPathWithOneSlash = pathBeforeSlash + '/';
        }

        @Override
        @NotNull
        public CharSequence getNameSequence() {
            return this.myName;
        }

        @Override
        @NotNull
        protected char[] appendPathOnFileSystem(int pathLength, int[] position) {
            int myLength = this.myPathWithOneSlash.length() - 1;
            char[] chars = new char[pathLength + myLength];
            CharArrayUtil.getChars((CharSequence)this.myPathWithOneSlash, (char[])chars, (int)0, (int)position[0], (int)myLength);
            position[0] = position[0] + myLength;
            return chars;
        }

        @Override
        public void setNewName(@NotNull String newName) {
            throw new IncorrectOperationException();
        }

        @Override
        public final void setParent(@NotNull VirtualFile newParent) {
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myPathWithOneSlash;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.getFileSystem().getProtocol() + "://" + this.getPath();
        }
    }

    public static class ChildInfo {
        public final int id;
        public final String name;
        public final FileAttributes attributes;
        public final boolean isEmptyDirectory;

        public ChildInfo(int id, String name, FileAttributes attributes, boolean isEmptyDirectory) {
            this.id = id;
            this.name = name;
            this.attributes = attributes;
            this.isEmptyDirectory = isEmptyDirectory;
        }
    }
}

