/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class VfsDependentEnum<T> {
    private static final String DEPENDENT_PERSISTENT_LIST_START_PREFIX = "vfs_enum_";
    private final File myFile;
    private final DataExternalizer<T> myKeyDescriptor;
    private final int myVersion;
    private boolean myMarkedForInvalidation;
    private final ConcurrentList<T> myInstances = ContainerUtil.createConcurrentList();
    private final ConcurrentMap<T, Integer> myInstanceToId = ContainerUtil.newConcurrentMap();
    private final Object myLock = new Object();
    private boolean myTriedToLoadFile;

    public VfsDependentEnum(String fileName2, KeyDescriptor<T> descriptor, int version2) {
        this.myFile = new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX + fileName2 + FSRecords.VFS_FILES_EXTENSION);
        this.myKeyDescriptor = descriptor;
        this.myVersion = version2;
    }

    static File getBaseFile() {
        return new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX);
    }

    public int getId(@NotNull T s) throws IOException {
        return this.getIdRaw(s, true);
    }

    int getIdRaw(@NotNull T s, boolean vfsRebuildOnException) throws IOException {
        Integer integer = (Integer)this.myInstanceToId.get(s);
        if (integer != null) {
            return integer;
        }
        Object object = this.myLock;
        synchronized (object) {
            integer = (Integer)this.myInstanceToId.get(s);
            if (integer != null) {
                return integer;
            }
            try {
                boolean loaded = this.loadFromFile();
                if (loaded && (integer = (Integer)this.myInstanceToId.get(s)) != null) {
                    return integer;
                }
                int enumerated = this.myInstances.size() + 1;
                this.register(s, enumerated);
                this.saveToFile(s);
                return enumerated;
            }
            catch (IOException e) {
                this.invalidate(e, vfsRebuildOnException);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(@NotNull T instance) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.myFile, true);
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(fileOutputStream));){
            if (this.myFile.length() == 0L) {
                DataInputOutputUtil.writeTIME((DataOutput)output, (long)FSRecords.getCreationTimestamp());
                DataInputOutputUtil.writeINT((DataOutput)output, (int)this.myVersion);
            }
            this.myKeyDescriptor.save((DataOutput)output, instance);
        }
        finally {
            try {
                fileOutputStream.getFD().sync();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromFile() throws IOException {
        THashMap elementToIdMap;
        ArrayList<Object> elements;
        DataInputStream input;
        block27: {
            if (this.myTriedToLoadFile) return false;
            if (!this.myInstances.isEmpty()) return false;
            if (!this.myFile.exists()) return false;
            this.myTriedToLoadFile = true;
            boolean deleteFile2 = false;
            input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myFile)));
            Throwable throwable = null;
            try {
                long vfsVersion = DataInputOutputUtil.readTIME((DataInput)input);
                if (vfsVersion != FSRecords.getCreationTimestamp()) {
                    deleteFile2 = true;
                    boolean bl = false;
                    return bl;
                }
                int savedVersion = DataInputOutputUtil.readINT((DataInput)input);
                if (savedVersion == this.myVersion) {
                    elements = new ArrayList<Object>();
                    elementToIdMap = new THashMap();
                    break block27;
                }
                throw new IOException("Version mismatch: current " + this.myVersion + ", previous:" + savedVersion + ", file:" + this.myFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (deleteFile2) {
                    FileUtil.deleteWithRenaming((File)this.myFile);
                }
            }
        }
        while (true) {
            if (input.available() <= 0) {
                this.myInstances.addAll(elements);
                this.myInstanceToId.putAll((Map<T, Integer>)elementToIdMap);
                boolean bl = true;
                return bl;
            }
            Object instance = this.myKeyDescriptor.read((DataInput)input);
            assert (instance != null);
            elements.add(instance);
            elementToIdMap.put(instance, elements.size());
        }
    }

    private void invalidate(@NotNull Throwable e, boolean vfsRebuildOnException) {
        if (!this.myMarkedForInvalidation) {
            this.myMarkedForInvalidation = true;
            FileUtil.deleteWithRenaming((File)this.myFile);
            if (vfsRebuildOnException) {
                FSRecords.requestVfsRebuild(e);
            }
        }
    }

    private void register(@NotNull T instance, int id) {
        this.myInstanceToId.put(instance, id);
        assert (id == this.myInstances.size() + 1);
        this.myInstances.add(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public T getById(int id) throws IOException {
        Object instance;
        assert (id > 0);
        if (--id < this.myInstances.size() && (instance = this.myInstances.get(id)) != null) {
            return (T)instance;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (id < this.myInstances.size() && (instance = this.myInstances.get(id)) != null) {
                return (T)instance;
            }
            try {
                boolean loaded = this.loadFromFile();
                if (loaded && (instance = this.myInstances.get(id)) != null) {
                    return (T)instance;
                }
                assert (false) : "Reading nonexistent value:" + id + "," + this.myFile + ", loaded:" + loaded;
            }
            catch (IOException | AssertionError e) {
                this.invalidate((Throwable)e, true);
                throw e;
            }
        }
        return null;
    }
}

