/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class VfsEventGenerationHelper {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker");
    private final List<VFileEvent> myEvents = new ArrayList<VFileEvent>();

    VfsEventGenerationHelper() {
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        return this.myEvents;
    }

    boolean checkDirty(@NotNull NewVirtualFile file2) {
        boolean fileDirty = file2.isDirty();
        if (LOG.isTraceEnabled()) {
            LOG.trace("file=" + file2 + " dirty=" + fileDirty);
        }
        return fileDirty;
    }

    void checkContentChanged(@NotNull VirtualFile file2, long oldTimestamp, long newTimestamp, long oldLength, long newLength) {
        if (oldTimestamp != newTimestamp || oldLength != newLength) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("update file=" + file2 + (oldTimestamp != newTimestamp ? " TS=" + oldTimestamp + "->" + newTimestamp : "") + (oldLength != newLength ? " len=" + oldLength + "->" + newLength : ""));
            }
            this.myEvents.add((VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, oldTimestamp, newTimestamp, oldLength, newLength, true));
        }
    }

    void scheduleCreation(@NotNull VirtualFile parent, @NotNull String childName, @NotNull FileAttributes attributes, boolean isEmptyDir, String symlinkTarget) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("create parent=" + parent + " name=" + childName + " attr=" + attributes);
        }
        this.myEvents.add((VFileEvent)new VFileCreateEvent(null, parent, childName, attributes.isDirectory(), attributes, symlinkTarget, true, isEmptyDir));
    }

    void scheduleDeletion(@NotNull VirtualFile file2) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("delete file=" + file2);
        }
        this.myEvents.add((VFileEvent)new VFileDeleteEvent(null, file2, true));
    }

    void checkSymbolicLinkChange(@NotNull VirtualFile child2, String oldTarget, String currentTarget) {
        String currentVfsTarget;
        String string = currentVfsTarget = currentTarget != null ? FileUtil.toSystemIndependentName((String)currentTarget) : null;
        if (!Comparing.equal((String)oldTarget, (String)currentVfsTarget)) {
            this.scheduleAttributeChange(child2, "symlink", oldTarget, currentVfsTarget);
        }
    }

    void checkHiddenAttributeChange(@NotNull VirtualFile child2, boolean oldHidden, boolean newHidden) {
        if (oldHidden != newHidden) {
            this.scheduleAttributeChange(child2, "HIDDEN", oldHidden, newHidden);
        }
    }

    void checkWritableAttributeChange(@NotNull VirtualFile file2, boolean oldWritable, boolean newWritable) {
        if (oldWritable != newWritable) {
            this.scheduleAttributeChange(file2, "writable", oldWritable, newWritable);
        }
    }

    void scheduleAttributeChange(@NotNull VirtualFile file2, @VirtualFile.PropName @NotNull String property, Object current, Object upToDate) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("update file=" + file2 + ' ' + property + '=' + current + "->" + upToDate);
        }
        this.myEvents.add((VFileEvent)new VFilePropertyChangeEvent(null, file2, property, current, upToDate, true));
    }

    void addAllEventsFrom(@NotNull VfsEventGenerationHelper otherHelper) {
        this.myEvents.addAll(otherHelper.myEvents);
    }
}

