/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolWindowContextMenuActionBase
extends AnAction {
    public final void actionPerformed(@NotNull AnActionEvent e) {
        ToolWindow toolWindow = (ToolWindow)e.getDataContext().getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow == null) {
            return;
        }
        Content content = ToolWindowContextMenuActionBase.getContextContent(e, toolWindow);
        this.actionPerformed(e, toolWindow, content);
    }

    public final void update(@NotNull AnActionEvent e) {
        ToolWindow toolWindow = (ToolWindow)e.getDataContext().getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Content content = ToolWindowContextMenuActionBase.getContextContent(e, toolWindow);
        this.update(e, toolWindow, content);
    }

    public abstract void update(@NotNull AnActionEvent var1, @NotNull ToolWindow var2, @Nullable Content var3);

    public abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull ToolWindow var2, @Nullable Content var3);

    @Nullable
    private static Content getContextContent(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow) {
        Content selectedContent;
        BaseLabel baseLabel = (BaseLabel)ObjectUtils.tryCast((Object)e.getData(PlatformDataKeys.CONTEXT_COMPONENT), BaseLabel.class);
        Content content = selectedContent = baseLabel != null ? baseLabel.getContent() : null;
        if (selectedContent == null) {
            selectedContent = toolWindow.getContentManager().getSelectedContent();
        }
        return selectedContent;
    }
}

