/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.util.containers.Stack;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

final class ActiveStack {
    private final Stack<String> myStack = new Stack();
    private final Stack<String> myPersistentStack = new Stack();

    ActiveStack() {
    }

    void clear() {
        this.myStack.clear();
    }

    boolean isEmpty() {
        return this.myStack.isEmpty();
    }

    @NotNull
    String pop() {
        return (String)this.myStack.pop();
    }

    @NotNull
    String peek() {
        return (String)this.myStack.peek();
    }

    int getSize() {
        return this.myStack.size();
    }

    @NotNull
    private String peek(int i) {
        return (String)this.myStack.get(this.getSize() - i - 1);
    }

    @NotNull
    String[] getStack() {
        String[] result2 = new String[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            result2[i] = this.peek(i);
        }
        return result2;
    }

    @NotNull
    String[] getPersistentStack() {
        String[] result2 = new String[this.getPersistentSize()];
        for (int i = 0; i < this.getPersistentSize(); ++i) {
            result2[i] = this.peekPersistent(i);
        }
        return result2;
    }

    void push(@NotNull String id) {
        this.remove(id, true);
        this.myStack.push((Object)id);
        this.myPersistentStack.push((Object)id);
    }

    int getPersistentSize() {
        return this.myPersistentStack.size();
    }

    @NotNull
    String peekPersistent(int index) {
        return (String)this.myPersistentStack.get(this.myPersistentStack.size() - index - 1);
    }

    void remove(@NotNull String id, boolean removePersistentAlso) {
        Iterator i = this.myStack.iterator();
        while (i.hasNext()) {
            if (!id.equals(i.next())) continue;
            i.remove();
        }
        if (removePersistentAlso) {
            i = this.myPersistentStack.iterator();
            while (i.hasNext()) {
                if (!id.equals(i.next())) continue;
                i.remove();
            }
        }
    }
}

