/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DesktopLayout {
    private static final Logger LOG = Logger.getInstance(DesktopLayout.class);
    private static final Comparator<WindowInfoImpl> ourWindowInfoComparator = (o1, o2) -> {
        int d = DesktopLayout.getAnchorWeight(o1.getAnchor()) - DesktopLayout.getAnchorWeight(o2.getAnchor());
        return d == 0 ? o1.getOrder() - o2.getOrder() : d;
    };
    static final String TAG = "layout";
    private final Map<String, WindowInfoImpl> myIdToInfo = new THashMap();
    private final ClearableLazyValue<List<WindowInfoImpl>> myRegisteredInfos = new ClearableLazyValue<List<WindowInfoImpl>>(){

        @NotNull
        protected List<WindowInfoImpl> compute() {
            if (DesktopLayout.this.myIdToInfo.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<WindowInfoImpl> result2 = new ArrayList<WindowInfoImpl>();
            for (WindowInfoImpl value : DesktopLayout.this.myIdToInfo.values()) {
                if (!value.isRegistered()) continue;
                result2.add(value);
            }
            result2.sort(ourWindowInfoComparator);
            return result2;
        }
    };

    private static int getAnchorWeight(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == ToolWindowAnchor.TOP) {
            return 1;
        }
        if (anchor2 == ToolWindowAnchor.LEFT) {
            return 2;
        }
        if (anchor2 == ToolWindowAnchor.BOTTOM) {
            return 3;
        }
        if (anchor2 == ToolWindowAnchor.RIGHT) {
            return 4;
        }
        return 0;
    }

    public final void copyFrom(@NotNull DesktopLayout layout) {
        THashMap old = new THashMap(this.myIdToInfo);
        this.myIdToInfo.clear();
        for (WindowInfoImpl otherInfo : layout.myIdToInfo.values()) {
            WindowInfoImpl oldInfo = (WindowInfoImpl)old.get(otherInfo.getId());
            if (oldInfo == null) {
                WindowInfoImpl newInfo = otherInfo.copy();
                newInfo.setRegistered(otherInfo.isRegistered());
                this.myIdToInfo.put(otherInfo.getId(), newInfo);
                continue;
            }
            oldInfo.copyFrom(otherInfo);
            oldInfo.setRegistered(otherInfo.isRegistered());
            this.myIdToInfo.put(otherInfo.getId(), oldInfo);
        }
        this.normalizeOrders();
    }

    private void normalizeOrders() {
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.TOP));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.LEFT));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.BOTTOM));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.RIGHT));
        this.myRegisteredInfos.drop();
    }

    final WindowInfoImpl register(@NotNull String id, @NotNull ToolWindowAnchor anchor2, boolean splitMode) {
        WindowInfoImpl info = this.myIdToInfo.get(id);
        if (info == null) {
            info = new WindowInfoImpl();
            info.setId(id);
            info.setAnchor(anchor2);
            info.setSplit(splitMode);
            this.myIdToInfo.put(id, info);
        }
        if (!info.isRegistered()) {
            info.setRegistered(true);
            this.myRegisteredInfos.drop();
        }
        return info;
    }

    final void unregister(@NotNull String id) {
        WindowInfoImpl info = this.myIdToInfo.get(id);
        if (info.isRegistered()) {
            info.setRegistered(false);
            this.myRegisteredInfos.drop();
        }
    }

    final WindowInfoImpl getInfo(@NotNull String id, boolean onlyRegistered) {
        WindowInfoImpl info = this.myIdToInfo.get(id);
        if (onlyRegistered && info != null && !info.isRegistered()) {
            return null;
        }
        return info;
    }

    @Nullable
    final String getActiveId() {
        for (WindowInfoImpl info : this.getInfos()) {
            if (!info.isActive()) continue;
            return info.getId();
        }
        return null;
    }

    @NotNull
    final List<WindowInfoImpl> getInfos() {
        return (List)this.myRegisteredInfos.getValue();
    }

    @NotNull
    private List<WindowInfoImpl> getAllInfos(@NotNull ToolWindowAnchor anchor2) {
        ArrayList<WindowInfoImpl> result2 = new ArrayList<WindowInfoImpl>();
        for (WindowInfoImpl info : this.myIdToInfo.values()) {
            if (anchor2 != info.getAnchor()) continue;
            result2.add(info);
        }
        result2.sort(ourWindowInfoComparator);
        return result2;
    }

    private static void normalizeOrder(@NotNull List<WindowInfoImpl> infos) {
        for (int i = 0; i < infos.size(); ++i) {
            infos.get(i).setOrder(i);
        }
    }

    final boolean isToolWindowRegistered(@NotNull String id) {
        WindowInfoImpl info = this.myIdToInfo.get(id);
        return info != null && info.isRegistered();
    }

    @NotNull
    final Comparator<StripeButton> comparator(@NotNull ToolWindowAnchor anchor2) {
        return new MyStripeButtonComparator(anchor2);
    }

    private int getMaxOrder(@NotNull ToolWindowAnchor anchor2) {
        int res2 = -1;
        for (WindowInfoImpl info : this.myIdToInfo.values()) {
            if (anchor2 != info.getAnchor() || res2 >= info.getOrder()) continue;
            res2 = info.getOrder();
        }
        return res2;
    }

    final void setAnchor(@NotNull String id, @NotNull ToolWindowAnchor newAnchor, int newOrder) {
        if (newOrder == -1) {
            newOrder = this.getMaxOrder(newAnchor) + 1;
        }
        WindowInfoImpl info = this.getInfo(id, true);
        ToolWindowAnchor oldAnchor = info.getAnchor();
        List<WindowInfoImpl> infos = this.getAllInfos(newAnchor);
        for (int i = infos.size() - 1; i > -1; --i) {
            WindowInfoImpl info2 = infos.get(i);
            if (newOrder > info2.getOrder()) continue;
            info2.setOrder(info2.getOrder() + 1);
        }
        info.setAnchor(newAnchor);
        info.setOrder(newOrder);
        DesktopLayout.normalizeOrder(this.getAllInfos(oldAnchor));
        if (oldAnchor != newAnchor) {
            DesktopLayout.normalizeOrder(this.getAllInfos(newAnchor));
        }
        this.myRegisteredInfos.drop();
    }

    final void setSplitMode(@NotNull String id, boolean split) {
        this.getInfo(id, true).setSplit(split);
    }

    public final void readExternal(@NotNull Element layoutElement) {
        THashSet registered = new THashSet();
        for (WindowInfoImpl info : this.myIdToInfo.values()) {
            if (!info.isRegistered()) continue;
            registered.add(info.getId());
        }
        this.myIdToInfo.clear();
        for (Element e : layoutElement.getChildren("window_info")) {
            WindowInfoImpl info = (WindowInfoImpl)XmlSerializer.deserialize((Element)e, WindowInfoImpl.class);
            info.normalizeAfterRead();
            if (info.getId() == null) {
                LOG.warn("Skip invalid window info (no id): " + JDOMUtil.writeElement((Element)e));
                continue;
            }
            if (registered.contains(info.getId())) {
                info.setRegistered(true);
            }
            this.myIdToInfo.put(info.getId(), info);
        }
        for (WindowInfoImpl info : this.myIdToInfo.values()) {
            if (info.getOrder() != -1) continue;
            info.setOrder(this.getMaxOrder(info.getAnchor()) + 1);
        }
        this.normalizeOrders();
    }

    @Nullable
    public final Element writeExternal(@NotNull String tagName) {
        if (this.myIdToInfo.isEmpty()) {
            return null;
        }
        ArrayList<WindowInfoImpl> list2 = new ArrayList<WindowInfoImpl>(this.myIdToInfo.values());
        list2.sort(ourWindowInfoComparator);
        Element state = new Element(tagName);
        for (WindowInfoImpl info : list2) {
            Element element = XmlSerializer.serialize((Object)info);
            if (element == null) continue;
            state.addContent(element);
        }
        return state;
    }

    @NotNull
    List<String> getVisibleIdsOn(@NotNull ToolWindowAnchor anchor2, @NotNull ToolWindowManagerImpl manager) {
        ArrayList<String> ids = new ArrayList<String>();
        for (WindowInfoImpl each : this.getAllInfos(anchor2)) {
            ToolWindow window = manager.getToolWindow(each.getId());
            if (window == null || !window.isAvailable() && !UISettings.getInstance().getAlwaysShowWindowsButton()) continue;
            ids.add(each.getId());
        }
        return ids;
    }

    private final class MyStripeButtonComparator
    implements Comparator<StripeButton> {
        private final Map<String, WindowInfoImpl> myIdToInfo = new THashMap();

        MyStripeButtonComparator(ToolWindowAnchor anchor2) {
            for (WindowInfoImpl info : DesktopLayout.this.getInfos()) {
                if (anchor2 != info.getAnchor()) continue;
                this.myIdToInfo.put(info.getId(), info.copy());
            }
        }

        @Override
        public final int compare(StripeButton obj1, StripeButton obj2) {
            WindowInfoImpl info1 = this.myIdToInfo.get(obj1.getWindowInfo().getId());
            int order1 = info1 != null ? info1.getOrder() : 0;
            WindowInfoImpl info2 = this.myIdToInfo.get(obj2.getWindowInfo().getId());
            int order2 = info2 != null ? info2.getOrder() : 0;
            return order1 - order2;
        }
    }
}

