/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.TimedOutCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusManagerImpl
extends IdeFocusManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FocusManagerImpl.class);
    private final Application myApp;
    private final List<FocusRequestInfo> myRequests = new LinkedList<FocusRequestInfo>();
    private final IdeEventQueue myQueue;
    private final EdtAlarm myFocusedComponentAlarm;
    private final EdtAlarm myForcedFocusRequestsAlarm;
    private final Set<FurtherRequestor> myValidFurtherRequestors = new HashSet<FurtherRequestor>();
    private final Set<ActionCallback> myTypeAheadRequestors = new HashSet<ActionCallback>();
    private boolean myTypeaheadEnabled = true;
    private final Map<IdeFrame, Component> myLastFocused = ContainerUtil.createWeakValueMap();
    private final Map<IdeFrame, Component> myLastFocusedAtDeactivation = ContainerUtil.createWeakValueMap();
    private DataContext myRunContext;
    private IdeFrame myLastFocusedFrame;

    public FocusManagerImpl(ServiceManagerImpl serviceManager, WindowManager wm, UiActivityMonitor monitor) {
        this.myApp = ApplicationManager.getApplication();
        this.myQueue = IdeEventQueue.getInstance();
        this.myFocusedComponentAlarm = new EdtAlarm();
        this.myForcedFocusRequestsAlarm = new EdtAlarm();
        AppListener myAppListener = new AppListener();
        this.myApp.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)myAppListener);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof FocusEvent) {
                FocusEvent fe = (FocusEvent)e;
                Component c = fe.getComponent();
                if (c instanceof Window || c == null) {
                    return false;
                }
                Component parent = UIUtil.findUltimateParent((Component)c);
                if (parent instanceof IdeFrame) {
                    this.myLastFocused.put((IdeFrame)parent, c);
                }
            } else if (e instanceof WindowEvent) {
                Window wnd = ((WindowEvent)e).getWindow();
                if (e.getID() == 202 && wnd instanceof IdeFrame) {
                    this.myLastFocused.remove(wnd);
                    this.myLastFocusedAtDeactivation.remove(wnd);
                }
            }
            return false;
        }, this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", evt -> {
            if (evt.getNewValue() instanceof IdeFrame) {
                this.myLastFocusedFrame = (IdeFrame)evt.getNewValue();
            }
        });
    }

    public IdeFrame getLastFocusedFrame() {
        return this.myLastFocusedFrame;
    }

    public ActionCallback requestFocusInProject(@NotNull Component c, @Nullable Project project) {
        if (ApplicationManager.getApplication().isActive() || !UIUtil.SUPPRESS_FOCUS_STEALING) {
            c.requestFocus();
        } else {
            c.requestFocusInWindow();
        }
        return ActionCallback.DONE;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        c.requestFocus();
        return ActionCallback.DONE;
    }

    @NotNull
    public List<FocusRequestInfo> getRequests() {
        return this.myRequests;
    }

    public void recordFocusRequest(Component c, boolean forced) {
        this.myRequests.add(new FocusRequestInfo(c, new Throwable(), forced));
        if (this.myRequests.size() > 200) {
            this.myRequests.remove(0);
        }
    }

    public static IdeFocusManager getInstance() {
        return (IdeFocusManager)ApplicationManager.getApplication().getComponent(IdeFocusManager.class);
    }

    public void dispose() {
        this.myForcedFocusRequestsAlarm.cancelAllRequests();
        this.myFocusedComponentAlarm.cancelAllRequests();
        for (FurtherRequestor requestor : this.myValidFurtherRequestors) {
            Disposer.dispose((Disposable)requestor);
        }
        this.myValidFurtherRequestors.clear();
    }

    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable2) {
        this.doWhenFocusSettlesDown((Runnable)runnable2);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2) {
        this.myQueue.executeWhenAllFocusEventsLeftTheQueue(runnable2);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2, @NotNull ModalityState modality) {
        AtomicBoolean immediate = new AtomicBoolean(true);
        this.doWhenFocusSettlesDown(() -> {
            if (immediate.get()) {
                if (!(runnable2 instanceof ExpirableRunnable) || !((ExpirableRunnable)runnable2).isExpired()) {
                    runnable2.run();
                }
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> this.doWhenFocusSettlesDown(runnable2, modality), modality);
        });
        immediate.set(false);
    }

    public void setTypeaheadEnabled(boolean enabled) {
        this.myTypeaheadEnabled = enabled;
    }

    private boolean isTypeaheadEnabled() {
        return Registry.is((String)"actionSystem.fixLostTyping") && this.myTypeaheadEnabled;
    }

    public void typeAheadUntil(@NotNull ActionCallback callback2, final @NotNull String cause) {
        ActionCallback done;
        if (!this.isTypeaheadEnabled()) {
            return;
        }
        final long currentTime = System.currentTimeMillis();
        if (!Registry.is((String)"type.ahead.logging.enabled")) {
            done = callback2;
        } else {
            String id = new Exception().getStackTrace()[2].getClassName();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:ss:SSS", Locale.US);
            LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tStarted:  " + id);
            done = new ActionCallback();
            callback2.doWhenDone(() -> {
                done.setDone();
                LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tDone:     " + id);
            });
            callback2.doWhenRejected(() -> {
                done.setRejected();
                LOG.info(dateFormat.format(System.currentTimeMillis()) + "\tRejected: " + id);
            });
        }
        FocusManagerImpl.assertDispatchThread();
        this.myTypeAheadRequestors.add(done);
        done.notify(new TimedOutCallback((long)Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Typeahead request blocked", (Throwable)new Exception(){

            @Override
            public String getMessage() {
                return "Time: " + (System.currentTimeMillis() - currentTime) + "; cause: " + cause + "; runnable waiting for the focus change: " + IdeEventQueue.getInstance().runnablesWaitingForFocusChangeState();
            }
        }, true).doWhenProcessed(() -> this.myTypeAheadRequestors.remove(done)));
    }

    public Component getFocusOwner() {
        FocusManagerImpl.assertDispatchThread();
        Component result2 = null;
        if (!ApplicationManager.getApplication().isActive()) {
            result2 = this.myLastFocusedAtDeactivation.get(this.getLastFocusedFrame());
        } else if (this.myRunContext != null) {
            result2 = (Component)this.myRunContext.getData(PlatformDataKeys.CONTEXT_COMPONENT.getName());
        }
        if (result2 == null) {
            result2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (result2 == null) {
            Component permOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (permOwner != null) {
                result2 = permOwner;
            }
            if (UIUtil.isMeaninglessFocusOwner((Component)result2)) {
                result2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            }
        }
        return result2;
    }

    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable2) {
        FocusManagerImpl.assertDispatchThread();
        this.myRunContext = context;
        try {
            runnable2.run();
        }
        finally {
            this.myRunContext = null;
        }
    }

    public Component getLastFocusedFor(IdeFrame frame) {
        FocusManagerImpl.assertDispatchThread();
        return this.myLastFocused.get(frame);
    }

    public void setLastFocusedAtDeactivation(@NotNull IdeFrame frame, @NotNull Component c) {
        this.myLastFocusedAtDeactivation.put(frame, c);
    }

    public void toFront(JComponent c) {
        FocusManagerImpl.assertDispatchThread();
        if (c == null) {
            return;
        }
        Window window = (Window)UIUtil.getParentOfType(Window.class, (Component)c);
        if (window != null && window.isShowing()) {
            this.doWhenFocusSettlesDown(() -> {
                if (ApplicationManager.getApplication().isActive()) {
                    if (window instanceof JFrame && ((JFrame)window).getState() == 1) {
                        ((JFrame)window).setState(0);
                    } else {
                        window.toFront();
                    }
                }
            });
        }
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(comp);
    }

    public Component getFocusedDescendantFor(Component comp) {
        Component focused = this.getFocusOwner();
        if (focused == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        List<JBPopup> popups = AbstractPopup.getChildPopups(comp);
        for (JBPopup each : popups) {
            if (!each.isFocused()) continue;
            return focused;
        }
        return null;
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        Component toFocus = null;
        if (this.myLastFocusedFrame != null) {
            toFocus = this.myLastFocused.get(this.myLastFocusedFrame);
            if (toFocus == null || !toFocus.isShowing()) {
                toFocus = this.getFocusTargetFor(this.myLastFocusedFrame.getComponent());
            }
        } else {
            Optional<Component> toFocusOptional = Arrays.stream(Window.getWindows()).filter(window -> window instanceof RootPaneContainer).filter(window -> ((RootPaneContainer)((Object)window)).getRootPane() != null).filter(window -> window.isActive()).findFirst().map(w -> this.getFocusTargetFor(((RootPaneContainer)((Object)w)).getRootPane()));
            if (toFocusOptional.isPresent()) {
                toFocus = toFocusOptional.get();
            }
        }
        if (toFocus != null) {
            if (ApplicationManager.getApplication().isActive() || !UIUtil.SUPPRESS_FOCUS_STEALING) {
                toFocus.requestFocus();
            } else {
                toFocus.requestFocusInWindow();
            }
            return ActionCallback.DONE;
        }
        return ActionCallback.DONE;
    }

    public boolean isFocusTransferEnabled() {
        if (Registry.is((String)"focus.fix.lost.cursor")) {
            return true;
        }
        return this.myApp.isActive() || !Registry.is((String)"actionSystem.suspendFocusTransferIfApplicationInactive");
    }

    private static void assertDispatchThread() {
        if (Registry.is((String)"actionSystem.assertFocusAccessFromEdt")) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
    }

    private class AppListener
    implements ApplicationActivationListener {
        private AppListener() {
        }

        public void delayedApplicationDeactivated(@NotNull IdeFrame ideFrame) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component parent = UIUtil.findUltimateParent((Component)owner);
            if (parent == ideFrame) {
                FocusManagerImpl.this.myLastFocusedAtDeactivation.put(ideFrame, owner);
            }
        }
    }

    static class EdtAlarm {
        private final Set<EdtRunnable> myRequests = new HashSet<EdtRunnable>();

        EdtAlarm() {
        }

        public void cancelAllRequests() {
            for (EdtRunnable each : this.myRequests) {
                each.expire();
            }
            this.myRequests.clear();
        }

        public void addRequest(@NotNull EdtRunnable runnable2, int delay) {
            this.myRequests.add(runnable2);
            EdtExecutorService.getScheduledExecutorInstance().schedule((Runnable)runnable2, (long)delay, TimeUnit.MILLISECONDS);
        }
    }

    private static class FurtherRequestor
    implements FocusRequestor {
        private final IdeFocusManager myManager;
        private final Expirable myExpirable;
        private Throwable myAllocation;
        private boolean myDisposed;

        private FurtherRequestor(@NotNull IdeFocusManager manager, @NotNull Expirable expirable) {
            this.myManager = manager;
            this.myExpirable = expirable;
            if (Registry.is((String)"ide.debugMode")) {
                this.myAllocation = new Exception();
            }
        }

        @NotNull
        public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
            ActionCallback result2 = this.isExpired() ? ActionCallback.REJECTED : this.myManager.requestFocus(c, forced);
            result2.doWhenProcessed(() -> Disposer.dispose((Disposable)this));
            return result2;
        }

        private boolean isExpired() {
            return this.myExpirable.isExpired() || this.myDisposed;
        }

        public void dispose() {
            this.myDisposed = true;
        }
    }
}

