/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenuBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeFrameDecorator
implements Disposable {
    protected IdeFrameImpl myFrame;

    protected IdeFrameDecorator(IdeFrameImpl frame) {
        this.myFrame = frame;
    }

    public abstract boolean isInFullScreen();

    public abstract ActionCallback toggleFullScreen(boolean var1);

    public void dispose() {
        this.myFrame = null;
    }

    @Nullable
    public static IdeFrameDecorator decorate(@NotNull IdeFrameImpl frame) {
        if (SystemInfo.isMac) {
            return new MacMainFrameDecorator(frame, PlatformUtils.isAppCode());
        }
        if (SystemInfo.isWindows) {
            return new WinMainFrameDecorator(frame);
        }
        if (SystemInfo.isXWindow && X11UiUtil.isFullScreenSupported()) {
            return new EWMHFrameDecorator(frame);
        }
        return null;
    }

    protected void notifyFrameComponents(boolean state) {
        if (this.myFrame != null) {
            this.myFrame.getRootPane().putClientProperty("ide.frame.full.screen", state);
            JMenuBar menuBar = this.myFrame.getJMenuBar();
            if (menuBar != null) {
                menuBar.putClientProperty("ide.frame.full.screen", state);
            }
        }
    }

    public static boolean isCustomDecorationActive() {
        return SystemInfo.isWindows && Registry.is((String)"ide.win.frame.decoration") && JdkEx.isCustomDecorationSupported();
    }

    private static class EWMHFrameDecorator
    extends IdeFrameDecorator {
        private Boolean myRequestedState = null;

        private EWMHFrameDecorator(final IdeFrameImpl frame) {
            super(frame);
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (myRequestedState != null) {
                        this.notifyFrameComponents(myRequestedState);
                        myRequestedState = null;
                    }
                }
            });
            if (SystemInfo.isKDE && UIUtil.SUPPRESS_FOCUS_STEALING) {
                final WindowAdapter deiconifyListener = new WindowAdapter(){

                    @Override
                    public void windowDeiconified(WindowEvent event) {
                        frame.toFront();
                    }
                };
                frame.addWindowListener(deiconifyListener);
                Disposer.register((Disposable)this, (Disposable)new Disposable(){

                    public void dispose() {
                        frame.removeWindowListener(deiconifyListener);
                    }
                });
            }
        }

        @Override
        public boolean isInFullScreen() {
            return this.myFrame != null && X11UiUtil.isInFullScreenMode(this.myFrame);
        }

        @Override
        public ActionCallback toggleFullScreen(boolean state) {
            if (this.myFrame != null) {
                this.myRequestedState = state;
                X11UiUtil.toggleFullScreenMode(this.myFrame);
                if (this.myFrame.getJMenuBar() instanceof IdeMenuBar) {
                    IdeMenuBar frameMenuBar = (IdeMenuBar)this.myFrame.getJMenuBar();
                    frameMenuBar.onToggleFullScreen(state);
                }
            }
            return ActionCallback.DONE;
        }
    }

    private static class WinMainFrameDecorator
    extends IdeFrameDecorator {
        private WinMainFrameDecorator(@NotNull IdeFrameImpl frame) {
            super(frame);
        }

        @Override
        public boolean isInFullScreen() {
            if (this.myFrame == null) {
                return false;
            }
            if (UIUtil.isWindowClientPropertyTrue((Window)this.myFrame, (Object)"ide.frame.full.screen")) {
                return true;
            }
            Rectangle frameBounds = this.myFrame.getBounds();
            GraphicsDevice device = ScreenUtil.getScreenDevice((Rectangle)frameBounds);
            return device != null && device.getDefaultConfiguration().getBounds().equals(frameBounds) && this.myFrame.isUndecorated();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActionCallback toggleFullScreen(boolean state) {
            GraphicsDevice device;
            if (this.myFrame == null) {
                return ActionCallback.REJECTED;
            }
            Rectangle bounds2 = this.myFrame.getBounds();
            int extendedState = this.myFrame.getExtendedState();
            if (state && extendedState == 0) {
                this.myFrame.getRootPane().putClientProperty("normalBounds", bounds2);
            }
            if ((device = ScreenUtil.getScreenDevice((Rectangle)bounds2)) == null) {
                return ActionCallback.REJECTED;
            }
            Rectangle defaultBounds = device.getDefaultConfiguration().getBounds();
            try {
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", Boolean.TRUE);
                this.myFrame.dispose();
                this.myFrame.setUndecorated(state);
            }
            finally {
                if (state) {
                    this.myFrame.setBounds(defaultBounds);
                } else {
                    Object o = this.myFrame.getRootPane().getClientProperty("normalBounds");
                    if (o instanceof Rectangle) {
                        this.myFrame.setBounds((Rectangle)o);
                    }
                }
                this.myFrame.setVisible(true);
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", null);
                if (!state && (extendedState & 6) != 0) {
                    this.myFrame.setExtendedState(extendedState);
                }
                this.notifyFrameComponents(state);
            }
            return ActionCallback.DONE;
        }
    }
}

