/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.impl.ShadowPainter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.win32.WindowsElevationUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.CloseProjectWindowHelper;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.Windows;
import com.intellij.openapi.wm.impl.status.ColumnSelectionModePanel;
import com.intellij.openapi.wm.impl.status.EncodingPanel;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.openapi.wm.impl.status.PositionPanel;
import com.intellij.openapi.wm.impl.status.ToggleReadOnlyAttributePanel;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeFrameImpl
extends JFrame
implements IdeFrameEx,
AccessibleContextAccessor,
DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.IdeFrameImpl");
    public static final String NORMAL_STATE_BOUNDS = "normalBounds";
    public static final Key<Boolean> SHOULD_OPEN_IN_FULL_SCREEN = Key.create((String)"should.open.in.full.screen");
    private static boolean ourUpdatingTitle;
    private String myTitle;
    private String myFileTitle;
    private File myCurrentFile;
    private Project myProject;
    private IdeRootPane myRootPane;
    private BalloonLayout myBalloonLayout;
    private IdeFrameDecorator myFrameDecorator;
    private boolean myRestoreFullScreen;
    private final LafManagerListener myLafListener;
    private final ComponentListener resizedListener;
    private final Set<String> widgetIDs = ContainerUtil.newHashSet();
    private static final ShadowPainter ourShadowPainter;

    public IdeFrameImpl(ActionManagerEx actionManager, DataManager dataManager) {
        super(ApplicationNamesInfo.getInstance().getFullProductName());
        this.myRootPane = this.createRootPane(actionManager, dataManager);
        this.setRootPane(this.myRootPane);
        this.setBackground(UIUtil.getPanelBackground());
        this.myLafListener = src -> this.setBackground(UIUtil.getPanelBackground());
        LafManager.getInstance().addLafManagerListener(this.myLafListener);
        AppUIUtil.updateWindowIcon(this);
        this.resizedListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (IdeFrameImpl.this.getExtendedState() == 0) {
                    IdeFrameImpl.this.getRootPane().putClientProperty(IdeFrameImpl.NORMAL_STATE_BOUNDS, IdeFrameImpl.this.getBounds());
                }
            }
        };
        this.myRootPane.addComponentListener(this.resizedListener);
        Dimension size = ScreenUtil.getMainScreenBounds().getSize();
        size.width = Math.min(1400, size.width - 20);
        size.height = Math.min(1000, size.height - 40);
        this.setSize(size);
        this.setLocationRelativeTo(null);
        this.setMinimumSize(new Dimension(340, this.getMinimumSize().height));
        if (UIUtil.SUPPRESS_FOCUS_STEALING && Registry.is((String)"suppress.focus.stealing.auto.request.focus") && !ApplicationManagerEx.getApplicationEx().isActive()) {
            this.setAutoRequestFocus(false);
        }
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt(){

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                JComponent component;
                EditorWithProviderComposite editor;
                EditorWindow window;
                FileEditorManagerEx fileEditorManagerEx;
                if (IdeFrameImpl.this.myProject != null && (fileEditorManagerEx = FileEditorManagerEx.getInstanceEx(IdeFrameImpl.this.myProject)) != null && (window = fileEditorManagerEx.getCurrentWindow()) != null && (editor = window.getSelectedEditor()) != null && (component = editor.getPreferredFocusedComponent()) != null) {
                    return component;
                }
                return super.getComponentAfter(focusCycleRoot, aComponent);
            }
        });
        this.setupCloseAction();
        MnemonicHelper.init((Component)this);
        this.myBalloonLayout = new BalloonLayoutImpl(this.myRootPane, (Insets)JBUI.insets((int)8));
        if (SystemInfo.isMac) {
            this.setIconImage(null);
        }
        MouseGestureManager.getInstance().add(this);
        this.myFrameDecorator = IdeFrameDecorator.decorate(this);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt(){

            @Override
            protected Component getDefaultComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getDefaultComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getFirstComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getFirstComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getLastComponentImpl(Container focusCycleRoot) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getLastComponentImpl(focusCycleRoot) : component;
            }

            @Override
            protected Component getComponentAfterImpl(Container focusCycleRoot, Component aComponent) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getComponentAfterImpl(focusCycleRoot, aComponent) : component;
            }

            @Override
            public Component getInitialComponent(Window window) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getInitialComponent(window) : component;
            }

            @Override
            protected Component getComponentBeforeImpl(Container focusCycleRoot, Component aComponent) {
                Component component = IdeFrameImpl.this.findNextFocusComponent();
                return component == null ? super.getComponentBeforeImpl(focusCycleRoot, aComponent) : component;
            }
        });
    }

    private Component findNextFocusComponent() {
        if (this.myProject != null) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(this.myProject);
            if (focusOwner instanceof EditorComponentImpl && !Windows.ToolWindowProvider.isInToolWindow(focusOwner)) {
                String toolWindowId = toolWindowManagerEx.getLastActiveToolWindowId();
                ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(toolWindowId);
                if (toolWindow != null) {
                    return toolWindow.getComponent().getFocusTraversalPolicy().getDefaultComponent(toolWindow.getComponent());
                }
            } else {
                JComponent preferredFocusedComponent;
                EditorWithProviderComposite selectedEditor;
                EditorWindow currentWindow = FileEditorManagerEx.getInstanceEx(this.myProject).getSplitters().getCurrentWindow();
                if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && (preferredFocusedComponent = selectedEditor.getPreferredFocusedComponent()) != null) {
                    return preferredFocusedComponent;
                }
            }
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @NotNull
    private IdeRootPane createRootPane(ActionManagerEx actionManager, DataManager dataManager) {
        return new IdeRootPane(actionManager, dataManager, this);
    }

    @Override
    @NotNull
    public Insets getInsets() {
        return SystemInfo.isMac && this.isInFullScreen() ? JBUI.emptyInsets() : super.getInsets();
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    @Nullable
    public static Window getActiveFrame() {
        for (Frame frame : IdeFrameImpl.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    @Override
    public void show() {
        super.show();
        SwingUtilities.invokeLater(() -> this.setFocusableWindowState(true));
    }

    @Override
    public synchronized void setMaximizedBounds(Rectangle bounds2) {
        super.setMaximizedBounds(null);
    }

    @Override
    public void setExtendedState(int state) {
        if (this.getExtendedState() == 0 && (state & 6) != 0) {
            this.getRootPane().putClientProperty(NORMAL_STATE_BOUNDS, this.getBounds());
        }
        super.setExtendedState(state);
    }

    private void setupCloseAction() {
        this.setDefaultCloseOperation(0);
        final CloseProjectWindowHelper helper = new CloseProjectWindowHelper();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(@NotNull WindowEvent e) {
                if (!IdeFrameImpl.this.isTemporaryDisposed()) {
                    helper.windowClosing(IdeFrameImpl.this.myProject);
                }
            }
        });
    }

    public StatusBar getStatusBar() {
        return this.myRootPane == null ? null : this.myRootPane.getStatusBar();
    }

    @Override
    public void setTitle(String title) {
        if (ourUpdatingTitle) {
            super.setTitle(title);
        } else {
            this.myTitle = title;
        }
        this.updateTitle();
    }

    public void setFrameTitle(String text) {
        super.setTitle(text);
    }

    public void setFileTitle(@Nullable String fileTitle, @Nullable File file2) {
        this.myFileTitle = fileTitle;
        this.myCurrentFile = file2;
        this.updateTitle();
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return this.myRootPane.findByName(key);
    }

    private void updateTitle() {
        IdeFrameImpl.updateTitle(this, this.myTitle, this.myFileTitle, this.myCurrentFile);
    }

    public static String getElevationSuffix() {
        return WindowsElevationUtil.isUnderElevation() ? " (Administrator)" : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTitle(@NotNull JFrame frame, @Nullable String title, @Nullable String fileTitle, @Nullable File currentFile) {
        if (ourUpdatingTitle) {
            return;
        }
        try {
            ourUpdatingTitle = true;
            if (IdeFrameDecorator.isCustomDecorationActive()) {
                frame.getRootPane().putClientProperty("Window.CustomDecoration.documentFile", currentFile);
            }
            if (Registry.is((String)"ide.show.fileType.icon.in.titleBar")) {
                frame.getRootPane().putClientProperty("Window.documentFile", currentFile);
            }
            Builder builder2 = new Builder().append(title).append(fileTitle);
            if (Boolean.getBoolean("ide.ui.version.in.title")) {
                builder2.append(ApplicationNamesInfo.getInstance().getFullProductName() + ' ' + ApplicationInfo.getInstance().getFullVersion() + IdeFrameImpl.getElevationSuffix());
            } else if (!SystemInfo.isMac || builder2.isEmpty()) {
                builder2.append(ApplicationNamesInfo.getInstance().getFullProductName() + IdeFrameImpl.getElevationSuffix());
            }
            frame.setTitle(builder2.toString());
        }
        finally {
            ourUpdatingTitle = false;
        }
    }

    public void updateView() {
        ((IdeRootPane)this.getRootPane()).updateToolbar();
        ((IdeRootPane)this.getRootPane()).updateMainMenuActions();
        ((IdeRootPane)this.getRootPane()).updateNorthComponents();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    public Object getData(@NotNull String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId) && this.myProject != null) {
            return this.myProject.isInitialized() ? this.myProject : null;
        }
        if (IdeFrame.KEY.getName().equals(dataId)) {
            return this;
        }
        return null;
    }

    public void setProject(@Nullable Project project) {
        if (this.myProject == project) {
            return;
        }
        this.myProject = project;
        if (project != null) {
            if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS()) {
                boolean bl = this.myRestoreFullScreen = SHOULD_OPEN_IN_FULL_SCREEN.get((UserDataHolder)project) == Boolean.TRUE || ProjectFrameBounds.getInstance(project).isInFullScreen();
                if (!this.myRestoreFullScreen && PropertiesComponent.getInstance((Project)project).getBoolean("FullScreen")) {
                    this.myRestoreFullScreen = true;
                    PropertiesComponent.getInstance((Project)project).unsetValue("FullScreen");
                }
            }
            if (this.myRootPane != null) {
                this.myRootPane.installNorthComponents(project);
                StatusBar statusBar = this.myRootPane.getStatusBar();
                if (statusBar != null) {
                    project.getMessageBus().connect().subscribe(StatusBar.Info.TOPIC, (Object)statusBar);
                }
            }
            this.installDefaultProjectStatusBarWidgets(this.myProject);
        } else if (this.myRootPane != null) {
            this.myRootPane.deinstallNorthComponents();
        }
        if (this.myRestoreFullScreen && this.isVisible()) {
            this.toggleFullScreen(true);
            this.myRestoreFullScreen = false;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this.myRestoreFullScreen) {
            SwingUtilities.invokeLater(() -> {
                this.toggleFullScreen(true);
                if (SystemInfo.isMacOSLion) {
                    this.setBounds(ScreenUtil.getScreenRectangle((Point)this.getLocationOnScreen()));
                }
                this.myRestoreFullScreen = false;
            });
        }
    }

    private void addWidget(StatusBar statusBar, StatusBarWidget widget, String anchor2) {
        if (!this.widgetIDs.add(widget.ID())) {
            LOG.error("Attempting to add more than one widget with ID: " + widget.ID());
            return;
        }
        statusBar.addWidget(widget, anchor2);
    }

    private void installDefaultProjectStatusBarWidgets(@NotNull Project project) {
        StatusBar statusBar = this.getStatusBar();
        this.addWidget(statusBar, new PositionPanel(project), StatusBar.Anchors.before((String)"FatalError"));
        this.addWidget(statusBar, (StatusBarWidget)new IdeNotificationArea(), StatusBar.Anchors.before((String)"FatalError"));
        this.addWidget(statusBar, new EncodingPanel(project), StatusBar.Anchors.after((String)"Position"));
        this.addWidget(statusBar, new LineSeparatorPanel(project), StatusBar.Anchors.before((String)"Encoding"));
        this.addWidget(statusBar, new ColumnSelectionModePanel(project), StatusBar.Anchors.after((String)"Encoding"));
        this.addWidget(statusBar, (StatusBarWidget)new ToggleReadOnlyAttributePanel(project), StatusBar.Anchors.after((String)"InsertOverwrite"));
        for (StatusBarWidgetProvider widgetProvider : (StatusBarWidgetProvider[])StatusBarWidgetProvider.EP_NAME.getExtensions()) {
            StatusBarWidget widget = widgetProvider.getWidget(project);
            if (widget == null) continue;
            this.addWidget(statusBar, widget, widgetProvider.getAnchor());
        }
        Disposer.register((Disposable)project, () -> {
            for (String widgetID : this.widgetIDs) {
                statusBar.removeWidget(widgetID);
            }
            this.widgetIDs.clear();
            ((StatusBarEx)statusBar).removeCustomIndicationComponents();
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void dispose() {
        if (SystemInfo.isMac && this.isInFullScreen()) {
            ((MacMainFrameDecorator)this.myFrameDecorator).toggleFullScreenNow();
        }
        if (this.isTemporaryDisposed()) {
            super.dispose();
            return;
        }
        MouseGestureManager.getInstance().remove(this);
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        if (this.myRootPane != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.myRootPane.removeNotify();
            }
            this.myRootPane.removeComponentListener(this.resizedListener);
            this.setRootPane(new JRootPane());
            Disposer.dispose((Disposable)this.myRootPane);
            this.myRootPane = null;
        }
        if (this.myFrameDecorator != null) {
            Disposer.dispose((Disposable)this.myFrameDecorator);
            this.myFrameDecorator = null;
        }
        if (this.myLafListener != null) {
            LafManager.getInstance().removeLafManagerListener(this.myLafListener);
        }
        super.dispose();
    }

    private boolean isTemporaryDisposed() {
        return this.myRootPane != null && this.myRootPane.getClientProperty("dispose.temporary") != null;
    }

    public void storeFullScreenStateIfNeeded() {
        if (this.myProject != null) {
            this.doLayout();
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        UISettings.setupAntialiasing((Graphics)g);
        super.paint(g);
    }

    public Rectangle suggestChildFrameBounds() {
        Rectangle b = this.getBounds();
        b.x += 100;
        b.width -= 200;
        b.y += 100;
        b.height -= 200;
        return b;
    }

    public final BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @Override
    public boolean isInFullScreen() {
        return this.myFrameDecorator != null && this.myFrameDecorator.isInFullScreen();
    }

    @Override
    @NotNull
    public ActionCallback toggleFullScreen(boolean state) {
        if (this.temporaryFixForIdea156004(state)) {
            return ActionCallback.DONE;
        }
        if (this.myFrameDecorator != null) {
            return this.myFrameDecorator.toggleFullScreen(state);
        }
        return ActionCallback.DONE;
    }

    private boolean temporaryFixForIdea156004(boolean state) {
        if (SystemInfo.isMac) {
            try {
                Field modalBlockerField = Window.class.getDeclaredField("modalBlocker");
                modalBlockerField.setAccessible(true);
                Window modalBlocker = (Window)modalBlockerField.get(this);
                if (modalBlocker != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.toggleFullScreen(state), ModalityState.NON_MODAL);
                    return true;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIdeFrameImpl();
        }
        return this.accessibleContext;
    }

    static {
        ourShadowPainter = new ShadowPainter(AllIcons.Ide.Shadow.Top, AllIcons.Ide.Shadow.TopRight, AllIcons.Ide.Shadow.Right, AllIcons.Ide.Shadow.BottomRight, AllIcons.Ide.Shadow.Bottom, AllIcons.Ide.Shadow.BottomLeft, AllIcons.Ide.Shadow.Left, AllIcons.Ide.Shadow.TopLeft);
    }

    protected class AccessibleIdeFrameImpl
    extends JFrame.AccessibleJFrame {
        protected AccessibleIdeFrameImpl() {
            super(IdeFrameImpl.this);
        }

        @Override
        public String getAccessibleName() {
            StringBuilder builder2 = new StringBuilder();
            if (IdeFrameImpl.this.myProject != null) {
                builder2.append(IdeFrameImpl.this.myProject.getName());
                builder2.append(" - ");
            }
            builder2.append(ApplicationNamesInfo.getInstance().getFullProductName());
            return builder2.toString();
        }
    }

    private static final class Builder {
        private final StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        public Builder append(@Nullable String s) {
            if (!StringUtil.isEmptyOrSpaces((String)s)) {
                if (this.sb.length() > 0) {
                    this.sb.append(" - ");
                }
                this.sb.append(s);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.sb.length() == 0;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

