/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.ResizeToolWindowAction;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.actions.ToolWindowMoveAction;
import com.intellij.ide.actions.ToolWindowViewModeAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalDecorator
extends JPanel
implements Queryable,
DataProvider {
    private Project myProject;
    private WindowInfoImpl myInfo;
    private final ToolWindowImpl myToolWindow;
    private final MyDivider myDivider;
    private final EventDispatcher<InternalDecoratorListener> myDispatcher = EventDispatcher.create(InternalDecoratorListener.class);
    private final ToggleContentUiTypeAction myToggleContentUiTypeAction;
    private final RemoveStripeButtonAction myRemoveFromSideBarAction;
    private ActionGroup myAdditionalGearActions;
    @NonNls
    static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";
    @Deprecated
    @NonNls
    public static final String TOGGLE_PINNED_MODE_ACTION_ID = "TogglePinnedMode";
    @Deprecated
    @NonNls
    public static final String TOGGLE_DOCK_MODE_ACTION_ID = "ToggleDockMode";
    @Deprecated
    @NonNls
    public static final String TOGGLE_FLOATING_MODE_ACTION_ID = "ToggleFloatingMode";
    @Deprecated
    @NonNls
    public static final String TOGGLE_WINDOWED_MODE_ACTION_ID = "ToggleWindowedMode";
    @Deprecated
    @NonNls
    public static final String TOGGLE_SIDE_MODE_ACTION_ID = "ToggleSideMode";
    @NonNls
    private static final String TOGGLE_CONTENT_UI_TYPE_ACTION_ID = "ToggleContentUiTypeMode";
    private ToolWindowHeader myHeader;
    private final ActionGroup myToggleToolbarGroup;

    InternalDecorator(Project project, @NotNull WindowInfoImpl info, ToolWindowImpl toolWindow, boolean dumbAware) {
        super(new BorderLayout());
        this.myProject = project;
        this.myToolWindow = toolWindow;
        this.myToolWindow.setDecorator(this);
        this.myDivider = new MyDivider();
        this.myToggleContentUiTypeAction = new ToggleContentUiTypeAction();
        this.myRemoveFromSideBarAction = new RemoveStripeButtonAction();
        this.myToggleToolbarGroup = ToggleToolbarAction.createToggleToolbarGroup(this.myProject, this.myToolWindow);
        if (!ToolWindowId.PREVIEW.equals(info.getId())) {
            ((DefaultActionGroup)this.myToggleToolbarGroup).addAction((AnAction)this.myToggleContentUiTypeAction);
        }
        this.setFocusable(false);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myHeader = new ToolWindowHeader(toolWindow, () -> this.createPopupGroup(true)){

            @Override
            protected boolean isActive() {
                return InternalDecorator.this.myToolWindow.isActive();
            }

            @Override
            protected void hideToolWindow() {
                InternalDecorator.this.fireHidden();
            }
        };
        this.init(dumbAware);
        this.apply(info);
    }

    @Override
    public String toString() {
        return this.myToolWindow.getId();
    }

    public boolean isFocused() {
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component component = fm.getFocusedDescendantFor((Component)this.myToolWindow.getComponent());
        if (component != null) {
            return true;
        }
        Component owner = fm.getLastFocusedFor(WindowManager.getInstance().getIdeFrame(this.myProject));
        return owner != null && SwingUtilities.isDescendingFrom(owner, this.myToolWindow.getComponent());
    }

    public final void apply(@NotNull WindowInfoImpl info) {
        FloatingDecorator floatingDecorator;
        if (Comparing.equal((Object)this.myInfo, (Object)info) || this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        this.myInfo = info;
        ToolWindowAnchor anchor2 = this.myInfo.getAnchor();
        if (info.isSliding()) {
            this.myDivider.invalidate();
            if (ToolWindowAnchor.TOP == anchor2) {
                this.add((Component)this.myDivider, "South");
            } else if (ToolWindowAnchor.LEFT == anchor2) {
                this.add((Component)this.myDivider, "East");
            } else if (ToolWindowAnchor.BOTTOM == anchor2) {
                this.add((Component)this.myDivider, "North");
            } else if (ToolWindowAnchor.RIGHT == anchor2) {
                this.add((Component)this.myDivider, "West");
            }
            this.myDivider.setPreferredSize(new Dimension(0, 0));
        } else {
            this.remove(this.myDivider);
        }
        this.validate();
        this.repaint();
        if (this.myInfo.isFloating() && this.myInfo.isVisible() && (floatingDecorator = (FloatingDecorator)SwingUtilities.getAncestorOfClass(FloatingDecorator.class, this)) != null) {
            floatingDecorator.apply(this.myInfo);
        }
        this.myToolWindow.getContentUI().setType(this.myInfo.getContentUiType());
        this.setBorder(new InnerPanelBorder(this.myToolWindow));
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.myToolWindow;
        }
        return null;
    }

    final void addInternalDecoratorListener(InternalDecoratorListener l) {
        this.myDispatcher.addListener((EventListener)l);
    }

    final void removeInternalDecoratorListener(InternalDecoratorListener l) {
        this.myDispatcher.removeListener((EventListener)l);
    }

    final void dispose() {
        this.removeAll();
        Disposer.dispose((Disposable)this.myHeader);
        this.myHeader = null;
        this.myProject = null;
    }

    final void fireHidden() {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).hidden(this);
    }

    final void fireHiddenSide() {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).hiddenSide(this);
    }

    final void fireActivated() {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).activated(this);
    }

    final void fireResized() {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).resized(this);
    }

    private void fireContentUiTypeChanges(@NotNull ToolWindowContentUiType type) {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).contentUiTypeChanges(this, type);
    }

    private void fireVisibleOnPanelChanged(boolean visibleOnPanel) {
        ((InternalDecoratorListener)this.myDispatcher.getMulticaster()).visibleStripeButtonChanged(this, visibleOnPanel);
    }

    private void init(boolean dumbAware) {
        this.enableEvents(1L);
        JPanel contentPane = new JPanel(new BorderLayout());
        InternalDecorator.installFocusTraversalPolicy(contentPane, new LayoutFocusTraversalPolicy());
        contentPane.add((Component)this.myHeader, "North");
        JPanel innerPanel = new JPanel(new BorderLayout());
        JComponent toolWindowComponent = this.myToolWindow.getComponent();
        if (!dumbAware) {
            toolWindowComponent = DumbService.getInstance((Project)this.myProject).wrapGently(toolWindowComponent, (Disposable)this.myProject);
        }
        innerPanel.add((Component)toolWindowComponent, "Center");
        NonOpaquePanel inner = new NonOpaquePanel((JComponent)innerPanel);
        contentPane.add((Component)inner, "Center");
        this.add((Component)contentPane, "Center");
        if (SystemInfo.isMac) {
            this.setBackground((Color)new JBColor((Color)Gray._200, (Color)Gray._90));
        }
        AncestorListener ancestorListener = new AncestorListener(){
            private static final String FOCUS_EDITOR_ACTION_KEY = "FOCUS_EDITOR_ACTION_KEY";

            @Override
            public void ancestorAdded(AncestorEvent event) {
                this.registerEscapeAction();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            private void registerEscapeAction() {
                InternalDecorator.this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), FOCUS_EDITOR_ACTION_KEY);
                InternalDecorator.this.getActionMap().put(FOCUS_EDITOR_ACTION_KEY, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ToolWindowManager.getInstance((Project)InternalDecorator.this.myProject).activateEditorComponent();
                    }
                });
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        };
        this.addAncestorListener(ancestorListener);
        Disposer.register((Disposable)this.myHeader, () -> this.removeAncestorListener(ancestorListener));
    }

    public void setTitleActions(@NotNull AnAction[] actions) {
        this.myHeader.setAdditionalTitleActions(actions);
    }

    void setTabActions(@NotNull AnAction[] actions) {
        this.myHeader.setTabActions(actions);
    }

    @NotNull
    final ActionGroup createPopupGroup() {
        return this.createPopupGroup(false);
    }

    @NotNull
    private ActionGroup createPopupGroup(boolean skipHideAction) {
        GearActionGroup group = new GearActionGroup();
        if (this.myInfo == null) {
            return group;
        }
        if (!skipHideAction) {
            group.addSeparator();
            group.add(new HideAction());
        }
        group.addSeparator();
        group.add((AnAction)new ContextHelpAction(){

            @Nullable
            protected String getHelpId(DataContext dataContext) {
                String helpId;
                Content content = InternalDecorator.this.myToolWindow.getContentManager().getSelectedContent();
                if (content != null && (helpId = content.getHelpId()) != null) {
                    return helpId;
                }
                String id = InternalDecorator.this.myToolWindow.getHelpId();
                if (id != null) {
                    return id;
                }
                DataContext context = content != null ? DataManager.getInstance().getDataContext((Component)content.getComponent()) : dataContext;
                return super.getHelpId(context);
            }

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabledAndVisible(this.getHelpId(e.getDataContext()) != null);
            }
        });
        return group;
    }

    @NotNull
    private DefaultActionGroup createResizeActionGroup() {
        DefaultActionGroup resize = new DefaultActionGroup(ActionsBundle.groupText((String)"ResizeToolWindowGroup"), true){

            public boolean isDumbAware() {
                return true;
            }
        };
        resize.add((AnAction)new ResizeToolWindowAction.Left(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Right(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Up(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Down(this.myToolWindow, this));
        resize.add(ActionManager.getInstance().getAction("MaximizeToolWindow"));
        return resize;
    }

    private static void addSorted(DefaultActionGroup main, ActionGroup group) {
        AnAction[] children2 = group.getChildren(null);
        boolean hadSecondary = false;
        for (AnAction action : children2) {
            if (group.isPrimary(action)) {
                main.add(action);
                continue;
            }
            hadSecondary = true;
        }
        if (hadSecondary) {
            main.addSeparator();
            for (AnAction action : children2) {
                if (group.isPrimary(action)) continue;
                main.addAction(action).setAsSecondary(true);
            }
        }
        String separatorText = group.getTemplatePresentation().getText();
        if (children2.length > 0 && !StringUtil.isEmpty((String)separatorText)) {
            main.addAction((AnAction)new Separator(separatorText), Constraints.FIRST);
        }
    }

    final ToolWindowImpl getToolWindow() {
        return this.myToolWindow;
    }

    @NotNull
    final WindowInfoImpl getWindowInfo() {
        return this.myInfo;
    }

    public int getHeaderHeight() {
        return this.myHeader.getPreferredSize().height;
    }

    public void setHeaderVisible(boolean value) {
        this.myHeader.setVisible(value);
    }

    @Override
    protected final void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if (101 == e.getID()) {
            this.fireResized();
        }
    }

    void removeStripeButton() {
        this.fireVisibleOnPanelChanged(false);
        this.fireHidden();
    }

    void showStripeButton() {
        this.fireVisibleOnPanelChanged(true);
        this.fireActivated();
    }

    public void putInfo(@NotNull Map<String, String> info) {
        info.put("toolWindowTitle", this.myToolWindow.getTitle());
        Content selection = this.myToolWindow.getContentManager().getSelectedContent();
        if (selection != null) {
            info.put("toolWindowTab", selection.getTabName());
        }
    }

    public void setAdditionalGearActions(@Nullable ActionGroup additionalGearActions) {
        this.myAdditionalGearActions = additionalGearActions;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleInternalDecorator();
        }
        return this.accessibleContext;
    }

    static void installFocusTraversalPolicy(@NotNull Container container, @NotNull FocusTraversalPolicy policy) {
        container.setFocusCycleRoot(true);
        container.setFocusTraversalPolicyProvider(true);
        container.setFocusTraversalPolicy(policy);
        InternalDecorator.installDefaultFocusTraversalKeys(container, 0);
        InternalDecorator.installDefaultFocusTraversalKeys(container, 1);
    }

    private static void installDefaultFocusTraversalKeys(@NotNull Container container, int id) {
        container.setFocusTraversalKeys(id, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id));
    }

    protected class AccessibleInternalDecorator
    extends JPanel.AccessibleJPanel {
        protected AccessibleInternalDecorator() {
            super(InternalDecorator.this);
        }

        @Override
        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (name == null) {
                String title = StringUtil.defaultIfEmpty((String)InternalDecorator.this.myToolWindow.getTitle(), (String)InternalDecorator.this.myToolWindow.getStripeTitle());
                title = StringUtil.defaultIfEmpty((String)title, (String)InternalDecorator.this.myToolWindow.getId());
                name = StringUtil.notNullize((String)title) + " Tool Window";
            }
            return name;
        }
    }

    private final class MyDivider
    extends JPanel {
        private boolean myDragging;
        private Point myLastPoint;
        private Disposable myDisposable;
        private IdeGlassPane myGlassPane;
        private final MouseAdapter myListener = new MyMouseAdapter();

        private MyDivider() {
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.myGlassPane = IdeGlassPaneUtil.find((Component)this);
            this.myDisposable = Disposer.newDisposable();
            this.myGlassPane.addMouseMotionPreprocessor((MouseMotionListener)this.myListener, this.myDisposable);
            this.myGlassPane.addMousePreprocessor((MouseListener)this.myListener, this.myDisposable);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this.myDisposable != null && !Disposer.isDisposed((Disposable)this.myDisposable)) {
                Disposer.dispose((Disposable)this.myDisposable);
            }
        }

        boolean isInDragZone(MouseEvent e) {
            Point p = SwingUtilities.convertMouseEvent(e.getComponent(), e, this).getPoint();
            return Math.abs(InternalDecorator.this.myInfo.getAnchor().isHorizontal() ? p.y : p.x) < 6;
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            boolean isVerticalCursor = InternalDecorator.this.myInfo.isDocked() ? InternalDecorator.this.myInfo.getAnchor().isSplitVertically() : InternalDecorator.this.myInfo.getAnchor().isHorizontal();
            return isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11);
        }

        private class MyMouseAdapter
        extends MouseAdapter {
            private MyMouseAdapter() {
            }

            private void updateCursor(MouseEvent e) {
                if (MyDivider.this.isInDragZone(e)) {
                    MyDivider.this.myGlassPane.setCursor(MyDivider.this.getCursor(), (Object)MyDivider.this);
                    e.consume();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MyDivider.this.myDragging = MyDivider.this.isInDragZone(e);
                this.updateCursor(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.updateCursor(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.updateCursor(e);
                MyDivider.this.myDragging = false;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateCursor(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!MyDivider.this.myDragging) {
                    return;
                }
                MouseEvent event = SwingUtilities.convertMouseEvent(e.getComponent(), e, MyDivider.this);
                ToolWindowAnchor anchor2 = InternalDecorator.this.myInfo.getAnchor();
                Point point = event.getPoint();
                Container windowPane = InternalDecorator.this.getParent();
                MyDivider.this.myLastPoint = SwingUtilities.convertPoint(MyDivider.this, point, windowPane);
                ((MyDivider)MyDivider.this).myLastPoint.x = Math.min(Math.max(((MyDivider)MyDivider.this).myLastPoint.x, 0), windowPane.getWidth());
                ((MyDivider)MyDivider.this).myLastPoint.y = Math.min(Math.max(((MyDivider)MyDivider.this).myLastPoint.y, 0), windowPane.getHeight());
                Rectangle bounds2 = InternalDecorator.this.getBounds();
                if (anchor2 == ToolWindowAnchor.TOP) {
                    InternalDecorator.this.setBounds(0, 0, bounds2.width, ((MyDivider)MyDivider.this).myLastPoint.y);
                } else if (anchor2 == ToolWindowAnchor.LEFT) {
                    InternalDecorator.this.setBounds(0, 0, ((MyDivider)MyDivider.this).myLastPoint.x, bounds2.height);
                } else if (anchor2 == ToolWindowAnchor.BOTTOM) {
                    InternalDecorator.this.setBounds(0, ((MyDivider)MyDivider.this).myLastPoint.y, bounds2.width, windowPane.getHeight() - ((MyDivider)MyDivider.this).myLastPoint.y);
                } else if (anchor2 == ToolWindowAnchor.RIGHT) {
                    InternalDecorator.this.setBounds(((MyDivider)MyDivider.this).myLastPoint.x, 0, windowPane.getWidth() - ((MyDivider)MyDivider.this).myLastPoint.x, bounds2.height);
                }
                InternalDecorator.this.validate();
                e.consume();
            }
        }
    }

    private final class ToggleContentUiTypeAction
    extends ToggleAction
    implements DumbAware {
        private boolean myHadSeveralContents;

        private ToggleContentUiTypeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_CONTENT_UI_TYPE_ACTION_ID));
        }

        public void update(@NotNull AnActionEvent e) {
            this.myHadSeveralContents = this.myHadSeveralContents || InternalDecorator.this.myToolWindow.getContentManager().getContentCount() > 1;
            super.update(e);
            e.getPresentation().setVisible(this.myHadSeveralContents);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return InternalDecorator.this.myInfo.getContentUiType() == ToolWindowContentUiType.COMBO;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            InternalDecorator.this.fireContentUiTypeChanges(state ? ToolWindowContentUiType.COMBO : ToolWindowContentUiType.TABBED);
        }
    }

    private final class HideAction
    extends AnAction
    implements DumbAware {
        @NonNls
        static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";

        HideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideActiveWindow"));
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            InternalDecorator.this.fireHidden();
        }

        public final void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(InternalDecorator.this.myInfo.isVisible());
        }
    }

    private final class RemoveStripeButtonAction
    extends AnAction
    implements DumbAware {
        RemoveStripeButtonAction() {
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(ActionsBundle.message((String)"action.RemoveStripeButton.text", (Object[])new Object[0]));
            presentation.setDescription(ActionsBundle.message((String)"action.RemoveStripeButton.description", (Object[])new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(InternalDecorator.this.myInfo.isShowStripeButton());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            InternalDecorator.this.removeStripeButton();
        }
    }

    private class GearActionGroup
    extends DefaultActionGroup {
        GearActionGroup() {
            this.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
            this.getTemplatePresentation().setText("Show Options Menu");
            if (InternalDecorator.this.myInfo == null) {
                return;
            }
            if (InternalDecorator.this.myAdditionalGearActions != null) {
                if (InternalDecorator.this.myAdditionalGearActions.isPopup() && !StringUtil.isEmpty((String)InternalDecorator.this.myAdditionalGearActions.getTemplatePresentation().getText())) {
                    this.add((AnAction)InternalDecorator.this.myAdditionalGearActions);
                } else {
                    InternalDecorator.addSorted(this, InternalDecorator.this.myAdditionalGearActions);
                }
                this.addSeparator();
            }
            this.addAction((AnAction)InternalDecorator.this.myToggleToolbarGroup).setAsSecondary(true);
            this.addSeparator();
            this.add((AnAction)new ToolWindowViewModeAction.Group());
            this.add((AnAction)new ToolWindowMoveAction.Group());
            this.add((AnAction)InternalDecorator.this.createResizeActionGroup());
            this.addSeparator();
            this.add(InternalDecorator.this.myRemoveFromSideBarAction);
        }
    }

    private class InnerPanelBorder
    implements Border {
        private final ToolWindow myWindow;

        private InnerPanelBorder(ToolWindow window) {
            this.myWindow = window;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(JBColor.border());
            this.doPaintBorder(c, g, x, y, width, height);
        }

        private void doPaintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = this.getBorderInsets(c);
            if (insets.top > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + insets.top - 1), (int)(x + width - 1), (int)(y + insets.top - 1));
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + insets.top), (int)(x + width - 1), (int)(y + insets.top));
            }
            if (insets.left > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height));
                UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)y, (int)(x + 1), (int)(y + height));
            }
            if (insets.right > 0) {
                UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)(y + insets.top), (int)(x + width - 1), (int)(y + height));
                UIUtil.drawLine((Graphics)g, (int)(x + width), (int)(y + insets.top), (int)(x + width), (int)(y + height));
            }
            if (insets.bottom > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height - 1));
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height), (int)(x + width), (int)(y + height));
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (InternalDecorator.this.myProject == null) {
                return new Insets(0, 0, 0, 0);
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)InternalDecorator.this.myProject);
            if (!(toolWindowManager instanceof ToolWindowManagerImpl) || !((ToolWindowManagerImpl)toolWindowManager).isToolWindowRegistered(InternalDecorator.this.myInfo.getId()) || this.myWindow.getType() == ToolWindowType.FLOATING || this.myWindow.getType() == ToolWindowType.WINDOWED) {
                return new Insets(0, 0, 0, 0);
            }
            ToolWindowAnchor anchor2 = this.myWindow.getAnchor();
            Container component = this.myWindow.getComponent();
            Container parent = component.getParent();
            boolean isSplitter = false;
            boolean isFirstInSplitter = false;
            boolean isVerticalSplitter = false;
            while (parent != null) {
                if (parent instanceof Splitter) {
                    Splitter splitter = (Splitter)parent;
                    isSplitter = true;
                    isFirstInSplitter = splitter.getFirstComponent() == component;
                    isVerticalSplitter = splitter.isVertical();
                    break;
                }
                component = parent;
                parent = component.getParent();
            }
            int top = isSplitter && (anchor2 == ToolWindowAnchor.RIGHT || anchor2 == ToolWindowAnchor.LEFT) && InternalDecorator.this.myInfo.isSplit() && isVerticalSplitter ? -1 : 0;
            int left = anchor2 == ToolWindowAnchor.RIGHT && (!isSplitter || isVerticalSplitter || isFirstInSplitter) ? 1 : 0;
            int bottom = 0;
            int right = anchor2 == ToolWindowAnchor.LEFT && (!isSplitter || isVerticalSplitter || !isFirstInSplitter) ? 1 : 0;
            return new Insets(top, left, bottom, right);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

