/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import org.jetbrains.annotations.NotNull;

public class PlatformFrameTitleBuilder
extends FrameTitleBuilder {
    @Override
    public String getProjectTitle(@NotNull Project project) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return project.getName();
        }
        if ((basePath = FileUtil.toSystemDependentName((String)basePath)).equals(project.getName())) {
            return "[" + FileUtil.getLocationRelativeToUserHome((String)basePath) + "]";
        }
        return project.getName() + " [" + FileUtil.getLocationRelativeToUserHome((String)basePath) + "]";
    }

    @Override
    public String getFileTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        String fileTitle = VfsPresentationUtil.getPresentableNameForUI(project, file2);
        if (!fileTitle.endsWith(file2.getPresentableName()) || file2.getParent() == null) {
            return fileTitle;
        }
        return ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)file2, (String)file2.getPresentableUrl(), (Project)project, (boolean)true, (boolean)false);
    }
}

