/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.BitUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectWindowAction
extends ToggleAction
implements DumbAware {
    private ProjectWindowAction myPrevious;
    private ProjectWindowAction myNext;
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myProjectLocation;

    public ProjectWindowAction(@NotNull String projectName, @NotNull String projectLocation, ProjectWindowAction previous) {
        this.myProjectName = projectName;
        this.myProjectLocation = projectLocation;
        if (previous != null) {
            this.myPrevious = previous;
            this.myNext = previous.myNext;
            this.myNext.myPrevious = this;
            this.myPrevious.myNext = this;
        } else {
            this.myPrevious = this;
            this.myNext = this;
        }
        this.getTemplatePresentation().setText(projectName, false);
    }

    public void dispose() {
        if (this.myPrevious == this) {
            assert (this.myNext == this);
            return;
        }
        if (this.myNext == this) {
            assert (false);
            return;
        }
        this.myPrevious.myNext = this.myNext;
        this.myNext.myPrevious = this.myPrevious;
    }

    public ProjectWindowAction getPrevious() {
        return this.myPrevious;
    }

    public ProjectWindowAction getNext() {
        return this.myNext;
    }

    @NotNull
    public String getProjectLocation() {
        return this.myProjectLocation;
    }

    @NotNull
    public String getProjectName() {
        return this.myProjectName;
    }

    @Nullable
    private Project findProject() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            if (!this.myProjectLocation.equals(project.getPresentableUrl())) continue;
            return project;
        }
        return null;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        return this.myProjectLocation.equals(project.getPresentableUrl());
    }

    public void setSelected(@NotNull AnActionEvent e, boolean selected) {
        if (!selected) {
            return;
        }
        Project project = this.findProject();
        if (project == null) {
            return;
        }
        JFrame projectFrame = WindowManager.getInstance().getFrame(project);
        if (projectFrame == null) {
            return;
        }
        int frameState = projectFrame.getExtendedState();
        if (SystemInfo.isMac && BitUtil.isSet((int)projectFrame.getExtendedState(), (int)1) && e.getInputEvent() instanceof KeyEvent) {
            return;
        }
        if (BitUtil.isSet((int)frameState, (int)1)) {
            projectFrame.setExtendedState(BitUtil.set((int)frameState, (int)1, (boolean)false));
        }
        projectFrame.toFront();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            Component mostRecentFocusOwner = projectFrame.getMostRecentFocusOwner();
            if (mostRecentFocusOwner != null) {
                IdeFocusManager.getGlobalInstance().requestFocus(mostRecentFocusOwner, true);
            }
        });
    }

    public String toString() {
        return this.getTemplatePresentation().getText() + " previous: " + this.myPrevious.getTemplatePresentation().getText() + " next: " + this.myNext.getTemplatePresentation().getText();
    }

    @Nullable
    public String getTemplateText() {
        return "Switch Project";
    }
}

