/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.MaximizeActiveDialogAction;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ToolWindowCollector;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.FrameEditorComponentProvider;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ActiveStack;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.SideStack;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.WindowedDecorator;
import com.intellij.openapi.wm.impl.Windows;
import com.intellij.openapi.wm.impl.commands.ApplyWindowInfoCmd;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.openapi.wm.impl.commands.InvokeLaterCmd;
import com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd;
import com.intellij.openapi.wm.impl.commands.UpdateRootPaneCmd;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ToolWindowManager", defaultStateAsResource=true, storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)})
public class ToolWindowManagerImpl
extends ToolWindowManagerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
    private final Project myProject;
    private final WindowManagerEx myWindowManager;
    private final EventDispatcher<ToolWindowManagerListener> myDispatcher = EventDispatcher.create(ToolWindowManagerListener.class);
    private final DesktopLayout myLayout = new DesktopLayout();
    private final Map<String, InternalDecorator> myId2InternalDecorator = new HashMap<String, InternalDecorator>();
    private final Map<String, FloatingDecorator> myId2FloatingDecorator = new HashMap<String, FloatingDecorator>();
    private final Map<String, WindowedDecorator> myId2WindowedDecorator = new HashMap<String, WindowedDecorator>();
    private final Map<String, StripeButton> myId2StripeButton = new HashMap<String, StripeButton>();
    private final Map<String, FocusWatcher> myId2FocusWatcher = new HashMap<String, FocusWatcher>();
    private final MyToolWindowPropertyChangeListener myToolWindowPropertyChangeListener = new MyToolWindowPropertyChangeListener();
    private final InternalDecoratorListener myInternalDecoratorListener = new MyInternalDecoratorListener();
    private final ActiveStack myActiveStack = new ActiveStack();
    private final SideStack mySideStack = new SideStack();
    private ToolWindowsPane myToolWindowsPane;
    private IdeFrameImpl myFrame;
    private DesktopLayout myLayoutToRestoreLater;
    @NonNls
    private static final String EDITOR_ELEMENT = "editor";
    @NonNls
    private static final String ACTIVE_ATTR_VALUE = "active";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String X_ATTR = "x";
    @NonNls
    private static final String Y_ATTR = "y";
    @NonNls
    private static final String WIDTH_ATTR = "width";
    @NonNls
    private static final String HEIGHT_ATTR = "height";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    @NonNls
    private static final String LAYOUT_TO_RESTORE = "layout-to-restore";
    private final Map<String, Balloon> myWindow2Balloon = new HashMap<String, Balloon>();
    private KeyState myCurrentState = KeyState.waiting;
    private final Alarm myWaiterForSecondPress = new Alarm();
    private final Runnable mySecondPressRunnable = () -> {
        if (this.myCurrentState != KeyState.hold) {
            this.resetHoldState();
        }
    };
    private final SingleAlarm myUpdateHeadersAlarm = new SingleAlarm(() -> this.updateToolWindowHeaders(), 50, this);
    private final CommandProcessor myCommandProcessor = new CommandProcessor();

    boolean isToolWindowRegistered(@NotNull String id) {
        return this.myLayout.isToolWindowRegistered(id);
    }

    public ToolWindowManagerImpl(Project project, WindowManagerEx windowManagerEx, ActionManager actionManager) {
        this.myProject = project;
        this.myWindowManager = windowManagerEx;
        if (project.isDefault()) {
            return;
        }
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)this.myDispatcher.getMulticaster());
        busConnection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (ToolWindowManagerImpl.this.myCurrentState != KeyState.hold) {
                    ToolWindowManagerImpl.this.resetHoldState();
                }
            }
        });
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project != ToolWindowManagerImpl.this.myProject) {
                    return;
                }
                ToolWindowManagerImpl.this.init();
                PropertyChangeListener focusListener = it -> ToolWindowManagerImpl.this.myUpdateHeadersAlarm.request();
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.addPropertyChangeListener("focusOwner", focusListener);
                Disposer.register((Disposable)ToolWindowManagerImpl.this, () -> keyboardFocusManager.removePropertyChangeListener("focusOwner", focusListener));
            }

            public void projectClosed(@NotNull Project project) {
                if (project == ToolWindowManagerImpl.this.myProject) {
                    ToolWindowManagerImpl.this.projectClosed();
                }
            }
        });
        this.myLayout.copyFrom(windowManagerEx.getLayout());
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(ToolWindowManagerImpl.this.myProject){

                    public void run() {
                        if (!ToolWindowManagerImpl.this.hasOpenEditorFiles()) {
                            ToolWindowManagerImpl.this.focusToolWindowByDefault(null);
                        }
                    }
                });
            }
        });
        Predicate<AWTEvent> predicate = event -> event.getID() == 1005 || event.getID() == 1004 || event.getID() == 501 || event.getID() == 401;
        Windows.ToolWindowFilter.filterBySignal(new Windows.Signal(predicate)).withEscAction(actionManager).handleDocked(toolWindowId -> {}).handleFloating(toolWindowId -> {}).handleFocusLostOnPinned(toolWindowId -> {
            ArrayList<FinalizableCommand> commands = new ArrayList<FinalizableCommand>();
            this.deactivateToolWindowImpl(this.getRegisteredInfoOrLogError((String)toolWindowId), true, commands);
            this.execute(commands, true);
        }).handleWindowed(toolWindowId -> {}).bind(this.myProject);
    }

    private void focusDefaultElementInSelectedEditor() {
        JComponent defaultFocusedComponentInEditor;
        EditorWithProviderComposite editor;
        EditorWindow window;
        EditorsSplitters splittersToFocus = this.getSplittersToFocus();
        if (splittersToFocus != null && (window = splittersToFocus.getCurrentWindow()) != null && (editor = window.getSelectedEditor()) != null && (defaultFocusedComponentInEditor = editor.getPreferredFocusedComponent()) != null) {
            defaultFocusedComponentInEditor.requestFocus();
        }
    }

    private void updateToolWindowHeaders() {
        this.getFocusManager().doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(this.myProject){

            public void run() {
                for (WindowInfoImpl each : ToolWindowManagerImpl.this.myLayout.getInfos()) {
                    InternalDecorator decorator;
                    ToolWindow tw;
                    if (!each.isVisible() || !((tw = ToolWindowManagerImpl.this.getToolWindow(each.getId())) instanceof ToolWindowImpl) || (decorator = ((ToolWindowImpl)tw).getDecorator()) == null) continue;
                    decorator.repaint();
                }
            }
        });
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        if (e.getKeyCode() != 17 && e.getKeyCode() != 18 && e.getKeyCode() != 16 && e.getKeyCode() != 157) {
            if (e.getModifiers() == 0) {
                this.resetHoldState();
            }
            return false;
        }
        if (e.getID() != 401 && e.getID() != 402) {
            return false;
        }
        Component parent = UIUtil.findUltimateParent((Component)e.getComponent());
        if (parent instanceof IdeFrame && ((IdeFrame)parent).getProject() != this.myProject) {
            this.resetHoldState();
            return false;
        }
        int vks = ToolWindowManagerImpl.getActivateToolWindowVKsMask();
        if (vks == 0) {
            this.resetHoldState();
            return false;
        }
        int mouseMask = 7168;
        if (BitUtil.isSet((int)vks, (int)ToolWindowManagerImpl.keyCodeToInputMask(e.getKeyCode())) && (e.getModifiersEx() & mouseMask) == 0) {
            boolean pressed = e.getID() == 401;
            int modifiers = e.getModifiers();
            if (ToolWindowManagerImpl.areAllModifiersPressed(modifiers, vks) || !pressed) {
                this.processState(pressed);
            } else {
                this.resetHoldState();
            }
        }
        return false;
    }

    private static boolean areAllModifiersPressed(@JdkConstants.InputEventMask int modifiers, @JdkConstants.InputEventMask int mask) {
        return (modifiers ^ mask) == 0;
    }

    @JdkConstants.InputEventMask
    private static int keyCodeToInputMask(int code) {
        int mask = 0;
        if (code == 16) {
            mask = 1;
        }
        if (code == 17) {
            mask = 2;
        }
        if (code == 157) {
            mask = 4;
        }
        if (code == 18) {
            mask = 8;
        }
        return mask;
    }

    @JdkConstants.InputEventMask
    private static int getActivateToolWindowVKsMask() {
        KeyStroke keyStroke;
        Shortcut each;
        if (ApplicationManager.getApplication() == null) {
            return 0;
        }
        Keymap keymap = Objects.requireNonNull(KeymapManager.getInstance()).getActiveKeymap();
        Shortcut[] baseShortcut = keymap.getShortcuts("ActivateProjectToolWindow");
        int baseModifiers = SystemInfo.isMac ? 4 : 8;
        Shortcut[] shortcutArray = baseShortcut;
        int n = shortcutArray.length;
        for (int i = 0; !(i >= n || (each = shortcutArray[i]) instanceof KeyboardShortcut && (baseModifiers = (keyStroke = ((KeyboardShortcut)each).getFirstKeyStroke()).getModifiers()) > 0); ++i) {
        }
        return baseModifiers & 0xF;
    }

    private void resetHoldState() {
        this.myCurrentState = KeyState.waiting;
        this.processHoldState();
    }

    private void processState(boolean pressed) {
        if (pressed) {
            if (this.myCurrentState == KeyState.waiting) {
                this.myCurrentState = KeyState.pressed;
            } else if (this.myCurrentState == KeyState.released) {
                this.myCurrentState = KeyState.hold;
                this.processHoldState();
            }
        } else if (this.myCurrentState == KeyState.pressed) {
            this.myCurrentState = KeyState.released;
            this.restartWaitingForSecondPressAlarm();
        } else {
            this.resetHoldState();
        }
    }

    private void processHoldState() {
        if (this.myToolWindowsPane != null) {
            this.myToolWindowsPane.setStripesOverlayed(this.myCurrentState == KeyState.hold);
        }
    }

    private void restartWaitingForSecondPressAlarm() {
        this.myWaiterForSecondPress.cancelAllRequests();
        this.myWaiterForSecondPress.addRequest(this.mySecondPressRunnable, Registry.intValue((String)"actionSystem.keyGestureDblClickTime"));
    }

    private boolean hasOpenEditorFiles() {
        return FileEditorManager.getInstance((Project)this.myProject).getOpenFiles().length > 0;
    }

    private static IdeFocusManager getFocusManagerImpl(Project project) {
        return IdeFocusManager.getInstance((Project)project);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public void dispose() {
        LOG.assertTrue(this.myId2StripeButton.isEmpty(), this.myId2StripeButton);
    }

    public void init() {
        if (this.myToolWindowsPane != null) {
            return;
        }
        this.myFrame = this.myWindowManager.allocateFrame(this.myProject);
        LOG.assertTrue(this.myFrame != null);
        this.myToolWindowsPane = new ToolWindowsPane(this.myFrame, this);
        Disposer.register((Disposable)this, (Disposable)this.myToolWindowsPane);
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(this.myToolWindowsPane);
        this.myFrame.setTitle(FrameTitleBuilder.getInstance().getProjectTitle(this.myProject));
        ((IdeRootPane)this.myFrame.getRootPane()).updateToolbar();
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof KeyEvent) {
                this.dispatchKeyEvent((KeyEvent)e);
            }
            if (e instanceof WindowEvent && e.getID() == 208 && e.getSource() == this.myFrame) {
                this.resetHoldState();
            }
            return false;
        }, this);
        UIUtil.putClientProperty((JComponent)((Object)this.myToolWindowsPane), (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> {
            List<WindowInfoImpl> infos = this.myLayout.getInfos();
            ArrayList<InternalDecorator> result2 = new ArrayList<InternalDecorator>(infos.size());
            for (WindowInfoImpl info : infos) {
                InternalDecorator decorator = this.getInternalDecorator(info.getId());
                if (decorator.getParent() != null) continue;
                result2.add(decorator);
            }
            return result2.iterator();
        });
    }

    private void initAll(List<? super FinalizableCommand> commandsList) {
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        JComponent editorComponent = ToolWindowManagerImpl.createEditorComponent(this.myProject);
        editorComponent.setFocusable(false);
        this.appendSetEditorComponentCmd(editorComponent, commandsList);
    }

    private static JComponent createEditorComponent(@NotNull Project project) {
        return ((FrameEditorComponentProvider[])FrameEditorComponentProvider.EP.getExtensions())[0].createEditorComponent(project);
    }

    private void registerToolWindowsFromBeans(List<? super FinalizableCommand> list2) {
        for (final ToolWindowEP bean : ToolWindowEP.EP_NAME.getExtensionList()) {
            list2.add(new FinalizableCommand(EmptyRunnable.INSTANCE){

                @Override
                public void run() {
                    try {
                        ToolWindowManagerImpl.this.initToolWindow(bean);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        LOG.error("failed to init toolwindow " + bean.factoryClass, t);
                    }
                }
            });
        }
    }

    @Override
    public void initToolWindow(@NotNull ToolWindowEP bean) {
        WindowInfoImpl info;
        Condition condition = bean.getCondition();
        if (condition != null && !condition.value((Object)this.myProject)) {
            return;
        }
        WindowInfoImpl before = this.myLayout.getInfo(bean.id, false);
        boolean visible = before != null && before.isVisible();
        JLabel label2 = ToolWindowManagerImpl.createInitializingLabel();
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.fromText((String)bean.anchor);
        ToolWindowFactory factory = bean.getToolWindowFactory();
        ToolWindow window = this.registerToolWindow(bean.id, label2, toolWindowAnchor, false, bean.canCloseContents, DumbService.isDumbAware((Object)factory), factory.shouldBeAvailable(this.myProject));
        ToolWindowImpl toolWindow = (ToolWindowImpl)window;
        toolWindow.setContentFactory(factory);
        if (bean.icon != null && toolWindow.getIcon() == null) {
            Icon icon = IconLoader.findIcon((String)bean.icon, factory.getClass());
            if (icon == null) {
                try {
                    icon = IconLoader.getIcon((String)bean.icon);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            toolWindow.setIcon(icon);
        }
        if (!(info = this.getRegisteredInfoOrLogError(bean.id)).isSplit() && bean.secondary && !info.isWasRead()) {
            toolWindow.setSplitMode(true, null);
        }
        DumbAwareRunnable runnable2 = () -> {
            if (toolWindow.isDisposed()) {
                return;
            }
            toolWindow.ensureContentInitialized();
        };
        if (visible) {
            runnable2.run();
        } else {
            UiNotifyConnector.doWhenFirstShown((JComponent)label2, () -> ApplicationManager.getApplication().invokeLater((Runnable)runnable2));
        }
    }

    @NotNull
    private static JLabel createInitializingLabel() {
        JLabel label2 = new JLabel("Initializing...", 0);
        label2.setOpaque(true);
        Color treeBg = UIManager.getColor("Tree.background");
        label2.setBackground(ColorUtil.toAlpha((Color)treeBg, (int)180));
        Color treeFg = UIUtil.getTreeForeground();
        label2.setForeground(ColorUtil.toAlpha((Color)treeFg, (int)180));
        return label2;
    }

    public void projectClosed() {
        if (this.myFrame == null) {
            return;
        }
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(null);
        this.myWindowManager.releaseFrame(this.myFrame);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        for (WindowInfoImpl info : this.myLayout.getInfos()) {
            this.deactivateToolWindowImpl(info, true, commandsList);
        }
        this.appendSetEditorComponentCmd(null, commandsList);
        this.execute(commandsList);
        this.myFrame = null;
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(ToolWindowManagerListener.TOPIC, (Object)listener2);
    }

    @Override
    public void removeToolWindowManagerListener(@NotNull ToolWindowManagerListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    void execute(@NotNull List<FinalizableCommand> commandList) {
        this.execute(commandList, true);
    }

    private void execute(@NotNull List<FinalizableCommand> commandList, boolean isFireStateChangedEvent) {
        if (isFireStateChangedEvent) {
            for (FinalizableCommand each : commandList) {
                if (!each.willChangeState()) continue;
                this.fireStateChanged();
                break;
            }
        }
        for (FinalizableCommand each : commandList) {
            each.beforeExecute(this);
        }
        this.myCommandProcessor.execute(commandList, this.myProject.getDisposed());
    }

    private void flushCommands() {
        this.myCommandProcessor.flush();
    }

    public void activateEditorComponent() {
        this.focusDefaultElementInSelectedEditor();
    }

    private void deactivateWindows(@NotNull String idToIgnore, @NotNull List<? super FinalizableCommand> commandList) {
        for (WindowInfoImpl info : this.myLayout.getInfos()) {
            if (idToIgnore.equals(info.getId())) continue;
            this.deactivateToolWindowImpl(info, ToolWindowManagerImpl.isToHideOnDeactivation(info), commandList);
        }
    }

    private static boolean isToHideOnDeactivation(@NotNull WindowInfoImpl info) {
        if (info.isFloating() || info.isWindowed()) {
            return false;
        }
        return info.isAutoHide() || info.isSliding();
    }

    private void showAndActivate(@NotNull String id, boolean dirtyMode, @NotNull List<? super FinalizableCommand> commandsList, boolean autoFocusContents) {
        if (!this.getToolWindow(id).isAvailable()) {
            return;
        }
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(id);
        boolean toApplyInfo = false;
        if (!info.isActive()) {
            info.setActive(true);
            toApplyInfo = true;
        }
        this.showToolWindowImpl(id, dirtyMode, commandsList);
        if (toApplyInfo) {
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.myActiveStack.push(id);
        }
        if (autoFocusContents && ApplicationManager.getApplication().isActive()) {
            this.appendRequestFocusInToolWindowCmd(id, commandsList);
        }
    }

    void activateToolWindow(@NotNull String id, boolean forced, boolean autoFocusContents) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.activateToolWindowImpl(id, commandList, forced, autoFocusContents);
        this.execute(commandList);
    }

    private void activateToolWindowImpl(@NotNull String id, @NotNull List<? super FinalizableCommand> commandList, boolean forced, boolean autoFocusContents) {
        ToolWindowCollector.getInstance().recordActivation(id);
        autoFocusContents &= forced;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindowImpl(" + id + ")");
        }
        if (!this.getToolWindow(id).isAvailable()) {
            InternalDecorator decorator = this.getInternalDecorator(id);
            if (!decorator.hasFocus() && autoFocusContents) {
                this.appendRequestFocusInToolWindowCmd(id, commandList);
            }
            return;
        }
        this.deactivateWindows(id, commandList);
        this.showAndActivate(id, false, commandList, autoFocusContents);
    }

    private void checkId(@NotNull String id) {
        this.getRegisteredInfoOrLogError(id);
    }

    @NotNull
    private WindowInfoImpl getRegisteredInfoOrLogError(@NotNull String id) {
        WindowInfoImpl info = this.myLayout.getInfo(id, false);
        if (info == null) {
            throw new IllegalThreadStateException("window with id=\"" + id + "\" is unknown");
        }
        if (!info.isRegistered()) {
            LOG.error("window with id=\"" + id + "\" isn't registered");
        }
        return info;
    }

    private void deactivateToolWindowImpl(@NotNull WindowInfoImpl info, boolean shouldHide, @NotNull List<? super FinalizableCommand> commandsList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: deactivateToolWindowImpl(" + info.getId() + "," + shouldHide + ")");
        }
        if (shouldHide && info.isVisible()) {
            this.applyInfo(info.getId(), info, commandsList);
        }
        info.setActive(false);
        this.appendApplyWindowInfoCmd(info, commandsList);
    }

    @NotNull
    public String[] getToolWindowIds() {
        List<WindowInfoImpl> infos = this.myLayout.getInfos();
        String[] ids = ArrayUtil.newStringArray((int)infos.size());
        for (int i = 0; i < infos.size(); ++i) {
            ids[i] = infos.get(i).getId();
        }
        return ids;
    }

    public String getActiveToolWindowId() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout.getActiveId();
    }

    @Override
    public String getLastActiveToolWindowId() {
        return this.getLastActiveToolWindowId(null);
    }

    @Override
    @Nullable
    public String getLastActiveToolWindowId(@Nullable Condition<? super JComponent> condition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String lastActiveToolWindowId = null;
        for (int i = 0; i < this.myActiveStack.getPersistentSize(); ++i) {
            String id = this.myActiveStack.peekPersistent(i);
            ToolWindow toolWindow = this.getToolWindow(id);
            LOG.assertTrue(toolWindow != null);
            if (!toolWindow.isAvailable() || condition != null && !condition.value((Object)toolWindow.getComponent())) continue;
            lastActiveToolWindowId = id;
            break;
        }
        return lastActiveToolWindowId;
    }

    private FloatingDecorator getFloatingDecorator(@NotNull String id) {
        return this.myId2FloatingDecorator.get(id);
    }

    private WindowedDecorator getWindowedDecorator(@NotNull String id) {
        return this.myId2WindowedDecorator.get(id);
    }

    private InternalDecorator getInternalDecorator(@NotNull String id) {
        return this.myId2InternalDecorator.get(id);
    }

    StripeButton getStripeButton(@NotNull String id) {
        return this.myId2StripeButton.get(id);
    }

    @Override
    @NotNull
    public List<String> getIdsOn(@NotNull ToolWindowAnchor anchor2) {
        return this.myLayout.getVisibleIdsOn(anchor2, this);
    }

    @Nullable
    public ToolWindow getToolWindow(@Nullable String id) {
        if (id == null || !this.myLayout.isToolWindowRegistered(id)) {
            return null;
        }
        InternalDecorator decorator = this.getInternalDecorator(id);
        return decorator != null ? decorator.getToolWindow() : null;
    }

    void showToolWindow(@NotNull String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: showToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.showToolWindowImpl(id, false, commandList);
        this.execute(commandList);
    }

    @Override
    public void hideToolWindow(@NotNull String id, boolean hideSide) {
        this.hideToolWindow(id, hideSide, true);
    }

    public void hideToolWindow(@NotNull String id, boolean hideSide, boolean moveFocus) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(id);
        if (!info.isVisible()) {
            return;
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        boolean wasActive = info.isActive();
        this.deactivateToolWindowImpl(info, true, commandList);
        if (hideSide && !info.isFloating() && !info.isWindowed()) {
            List<String> ids = this.myLayout.getVisibleIdsOn(info.getAnchor(), this);
            for (String each : ids) {
                this.myActiveStack.remove(each, true);
            }
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                this.mySideStack.pop(info.getAnchor());
            }
            for (WindowInfoImpl eachInfo : this.myLayout.getInfos()) {
                if (!eachInfo.isVisible() || eachInfo.getAnchor() != info.getAnchor()) continue;
                this.deactivateToolWindowImpl(eachInfo, true, commandList);
            }
        } else if (ToolWindowManagerImpl.isStackEnabled()) {
            WindowInfoImpl info2 = null;
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                WindowInfoImpl storedInfo = this.mySideStack.pop(info.getAnchor());
                if (storedInfo.isSplit() != info.isSplit()) continue;
                WindowInfoImpl currentInfo = this.getRegisteredInfoOrLogError(Objects.requireNonNull(storedInfo.getId()));
                if (storedInfo.getAnchor() != currentInfo.getAnchor() || storedInfo.getType() != currentInfo.getType() || storedInfo.isAutoHide() != currentInfo.isAutoHide()) continue;
                info2 = storedInfo;
                break;
            }
            if (info2 != null) {
                this.showToolWindowImpl(Objects.requireNonNull(info2.getId()), false, commandList);
            }
            this.myActiveStack.remove(id, false);
            if (wasActive && moveFocus && !this.myActiveStack.isEmpty()) {
                String toBeActivatedId = this.myActiveStack.pop();
                if (this.getRegisteredInfoOrLogError(toBeActivatedId).isVisible() || ToolWindowManagerImpl.isStackEnabled()) {
                    this.activateToolWindowImpl(toBeActivatedId, commandList, false, true);
                } else {
                    this.focusToolWindowByDefault(id);
                }
            }
        }
        this.execute(commandList);
    }

    private static boolean isStackEnabled() {
        return Registry.is((String)"ide.enable.toolwindow.stack");
    }

    private void showToolWindowImpl(@NotNull String id, boolean dirtyMode, @NotNull List<? super FinalizableCommand> commandsList) {
        WindowInfoImpl toBeShownInfo = this.getRegisteredInfoOrLogError(id);
        ToolWindow window = this.getToolWindow(id);
        if (window != null && toBeShownInfo.isWindowed()) {
            UIUtil.toFront((Window)UIUtil.getWindow((Component)window.getComponent()));
        }
        if (toBeShownInfo.isVisible() || window == null || !window.isAvailable()) {
            return;
        }
        toBeShownInfo.setVisible(true);
        InternalDecorator decorator = this.getInternalDecorator(id);
        if (toBeShownInfo.isFloating()) {
            commandsList.add(new AddFloatingDecoratorCmd(decorator, toBeShownInfo));
        } else if (toBeShownInfo.isWindowed()) {
            commandsList.add(new AddWindowedDecoratorCmd(decorator, toBeShownInfo));
        } else {
            for (WindowInfoImpl info : this.myLayout.getInfos()) {
                if (id.equals(info.getId()) || !info.isVisible() || info.getType() != toBeShownInfo.getType() || info.getAnchor() != toBeShownInfo.getAnchor() || info.isSplit() != toBeShownInfo.isSplit()) continue;
                info.setVisible(false);
                this.appendRemoveDecoratorCmd(Objects.requireNonNull(info.getId()), false, commandsList);
                if (info.isActive()) {
                    info.setActive(false);
                }
                this.appendApplyWindowInfoCmd(info, commandsList);
                if (!info.isDocked() || info.isAutoHide()) continue;
                this.mySideStack.push(info);
            }
            this.appendAddDecoratorCmd(decorator, toBeShownInfo, dirtyMode, commandsList);
            this.mySideStack.remove(id);
        }
        if (!toBeShownInfo.isShowStripeButton()) {
            toBeShownInfo.setShowStripeButton(true);
        }
        this.appendApplyWindowInfoCmd(toBeShownInfo, commandsList);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2) {
        return this.registerToolWindow(id, component, anchor2, false, false, false, true);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable) {
        return this.registerToolWindow(id, component, anchor2, parentDisposable, false, false);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        return this.registerToolWindow(id, component, anchor2, parentDisposable, canWorkInDumbMode, false);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean canCloseContents) {
        return this.registerToolWindow(id, component, anchor2, false, canCloseContents, canWorkInDumbMode, true);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2) {
        return this.registerToolWindow(id, null, anchor2, false, canCloseContent, false, true);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, boolean secondary) {
        return this.registerToolWindow(id, null, anchor2, secondary, canCloseContent, false, true);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        return this.registerToolWindow(id, canCloseContent, anchor2, parentDisposable, canWorkInDumbMode, false);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor2, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean secondary) {
        return this.registerToolWindow(id, null, anchor2, secondary, canCloseContent, canWorkInDumbMode, true);
    }

    @NotNull
    private ToolWindow registerToolWindow(@NotNull String id, @Nullable JComponent component, @NotNull ToolWindowAnchor anchor2, boolean sideTool, boolean canCloseContent, boolean canWorkInDumbMode, boolean shouldBeAvailable) {
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: installToolWindow(" + id + "," + component + "," + anchor2 + "\")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        WindowInfoImpl existingInfo = this.myLayout.getInfo(id, false);
        if (existingInfo != null && existingInfo.isRegistered()) {
            throw new IllegalArgumentException("window with id=\"" + id + "\" is already registered");
        }
        WindowInfoImpl info = this.myLayout.register(id, anchor2, sideTool);
        boolean wasActive = info.isActive();
        boolean wasVisible = info.isVisible();
        info.setActive(false);
        info.setVisible(false);
        ToolWindowImpl toolWindow = new ToolWindowImpl(this, id, canCloseContent, component);
        Disposer.register((Disposable)this, (Disposable)toolWindow);
        toolWindow.setAvailable(shouldBeAvailable, null);
        InternalDecorator decorator = new InternalDecorator(this.myProject, info.copy(), toolWindow, canWorkInDumbMode);
        ActivateToolWindowAction.ensureToolWindowActionRegistered(toolWindow);
        this.myId2InternalDecorator.put(id, decorator);
        decorator.addInternalDecoratorListener(this.myInternalDecoratorListener);
        toolWindow.addPropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myId2FocusWatcher.put(id, new ToolWindowFocusWatcher(toolWindow));
        StripeButton button2 = new StripeButton(decorator, this.myToolWindowsPane);
        Disposer.register((Disposable)toolWindow, (Disposable)button2);
        this.myId2StripeButton.put(id, button2);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.appendAddButtonCmd(button2, info, commandsList);
        if (!info.isAutoHide() && (info.isDocked() || info.isFloating())) {
            if (wasActive) {
                this.activateToolWindowImpl(Objects.requireNonNull(info.getId()), commandsList, true, true);
            } else if (wasVisible) {
                this.showToolWindowImpl(Objects.requireNonNull(info.getId()), false, commandsList);
            }
        }
        this.execute(commandsList);
        this.fireToolWindowRegistered(id);
        return toolWindow;
    }

    public void unregisterToolWindow(@NotNull String id) {
        ToolWindowImpl window = (ToolWindowImpl)this.getToolWindow(id);
        if (window != null) {
            Disposer.dispose((Disposable)window);
        }
    }

    void doUnregisterToolWindow(@NotNull String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: unregisterToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        WindowInfoImpl info = this.myLayout.getInfo(id, false);
        if (info == null || !info.isRegistered()) {
            return;
        }
        ToolWindowEx toolWindow = (ToolWindowEx)this.getToolWindow(id);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        if (info.isVisible()) {
            this.applyInfo(id, info, commandsList);
        }
        this.myLayout.unregister(id);
        this.myActiveStack.remove(id, true);
        this.mySideStack.remove(id);
        this.appendRemoveButtonCmd(id, info, commandsList);
        this.appendApplyWindowInfoCmd(info, commandsList);
        this.execute(commandsList, false);
        assert (toolWindow != null);
        ((ToolWindowManagerListener)this.myProject.getMessageBus().syncPublisher(ToolWindowManagerListener.TOPIC)).toolWindowUnregistered(id, toolWindow);
        toolWindow.removePropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myId2StripeButton.remove(id);
        ToolWindowFocusWatcher watcher = (ToolWindowFocusWatcher)this.myId2FocusWatcher.remove(id);
        watcher.deinstall();
        InternalDecorator decorator = this.getInternalDecorator(id);
        decorator.dispose();
        decorator.removeInternalDecoratorListener(this.myInternalDecoratorListener);
        this.myId2InternalDecorator.remove(id);
    }

    private void applyInfo(@NotNull String id, WindowInfoImpl info, List<? super FinalizableCommand> commandsList) {
        info.setVisible(false);
        if (info.isFloating()) {
            this.appendRemoveFloatingDecoratorCmd(info, commandsList);
        } else if (info.isWindowed()) {
            this.appendRemoveWindowedDecoratorCmd(info, commandsList);
        } else {
            this.appendRemoveDecoratorCmd(id, false, commandsList);
        }
    }

    @Override
    @NotNull
    public DesktopLayout getLayout() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout;
    }

    @Override
    public void setLayoutToRestoreLater(DesktopLayout layout) {
        this.myLayoutToRestoreLater = layout;
    }

    @Override
    public DesktopLayout getLayoutToRestoreLater() {
        return this.myLayoutToRestoreLater;
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
        WindowInfoImpl info;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        List<WindowInfoImpl> currentInfos = this.myLayout.getInfos();
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(Objects.requireNonNull(currentInfo.getId()), false);
            if (!currentInfo.isVisible() || info != null && info.isVisible()) continue;
            this.deactivateToolWindowImpl(currentInfo, true, commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(Objects.requireNonNull(currentInfo.getId()), false);
            if (info == null || currentInfo.getAnchor() == info.getAnchor() && currentInfo.getOrder() == info.getOrder()) continue;
            this.setToolWindowAnchorImpl(currentInfo.getId(), info.getAnchor(), info.getOrder(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(Objects.requireNonNull(currentInfo.getId()), false);
            if (info == null || currentInfo.getType() == info.getType()) continue;
            this.setToolWindowTypeImpl(currentInfo.getId(), info.getType(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(Objects.requireNonNull(currentInfo.getId()), false);
            if (info == null || currentInfo.isAutoHide() == info.isAutoHide()) continue;
            this.setToolWindowAutoHideImpl(currentInfo.getId(), info.isAutoHide(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(Objects.requireNonNull(currentInfo.getId()), false);
            if (info == null || !info.isVisible()) continue;
            this.showToolWindowImpl(currentInfo.getId(), false, commandList);
        }
        this.execute(commandList);
    }

    public void invokeLater(@NotNull Runnable runnable2) {
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        commandList.add(new InvokeLaterCmd(runnable2, this.myCommandProcessor));
        this.execute(commandList);
    }

    @NotNull
    public IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public boolean canShowNotification(@NotNull String toolWindowId) {
        if (!this.myLayout.isToolWindowRegistered(toolWindowId)) {
            return false;
        }
        Stripe stripe = this.myToolWindowsPane.getStripeFor(toolWindowId);
        return stripe != null && stripe.getButtonFor(toolWindowId) != null;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String htmlBody) {
        this.notifyByBalloon(toolWindowId, type, htmlBody, null, null);
    }

    public void notifyByBalloon(final @NotNull String toolWindowId, final @NotNull MessageType type, final @NotNull String text, @Nullable Icon icon, @Nullable HyperlinkListener listener2) {
        Stripe stripe;
        this.checkId(toolWindowId);
        Balloon existing = this.myWindow2Balloon.get(toolWindowId);
        if (existing != null) {
            Disposer.dispose((Disposable)existing);
        }
        if ((stripe = this.myToolWindowsPane.getStripeFor(toolWindowId)) == null) {
            return;
        }
        ToolWindowImpl window = this.getInternalDecorator(toolWindowId).getToolWindow();
        if (!window.isAvailable()) {
            window.setPlaceholderMode(true);
            stripe.updatePresentation();
            stripe.revalidate();
            stripe.repaint();
        }
        final ToolWindowAnchor anchor2 = this.getRegisteredInfoOrLogError(toolWindowId).getAnchor();
        final Ref position = Ref.create((Object)Balloon.Position.below);
        if (ToolWindowAnchor.TOP == anchor2) {
            position.set((Object)Balloon.Position.below);
        } else if (ToolWindowAnchor.BOTTOM == anchor2) {
            position.set((Object)Balloon.Position.above);
        } else if (ToolWindowAnchor.LEFT == anchor2) {
            position.set((Object)Balloon.Position.atRight);
        } else if (ToolWindowAnchor.RIGHT == anchor2) {
            position.set((Object)Balloon.Position.atLeft);
        }
        BalloonHyperlinkListener listenerWrapper = new BalloonHyperlinkListener(listener2);
        final Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text.replace("\n", "<br>"), icon, type.getTitleForeground(), type.getPopupBackground(), (HyperlinkListener)listenerWrapper).setBorderColor(type.getBorderColor()).setHideOnClickOutside(false).setHideOnFrameResize(false).createBalloon();
        NotificationsManagerImpl.frameActivateBalloonListener(balloon, () -> AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ((BalloonImpl)balloon).setHideOnClickOutside(true), 100L, TimeUnit.MILLISECONDS));
        listenerWrapper.myBalloon = balloon;
        this.myWindow2Balloon.put(toolWindowId, balloon);
        Disposer.register((Disposable)balloon, () -> {
            window.setPlaceholderMode(false);
            stripe.updatePresentation();
            stripe.revalidate();
            stripe.repaint();
            this.myWindow2Balloon.remove(toolWindowId);
        });
        Disposer.register((Disposable)this.getProject(), (Disposable)balloon);
        this.execute(new ArrayList<FinalizableCommand>(Collections.singletonList(new FinalizableCommand(null){

            @Override
            public void run() {
                StripeButton button2 = stripe.getButtonFor(toolWindowId);
                LOG.assertTrue(button2 != null, (Object)("Button was not found, popup won't be shown. Toolwindow id: " + toolWindowId + ", message: " + text + ", message type: " + type));
                if (button2 == null) {
                    return;
                }
                Runnable show = () -> {
                    PositionTracker<Balloon> tracker = button2.isShowing() ? new PositionTracker<Balloon>((Component)button2){

                        @Nullable
                        public RelativePoint recalculateLocation(Balloon object) {
                            StripeButton twButton;
                            Stripe twStripe = ToolWindowManagerImpl.this.myToolWindowsPane.getStripeFor(toolWindowId);
                            StripeButton stripeButton = twButton = twStripe != null ? twStripe.getButtonFor(toolWindowId) : null;
                            if (twButton == null) {
                                return null;
                            }
                            if (ToolWindowManagerImpl.this.getToolWindow(toolWindowId).getAnchor() != anchor2) {
                                object.hide();
                                return null;
                            }
                            Point point = new Point(twButton.getBounds().width / 2, twButton.getHeight() / 2 - 2);
                            return new RelativePoint((Component)twButton, point);
                        }
                    } : new PositionTracker<Balloon>((Component)((Object)ToolWindowManagerImpl.this.myToolWindowsPane)){

                        public RelativePoint recalculateLocation(Balloon object) {
                            Rectangle bounds2 = ToolWindowManagerImpl.this.myToolWindowsPane.getBounds();
                            Point target2 = UIUtil.getCenterPoint((Rectangle)bounds2, (Dimension)new Dimension(1, 1));
                            if (ToolWindowAnchor.TOP == anchor2) {
                                target2.y = 0;
                            } else if (ToolWindowAnchor.BOTTOM == anchor2) {
                                target2.y = bounds2.height - 3;
                            } else if (ToolWindowAnchor.LEFT == anchor2) {
                                target2.x = 0;
                            } else if (ToolWindowAnchor.RIGHT == anchor2) {
                                target2.x = bounds2.width;
                            }
                            return new RelativePoint((Component)((Object)ToolWindowManagerImpl.this.myToolWindowsPane), target2);
                        }
                    };
                    if (!balloon.isDisposed()) {
                        balloon.show((PositionTracker)tracker, (Balloon.Position)position.get());
                    }
                };
                if (!button2.isValid()) {
                    SwingUtilities.invokeLater(show);
                } else {
                    show.run();
                }
            }
        })));
    }

    public Balloon getToolWindowBalloon(String id) {
        return this.myWindow2Balloon.get(id);
    }

    public boolean isEditorComponentActive() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Component owner = this.getFocusManager().getFocusOwner();
        EditorsSplitters splitters = (EditorsSplitters)((Object)UIUtil.getParentOfType(EditorsSplitters.class, (Component)owner));
        return splitters != null;
    }

    @NotNull
    ToolWindowAnchor getToolWindowAnchor(@NotNull String id) {
        return this.getRegisteredInfoOrLogError(id).getAnchor();
    }

    void setToolWindowAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setToolWindowAnchor(id, anchor2, -1);
    }

    private void setToolWindowAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor2, int order) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAnchorImpl(id, anchor2, order, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAnchorImpl(@NotNull String id, @NotNull ToolWindowAnchor anchor2, int order, @NotNull List<? super FinalizableCommand> commandsList) {
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(id);
        if (anchor2 == info.getAnchor() && order == info.getOrder()) {
            return;
        }
        if (!info.isVisible() || anchor2 == info.getAnchor() || info.isFloating() || info.isWindowed()) {
            this.appendRemoveButtonCmd(id, info, commandsList);
            this.myLayout.setAnchor(id, anchor2, order);
            for (WindowInfoImpl info1 : this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
        } else {
            info.setVisible(false);
            this.appendRemoveDecoratorCmd(id, false, commandsList);
            this.appendRemoveButtonCmd(id, info, commandsList);
            this.myLayout.setAnchor(id, anchor2, order);
            for (WindowInfoImpl info1 : this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
            this.showToolWindowImpl(id, false, commandsList);
            if (info.isActive()) {
                this.appendRequestFocusInToolWindowCmd(id, commandsList);
            }
        }
    }

    boolean isSplitMode(@NotNull String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getRegisteredInfoOrLogError(id).isSplit();
    }

    @NotNull
    ToolWindowContentUiType getContentUiType(@NotNull String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getRegisteredInfoOrLogError(id).getContentUiType();
    }

    void setSideTool(@NotNull String id, boolean isSide) {
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setSplitModeImpl(id, isSide, commandList);
        this.execute(commandList);
    }

    void setContentUiType(@NotNull String id, @NotNull ToolWindowContentUiType type) {
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(id);
        info.setContentUiType(type);
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.appendApplyWindowInfoCmd(info, commandList);
        this.execute(commandList);
    }

    void setSideToolAndAnchor(@NotNull String id, @NotNull ToolWindowAnchor anchor2, int order, boolean isSide) {
        this.hideToolWindow(id, false);
        this.myLayout.setSplitMode(id, isSide);
        this.setToolWindowAnchor(id, anchor2, order);
        this.activateToolWindow(id, false, false);
    }

    private void setSplitModeImpl(@NotNull String id, boolean isSplit, @NotNull List<? super FinalizableCommand> commandList) {
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(id);
        if (isSplit == info.isSplit()) {
            return;
        }
        this.myLayout.setSplitMode(id, isSplit);
        boolean wasActive = info.isActive();
        boolean wasVisible = info.isVisible();
        if (wasActive || wasVisible) {
            this.hideToolWindow(id, false);
        }
        for (WindowInfoImpl info1 : this.myLayout.getInfos()) {
            this.appendApplyWindowInfoCmd(info1, commandList);
        }
        if (wasVisible || wasActive) {
            this.showToolWindowImpl(id, true, commandList);
        }
        if (wasActive) {
            this.activateToolWindowImpl(id, commandList, true, true);
        }
        commandList.add(this.myToolWindowsPane.createUpdateButtonPositionCmd(id, this.myCommandProcessor));
    }

    ToolWindowType getToolWindowInternalType(@NotNull String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getRegisteredInfoOrLogError(id).getInternalType();
    }

    ToolWindowType getToolWindowType(@NotNull String id) {
        return this.getRegisteredInfoOrLogError(id).getType();
    }

    private void fireToolWindowRegistered(@NotNull String id) {
        ((ToolWindowManagerListener)this.myProject.getMessageBus().syncPublisher(ToolWindowManagerListener.TOPIC)).toolWindowRegistered(id);
    }

    protected void fireStateChanged() {
        ((ToolWindowManagerListener)this.myProject.getMessageBus().syncPublisher(ToolWindowManagerListener.TOPIC)).stateChanged();
    }

    boolean isToolWindowActive(@NotNull String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getRegisteredInfoOrLogError(id).isActive();
    }

    boolean isToolWindowAutoHide(@NotNull String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getRegisteredInfoOrLogError(id).isAutoHide();
    }

    boolean isToolWindowVisible(@NotNull String id) {
        return this.getRegisteredInfoOrLogError(id).isVisible();
    }

    void setToolWindowAutoHide(@NotNull String id, boolean autoHide) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAutoHideImpl(id, autoHide, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAutoHideImpl(@NotNull String id, boolean autoHide, @NotNull List<? super FinalizableCommand> commandsList) {
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(id);
        if (info.isAutoHide() == autoHide) {
            return;
        }
        info.setAutoHide(autoHide);
        this.appendApplyWindowInfoCmd(info, commandsList);
        if (info.isVisible()) {
            this.deactivateWindows(id, commandsList);
            this.showAndActivate(id, false, commandsList, true);
        }
    }

    void setToolWindowType(@NotNull String id, @NotNull ToolWindowType type) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowTypeImpl(id, type, commandList);
        this.execute(commandList);
    }

    private void setToolWindowTypeImpl(@NotNull String id, @NotNull ToolWindowType type, @NotNull List<? super FinalizableCommand> commandsList) {
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(id);
        if (info.getType() == type) {
            return;
        }
        if (info.isVisible()) {
            boolean dirtyMode = info.isDocked() || info.isSliding();
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else if (info.isWindowed()) {
                this.appendRemoveWindowedDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, dirtyMode, commandsList);
            }
            info.setType(type);
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.deactivateWindows(id, commandsList);
            this.showAndActivate(id, dirtyMode, commandsList, true);
            this.appendUpdateToolWindowsPaneCmd(commandsList);
        } else {
            info.setType(type);
            this.appendApplyWindowInfoCmd(info, commandsList);
        }
    }

    private void appendApplyWindowInfoCmd(@NotNull WindowInfoImpl info, @NotNull List<? super FinalizableCommand> commandsList) {
        StripeButton button2 = this.getStripeButton(Objects.requireNonNull(info.getId()));
        InternalDecorator decorator = this.getInternalDecorator(info.getId());
        commandsList.add(new ApplyWindowInfoCmd(info, button2, decorator, this.myCommandProcessor));
    }

    private void appendAddDecoratorCmd(@NotNull InternalDecorator decorator, @NotNull WindowInfoImpl info, boolean dirtyMode, @NotNull List<? super FinalizableCommand> commandsList) {
        commandsList.add(this.myToolWindowsPane.createAddDecoratorCmd(decorator, info, dirtyMode, this.myCommandProcessor));
    }

    private void appendRemoveDecoratorCmd(@NotNull String id, boolean dirtyMode, @NotNull List<? super FinalizableCommand> commandsList) {
        commandsList.add(this.myToolWindowsPane.createRemoveDecoratorCmd(id, dirtyMode, this.myCommandProcessor));
    }

    private void appendRemoveFloatingDecoratorCmd(@NotNull WindowInfoImpl info, @NotNull List<? super FinalizableCommand> commandsList) {
        commandsList.add(new RemoveFloatingDecoratorCmd(info));
    }

    private void appendRemoveWindowedDecoratorCmd(@NotNull WindowInfoImpl info, @NotNull List<? super FinalizableCommand> commandsList) {
        commandsList.add(new RemoveWindowedDecoratorCmd(info));
    }

    private void appendAddButtonCmd(StripeButton button2, @NotNull WindowInfoImpl info, @NotNull List<? super FinalizableCommand> commandsList) {
        Comparator<StripeButton> comparator2 = this.myLayout.comparator(info.getAnchor());
        commandsList.add(this.myToolWindowsPane.createAddButtonCmd(button2, info, comparator2, this.myCommandProcessor));
    }

    private void appendRemoveButtonCmd(@NotNull String id, @NotNull WindowInfoImpl info, @NotNull List<? super FinalizableCommand> commandsList) {
        FinalizableCommand cmd = this.myToolWindowsPane.createRemoveButtonCmd(info, id, this.myCommandProcessor);
        if (cmd != null) {
            commandsList.add(cmd);
        }
    }

    private void appendRequestFocusInToolWindowCmd(String id, List<? super FinalizableCommand> commandList) {
        ToolWindowImpl toolWindow = (ToolWindowImpl)this.getToolWindow(id);
        FocusWatcher focusWatcher = this.myId2FocusWatcher.get(id);
        commandList.add(new RequestFocusInToolWindowCmd(this.getFocusManager(), toolWindow, focusWatcher, this.myCommandProcessor, this.myProject));
    }

    private void appendSetEditorComponentCmd(@Nullable JComponent component, @NotNull List<? super FinalizableCommand> commandsList) {
        commandsList.add(this.myToolWindowsPane.createSetEditorComponentCmd(component, this.myCommandProcessor));
    }

    private void appendUpdateToolWindowsPaneCmd(List<? super FinalizableCommand> commandsList) {
        JRootPane rootPane = this.myFrame.getRootPane();
        if (rootPane != null) {
            commandsList.add(new UpdateRootPaneCmd(rootPane, this.myCommandProcessor));
        }
    }

    private EditorsSplitters getSplittersToFocus() {
        Window activeWindow = this.myWindowManager.getMostRecentFocusedWindow();
        if (activeWindow instanceof FloatingDecorator) {
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            activeWindow = (Window)ObjectUtils.notNull((Object)lastFocusedWindow, (Object)activeWindow);
            FileEditorManagerEx fem = FileEditorManagerEx.getInstanceEx(Objects.requireNonNull(lastFocusedFrame.getProject()));
            EditorsSplitters splitters = fem.getSplittersFor(activeWindow);
            return splitters != null ? splitters : fem.getSplitters();
        }
        if (activeWindow instanceof IdeFrame.Child) {
            Project project = ((IdeFrame.Child)activeWindow).getProject();
            activeWindow = WindowManager.getInstance().getFrame(project);
            FileEditorManagerEx fem = FileEditorManagerEx.getInstanceEx(Objects.requireNonNull(project));
            EditorsSplitters splitters = activeWindow != null ? fem.getSplittersFor(activeWindow) : null;
            return splitters != null ? splitters : fem.getSplitters();
        }
        IdeFrame frame = FocusManagerImpl.getInstance().getLastFocusedFrame();
        if (frame instanceof IdeFrameImpl && ((IdeFrameImpl)frame).isActive()) {
            FileEditorManagerEx fem = FileEditorManagerEx.getInstanceEx(Objects.requireNonNull(frame.getProject()));
            EditorsSplitters splitters = activeWindow != null ? fem.getSplittersFor(activeWindow) : null;
            return splitters != null ? splitters : fem.getSplitters();
        }
        return null;
    }

    @Override
    public void clearSideStack() {
        this.mySideStack.clear();
    }

    @Nullable
    public Element getState() {
        Element layoutToRestoreElement;
        Element layoutElement;
        if (this.myFrame == null) {
            return null;
        }
        for (WindowInfoImpl info : this.myLayout.getInfos()) {
            if (!info.isVisible()) continue;
            InternalDecorator decorator = this.getInternalDecorator(Objects.requireNonNull(info.getId()));
            LOG.assertTrue(decorator != null);
            decorator.fireResized();
        }
        Element element = new Element("state");
        Rectangle frameBounds = this.myFrame.getBounds();
        Element frameElement = new Element(FRAME_ELEMENT);
        element.addContent(frameElement);
        frameElement.setAttribute(X_ATTR, Integer.toString(frameBounds.x));
        frameElement.setAttribute(Y_ATTR, Integer.toString(frameBounds.y));
        frameElement.setAttribute(WIDTH_ATTR, Integer.toString(frameBounds.width));
        frameElement.setAttribute(HEIGHT_ATTR, Integer.toString(frameBounds.height));
        frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(this.myFrame.getExtendedState()));
        if (this.isEditorComponentActive()) {
            Element editorElement = new Element(EDITOR_ELEMENT);
            editorElement.setAttribute(ACTIVE_ATTR_VALUE, "true");
            element.addContent(editorElement);
        }
        if ((layoutElement = this.myLayout.writeExternal("layout")) != null) {
            element.addContent(layoutElement);
        }
        Element element2 = layoutToRestoreElement = this.myLayoutToRestoreLater == null ? null : this.myLayoutToRestoreLater.writeExternal(LAYOUT_TO_RESTORE);
        if (layoutToRestoreElement != null) {
            element.addContent(layoutToRestoreElement);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        for (Element e : state.getChildren()) {
            if ("layout".equals(e.getName())) {
                this.myLayout.readExternal(e);
                continue;
            }
            if (!LAYOUT_TO_RESTORE.equals(e.getName())) continue;
            this.myLayoutToRestoreLater = new DesktopLayout();
            this.myLayoutToRestoreLater.readExternal(e);
        }
    }

    public void setDefaultState(@NotNull ToolWindowImpl toolWindow, @Nullable ToolWindowAnchor anchor2, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds2) {
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(toolWindow.getId());
        if (info.isWasRead()) {
            return;
        }
        if (floatingBounds2 != null) {
            info.setFloatingBounds(floatingBounds2);
        }
        if (anchor2 != null) {
            toolWindow.setAnchor(anchor2, null);
        }
        if (type != null) {
            toolWindow.setType(type, null);
        }
    }

    void setDefaultContentUiType(@NotNull ToolWindowImpl toolWindow, @NotNull ToolWindowContentUiType type) {
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(toolWindow.getId());
        if (info.isWasRead()) {
            return;
        }
        toolWindow.setContentUiType(type, null);
    }

    void stretchWidth(@NotNull ToolWindowImpl toolWindow, int value) {
        this.myToolWindowsPane.stretchWidth(toolWindow, value);
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        return this.myToolWindowsPane.isMaximized(wnd);
    }

    public void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
        if (wnd.getType() == ToolWindowType.FLOATING && wnd instanceof ToolWindowImpl) {
            MaximizeActiveDialogAction.doMaximize(this.getFloatingDecorator(((ToolWindowImpl)wnd).getId()));
            return;
        }
        if (wnd.getType() == ToolWindowType.WINDOWED && wnd instanceof ToolWindowImpl) {
            Frame frame;
            WindowedDecorator decorator = this.getWindowedDecorator(((ToolWindowImpl)wnd).getId());
            Frame frame2 = frame = decorator != null && decorator.getFrame() instanceof Frame ? (Frame)decorator.getFrame() : null;
            if (frame != null) {
                int state = frame.getState();
                if (state == 0) {
                    frame.setState(6);
                } else if (state == 6) {
                    frame.setState(0);
                }
            }
            return;
        }
        this.myToolWindowsPane.setMaximized(wnd, maximized);
    }

    void stretchHeight(ToolWindowImpl toolWindow, int value) {
        this.myToolWindowsPane.stretchHeight(toolWindow, value);
    }

    @NotNull
    private static Rectangle getRootBounds(JFrame frame) {
        JRootPane rootPane = frame.getRootPane();
        Rectangle bounds2 = rootPane.getBounds();
        bounds2.setLocation(frame.getX() + rootPane.getX(), frame.getY() + rootPane.getY());
        return bounds2;
    }

    private void focusToolWindowByDefault(@Nullable String idToIgnore) {
        String toFocus = null;
        for (String each : this.myActiveStack.getStack()) {
            if (idToIgnore != null && idToIgnore.equalsIgnoreCase(each) || !this.getRegisteredInfoOrLogError(each).isVisible()) continue;
            toFocus = each;
            break;
        }
        if (toFocus == null) {
            for (String each : this.myActiveStack.getPersistentStack()) {
                if (idToIgnore != null && idToIgnore.equalsIgnoreCase(each) || !this.getRegisteredInfoOrLogError(each).isVisible()) continue;
                toFocus = each;
                break;
            }
        }
        if (toFocus != null && !ApplicationManager.getApplication().isDisposeInProgress() && !ApplicationManager.getApplication().isDisposed()) {
            this.activateToolWindow(toFocus, false, true);
        }
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        return IdeFocusManager.getInstance((Project)this.myProject).requestFocus(c, forced);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2) {
        IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(runnable2);
    }

    void setShowStripeButton(@NotNull String id, boolean visibleOnPanel) {
        WindowInfoImpl info = this.getRegisteredInfoOrLogError(id);
        if (visibleOnPanel == info.isShowStripeButton()) {
            return;
        }
        info.setShowStripeButton(visibleOnPanel);
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.appendApplyWindowInfoCmd(info, commandList);
        this.execute(commandList);
    }

    boolean isShowStripeButton(@NotNull String id) {
        WindowInfoImpl info = this.myLayout.getInfo(id, true);
        return info == null || info.isShowStripeButton();
    }

    public static class InitToolWindowsActivity
    implements StartupActivity,
    DumbAware {
        public void runActivity(@NotNull Project project) {
            ToolWindowManagerEx ex = ToolWindowManagerEx.getInstanceEx(project);
            if (ex instanceof ToolWindowManagerImpl) {
                ToolWindowManagerImpl manager = (ToolWindowManagerImpl)ex;
                ArrayList list2 = new ArrayList();
                manager.registerToolWindowsFromBeans(list2);
                manager.initAll(list2);
                EdtInvocationManager.getInstance().invokeLater(() -> {
                    manager.execute(list2);
                    manager.flushCommands();
                });
            }
        }
    }

    private final class MyInternalDecoratorListener
    implements InternalDecoratorListener {
        private MyInternalDecoratorListener() {
        }

        @Override
        public void anchorChanged(@NotNull InternalDecorator source, @NotNull ToolWindowAnchor anchor2) {
            ToolWindowManagerImpl.this.setToolWindowAnchor(source.getToolWindow().getId(), anchor2);
        }

        @Override
        public void autoHideChanged(@NotNull InternalDecorator source, boolean autoHide) {
            ToolWindowManagerImpl.this.setToolWindowAutoHide(source.getToolWindow().getId(), autoHide);
        }

        @Override
        public void hidden(@NotNull InternalDecorator source) {
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), false);
        }

        @Override
        public void hiddenSide(@NotNull InternalDecorator source) {
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), true);
        }

        @Override
        public void contentUiTypeChanges(@NotNull InternalDecorator source, @NotNull ToolWindowContentUiType type) {
            ToolWindowManagerImpl.this.setContentUiType(source.getToolWindow().getId(), type);
        }

        @Override
        public void resized(@NotNull InternalDecorator source) {
            if (!source.isShowing()) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getRegisteredInfoOrLogError(source.getToolWindow().getId());
            if (info.isFloating()) {
                Window owner = SwingUtilities.getWindowAncestor(source);
                if (owner != null) {
                    info.setFloatingBounds(owner.getBounds());
                }
            } else if (info.isWindowed()) {
                Window frame;
                WindowedDecorator decorator = ToolWindowManagerImpl.this.getWindowedDecorator(Objects.requireNonNull(info.getId()));
                Window window = frame = decorator != null ? decorator.getFrame() : null;
                if (frame == null || !frame.isShowing()) {
                    return;
                }
                info.setFloatingBounds(ToolWindowManagerImpl.getRootBounds((JFrame)frame));
            } else {
                ToolWindowAnchor anchor2 = info.getAnchor();
                InternalDecorator another = null;
                if (source.getParent() instanceof Splitter) {
                    float sizeInSplit = anchor2.isSplitVertically() ? (float)source.getHeight() : (float)source.getWidth();
                    Splitter splitter = (Splitter)source.getParent();
                    if (splitter.getSecondComponent() == source) {
                        sizeInSplit += (float)splitter.getDividerWidth();
                        another = (InternalDecorator)splitter.getFirstComponent();
                    } else {
                        another = (InternalDecorator)splitter.getSecondComponent();
                    }
                    if (anchor2.isSplitVertically()) {
                        info.setSideWeight(sizeInSplit / (float)splitter.getHeight());
                    } else {
                        info.setSideWeight(sizeInSplit / (float)splitter.getWidth());
                    }
                }
                float paneWeight = anchor2.isHorizontal() ? (float)source.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight() : (float)source.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                info.setWeight(paneWeight);
                if (another != null && anchor2.isSplitVertically()) {
                    paneWeight = anchor2.isHorizontal() ? (float)another.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight() : (float)another.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                    another.getWindowInfo().setWeight(paneWeight);
                }
            }
        }

        @Override
        public void activated(@NotNull InternalDecorator source) {
            ToolWindowManagerImpl.this.activateToolWindow(source.getToolWindow().getId(), true, true);
        }

        @Override
        public void typeChanged(@NotNull InternalDecorator source, @NotNull ToolWindowType type) {
            ToolWindowManagerImpl.this.setToolWindowType(source.getToolWindow().getId(), type);
        }

        @Override
        public void sideStatusChanged(@NotNull InternalDecorator source, boolean isSideTool) {
            ToolWindowManagerImpl.this.setSideTool(source.getToolWindow().getId(), isSideTool);
        }

        @Override
        public void visibleStripeButtonChanged(@NotNull InternalDecorator source, boolean visible) {
            ToolWindowManagerImpl.this.setShowStripeButton(source.getToolWindow().getId(), visible);
        }
    }

    private final class MyToolWindowPropertyChangeListener
    implements PropertyChangeListener {
        private MyToolWindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            StripeButton button2;
            ToolWindowImpl toolWindow = (ToolWindowImpl)e.getSource();
            if ("available".equals(e.getPropertyName())) {
                WindowInfoImpl info = ToolWindowManagerImpl.this.getRegisteredInfoOrLogError(toolWindow.getId());
                if (!toolWindow.isAvailable() && info.isVisible()) {
                    ToolWindowManagerImpl.this.hideToolWindow(toolWindow.getId(), false);
                }
            }
            if ((button2 = (StripeButton)ToolWindowManagerImpl.this.myId2StripeButton.get(toolWindow.getId())) != null) {
                button2.updatePresentation();
            }
            ActivateToolWindowAction.updateToolWindowActionPresentation(toolWindow);
        }
    }

    private final class ToolWindowFocusWatcher
    extends FocusWatcher {
        private final String myId;
        private final ToolWindowImpl myToolWindow;

        private ToolWindowFocusWatcher(ToolWindowImpl toolWindow) {
            this.myId = toolWindow.getId();
            this.install(toolWindow.getComponent());
            this.myToolWindow = toolWindow;
        }

        public void deinstall() {
            this.deinstall(this.myToolWindow.getComponent());
        }

        protected boolean isFocusedComponentChangeValid(Component comp, AWTEvent cause) {
            return ToolWindowManagerImpl.this.myCommandProcessor.getCommandCount() == 0 && comp != null;
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            if (ToolWindowManagerImpl.this.myCommandProcessor.getCommandCount() > 0 || component == null) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getRegisteredInfoOrLogError(this.myId);
            if (!info.isActive()) {
                ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new EdtRunnable(){

                    public void runEdt() {
                        WindowInfoImpl windowInfo = ToolWindowManagerImpl.this.myLayout.getInfo(ToolWindowFocusWatcher.this.myId, true);
                        if (windowInfo == null || !windowInfo.isVisible()) {
                            return;
                        }
                        ToolWindowManagerImpl.this.activateToolWindow(ToolWindowFocusWatcher.this.myId, false, false);
                    }
                });
            }
        }
    }

    private final class RemoveWindowedDecoratorCmd
    extends FinalizableCommand {
        private final WindowedDecorator myWindowedDecorator;

        private RemoveWindowedDecoratorCmd(WindowInfoImpl info) {
            boolean maximized;
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myWindowedDecorator = ToolWindowManagerImpl.this.getWindowedDecorator(Objects.requireNonNull(info.getId()));
            ToolWindowManagerImpl.this.myId2WindowedDecorator.remove(info.getId());
            Window frame = this.myWindowedDecorator.getFrame();
            if (!frame.isShowing()) {
                return;
            }
            boolean bl = maximized = ((JFrame)frame).getExtendedState() == 6;
            if (maximized) {
                ((JFrame)frame).setExtendedState(0);
                frame.invalidate();
                frame.revalidate();
            }
            Rectangle bounds2 = ToolWindowManagerImpl.getRootBounds((JFrame)frame);
            info.setFloatingBounds(bounds2);
            info.setMaximized(maximized);
        }

        @Override
        public void run() {
            try {
                Disposer.dispose((Disposable)this.myWindowedDecorator);
            }
            finally {
                this.finish();
            }
        }

        @Override
        @NotNull
        public Condition getExpireCondition() {
            return ApplicationManager.getApplication().getDisposed();
        }
    }

    private final class AddWindowedDecoratorCmd
    extends FinalizableCommand {
        private final WindowedDecorator myWindowedDecorator;
        private final boolean myShouldBeMaximized;

        private AddWindowedDecoratorCmd(@NotNull InternalDecorator decorator, WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myWindowedDecorator = new WindowedDecorator(ToolWindowManagerImpl.this.myProject, info.copy(), decorator);
            this.myShouldBeMaximized = info.isMaximized();
            Window window = this.myWindowedDecorator.getFrame();
            Rectangle bounds2 = info.getFloatingBounds();
            if (bounds2 != null && bounds2.width > 0 && bounds2.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds2.x, bounds2.y, bounds2.width)) {
                window.setBounds(new Rectangle(bounds2));
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                window.setSize(size);
                window.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
            ToolWindowManagerImpl.this.myId2WindowedDecorator.put(info.getId(), this.myWindowedDecorator);
            this.myWindowedDecorator.addDisposable(() -> {
                if (ToolWindowManagerImpl.this.myId2WindowedDecorator.get(info.getId()) != null) {
                    ToolWindowManagerImpl.this.hideToolWindow(Objects.requireNonNull(info.getId()), false);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.myWindowedDecorator.show(false);
                Window window = this.myWindowedDecorator.getFrame();
                JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                Rectangle rootPaneBounds = rootPane.getBounds();
                Point point = rootPane.getLocationOnScreen();
                Rectangle windowBounds = window.getBounds();
                window.setLocation(2 * windowBounds.x - point.x, 2 * windowBounds.y - point.y);
                window.setSize(2 * windowBounds.width - rootPaneBounds.width, 2 * windowBounds.height - rootPaneBounds.height);
                if (this.myShouldBeMaximized && window instanceof Frame) {
                    ((Frame)window).setExtendedState(6);
                }
                window.toFront();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private RemoveFloatingDecoratorCmd(WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myFloatingDecorator = ToolWindowManagerImpl.this.getFloatingDecorator(Objects.requireNonNull(info.getId()));
            ToolWindowManagerImpl.this.myId2FloatingDecorator.remove(info.getId());
            info.setFloatingBounds(this.myFloatingDecorator.getBounds());
        }

        @Override
        public void run() {
            try {
                this.myFloatingDecorator.dispose();
            }
            finally {
                this.finish();
            }
        }

        @Override
        @NotNull
        public Condition getExpireCondition() {
            return ApplicationManager.getApplication().getDisposed();
        }
    }

    private final class AddFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private AddFloatingDecoratorCmd(@NotNull InternalDecorator decorator, WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myCommandProcessor);
            this.myFloatingDecorator = new FloatingDecorator(ToolWindowManagerImpl.this.myFrame, info.copy(), decorator);
            ToolWindowManagerImpl.this.myId2FloatingDecorator.put(info.getId(), this.myFloatingDecorator);
            Rectangle bounds2 = info.getFloatingBounds();
            if (bounds2 != null && bounds2.width > 0 && bounds2.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds2.x, bounds2.y, bounds2.width)) {
                this.myFloatingDecorator.setBounds(new Rectangle(bounds2));
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                this.myFloatingDecorator.setSize(size);
                this.myFloatingDecorator.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
        }

        @Override
        public void run() {
            try {
                this.myFloatingDecorator.show();
            }
            finally {
                this.finish();
            }
        }
    }

    private static class BalloonHyperlinkListener
    implements HyperlinkListener {
        private Balloon myBalloon;
        private final HyperlinkListener myListener;

        BalloonHyperlinkListener(HyperlinkListener listener2) {
            this.myListener = listener2;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (this.myBalloon != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.myBalloon.hide();
            }
            if (this.myListener != null) {
                this.myListener.hyperlinkUpdate(e);
            }
        }
    }

    private static enum KeyState {
        waiting,
        pressed,
        released,
        hold;

    }
}

