/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.Surface;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.reference.SoftReference;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowsPane
extends JBLayeredPane
implements UISettingsListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowsPane");
    private final IdeFrameImpl myFrame;
    private final Map<String, StripeButton> myId2Button = new HashMap<String, StripeButton>();
    private final Map<String, InternalDecorator> myId2Decorator = new HashMap<String, InternalDecorator>();
    private final Map<InternalDecorator, WindowInfoImpl> myDecorator2Info = new HashMap<InternalDecorator, WindowInfoImpl>();
    private final Map<String, Float> myId2SplitProportion = new HashMap<String, Float>();
    private Pair<ToolWindow, Integer> myMaximizedProportion;
    private final MyLayeredPane myLayeredPane;
    private final ThreeComponentsSplitter myVerticalSplitter;
    private final ThreeComponentsSplitter myHorizontalSplitter;
    private final Stripe myLeftStripe;
    private final Stripe myRightStripe;
    private final Stripe myBottomStripe;
    private final Stripe myTopStripe;
    private final List<Stripe> myStripes = new ArrayList<Stripe>();
    private final ToolWindowManagerImpl myManager;
    private boolean myStripesOverlayed;
    private boolean myWidescreen;
    private boolean myLeftHorizontalSplit;
    private boolean myRightHorizontalSplit;

    ToolWindowsPane(@NotNull IdeFrameImpl frame, @NotNull ToolWindowManagerImpl manager) {
        this.myManager = manager;
        this.setOpaque(false);
        this.myFrame = frame;
        this.myVerticalSplitter = new ThreeComponentsSplitter(true);
        RegistryValue registryValue = Registry.get((String)"ide.mainSplitter.min.size");
        registryValue.addListener((RegistryValueListener)new RegistryValueListener.Adapter(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                ToolWindowsPane.this.updateInnerMinSize(value);
            }
        }, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myVerticalSplitter);
        this.myVerticalSplitter.setDividerWidth(0);
        this.myVerticalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myVerticalSplitter.setBackground(Color.gray);
        this.myHorizontalSplitter = new ThreeComponentsSplitter(false);
        Disposer.register((Disposable)this, (Disposable)this.myHorizontalSplitter);
        this.myHorizontalSplitter.setDividerWidth(0);
        this.myHorizontalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myHorizontalSplitter.setBackground(Color.gray);
        this.updateInnerMinSize(registryValue);
        this.myWidescreen = UISettings.getInstance().getWideScreenSupport();
        this.myLeftHorizontalSplit = UISettings.getInstance().getLeftHorizontalSplit();
        this.myRightHorizontalSplit = UISettings.getInstance().getRightHorizontalSplit();
        if (this.myWidescreen) {
            this.myHorizontalSplitter.setInnerComponent((JComponent)this.myVerticalSplitter);
        } else {
            this.myVerticalSplitter.setInnerComponent((JComponent)this.myHorizontalSplitter);
        }
        this.myTopStripe = new Stripe(1, manager);
        this.myStripes.add(this.myTopStripe);
        this.myLeftStripe = new Stripe(2, manager);
        this.myStripes.add(this.myLeftStripe);
        this.myBottomStripe = new Stripe(3, manager);
        this.myStripes.add(this.myBottomStripe);
        this.myRightStripe = new Stripe(4, manager);
        this.myStripes.add(this.myRightStripe);
        this.updateToolStripesVisibility();
        this.myLayeredPane = new MyLayeredPane((JComponent)(this.myWidescreen ? this.myHorizontalSplitter : this.myVerticalSplitter));
        this.add(this.myTopStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myLeftStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myBottomStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myRightStripe, JLayeredPane.POPUP_LAYER);
        this.add((Component)((Object)this.myLayeredPane), JLayeredPane.DEFAULT_LAYER);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt());
    }

    private void updateInnerMinSize(@NotNull RegistryValue value) {
        int minSize = Math.max(0, Math.min(100, value.asInteger()));
        this.myVerticalSplitter.setMinSize(JBUI.scale((int)minSize));
        this.myHorizontalSplitter.setMinSize(JBUI.scale((int)minSize));
    }

    public void doLayout() {
        Dimension size = this.getSize();
        if (!this.myTopStripe.isVisible()) {
            this.myTopStripe.setBounds(0, 0, 0, 0);
            this.myBottomStripe.setBounds(0, 0, 0, 0);
            this.myLeftStripe.setBounds(0, 0, 0, 0);
            this.myRightStripe.setBounds(0, 0, 0, 0);
            this.myLayeredPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        } else {
            Dimension topSize = this.myTopStripe.getPreferredSize();
            Dimension bottomSize = this.myBottomStripe.getPreferredSize();
            Dimension leftSize = this.myLeftStripe.getPreferredSize();
            Dimension rightSize = this.myRightStripe.getPreferredSize();
            this.myTopStripe.setBounds(0, 0, size.width, topSize.height);
            this.myLeftStripe.setBounds(0, topSize.height, leftSize.width, size.height - topSize.height - bottomSize.height);
            this.myRightStripe.setBounds(size.width - rightSize.width, topSize.height, rightSize.width, size.height - topSize.height - bottomSize.height);
            this.myBottomStripe.setBounds(0, size.height - bottomSize.height, size.width, bottomSize.height);
            if (UISettings.getInstance().getHideToolStripes() || UISettings.getInstance().getPresentationMode()) {
                this.myLayeredPane.setBounds(0, 0, size.width, size.height);
            } else {
                this.myLayeredPane.setBounds(leftSize.width, topSize.height, size.width - leftSize.width - rightSize.width, size.height - topSize.height - bottomSize.height);
            }
        }
    }

    public final void addNotify() {
        super.addNotify();
    }

    public Project getProject() {
        return this.myFrame.getProject();
    }

    public final void uiSettingsChanged(UISettings uiSettings) {
        this.updateToolStripesVisibility();
        this.updateLayout();
    }

    @NotNull
    final FinalizableCommand createAddButtonCmd(StripeButton button2, @NotNull WindowInfoImpl info, @NotNull Comparator<StripeButton> comparator2, @NotNull Runnable finishCallBack) {
        WindowInfoImpl copiedInfo = info.copy();
        this.myId2Button.put(copiedInfo.getId(), button2);
        return new AddToolStripeButtonCmd(button2, copiedInfo, comparator2, finishCallBack);
    }

    @NotNull
    final FinalizableCommand createAddDecoratorCmd(@NotNull InternalDecorator decorator, @NotNull WindowInfoImpl info, boolean dirtyMode, @NotNull Runnable finishCallBack) {
        WindowInfoImpl copiedInfo = info.copy();
        String id = copiedInfo.getId();
        this.myDecorator2Info.put(decorator, copiedInfo);
        this.myId2Decorator.put(id, decorator);
        if (info.isDocked()) {
            WindowInfoImpl sideInfo = this.getDockedInfoAt(info.getAnchor(), !info.isSplit());
            return sideInfo == null ? new AddDockedComponentCmd(decorator, info, dirtyMode, finishCallBack) : new AddAndSplitDockedComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        if (info.isSliding()) {
            return new AddSlidingComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        throw new IllegalArgumentException("Unknown window type: " + info.getType());
    }

    @Nullable
    final FinalizableCommand createRemoveButtonCmd(@NotNull WindowInfoImpl info, @NotNull String id, @NotNull Runnable finishCallBack) {
        StripeButton button2 = this.myId2Button.remove(id);
        if (button2 == null) {
            return null;
        }
        return new RemoveToolStripeButtonCmd(button2, info, finishCallBack);
    }

    @NotNull
    final FinalizableCommand createRemoveDecoratorCmd(@NotNull String id, boolean dirtyMode, @NotNull Runnable finishCallBack) {
        InternalDecorator decorator = this.getDecoratorById(id);
        WindowInfoImpl info = this.getDecoratorInfoById(id);
        this.myDecorator2Info.remove(decorator);
        this.myId2Decorator.remove(id);
        WindowInfoImpl sideInfo = this.getDockedInfoAt(info.getAnchor(), !info.isSplit());
        if (info.isDocked()) {
            return sideInfo == null ? new RemoveDockedComponentCmd(info, dirtyMode, finishCallBack) : new RemoveSplitAndDockedComponentCmd(info, dirtyMode, finishCallBack);
        }
        if (info.isSliding()) {
            return new RemoveSlidingComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        throw new IllegalArgumentException("Unknown window type");
    }

    @NotNull
    final FinalizableCommand createSetEditorComponentCmd(JComponent component, @NotNull Runnable finishCallBack) {
        return new SetEditorComponentCmd(component, finishCallBack);
    }

    @NotNull
    final FinalizableCommand createUpdateButtonPositionCmd(@NotNull String id, @NotNull Runnable finishCallback) {
        return new UpdateButtonPositionCmd(id, finishCallback);
    }

    @NotNull
    public final JComponent getMyLayeredPane() {
        return this.myLayeredPane;
    }

    private InternalDecorator getDecoratorById(String id) {
        return this.myId2Decorator.get(id);
    }

    private WindowInfoImpl getDecoratorInfoById(String id) {
        return this.myDecorator2Info.get(this.myId2Decorator.get(id));
    }

    private void setComponent(JComponent component, @NotNull ToolWindowAnchor anchor2, float weight2) {
        if (ToolWindowAnchor.TOP == anchor2) {
            this.myVerticalSplitter.setFirstComponent(component);
            this.myVerticalSplitter.setFirstSize((int)((float)this.myLayeredPane.getHeight() * weight2));
        } else if (ToolWindowAnchor.LEFT == anchor2) {
            this.myHorizontalSplitter.setFirstComponent(component);
            this.myHorizontalSplitter.setFirstSize((int)((float)this.myLayeredPane.getWidth() * weight2));
        } else if (ToolWindowAnchor.BOTTOM == anchor2) {
            this.myVerticalSplitter.setLastComponent(component);
            this.myVerticalSplitter.setLastSize((int)((float)this.myLayeredPane.getHeight() * weight2));
        } else if (ToolWindowAnchor.RIGHT == anchor2) {
            this.myHorizontalSplitter.setLastComponent(component);
            this.myHorizontalSplitter.setLastSize((int)((float)this.myLayeredPane.getWidth() * weight2));
        } else {
            LOG.error("unknown anchor: " + anchor2);
        }
    }

    private JComponent getComponentAt(@NotNull ToolWindowAnchor anchor2) {
        if (ToolWindowAnchor.TOP == anchor2) {
            return this.myVerticalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.LEFT == anchor2) {
            return this.myHorizontalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.BOTTOM == anchor2) {
            return this.myVerticalSplitter.getLastComponent();
        }
        if (ToolWindowAnchor.RIGHT == anchor2) {
            return this.myHorizontalSplitter.getLastComponent();
        }
        LOG.error("unknown anchor: " + anchor2);
        return null;
    }

    private float getPreferredSplitProportion(@NotNull String id, float defaultValue) {
        Float f = this.myId2SplitProportion.get(id);
        return f == null ? defaultValue : f.floatValue();
    }

    private WindowInfoImpl getDockedInfoAt(@NotNull ToolWindowAnchor anchor2, boolean side) {
        for (WindowInfoImpl info : this.myDecorator2Info.values()) {
            if (!info.isVisible() || !info.isDocked() || info.getAnchor() != anchor2 || side != info.isSplit()) continue;
            return info;
        }
        return null;
    }

    private void setDocumentComponent(JComponent component) {
        (this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter).setInnerComponent(component);
    }

    private void updateToolStripesVisibility() {
        boolean oldVisible = this.myLeftStripe.isVisible();
        boolean showButtons = !UISettings.getInstance().getHideToolStripes() && !UISettings.getInstance().getPresentationMode();
        boolean visible = showButtons || this.myStripesOverlayed;
        this.myLeftStripe.setVisible(visible);
        this.myRightStripe.setVisible(visible);
        this.myTopStripe.setVisible(visible);
        this.myBottomStripe.setVisible(visible);
        boolean overlayed = !showButtons && this.myStripesOverlayed;
        this.myLeftStripe.setOverlayed(overlayed);
        this.myRightStripe.setOverlayed(overlayed);
        this.myTopStripe.setOverlayed(overlayed);
        this.myBottomStripe.setOverlayed(overlayed);
        if (oldVisible != visible) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getBottomHeight() {
        return this.myBottomStripe.isVisible() ? this.myBottomStripe.getHeight() : 0;
    }

    public boolean isBottomSideToolWindowsVisible() {
        return this.getComponentAt(ToolWindowAnchor.BOTTOM) != null;
    }

    @Nullable
    Stripe getStripeFor(String id) {
        ToolWindow window = this.myManager.getToolWindow(id);
        if (window == null) {
            return null;
        }
        ToolWindowAnchor anchor2 = this.myManager.getToolWindow(id).getAnchor();
        if (ToolWindowAnchor.TOP == anchor2) {
            return this.myTopStripe;
        }
        if (ToolWindowAnchor.BOTTOM == anchor2) {
            return this.myBottomStripe;
        }
        if (ToolWindowAnchor.LEFT == anchor2) {
            return this.myLeftStripe;
        }
        if (ToolWindowAnchor.RIGHT == anchor2) {
            return this.myRightStripe;
        }
        throw new IllegalArgumentException("Anchor=" + anchor2);
    }

    @Nullable
    Stripe getStripeFor(@NotNull Rectangle screenRec, @NotNull Stripe preferred) {
        if (preferred.containsScreen(screenRec)) {
            return this.myStripes.get(this.myStripes.indexOf(preferred));
        }
        for (Stripe each : this.myStripes) {
            if (!each.containsScreen(screenRec)) continue;
            return this.myStripes.get(this.myStripes.indexOf(each));
        }
        return null;
    }

    void startDrag() {
        for (Stripe each : this.myStripes) {
            each.startDrag();
        }
    }

    void stopDrag() {
        for (Stripe each : this.myStripes) {
            each.stopDrag();
        }
    }

    void stretchWidth(@NotNull ToolWindow wnd, int value) {
        this.stretch(wnd, value);
    }

    void stretchHeight(@NotNull ToolWindow wnd, int value) {
        this.stretch(wnd, value);
    }

    private void stretch(@NotNull ToolWindow wnd, int value) {
        Pair<Resizer, Component> pair = this.findResizerAndComponent(wnd);
        if (pair == null) {
            return;
        }
        boolean vertical = wnd.getAnchor() == ToolWindowAnchor.TOP || wnd.getAnchor() == ToolWindowAnchor.BOTTOM;
        int actualSize = (vertical ? ((Component)pair.second).getHeight() : ((Component)pair.second).getWidth()) + value;
        boolean first = wnd.getAnchor() == ToolWindowAnchor.LEFT || wnd.getAnchor() == ToolWindowAnchor.TOP;
        int maxValue = vertical ? this.myVerticalSplitter.getMaxSize(first) : this.myHorizontalSplitter.getMaxSize(first);
        int minValue = vertical ? this.myVerticalSplitter.getMinSize(first) : this.myHorizontalSplitter.getMinSize(first);
        ((Resizer)pair.first).setSize(Math.max(minValue, Math.min(maxValue, actualSize)));
    }

    @Nullable
    private Pair<Resizer, Component> findResizerAndComponent(@NotNull ToolWindow wnd) {
        if (!wnd.isVisible()) {
            return null;
        }
        Resizer resizer = null;
        Container cmp = null;
        if (wnd.getType() == ToolWindowType.DOCKED) {
            cmp = this.getComponentAt(wnd.getAnchor());
            if (cmp != null) {
                resizer = wnd.getAnchor().isHorizontal() ? (this.myVerticalSplitter.getFirstComponent() == cmp ? new Resizer.Splitter.FirstComponent(this.myVerticalSplitter) : new Resizer.Splitter.LastComponent(this.myVerticalSplitter)) : (this.myHorizontalSplitter.getFirstComponent() == cmp ? new Resizer.Splitter.FirstComponent(this.myHorizontalSplitter) : new Resizer.Splitter.LastComponent(this.myHorizontalSplitter));
            }
        } else if (wnd.getType() == ToolWindowType.SLIDING) {
            for (cmp = wnd.getComponent(); cmp != null && cmp.getParent() != this.myLayeredPane; cmp = cmp.getParent()) {
            }
            if (cmp != null) {
                if (wnd.getAnchor() == ToolWindowAnchor.TOP) {
                    resizer = new Resizer.LayeredPane.Top(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.BOTTOM) {
                    resizer = new Resizer.LayeredPane.Bottom(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.LEFT) {
                    resizer = new Resizer.LayeredPane.Left(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.RIGHT) {
                    resizer = new Resizer.LayeredPane.Right(cmp);
                }
            }
        }
        return resizer != null ? Pair.create(resizer, (Object)cmp) : null;
    }

    private void updateLayout() {
        InternalDecorator second;
        InternalDecorator first;
        Splitter splitter;
        JComponent component;
        UISettings uiSettings = UISettings.getInstance();
        if (this.myWidescreen != uiSettings.getWideScreenSupport()) {
            JComponent documentComponent = (this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter).getInnerComponent();
            this.myWidescreen = uiSettings.getWideScreenSupport();
            if (this.myWidescreen) {
                this.myVerticalSplitter.setInnerComponent(null);
                this.myHorizontalSplitter.setInnerComponent((JComponent)this.myVerticalSplitter);
            } else {
                this.myHorizontalSplitter.setInnerComponent(null);
                this.myVerticalSplitter.setInnerComponent((JComponent)this.myHorizontalSplitter);
            }
            this.myLayeredPane.remove((Component)(this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter));
            this.myLayeredPane.add((Component)(this.myWidescreen ? this.myHorizontalSplitter : this.myVerticalSplitter), DEFAULT_LAYER);
            this.setDocumentComponent(documentComponent);
        }
        if (this.myLeftHorizontalSplit != uiSettings.getLeftHorizontalSplit()) {
            component = this.getComponentAt(ToolWindowAnchor.LEFT);
            if (component instanceof Splitter) {
                splitter = (Splitter)component;
                first = (InternalDecorator)splitter.getFirstComponent();
                second = (InternalDecorator)splitter.getSecondComponent();
                this.setComponent((JComponent)splitter, ToolWindowAnchor.LEFT, ToolWindowAnchor.LEFT.isSplitVertically() ? first.getWindowInfo().getWeight() : first.getWindowInfo().getWeight() + second.getWindowInfo().getWeight());
            }
            this.myLeftHorizontalSplit = uiSettings.getLeftHorizontalSplit();
        }
        if (this.myRightHorizontalSplit != uiSettings.getRightHorizontalSplit()) {
            component = this.getComponentAt(ToolWindowAnchor.RIGHT);
            if (component instanceof Splitter) {
                splitter = (Splitter)component;
                first = (InternalDecorator)splitter.getFirstComponent();
                second = (InternalDecorator)splitter.getSecondComponent();
                this.setComponent((JComponent)splitter, ToolWindowAnchor.RIGHT, ToolWindowAnchor.RIGHT.isSplitVertically() ? first.getWindowInfo().getWeight() : first.getWindowInfo().getWeight() + second.getWindowInfo().getWeight());
            }
            this.myRightHorizontalSplit = uiSettings.getRightHorizontalSplit();
        }
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        return this.myMaximizedProportion != null && this.myMaximizedProportion.first == wnd;
    }

    void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
        Pair<Resizer, Component> resizerAndComponent = this.findResizerAndComponent(wnd);
        if (resizerAndComponent == null) {
            return;
        }
        if (!maximized) {
            ToolWindow maximizedWindow = (ToolWindow)this.myMaximizedProportion.first;
            assert (maximizedWindow == wnd);
            ((Resizer)resizerAndComponent.first).setSize((Integer)this.myMaximizedProportion.second);
            this.myMaximizedProportion = null;
        } else {
            int size = wnd.getAnchor().isHorizontal() ? ((Component)resizerAndComponent.second).getHeight() : ((Component)resizerAndComponent.second).getWidth();
            this.stretch(wnd, Short.MAX_VALUE);
            this.myMaximizedProportion = Pair.create((Object)wnd, (Object)size);
        }
        this.doLayout();
    }

    void setStripesOverlayed(boolean stripesOverlayed) {
        this.myStripesOverlayed = stripesOverlayed;
        this.updateToolStripesVisibility();
    }

    public void dispose() {
    }

    private static float normalizeWeigh(float weight2) {
        if (weight2 <= 0.0f) {
            return 0.33f;
        }
        if (weight2 >= 1.0f) {
            return 0.66999996f;
        }
        return weight2;
    }

    private final class MyLayeredPane
    extends JBLayeredPane {
        private final Function<JBUI.ScaleContext, ImageRef> myImageProvider = __ -> {
            int width = Math.max(Math.max(1, this.getWidth()), ToolWindowsPane.this.myFrame.getWidth());
            int height = Math.max(Math.max(1, this.getHeight()), ToolWindowsPane.this.myFrame.getHeight());
            return new ImageRef(UIUtil.createImage((GraphicsConfiguration)this.getGraphicsConfiguration(), (int)width, (int)height, (int)1));
        };
        private final ImageCache myBottomImageCache = new ImageCache(this.myImageProvider);
        private final ImageCache myTopImageCache = new ImageCache(this.myImageProvider);

        MyLayeredPane(JComponent splitter) {
            this.setOpaque(false);
            this.add(splitter, JLayeredPane.DEFAULT_LAYER);
        }

        final Image getBottomImage() {
            return this.myBottomImageCache.get(JBUI.ScaleContext.create((Component)((Object)this)));
        }

        final Image getTopImage() {
            return this.myTopImageCache.get(JBUI.ScaleContext.create((Component)((Object)this)));
        }

        public void doLayout() {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width < 0 || height < 0) {
                return;
            }
            Component[] components = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            LOG.assertTrue(components.length <= 1);
            for (Component component : components) {
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            for (Component component : components = this.getComponentsInLayer(JLayeredPane.PALETTE_LAYER)) {
                WindowInfoImpl info;
                if (!(component instanceof InternalDecorator) || (info = (WindowInfoImpl)ToolWindowsPane.this.myDecorator2Info.get(component)) == null) continue;
                float weight2 = info.getAnchor().isHorizontal() ? (float)component.getHeight() / (float)this.getHeight() : (float)component.getWidth() / (float)this.getWidth();
                this.setBoundsInPaletteLayer(component, info.getAnchor(), weight2);
            }
        }

        final void setBoundsInPaletteLayer(@NotNull Component component, @NotNull ToolWindowAnchor anchor2, float weight2) {
            if (weight2 < 0.0f) {
                weight2 = 0.33f;
            } else if (weight2 > 1.0f) {
                weight2 = 1.0f;
            }
            if (ToolWindowAnchor.TOP == anchor2) {
                component.setBounds(0, 0, this.getWidth(), (int)((float)this.getHeight() * weight2 + 0.5f));
            } else if (ToolWindowAnchor.LEFT == anchor2) {
                component.setBounds(0, 0, (int)((float)this.getWidth() * weight2 + 0.5f), this.getHeight());
            } else if (ToolWindowAnchor.BOTTOM == anchor2) {
                int height = (int)((float)this.getHeight() * weight2 + 0.5f);
                component.setBounds(0, this.getHeight() - height, this.getWidth(), height);
            } else if (ToolWindowAnchor.RIGHT == anchor2) {
                int width = (int)((float)this.getWidth() * weight2 + 0.5f);
                component.setBounds(this.getWidth() - width, 0, width, this.getHeight());
            } else {
                LOG.error("unknown anchor " + anchor2);
            }
        }
    }

    private static class ImageCache
    extends JBUI.ScaleContext.Cache<ImageRef> {
        ImageCache(@NotNull Function<? super JBUI.ScaleContext, ? extends ImageRef> imageProvider) {
            super(imageProvider);
        }

        public BufferedImage get(@NotNull JBUI.ScaleContext ctx) {
            ImageRef ref = (ImageRef)((Object)this.getOrProvide((JBUI.BaseScaleContext)ctx));
            BufferedImage image = (BufferedImage)SoftReference.dereference((Reference)((Object)ref));
            if (image != null) {
                return image;
            }
            this.clear();
            return this.get(ctx);
        }
    }

    private static class ImageRef
    extends SoftReference<BufferedImage> {
        @Nullable
        private BufferedImage myStrongRef;

        ImageRef(@NotNull BufferedImage image) {
            super((Object)image);
            this.myStrongRef = image;
        }

        public BufferedImage get() {
            if (this.myStrongRef != null) {
                BufferedImage img = this.myStrongRef;
                this.myStrongRef = null;
                return img;
            }
            return (BufferedImage)super.get();
        }
    }

    private final class UpdateButtonPositionCmd
    extends FinalizableCommand {
        private final String myId;

        private UpdateButtonPositionCmd(@NotNull String id, Runnable finishCallBack) {
            super(finishCallBack);
            this.myId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StripeButton stripeButton = (StripeButton)ToolWindowsPane.this.myId2Button.get(this.myId);
                if (stripeButton == null) {
                    return;
                }
                WindowInfoImpl info = stripeButton.getWindowInfo();
                ToolWindowAnchor anchor2 = info.getAnchor();
                if (ToolWindowAnchor.TOP == anchor2) {
                    ToolWindowsPane.this.myTopStripe.revalidate();
                } else if (ToolWindowAnchor.LEFT == anchor2) {
                    ToolWindowsPane.this.myLeftStripe.revalidate();
                } else if (ToolWindowAnchor.BOTTOM == anchor2) {
                    ToolWindowsPane.this.myBottomStripe.revalidate();
                } else if (ToolWindowAnchor.RIGHT == anchor2) {
                    ToolWindowsPane.this.myRightStripe.revalidate();
                } else {
                    LOG.error("unknown anchor: " + anchor2);
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class SetEditorComponentCmd
    extends FinalizableCommand {
        private final JComponent myComponent;

        SetEditorComponentCmd(@NotNull JComponent component, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
        }

        @Override
        public void run() {
            try {
                ToolWindowsPane.this.setDocumentComponent(this.myComponent);
                ToolWindowsPane.this.myLayeredPane.validate();
                ToolWindowsPane.this.myLayeredPane.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveSlidingComponentCmd
    extends FinalizableCommand {
        private final Component myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        RemoveSlidingComponentCmd(@NotNull Component component, WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                UISettings uiSettings = UISettings.getInstance();
                if (!this.myDirtyMode && uiSettings.getAnimateWindows() && !RemoteDesktopService.isRemoteSession()) {
                    Rectangle bounds2 = this.myComponent.getBounds();
                    Image topImage = ToolWindowsPane.this.myLayeredPane.getTopImage();
                    UIUtil.useSafely((Graphics)topImage.getGraphics(), topGraphics -> this.myComponent.paint((Graphics)topGraphics));
                    Image bottomImage = ToolWindowsPane.this.myLayeredPane.getBottomImage();
                    Point2D bottomImageOffset = PaintUtil.getFractOffsetInRootPane((JComponent)((Object)ToolWindowsPane.this.myLayeredPane));
                    UIUtil.useSafely((Graphics)bottomImage.getGraphics(), bottomGraphics -> {
                        ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                        bottomGraphics.clipRect(0, 0, bounds2.width, bounds2.height);
                        bottomGraphics.translate(bottomImageOffset.getX() - (double)bounds2.x, bottomImageOffset.getY() - (double)bounds2.y);
                        ToolWindowsPane.this.myLayeredPane.paint((Graphics)bottomGraphics);
                    });
                    Surface surface = new Surface(topImage, bottomImage, PaintUtil.negate((Point2D)bottomImageOffset), -1, this.myInfo.getAnchor(), 300);
                    ToolWindowsPane.this.myLayeredPane.add(surface, JLayeredPane.PALETTE_LAYER);
                    surface.setBounds(bounds2);
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                    surface.runMovement();
                    ToolWindowsPane.this.myLayeredPane.remove(surface);
                } else {
                    ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
                ToolWindowsPane.this.transferFocus();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveSplitAndDockedComponentCmd
    extends FinalizableCommand {
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        private RemoveSplitAndDockedComponentCmd(WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ToolWindowAnchor anchor2 = this.myInfo.getAnchor();
                JComponent c = ToolWindowsPane.this.getComponentAt(anchor2);
                if (c instanceof Splitter) {
                    InternalDecorator component;
                    Splitter splitter = (Splitter)c;
                    InternalDecorator internalDecorator = component = this.myInfo.isSplit() ? (InternalDecorator)splitter.getFirstComponent() : (InternalDecorator)splitter.getSecondComponent();
                    if (this.myInfo.isSplit() && component != null) {
                        ToolWindowsPane.this.myId2SplitProportion.put(component.getWindowInfo().getId(), Float.valueOf(splitter.getProportion()));
                    }
                    ToolWindowsPane.this.setComponent(component, anchor2, component != null ? component.getWindowInfo().getWeight() : 0.0f);
                } else {
                    ToolWindowsPane.this.setComponent(null, anchor2, 0.0f);
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
                ToolWindowsPane.this.transferFocus();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveDockedComponentCmd
    extends FinalizableCommand {
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        RemoveDockedComponentCmd(WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        @Override
        public final void run() {
            try {
                ToolWindowsPane.this.setComponent(null, this.myInfo.getAnchor(), 0.0f);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
                ToolWindowsPane.this.transferFocus();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveToolStripeButtonCmd
    extends FinalizableCommand {
        private final StripeButton myButton;
        private final WindowInfoImpl myInfo;
        private final ToolWindowAnchor myAnchor;

        RemoveToolStripeButtonCmd(@NotNull StripeButton button2, @NotNull WindowInfoImpl info, Runnable finishCallBack) {
            super(finishCallBack);
            this.myButton = button2;
            this.myInfo = info;
            this.myAnchor = this.myInfo.getAnchor();
        }

        @Override
        public final void run() {
            try {
                if (ToolWindowAnchor.TOP == this.myAnchor) {
                    ToolWindowsPane.this.myTopStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.LEFT == this.myAnchor) {
                    ToolWindowsPane.this.myLeftStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.BOTTOM == this.myAnchor) {
                    ToolWindowsPane.this.myBottomStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.RIGHT == this.myAnchor) {
                    ToolWindowsPane.this.myRightStripe.removeButton(this.myButton);
                } else {
                    LOG.error("unknown anchor: " + this.myAnchor);
                }
                ToolWindowsPane.this.validate();
                ToolWindowsPane.this.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddToolStripeButtonCmd
    extends FinalizableCommand {
        private final StripeButton myButton;
        private final WindowInfoImpl myInfo;
        private final Comparator<StripeButton> myComparator;

        AddToolStripeButtonCmd(@NotNull StripeButton button2, @NotNull WindowInfoImpl info, @NotNull Comparator<StripeButton> comparator2, Runnable finishCallBack) {
            super(finishCallBack);
            this.myButton = button2;
            this.myInfo = info;
            this.myComparator = comparator2;
        }

        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor2 = this.myInfo.getAnchor();
                if (ToolWindowAnchor.TOP == anchor2) {
                    ToolWindowsPane.this.myTopStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.LEFT == anchor2) {
                    ToolWindowsPane.this.myLeftStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.BOTTOM == anchor2) {
                    ToolWindowsPane.this.myBottomStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.RIGHT == anchor2) {
                    ToolWindowsPane.this.myRightStripe.addButton(this.myButton, this.myComparator);
                } else {
                    LOG.error("unknown anchor: " + anchor2);
                }
                ToolWindowsPane.this.validate();
                ToolWindowsPane.this.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddSlidingComponentCmd
    extends FinalizableCommand {
        private final Component myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        AddSlidingComponentCmd(@NotNull Component component, WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                if (!this.myDirtyMode && UISettings.getInstance().getAnimateWindows() && !RemoteDesktopService.isRemoteSession()) {
                    Image topImage = ToolWindowsPane.this.myLayeredPane.getTopImage();
                    Rectangle bounds2 = this.myComponent.getBounds();
                    UIUtil.useSafely((Graphics)topImage.getGraphics(), topGraphics -> {
                        ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                        ToolWindowsPane.this.myLayeredPane.moveToFront(this.myComponent);
                        ToolWindowsPane.this.myLayeredPane.setBoundsInPaletteLayer(this.myComponent, this.myInfo.getAnchor(), this.myInfo.getWeight());
                        this.myComponent.paint((Graphics)topGraphics);
                        ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                    });
                    Image bottomImage = ToolWindowsPane.this.myLayeredPane.getBottomImage();
                    Point2D bottomImageOffset = PaintUtil.getFractOffsetInRootPane((JComponent)((Object)ToolWindowsPane.this.myLayeredPane));
                    UIUtil.useSafely((Graphics)bottomImage.getGraphics(), bottomGraphics -> {
                        bottomGraphics.setClip(0, 0, bounds2.width, bounds2.height);
                        bottomGraphics.translate(bottomImageOffset.getX() - (double)bounds2.x, bottomImageOffset.getY() - (double)bounds2.y);
                        ToolWindowsPane.this.myLayeredPane.paint((Graphics)bottomGraphics);
                    });
                    Surface surface = new Surface(topImage, bottomImage, PaintUtil.negate((Point2D)bottomImageOffset), 1, this.myInfo.getAnchor(), 300);
                    ToolWindowsPane.this.myLayeredPane.add(surface, JLayeredPane.PALETTE_LAYER);
                    surface.setBounds(bounds2);
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                    surface.runMovement();
                    ToolWindowsPane.this.myLayeredPane.remove(surface);
                    ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                } else {
                    ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                    ToolWindowsPane.this.myLayeredPane.setBoundsInPaletteLayer(this.myComponent, this.myInfo.getAnchor(), this.myInfo.getWeight());
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddAndSplitDockedComponentCmd
    extends FinalizableCommand {
        private final JComponent myNewComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        private AddAndSplitDockedComponentCmd(@NotNull JComponent newComponent, WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myNewComponent = newComponent;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                float newWeight;
                JComponent c;
                final ToolWindowAnchor anchor2 = this.myInfo.getAnchor();
                class MySplitter
                extends OnePixelSplitter
                implements UISettingsListener {
                    MySplitter() {
                    }

                    public void uiSettingsChanged(UISettings uiSettings) {
                        if (anchor2 == ToolWindowAnchor.LEFT) {
                            this.setOrientation(!uiSettings.getLeftHorizontalSplit());
                        } else if (anchor2 == ToolWindowAnchor.RIGHT) {
                            this.setOrientation(!uiSettings.getRightHorizontalSplit());
                        }
                    }

                    public String toString() {
                        return "[" + this.getFirstComponent() + "|" + this.getSecondComponent() + "]";
                    }
                }
                MySplitter splitter = new MySplitter();
                splitter.setOrientation(anchor2.isSplitVertically());
                if (!anchor2.isHorizontal()) {
                    splitter.setAllowSwitchOrientationByMouseClick(true);
                    splitter.addPropertyChangeListener(arg_0 -> AddAndSplitDockedComponentCmd.lambda$run$0((Splitter)splitter, anchor2, arg_0));
                }
                if ((c = ToolWindowsPane.this.getComponentAt(anchor2)) == null) {
                    InternalDecorator anotherDecorator;
                    List<String> ids = ToolWindowsPane.this.myManager.getIdsOn(anchor2);
                    ids.remove(this.myInfo.getId());
                    Iterator<String> iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        String id = iterator.next();
                        ToolWindow window = this.myManager.getToolWindow(id);
                        if (window != null && window.isSplitMode() != this.myInfo.isSplit() && window.isVisible()) continue;
                        iterator.remove();
                    }
                    if (!ids.isEmpty() && (anotherDecorator = ToolWindowsPane.this.getDecoratorById(ids.get(0))) != null) {
                        c = anotherDecorator;
                    }
                    if (c == null) {
                        LOG.error("Empty splitter @ " + anchor2 + " during AddAndSplitDockedComponentCmd for " + this.myInfo.getId());
                    }
                }
                if (c instanceof InternalDecorator) {
                    InternalDecorator oldComponent = (InternalDecorator)c;
                    WindowInfoImpl oldInfo = oldComponent.getWindowInfo();
                    if (this.myInfo.isSplit()) {
                        splitter.setFirstComponent(oldComponent);
                        splitter.setSecondComponent(this.myNewComponent);
                        float proportion = ToolWindowsPane.this.getPreferredSplitProportion(oldInfo.getId(), ToolWindowsPane.normalizeWeigh(oldInfo.getSideWeight() / (oldInfo.getSideWeight() + this.myInfo.getSideWeight())));
                        splitter.setProportion(proportion);
                        newWeight = !anchor2.isHorizontal() && !anchor2.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldInfo.getWeight() + this.myInfo.getWeight()) : ToolWindowsPane.normalizeWeigh(oldInfo.getWeight());
                    } else {
                        splitter.setFirstComponent(this.myNewComponent);
                        splitter.setSecondComponent(oldComponent);
                        splitter.setProportion(ToolWindowsPane.normalizeWeigh(this.myInfo.getSideWeight()));
                        newWeight = !anchor2.isHorizontal() && !anchor2.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldInfo.getWeight() + this.myInfo.getWeight()) : ToolWindowsPane.normalizeWeigh(this.myInfo.getWeight());
                    }
                } else {
                    newWeight = ToolWindowsPane.normalizeWeigh(this.myInfo.getWeight());
                }
                ToolWindowsPane.this.setComponent((JComponent)((Object)splitter), anchor2, newWeight);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void lambda$run$0(Splitter splitter, ToolWindowAnchor anchor2, PropertyChangeEvent evt) {
            if (!"orientation".equals(evt.getPropertyName())) {
                return;
            }
            boolean isSplitterHorizontalNow = !splitter.isVertical();
            UISettings settings = UISettings.getInstance();
            if (anchor2 == ToolWindowAnchor.LEFT && settings.getLeftHorizontalSplit() != isSplitterHorizontalNow) {
                settings.setLeftHorizontalSplit(isSplitterHorizontalNow);
                settings.fireUISettingsChanged();
            }
            if (anchor2 == ToolWindowAnchor.RIGHT && settings.getRightHorizontalSplit() != isSplitterHorizontalNow) {
                settings.setRightHorizontalSplit(isSplitterHorizontalNow);
                settings.fireUISettingsChanged();
            }
        }
    }

    private final class AddDockedComponentCmd
    extends FinalizableCommand {
        private final JComponent myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        AddDockedComponentCmd(@NotNull JComponent component, WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor2 = this.myInfo.getAnchor();
                ToolWindowsPane.this.setComponent(this.myComponent, anchor2, ToolWindowsPane.normalizeWeigh(this.myInfo.getWeight()));
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    @FunctionalInterface
    static interface Resizer {
        public void setSize(int var1);

        public static abstract class LayeredPane
        implements Resizer {
            Component myComponent;

            LayeredPane(@NotNull Component component) {
                this.myComponent = component;
            }

            @Override
            public final void setSize(int size) {
                this._setSize(size);
                if (this.myComponent.getParent() instanceof JComponent) {
                    JComponent parent = (JComponent)this.myComponent;
                    parent.revalidate();
                    parent.repaint();
                }
            }

            abstract void _setSize(int var1);

            static class Bottom
            extends LayeredPane {
                Bottom(@NotNull Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds2 = this.myComponent.getBounds();
                    int delta = size - bounds2.height;
                    bounds2.y -= delta;
                    bounds2.height += delta;
                    this.myComponent.setBounds(bounds2);
                }
            }

            static class Top
            extends LayeredPane {
                Top(@NotNull Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(this.myComponent.getWidth(), size);
                }
            }

            static class Right
            extends LayeredPane {
                Right(@NotNull Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds2 = this.myComponent.getBounds();
                    int delta = size - bounds2.width;
                    bounds2.x -= delta;
                    bounds2.width += delta;
                    this.myComponent.setBounds(bounds2);
                }
            }

            static class Left
            extends LayeredPane {
                Left(@NotNull Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(size, this.myComponent.getHeight());
                }
            }
        }

        public static abstract class Splitter
        implements Resizer {
            ThreeComponentsSplitter mySplitter;

            Splitter(@NotNull ThreeComponentsSplitter splitter) {
                this.mySplitter = splitter;
            }

            static class LastComponent
            extends Splitter {
                LastComponent(@NotNull ThreeComponentsSplitter splitter) {
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setLastSize(size);
                }
            }

            static class FirstComponent
            extends Splitter {
                FirstComponent(@NotNull ThreeComponentsSplitter splitter) {
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setFirstSize(size);
                }
            }
        }
    }
}

