/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.wm.impl.content.AdditionalIcon;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.SmartList;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtilities;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

class ContentTabLabel
extends BaseLabel {
    private static final int MAX_WIDTH = JBUI.scale((int)300);
    private static final int DEFAULT_HORIZONTAL_INSET = JBUI.scale((int)12);
    private static final int ICONS_GAP = JBUI.scale((int)3);
    private final ActiveIcon myCloseIcon = new ActiveIcon(JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)true), JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)false));
    @NotNull
    private final Content myContent;
    private final TabContentLayout myLayout;
    private final List<AdditionalIcon> myAdditionalIcons = new SmartList();
    private String myText;
    private int myIconWithInsetsWidth;
    private final AdditionalIcon closeTabIcon = new AdditionalIcon(this.myCloseIcon){
        private static final String ACTION_NAME = "Close tab";

        @Override
        @NotNull
        public Rectangle getRectangle() {
            return new Rectangle(this.getX(), 0, this.getIconWidth(), ContentTabLabel.this.getHeight());
        }

        @Override
        public boolean getActive() {
            return ContentTabLabel.this.mouseOverIcon(this);
        }

        @Override
        public boolean getAvailable() {
            return ContentTabLabel.this.canBeClosed();
        }

        @Override
        @NotNull
        public Runnable getAction() {
            return () -> ContentTabLabel.this.contentManager().removeContent(ContentTabLabel.this.getContent(), true);
        }

        @Override
        public boolean getAfterText() {
            return UISettings.getShadowInstance().getCloseTabButtonOnTheRight() || !UISettings.getShadowInstance().getShowCloseButton();
        }

        @Override
        @NotNull
        public String getTooltip() {
            String text = KeymapUtil.getShortcutsText((Shortcut[])KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseActiveTab"));
            return text.isEmpty() || !ContentTabLabel.this.isSelected() ? ACTION_NAME : "Close tab (" + text + ")";
        }
    };
    private CurrentTooltip currentIconTooltip;
    private final BaseButtonBehavior behavior = new BaseButtonBehavior(this){

        protected void execute(MouseEvent e) {
            Optional<Runnable> first = ContentTabLabel.this.myAdditionalIcons.stream().filter(icon -> ContentTabLabel.this.mouseOverIcon((AdditionalIcon)icon)).map(icon -> icon.getAction()).findFirst();
            if (first.isPresent()) {
                first.get().run();
                return;
            }
            ContentTabLabel.this.selectContent();
            if (e.getClickCount() == 2 && e.getButton() == 1 && !((ContentTabLabel)ContentTabLabel.this).myLayout.myDoubleClickActions.isEmpty()) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)ContentTabLabel.this);
                for (AnAction action : ((ContentTabLabel)ContentTabLabel.this).myLayout.myDoubleClickActions) {
                    AnActionEvent event;
                    if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)(event = AnActionEvent.createFromInputEvent((InputEvent)e, (String)"unknown", null, (DataContext)dataContext)), (boolean)false)) continue;
                    ActionManagerEx.getInstanceEx().fireBeforeActionPerformed(action, dataContext, event);
                    ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                }
            }
        }
    };

    private void showTooltip(AdditionalIcon icon) {
        if (icon != null) {
            String toolText;
            if (this.currentIconTooltip != null) {
                if (this.currentIconTooltip.icon == icon) {
                    IdeTooltipManager.getInstance().show(this.currentIconTooltip.currentTooltip, false, false);
                    return;
                }
                this.hideCurrentTooltip();
            }
            if ((toolText = icon.getTooltip()) != null && !toolText.isEmpty()) {
                IdeTooltip tooltip = new IdeTooltip(this, icon.getCenterPoint(), new JLabel(toolText), new Object[0]);
                this.currentIconTooltip = new CurrentTooltip(IdeTooltipManager.getInstance().show(tooltip, false, false), icon);
                return;
            }
        }
        this.hideCurrentTooltip();
        if (this.myText != null && !this.myText.equals(this.getText())) {
            IdeTooltip tooltip = new IdeTooltip(this, this.getMousePosition(), new JLabel(this.myText), new Object[0]);
            this.currentIconTooltip = new CurrentTooltip(IdeTooltipManager.getInstance().show(tooltip, false, false), null);
        }
    }

    private void hideCurrentTooltip() {
        if (this.currentIconTooltip == null) {
            return;
        }
        this.currentIconTooltip.currentTooltip.hide();
        this.currentIconTooltip = null;
    }

    @Override
    public void setText(String text) {
        this.myText = text;
        this.updateText();
    }

    private void updateText() {
        int maxWidth;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int textWidth = UIUtilities.stringWidth((JComponent)this, (FontMetrics)fm, (String)this.myText);
        int prefWidth = this.myIconWithInsetsWidth + textWidth;
        if (prefWidth > (maxWidth = this.getMaximumSize().width)) {
            int offset = maxWidth - this.myIconWithInsetsWidth;
            String s = UIUtilities.clipString((JComponent)this, (FontMetrics)fm, (String)this.myText, (int)offset);
            super.setText(s);
            return;
        }
        super.setText(this.myText);
    }

    final boolean mouseOverIcon(AdditionalIcon icon) {
        if (!this.isHovered() || !icon.getAvailable()) {
            return false;
        }
        PointerInfo info = MouseInfo.getPointerInfo();
        if (info == null) {
            return false;
        }
        Point point = info.getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        return icon.contains(point);
    }

    ContentTabLabel(@NotNull Content content, @NotNull TabContentLayout layout) {
        super(layout.myUi, false);
        this.myLayout = layout;
        this.myContent = content;
        this.fillIcons(this.myAdditionalIcons);
        this.behavior.setActionTrigger(502);
        this.behavior.setMouseDeadzone(TimedDeadzone.NULL);
        this.myContent.addPropertyChangeListener(event -> {
            String property = event.getPropertyName();
            if ("isClosable".equals(property)) {
                this.repaint();
            }
        });
        this.setMaximumSize(new Dimension(MAX_WIDTH, this.getMaximumSize().height));
    }

    protected void fillIcons(@NotNull List<? super AdditionalIcon> icons) {
        icons.add(this.closeTabIcon);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent event) {
        super.processMouseMotionEvent(event);
        boolean hovered = this.isHovered();
        if (hovered) {
            Optional<AdditionalIcon> first;
            if (this.invalid()) {
                this.repaint();
            }
            if ((first = this.myAdditionalIcons.stream().filter(icon -> this.mouseOverIcon((AdditionalIcon)icon)).findFirst()).isPresent()) {
                this.showTooltip(first.get());
                return;
            }
        }
        this.showTooltip(null);
    }

    protected boolean invalid() {
        return this.myAdditionalIcons.stream().anyMatch(icon -> icon.getAvailable());
    }

    public final boolean canBeClosed() {
        return this.myContent.isCloseable() && this.myUi.myWindow.canCloseContents();
    }

    protected void selectContent() {
        ContentManager mgr = this.contentManager();
        if (mgr.getIndexOfContent(this.myContent) >= 0) {
            mgr.setSelectedContent(this.myContent, true);
        }
    }

    public void update() {
        this.setHorizontalAlignment(2);
        if (!this.myLayout.isToDrawTabs()) {
            this.setBorder(null);
        }
        this.updateTextAndIcon(this.myContent, this.isSelected());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        THashMap map2 = new THashMap();
        for (AdditionalIcon myAdditionalIcon : this.myAdditionalIcons) {
            if (!myAdditionalIcon.getAvailable()) continue;
            map2.computeIfAbsent(myAdditionalIcon.getAfterText(), k -> new SmartList()).add(myAdditionalIcon);
        }
        int left = DEFAULT_HORIZONTAL_INSET;
        int iconWidth = 0;
        if (map2.get(false) != null) {
            iconWidth = ICONS_GAP;
            for (AdditionalIcon icon : (List)map2.get(false)) {
                icon.setX(iconWidth);
                iconWidth += icon.getIconWidth() + ICONS_GAP;
            }
            left = iconWidth;
            iconWidth = 0;
        }
        int right = DEFAULT_HORIZONTAL_INSET;
        if (map2.get(true) != null) {
            right = ICONS_GAP + JBUI.scale((int)4);
            for (AdditionalIcon icon : (List)map2.get(true)) {
                icon.setX(iconWidth + size.width + ICONS_GAP - right);
                iconWidth += icon.getIconWidth() + ICONS_GAP;
            }
        }
        this.setBorder(new EmptyBorder(0, left, 0, right));
        this.myIconWithInsetsWidth = iconWidth + right + left;
        return new Dimension(iconWidth + size.width, size.height);
    }

    @Override
    protected boolean allowEngravement() {
        return this.isSelected() || this.myUi != null && this.myUi.myWindow.isActive();
    }

    @Override
    protected Color getActiveFg(boolean selected) {
        if (this.contentManager().getContentCount() > 1) {
            return JBUI.CurrentTheme.Label.foreground((boolean)selected);
        }
        return super.getActiveFg(selected);
    }

    @Override
    protected Color getPassiveFg(boolean selected) {
        if (this.contentManager().getContentCount() > 1) {
            return JBUI.CurrentTheme.Label.foreground((boolean)selected);
        }
        return super.getPassiveFg(selected);
    }

    private void paintIcons(Graphics g) {
        for (AdditionalIcon icon : this.myAdditionalIcons) {
            if (!icon.getAvailable()) continue;
            icon.paintIcon(this, g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintIcons(g);
    }

    public boolean isSelected() {
        return this.contentManager().isSelected(this.myContent);
    }

    public boolean isHovered() {
        return this.behavior.isHovered();
    }

    @Override
    protected Graphics _getGraphics(Graphics2D g) {
        if (this.isSelected() && this.contentManager().getContentCount() > 1) {
            return new EngravedTextGraphics(g, 1, 1, Gray._0.withAlpha(this.myUi.myWindow.isActive() ? 120 : 130));
        }
        return super._getGraphics(g);
    }

    private ContentManager contentManager() {
        return this.myUi.myWindow.getContentManager();
    }

    @Override
    @NotNull
    public Content getContent() {
        return this.myContent;
    }

    private static class CurrentTooltip {
        final IdeTooltip currentTooltip;
        final AdditionalIcon icon;

        CurrentTooltip(IdeTooltip currentTooltip, AdditionalIcon icon) {
            this.currentTooltip = currentTooltip;
            this.icon = icon;
        }
    }
}

