/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.content.AdditionalIcon;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentTabStep;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.reference.SoftReference;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedContentTabLabel
extends ContentTabLabel {
    private final TabbedContent myContent;
    private Reference<JBPopup> myPopupReference = null;

    public TabbedContentTabLabel(@NotNull TabbedContent content, @NotNull TabContentLayout layout) {
        super((Content)content, layout);
        this.myContent = content;
    }

    private boolean isPopupShown() {
        return this.myPopupReference != null && this.myPopupReference.get() != null && this.myPopupReference.get().isVisible();
    }

    @Override
    protected void selectContent() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        super.selectContent();
        if (this.hasMultipleTabs()) {
            SelectContentTabStep step = new SelectContentTabStep(this.getContent());
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
            this.myPopupReference = new WeakReference<ListPopup>(popup2);
            popup2.showUnderneathOf((Component)this);
            popup2.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    TabbedContentTabLabel.this.repaint();
                }
            });
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.myContent != null) {
            this.setText(this.myContent.getTabName());
        }
    }

    @Override
    protected void fillIcons(@NotNull List<? super AdditionalIcon> icons) {
        icons.add(new AdditionalIcon(new ActiveIcon(JBUI.CurrentTheme.ToolWindow.comboTabIcon((boolean)true), JBUI.CurrentTheme.ToolWindow.comboTabIcon((boolean)false))){

            @Override
            @NotNull
            public Rectangle getRectangle() {
                return new Rectangle(this.getX(), 0, this.getIconWidth(), TabbedContentTabLabel.this.getHeight());
            }

            @Override
            public boolean getActive() {
                return TabbedContentTabLabel.this.mouseOverIcon(this) || TabbedContentTabLabel.this.isPopupShown();
            }

            @Override
            public boolean getAvailable() {
                return TabbedContentTabLabel.this.hasMultipleTabs();
            }

            @Override
            @Nullable
            public Runnable getAction() {
                return () -> TabbedContentTabLabel.this.selectContent();
            }
        });
        super.fillIcons(icons);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JBPopup popup2 = (JBPopup)SoftReference.dereference(this.myPopupReference);
        if (popup2 != null) {
            Disposer.dispose((Disposable)popup2);
            this.myPopupReference = null;
        }
    }

    @NotNull
    public TabbedContent getContent() {
        return this.myContent;
    }

    private boolean hasMultipleTabs() {
        return this.myContent != null && this.myContent.hasMultipleTabs();
    }
}

