/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.UIBundle;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ColumnSelectionModePanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget,
PropertyChangeListener {
    private final TextPanel myTextPanel = new TextPanel();

    public ColumnSelectionModePanel(Project project) {
        super(project);
        this.myTextPanel.setRightPadding(7);
    }

    @NotNull
    public String ID() {
        return "InsertOverwrite";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        return null;
    }

    public StatusBarWidget copy() {
        return new ColumnSelectionModePanel(this.getProject());
    }

    public JComponent getComponent() {
        return this.myTextPanel;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        super.install(statusBar);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        Disposer.register((Disposable)this, () -> KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this));
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        if (multicaster instanceof EditorEventMulticasterEx) {
            ((EditorEventMulticasterEx)multicaster).addPropertyChangeListener(this, (Disposable)this);
        }
    }

    private void updateStatus() {
        if (!this.myProject.isOpen()) {
            return;
        }
        Editor editor = this.getFocusedEditor();
        if (editor != null && !this.isOurEditor(editor)) {
            return;
        }
        if (editor == null || !editor.isColumnMode()) {
            this.myTextPanel.setBorder(null);
            this.myTextPanel.setVisible(false);
        } else {
            this.myTextPanel.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
            this.myTextPanel.setVisible(true);
            this.myTextPanel.setText(UIBundle.message((String)"status.bar.column.status.text", (Object[])new Object[0]));
            this.myTextPanel.setToolTipText("Column selection mode");
        }
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.updateStatus();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.updateStatus();
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("insertMode".equals(propertyName) || "columnMode".equals(propertyName) || "focusOwner".equals(propertyName)) {
            this.updateStatus();
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        this.updateStatus();
    }
}

