/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorBasedStatusBarPopup
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    private final TextPanel.WithIconAndArrows myComponent;
    private boolean actionEnabled;
    private final Alarm update;
    private volatile Reference<Editor> myEditor = new WeakReference<Object>(null);

    public EditorBasedStatusBarPopup(@NotNull Project project) {
        super(project);
        this.update = new Alarm((Disposable)this);
        this.myComponent = new TextPanel.WithIconAndArrows(){

            @Override
            protected boolean shouldPaintArrows() {
                return EditorBasedStatusBarPopup.this.actionEnabled;
            }
        };
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                EditorBasedStatusBarPopup.this.update();
                EditorBasedStatusBarPopup.this.showPopup(e);
                return true;
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile newFile = event.getNewFile();
        Project project = this.getProject();
        assert (project != null);
        FileEditor fileEditor = newFile == null ? null : FileEditorManager.getInstance((Project)project).getSelectedEditor(newFile);
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        this.myEditor = new WeakReference<Editor>(editor);
        this.fileChanged(newFile);
    }

    private void fileChanged(VirtualFile newFile) {
        this.handleFileChange(newFile);
        this.update();
    }

    protected void handleFileChange(VirtualFile file2) {
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.fileChanged(file2);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.fileChanged(file2);
    }

    public StatusBarWidget copy() {
        return this.createInstance(this.getProject());
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        return null;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        super.install(statusBar);
        this.registerCustomListeners();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                Document document = e.getDocument();
                EditorBasedStatusBarPopup.this.updateForDocument(document);
            }
        }, (Disposable)this);
    }

    protected void updateForDocument(@Nullable(value="null means update anyway") Document document) {
        Editor selectedEditor = this.myEditor.get();
        if (document != null && (selectedEditor == null || selectedEditor.getDocument() != document)) {
            return;
        }
        this.update();
    }

    protected void updateForFile(@Nullable(value="null means update anyway") VirtualFile file2) {
        if (file2 == null) {
            this.update();
        } else {
            this.updateForDocument(FileDocumentManager.getInstance().getCachedDocument(file2));
        }
    }

    private void showPopup(@NotNull MouseEvent e) {
        if (!this.actionEnabled) {
            return;
        }
        DataContext dataContext = this.getContext();
        ListPopup popup2 = this.createPopup(dataContext);
        if (popup2 != null) {
            Dimension dimension = popup2.getContent().getPreferredSize();
            Point at = new Point(0, -dimension.height);
            popup2.show(new RelativePoint(e.getComponent(), at));
            Disposer.register((Disposable)this, (Disposable)popup2);
        }
    }

    @NotNull
    protected DataContext getContext() {
        VirtualFile[] virtualFileArray;
        Editor editor = this.getEditor();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myStatusBar);
        VirtualFile selectedFile = this.getSelectedFile();
        ContainerUtil.ImmutableMapBuilder immutableMapBuilder = ContainerUtil.immutableMapBuilder().put((Object)CommonDataKeys.VIRTUAL_FILE.getName(), (Object)selectedFile);
        String string = CommonDataKeys.VIRTUAL_FILE_ARRAY.getName();
        if (selectedFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = selectedFile;
        }
        return SimpleDataContext.getSimpleContext(immutableMapBuilder.put((Object)string, (Object)virtualFileArray).put((Object)CommonDataKeys.PROJECT.getName(), (Object)this.getProject()).put((Object)PlatformDataKeys.CONTEXT_COMPONENT.getName(), (Object)(editor == null ? null : editor.getComponent())).build(), parent);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    protected boolean isEmpty() {
        return StringUtil.isEmpty((String)this.myComponent.getText()) && !this.myComponent.hasIcon();
    }

    public boolean isActionEnabled() {
        return this.actionEnabled;
    }

    public void updateInTests(boolean immediately) {
        this.update();
        this.update.drainRequestsInTest();
        UIUtil.dispatchAllInvocationEvents();
        if (immediately) {
            this.update.drainRequestsInTest();
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    public void flushUpdateInTests() {
        this.update.drainRequestsInTest();
    }

    public void update() {
        this.update(null);
    }

    public void update(@Nullable Runnable finishUpdate) {
        if (this.update.isDisposed()) {
            return;
        }
        this.update.cancelAllRequests();
        this.update.addRequest(() -> {
            if (this.isDisposed()) {
                return;
            }
            VirtualFile file2 = this.getSelectedFile();
            WidgetState state = this.getWidgetState(file2);
            if (state == WidgetState.NO_CHANGE) {
                return;
            }
            if (state == WidgetState.NO_CHANGE_MAKE_VISIBLE) {
                this.myComponent.setVisible(true);
                return;
            }
            if (state == WidgetState.HIDDEN) {
                this.myComponent.setVisible(false);
                return;
            }
            this.myComponent.setVisible(true);
            this.actionEnabled = state.actionEnabled && file2 != null && (!this.requiresWritableFile() || file2.isWritable());
            String widgetText = state.text;
            String toolTipText = state.toolTip;
            if (this.actionEnabled) {
                this.myComponent.setForeground(UIUtil.getActiveTextColor());
                this.myComponent.setTextAlignment(0.0f);
            } else {
                this.myComponent.setForeground(UIUtil.getInactiveTextColor());
                this.myComponent.setTextAlignment(0.5f);
            }
            this.myComponent.setIcon(state.icon);
            this.myComponent.setToolTipText(toolTipText);
            this.myComponent.setText(widgetText);
            this.myComponent.invalidate();
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
            if (finishUpdate != null) {
                finishUpdate.run();
            }
            this.afterVisibleUpdate(state);
        }, 200, ModalityState.any());
    }

    protected void afterVisibleUpdate(@NotNull WidgetState state) {
    }

    protected boolean requiresWritableFile() {
        return true;
    }

    @NotNull
    protected abstract WidgetState getWidgetState(@Nullable VirtualFile var1);

    @Nullable
    protected abstract ListPopup createPopup(DataContext var1);

    protected abstract void registerCustomListeners();

    @NotNull
    protected abstract StatusBarWidget createInstance(Project var1);

    protected static class WidgetState {
        public static final WidgetState HIDDEN = new WidgetState();
        public static final WidgetState NO_CHANGE = new WidgetState();
        public static final WidgetState NO_CHANGE_MAKE_VISIBLE = new WidgetState();
        protected final String toolTip;
        private final String text;
        private final boolean actionEnabled;
        private Icon icon;

        private WidgetState() {
            this("", "", false);
        }

        public WidgetState(String toolTip, String text, boolean actionEnabled) {
            this.toolTip = toolTip;
            this.text = text;
            this.actionEnabled = actionEnabled;
        }

        public static WidgetState getDumbModeState(String name, String widgetPrefix) {
            return new WidgetState(ActionUtil.getUnavailableMessage((String)name, (boolean)false), widgetPrefix + IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]), false);
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }
    }
}

