/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingPanel
extends EditorBasedStatusBarPopup {
    public EncodingPanel(@NotNull Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        Pair<Charset, String> check = EncodingUtil.getCharsetAndTheReasonTooltip(file2);
        String failReason = (String)Pair.getSecond(check);
        Charset charset = (Charset)ObjectUtils.notNull((Object)Pair.getFirst(check), (Object)file2.getCharset());
        String charsetName = (String)ObjectUtils.notNull((Object)charset.displayName(), (Object)"n/a");
        String toolTipText = failReason == null ? "File Encoding: " + charsetName : StringUtil.capitalize((String)failReason) + ".";
        return new EditorBasedStatusBarPopup.WidgetState(toolTipText, charsetName, failReason == null);
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        return new ChangeFileEncodingAction().createPopup(context);
    }

    @Override
    protected void registerCustomListeners() {
        EncodingManager.getInstance().addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("cachedEncoding")) {
                Document document = evt.getSource() instanceof Document ? (Document)evt.getSource() : null;
                this.updateForDocument(document);
            }
        }, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if ("encoding".equals(event.getPropertyName())) {
                    EncodingPanel.this.updateForFile(event.getFile());
                }
            }
        }));
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(Project project) {
        return new EncodingPanel(project);
    }

    @NotNull
    public String ID() {
        return "Encoding";
    }
}

