/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.openapi.wm.impl.status.PresentationModeProgressPanel;
import com.intellij.openapi.wm.impl.status.ProcessPopup;
import com.intellij.openapi.wm.impl.status.ProgressButton;
import com.intellij.openapi.wm.impl.status.StatusPanel;
import com.intellij.reference.SoftReference;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfoAndProgressPanel
extends JPanel
implements CustomStatusBarWidget {
    private final ProcessPopup myPopup;
    private final StatusPanel myInfoPanel = new StatusPanel();
    private final JPanel myRefreshAndInfoPanel = new JPanel();
    private final AsyncProcessIcon myProgressIcon;
    private final List<ProgressIndicatorEx> myOriginals = new ArrayList<ProgressIndicatorEx>();
    private final List<TaskInfo> myInfos = new ArrayList<TaskInfo>();
    private final Map<InlineProgressIndicator, ProgressIndicatorEx> myInline2Original = new HashMap<InlineProgressIndicator, ProgressIndicatorEx>();
    private final MultiValuesMap<ProgressIndicatorEx, MyInlineProgressIndicator> myOriginal2Inlines = new MultiValuesMap();
    private final MergingUpdateQueue myUpdateQueue;
    private final Alarm myQueryAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private boolean myShouldClosePopupAndOnProcessFinish;
    private final JLabel myRefreshIcon = new JLabel((Icon)new AnimatedIcon.FS());
    private String myCurrentRequestor;
    private boolean myDisposed;
    private WeakReference<Balloon> myLastShownBalloon;
    private final Set<InlineProgressIndicator> myDirtyIndicators = ContainerUtil.newIdentityTroveSet();
    private final Update myUpdateIndicators = new Update("UpdateIndicators", false, 1){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList indicators;
            Set set2 = InfoAndProgressPanel.this.myDirtyIndicators;
            synchronized (set2) {
                indicators = ContainerUtil.newArrayList((Iterable)InfoAndProgressPanel.this.myDirtyIndicators);
                InfoAndProgressPanel.this.myDirtyIndicators.clear();
            }
            for (InlineProgressIndicator indicator : indicators) {
                indicator.updateAndRepaint();
            }
        }
    };

    InfoAndProgressPanel() {
        this.setOpaque(false);
        this.myRefreshIcon.setVisible(false);
        this.myRefreshAndInfoPanel.setLayout(new BorderLayout());
        this.myRefreshAndInfoPanel.setOpaque(false);
        this.myRefreshAndInfoPanel.add((Component)this.myRefreshIcon, "West");
        this.myRefreshAndInfoPanel.add((Component)this.myInfoPanel, "Center");
        this.myProgressIcon = new AsyncProcessIcon("Background process");
        this.myProgressIcon.setOpaque(false);
        this.myProgressIcon.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                InfoAndProgressPanel.this.handle(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                InfoAndProgressPanel.this.handle(e);
            }
        });
        this.myProgressIcon.setCursor(Cursor.getPredefinedCursor(12));
        this.myProgressIcon.setBorder(StatusBarWidget.WidgetBorder.INSTANCE);
        this.myProgressIcon.setToolTipText(ActionsBundle.message((String)"action.ShowProcessWindow.double.click", (Object[])new Object[0]));
        this.myUpdateQueue = new MergingUpdateQueue("Progress indicator", 50, true, MergingUpdateQueue.ANY_COMPONENT);
        this.myPopup = new ProcessPopup(this);
        this.setRefreshVisible(false);
        this.restoreEmptyStatus();
        this.runOnProgressRelatedChange(this::updateProgressIcon, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnProgressRelatedChange(final @NotNull Runnable runnable2, Disposable parentDisposable) {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (!this.myDisposed) {
                MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
                connection.subscribe(PowerSaveMode.TOPIC, () -> UIUtil.invokeLaterIfNeeded((Runnable)runnable2));
                connection.subscribe(ProgressSuspender.TOPIC, (Object)new ProgressSuspender.SuspenderListener(){

                    @Override
                    public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender) {
                        UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
                    }

                    @Override
                    public void suspendedStatusChanged(@NotNull ProgressSuspender suspender) {
                        UIUtil.invokeLaterIfNeeded((Runnable)runnable2);
                    }
                });
            }
        }
    }

    private void handle(MouseEvent e) {
        if (UIUtil.isActionClick((MouseEvent)e, (int)501)) {
            if (!this.myPopup.isShowing()) {
                this.openProcessPopup(true);
            } else {
                this.hideProcessPopup();
            }
        } else if (e.isPopupTrigger()) {
            ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("BackgroundTasks");
            ActionManager.getInstance().createActionPopupMenu("unknown", group).getComponent().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @NotNull
    public String ID() {
        return "InfoAndProgress";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        return null;
    }

    public void install(@NotNull StatusBar statusBar) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.setRefreshVisible(false);
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            this.restoreEmptyStatus();
            for (InlineProgressIndicator indicator : this.myInline2Original.keySet()) {
                Disposer.dispose((Disposable)indicator);
            }
            this.myInline2Original.clear();
            this.myOriginal2Inlines.clear();
            this.myDisposed = true;
        }
    }

    public JComponent getComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<Pair<TaskInfo, ProgressIndicator>> getBackgroundProcesses() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (this.myOriginals.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Pair> result2 = new ArrayList<Pair>(this.myOriginals.size());
            for (int i = 0; i < this.myOriginals.size(); ++i) {
                result2.add(Pair.create((Object)this.myInfos.get(i), (Object)this.myOriginals.get(i)));
            }
            return Collections.unmodifiableList(result2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProgress(@NotNull ProgressIndicatorEx original, @NotNull TaskInfo info) {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            boolean veryFirst = !this.hasProgressIndicators();
            this.myOriginals.add(original);
            this.myInfos.add(info);
            MyInlineProgressIndicator expanded = this.createInlineDelegate(info, original, false);
            MyInlineProgressIndicator compact = this.createInlineDelegate(info, original, true);
            this.myPopup.addIndicator(expanded);
            this.updateProgressIcon();
            if (veryFirst && !this.myPopup.isShowing()) {
                this.buildInInlineIndicator(compact);
            } else {
                this.buildInProcessCount();
                if (this.myInfos.size() > 1 && Registry.is((String)"ide.windowSystem.autoShowProcessPopup")) {
                    this.openProcessPopup(false);
                }
            }
            this.runQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProgressIndicators() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            return !this.myOriginals.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgress(@NotNull MyInlineProgressIndicator progress) {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (!this.myInline2Original.containsKey(progress)) {
                return;
            }
            boolean last = this.myOriginals.size() == 1;
            boolean beforeLast = this.myOriginals.size() == 2;
            this.myPopup.removeIndicator(progress);
            ProgressIndicatorEx original = this.removeFromMaps(progress);
            if (this.myOriginals.contains(original)) {
                Disposer.dispose((Disposable)progress);
                return;
            }
            if (last) {
                this.restoreEmptyStatus();
                if (this.myShouldClosePopupAndOnProcessFinish) {
                    this.hideProcessPopup();
                }
            } else if (this.myPopup.isShowing() || this.myOriginals.size() > 1) {
                this.buildInProcessCount();
            } else if (beforeLast) {
                this.buildInInlineIndicator(this.createInlineDelegate(this.myInfos.get(0), this.myOriginals.get(0), true));
            } else {
                this.restoreEmptyStatus();
            }
            this.runQuery();
        }
        Disposer.dispose((Disposable)progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressIndicatorEx removeFromMaps(@NotNull MyInlineProgressIndicator progress) {
        ProgressIndicatorEx original = this.myInline2Original.get(progress);
        this.myInline2Original.remove(progress);
        Set<InlineProgressIndicator> set2 = this.myDirtyIndicators;
        synchronized (set2) {
            this.myDirtyIndicators.remove(progress);
        }
        this.myOriginal2Inlines.remove((Object)original, (Object)progress);
        if (this.myOriginal2Inlines.get((Object)original) == null) {
            int originalIndex = this.myOriginals.indexOf(original);
            this.myOriginals.remove(originalIndex);
            this.myInfos.remove(originalIndex);
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProcessPopup(boolean requestFocus) {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (this.myPopup.isShowing()) {
                return;
            }
            if (this.hasProgressIndicators()) {
                this.myShouldClosePopupAndOnProcessFinish = true;
                this.buildInProcessCount();
            } else {
                this.myShouldClosePopupAndOnProcessFinish = false;
                this.restoreEmptyStatus();
            }
            this.myPopup.show(requestFocus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideProcessPopup() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            if (!this.myPopup.isShowing()) {
                return;
            }
            if (this.myOriginals.size() == 1) {
                this.buildInInlineIndicator(this.createInlineDelegate(this.myInfos.get(0), this.myOriginals.get(0), true));
            } else if (!this.hasProgressIndicators()) {
                this.restoreEmptyStatus();
            } else {
                this.buildInProcessCount();
            }
            this.myPopup.hide();
        }
    }

    private void buildInProcessCount() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel progressCountPanel = new JPanel(new BorderLayout(0, 0));
        progressCountPanel.setOpaque(false);
        String processWord = this.myOriginals.size() == 1 ? " process" : " processes";
        LinkLabel label2 = new LinkLabel(this.myOriginals.size() + processWord + " running...", null, (aSource, aLinkData) -> this.triggerPopupShowing());
        if (SystemInfo.isMac) {
            label2.setFont((Font)JBUI.Fonts.label((float)11.0f));
        }
        label2.setOpaque(false);
        Wrapper labelComp = new Wrapper((JComponent)label2);
        labelComp.setOpaque(false);
        progressCountPanel.add((Component)labelComp, "Center");
        progressCountPanel.add((Component)this.myProgressIcon, "West");
        this.add((Component)this.myRefreshAndInfoPanel, "Center");
        progressCountPanel.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        this.add((Component)progressCountPanel, "East");
        this.revalidate();
        this.repaint();
    }

    private void buildInInlineIndicator(@NotNull MyInlineProgressIndicator inline) {
        this.removeAll();
        this.setLayout((LayoutManager)((Object)new InlineLayout()));
        final JRootPane pane = this.getRootPane();
        if (pane == null) {
            return;
        }
        this.add(this.myRefreshAndInfoPanel);
        JPanel inlinePanel = new JPanel(new BorderLayout());
        inline.getComponent().setBorder((Border)JBUI.Borders.empty((int)1, (int)0, (int)0, (int)2));
        JComponent inlineComponent = inline.getComponent();
        inlineComponent.setOpaque(false);
        inlinePanel.add((Component)inlineComponent, "Center");
        inlinePanel.add((Component)this.myProgressIcon, "West");
        inline.updateProgressNow();
        inlinePanel.setOpaque(false);
        this.add(inlinePanel);
        this.myRefreshAndInfoPanel.revalidate();
        this.myRefreshAndInfoPanel.repaint();
        if (inline.myPresentationModeProgressPanel != null) {
            return;
        }
        inline.myPresentationModeProgressPanel = new PresentationModeProgressPanel(inline);
        Component anchor2 = InfoAndProgressPanel.getAnchor(pane);
        final BalloonLayoutImpl balloonLayout = InfoAndProgressPanel.getBalloonLayout(pane);
        final Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(inline.myPresentationModeProgressPanel.getProgressPanel()).setFadeoutTime(0L).setFillColor(Gray.TRANSPARENT).setShowCallout(false).setBorderColor(Gray.TRANSPARENT).setBorderInsets((Insets)JBUI.emptyInsets()).setAnimationCycle(0).setCloseButtonEnabled(false).setHideOnClickOutside(false).setDisposable((Disposable)inline).setHideOnFrameResize(false).setHideOnKeyOutside(false).setBlockClicksThroughBalloon(true).setHideOnAction(false).setShadow(false).createBalloon();
        if (balloonLayout != null) {
            class MyListener
            implements JBPopupListener,
            Runnable {
                MyListener() {
                }

                public void beforeShown(@NotNull LightweightWindowEvent event) {
                    balloonLayout.addListener(this);
                }

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    balloonLayout.removeListener(this);
                }

                @Override
                public void run() {
                    if (!balloon.isDisposed()) {
                        balloon.revalidate();
                    }
                }
            }
            balloon.addListener((JBPopupListener)new MyListener());
        }
        balloon.show((PositionTracker)new PositionTracker<Balloon>(anchor2){

            public RelativePoint recalculateLocation(Balloon object) {
                Component component;
                Component c = InfoAndProgressPanel.getAnchor(pane);
                int y = c.getHeight() - JBUI.scale((int)45);
                if (balloonLayout != null && !InfoAndProgressPanel.isBottomSideToolWindowsVisible(pane) && (component = balloonLayout.getTopBalloonComponent()) != null) {
                    y = SwingUtilities.convertPoint((Component)component, (int)0, (int)(-JBUI.scale((int)45)), (Component)c).y;
                }
                return new RelativePoint(c, new Point(c.getWidth() - JBUI.scale((int)150), y));
            }
        }, Balloon.Position.above);
    }

    @Nullable
    private static BalloonLayoutImpl getBalloonLayout(@NotNull JRootPane pane) {
        Component parent = UIUtil.findUltimateParent((Component)pane);
        if (parent instanceof IdeFrame) {
            return (BalloonLayoutImpl)((IdeFrame)parent).getBalloonLayout();
        }
        return null;
    }

    @NotNull
    private static Component getAnchor(@NotNull JRootPane pane) {
        JComponent tabWrapper = UIUtil.findComponentOfType((JComponent)pane, TabbedPaneWrapper.TabWrapper.class);
        if (tabWrapper != null && tabWrapper.isShowing()) {
            return tabWrapper;
        }
        EditorsSplitters splitters = (EditorsSplitters)((Object)UIUtil.findComponentOfType((JComponent)pane, EditorsSplitters.class));
        if (splitters != null) {
            return splitters.isShowing() ? splitters : pane;
        }
        FileEditorManagerEx ex = FileEditorManagerEx.getInstanceEx(ProjectUtil.guessCurrentProject((JComponent)pane));
        if (ex == null) {
            return pane;
        }
        splitters = ex.getSplitters();
        return splitters.isShowing() ? splitters : pane;
    }

    private static boolean isBottomSideToolWindowsVisible(@NotNull JRootPane parent) {
        ToolWindowsPane pane = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)parent, ToolWindowsPane.class));
        return pane != null && pane.isBottomSideToolWindowsVisible();
    }

    public Couple<String> setText(@Nullable String text, @Nullable String requestor) {
        if (StringUtil.isEmpty((String)text) && !Comparing.equal((String)requestor, (String)this.myCurrentRequestor) && !"Internal log requestor".equals(requestor)) {
            return Couple.of((Object)this.myInfoPanel.getText(), (Object)this.myCurrentRequestor);
        }
        boolean logMode = this.myInfoPanel.updateText("Internal log requestor".equals(requestor) ? "" : text);
        this.myCurrentRequestor = logMode ? "Internal log requestor" : requestor;
        return Couple.of((Object)text, (Object)requestor);
    }

    void setRefreshVisible(boolean visible) {
        UIUtil.invokeLaterIfNeeded(() -> this.myRefreshIcon.setVisible(visible));
    }

    void setRefreshToolTipText(String tooltip) {
        this.myRefreshIcon.setToolTipText(tooltip);
    }

    public BalloonHandler notifyByBalloon(MessageType type, String htmlBody, @Nullable Icon icon, @Nullable HyperlinkListener listener2) {
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlBody.replace("\n", "<br>"), icon != null ? icon : type.getDefaultIcon(), type.getPopupBackground(), listener2).createBalloon();
        SwingUtilities.invokeLater(() -> {
            Balloon oldBalloon = (Balloon)SoftReference.dereference(this.myLastShownBalloon);
            if (oldBalloon != null) {
                balloon.setAnimationEnabled(false);
                oldBalloon.setAnimationEnabled(false);
                oldBalloon.hide();
            }
            this.myLastShownBalloon = new WeakReference<Balloon>(balloon);
            InfoAndProgressPanel comp = this;
            if (comp.isShowing()) {
                int offset = ((Component)comp).getHeight() / 2;
                Point point = new Point(((Component)comp).getWidth() - offset, ((Component)comp).getHeight() - offset);
                balloon.show(new RelativePoint((Component)comp, point), Balloon.Position.above);
            } else {
                JRootPane rootPane = SwingUtilities.getRootPane(comp);
                if (rootPane != null && rootPane.isShowing()) {
                    Container contentPane = rootPane.getContentPane();
                    Rectangle bounds2 = contentPane.getBounds();
                    Point target2 = UIUtil.getCenterPoint((Rectangle)bounds2, (Dimension)JBUI.size((int)1, (int)1));
                    target2.y = bounds2.height - 3;
                    balloon.show(new RelativePoint((Component)contentPane, target2), Balloon.Position.above);
                }
            }
        });
        return () -> SwingUtilities.invokeLater(() -> ((Balloon)balloon).hide());
    }

    @NotNull
    private MyInlineProgressIndicator createInlineDelegate(@NotNull TaskInfo info, @NotNull ProgressIndicatorEx original, boolean compact) {
        Collection inlines = this.myOriginal2Inlines.get((Object)original);
        if (inlines != null) {
            for (MyInlineProgressIndicator eachInline : inlines) {
                if (eachInline.isCompact() != compact) continue;
                return eachInline;
            }
        }
        MyInlineProgressIndicator inline = new MyInlineProgressIndicator(compact, info, original);
        this.myInline2Original.put(inline, original);
        this.myOriginal2Inlines.put((Object)original, (Object)inline);
        if (compact) {
            inline.getComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    InfoAndProgressPanel.this.handle(e);
                }
            });
        }
        return inline;
    }

    private void triggerPopupShowing() {
        if (this.myPopup.isShowing()) {
            this.hideProcessPopup();
        } else {
            this.openProcessPopup(true);
        }
    }

    private void restoreEmptyStatusInner() {
        this.removeAll();
        this.updateProgressIcon();
        Container iconParent = this.myProgressIcon.getParent();
        if (iconParent != null) {
            iconParent.remove((Component)this.myProgressIcon);
        }
    }

    private void updateProgressIcon() {
        if (this.myOriginals.isEmpty() || PowerSaveMode.isEnabled() || this.myOriginals.stream().map(ProgressSuspender::getSuspender).allMatch(s -> s != null && s.isSuspended())) {
            this.myProgressIcon.suspend();
        } else {
            this.myProgressIcon.resume();
        }
    }

    private void restoreEmptyStatus() {
        this.restoreEmptyStatusInner();
        this.setLayout(new BorderLayout());
        this.add((Component)this.myRefreshAndInfoPanel, "Center");
        this.myRefreshAndInfoPanel.revalidate();
        this.myRefreshAndInfoPanel.repaint();
    }

    boolean isProcessWindowOpen() {
        return this.myPopup.isShowing();
    }

    void setProcessWindowOpen(boolean open2) {
        if (open2) {
            this.openProcessPopup(true);
        } else {
            this.hideProcessPopup();
        }
    }

    private void runQuery() {
        if (this.getRootPane() == null) {
            return;
        }
        Set<InlineProgressIndicator> indicators = this.getCurrentInlineIndicators();
        if (indicators.isEmpty()) {
            return;
        }
        for (InlineProgressIndicator each : indicators) {
            each.updateProgress();
        }
        this.myQueryAlarm.cancelAllRequests();
        this.myQueryAlarm.addRequest(this::runQuery, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<InlineProgressIndicator> getCurrentInlineIndicators() {
        List<ProgressIndicatorEx> list2 = this.myOriginals;
        synchronized (list2) {
            return this.myInline2Original.keySet();
        }
    }

    private class MyInlineProgressIndicator
    extends InlineProgressIndicator {
        private ProgressIndicatorEx myOriginal;
        private PresentationModeProgressPanel myPresentationModeProgressPanel;

        MyInlineProgressIndicator(@NotNull boolean compact, @NotNull TaskInfo task2, ProgressIndicatorEx original) {
            super(compact, task2);
            this.myOriginal = original;
            original.addStateDelegate(this);
            this.addStateDelegate(new AbstractProgressIndicatorExBase(){

                @Override
                public void cancel() {
                    super.cancel();
                    MyInlineProgressIndicator.this.updateProgress();
                }
            });
            InfoAndProgressPanel.this.runOnProgressRelatedChange(this::queueProgressUpdate, this);
        }

        @Override
        public String getText() {
            String text = StringUtil.notNullize((String)super.getText());
            ProgressSuspender suspender = this.getSuspender();
            return suspender != null && suspender.isSuspended() ? suspender.getSuspendedText() : text;
        }

        @Override
        protected JBIterable<ProgressButton> createEastButtons() {
            return JBIterable.of((Object)this.createSuspendButton()).append(super.createEastButtons());
        }

        private ProgressButton createSuspendButton() {
            InplaceButton suspendButton = new InplaceButton("", AllIcons.Actions.Pause, e -> {
                ProgressSuspender suspender = Objects.requireNonNull(this.getSuspender());
                if (suspender.isSuspended()) {
                    suspender.resumeProcess();
                } else {
                    suspender.suspendProcess(null);
                }
                ActionsCollector.getInstance().record(suspender.isSuspended() ? "Progress Paused" : "Progress Resumed", MyInlineProgressIndicator.class);
            }).setFillBg(false);
            suspendButton.setVisible(false);
            return new ProgressButton(suspendButton, () -> {
                ProgressSuspender suspender = this.getSuspender();
                suspendButton.setVisible(suspender != null);
                if (suspender != null) {
                    String toolTipText;
                    String string = toolTipText = suspender.isSuspended() ? "Resume" : "Pause";
                    if (!toolTipText.equals(suspendButton.getToolTipText())) {
                        InfoAndProgressPanel.this.updateProgressIcon();
                        if (suspender.isSuspended()) {
                            this.showResumeIcons(suspendButton);
                        } else {
                            this.showPauseIcons(suspendButton);
                        }
                        suspendButton.setToolTipText(toolTipText);
                    }
                }
            });
        }

        private void showPauseIcons(InplaceButton button2) {
            this.setIcons(button2, AllIcons.Process.ProgressPauseSmall, AllIcons.Process.ProgressPause, AllIcons.Process.ProgressPauseSmallHover, AllIcons.Process.ProgressPauseHover);
        }

        private void showResumeIcons(InplaceButton button2) {
            this.setIcons(button2, AllIcons.Process.ProgressResumeSmall, AllIcons.Process.ProgressResume, AllIcons.Process.ProgressResumeSmallHover, AllIcons.Process.ProgressResumeHover);
        }

        private void setIcons(InplaceButton button2, Icon compactRegular, Icon regular, Icon compactHovered, Icon hovered) {
            button2.setIcons(this.isCompact() ? compactRegular : regular, null, this.isCompact() ? compactHovered : hovered);
        }

        @Nullable
        private ProgressSuspender getSuspender() {
            ProgressIndicatorEx original = this.myOriginal;
            return original == null ? null : ProgressSuspender.getSuspender(original);
        }

        @Override
        public void stop() {
            super.stop();
            this.updateProgress();
        }

        @Override
        protected boolean isFinished() {
            TaskInfo info = this.getInfo();
            return info == null || this.isFinished(info);
        }

        @Override
        public void finish(@NotNull TaskInfo task2) {
            super.finish(task2);
            this.queueRunningUpdate(() -> InfoAndProgressPanel.this.removeProgress(this));
        }

        @Override
        public void dispose() {
            super.dispose();
            this.myOriginal = null;
        }

        @Override
        protected void cancelRequest() {
            this.myOriginal.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void queueProgressUpdate() {
            Set set2 = InfoAndProgressPanel.this.myDirtyIndicators;
            synchronized (set2) {
                InfoAndProgressPanel.this.myDirtyIndicators.add(this);
            }
            InfoAndProgressPanel.this.myUpdateQueue.queue(InfoAndProgressPanel.this.myUpdateIndicators);
        }

        @Override
        protected void queueRunningUpdate(final @NotNull Runnable update) {
            InfoAndProgressPanel.this.myUpdateQueue.queue(new Update(new Object(), false, 0){

                public void run() {
                    ApplicationManager.getApplication().invokeLater(update);
                }
            });
        }

        @Override
        public void updateProgressNow() {
            this.myProgress.setVisible(!PowerSaveMode.isEnabled() || !this.isPaintingIndeterminate());
            super.updateProgressNow();
            if (this.myPresentationModeProgressPanel != null) {
                this.myPresentationModeProgressPanel.update();
            }
        }
    }

    private static class InlineLayout
    extends AbstractLayoutManager {
        private int myProgressWidth;

        private InlineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result2 = new Dimension();
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Dimension prefSize = parent.getComponent(i).getPreferredSize();
                result2.width += prefSize.width;
                result2.height = Math.max(prefSize.height, result2.height);
            }
            return result2;
        }

        public void layoutContainer(Container parent) {
            assert (parent.getComponentCount() == 2);
            Component infoPanel = parent.getComponent(0);
            Component progressPanel = parent.getComponent(1);
            int progressPrefWidth = progressPanel.getPreferredSize().width;
            Dimension size = parent.getSize();
            int maxProgressWidth = (int)((double)size.width * 0.8);
            int minProgressWidth = (int)((double)size.width * 0.5);
            if (progressPrefWidth > this.myProgressWidth) {
                this.myProgressWidth = progressPrefWidth;
            }
            if (this.myProgressWidth > maxProgressWidth) {
                this.myProgressWidth = maxProgressWidth;
            }
            if (this.myProgressWidth < minProgressWidth) {
                this.myProgressWidth = minProgressWidth;
            }
            infoPanel.setBounds(0, 0, size.width - this.myProgressWidth, size.height);
            progressPanel.setBounds(size.width - this.myProgressWidth, 0, this.myProgressWidth, size.height);
        }
    }
}

