/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineSeparatorPanel
extends EditorBasedStatusBarPopup {
    public LineSeparatorPanel(@NotNull Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        String panelText;
        String toolTipText;
        if (file2 == null) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        String lineSeparator = LoadTextUtil.detectLineSeparator(file2, true);
        if (lineSeparator != null) {
            toolTipText = String.format("Line separator: %s", StringUtil.escapeLineBreak((String)lineSeparator));
            panelText = LineSeparator.fromString((String)lineSeparator).toString();
        } else {
            toolTipText = "No line separator";
            panelText = "n/a";
        }
        return new EditorBasedStatusBarPopup.WidgetState(toolTipText, panelText, lineSeparator != null);
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        AnAction group = ActionManager.getInstance().getAction("ChangeLineSeparators");
        if (!(group instanceof ActionGroup)) {
            return null;
        }
        return JBPopupFactory.getInstance().createActionGroupPopup("Line Separator", (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @Override
    protected void registerCustomListeners() {
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(Project project) {
        return new LineSeparatorPanel(project);
    }

    @NotNull
    public String ID() {
        return "LineSeparator";
    }
}

