/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.ui.components.panels.Wrapper;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSouthPanelTestDialogAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        new MyDialogWrapper(e.getProject()).show();
    }

    private static class MyDialogWrapper
    extends DialogWrapper {
        private final boolean ORIGINAL_ALLOW_MERGE_BUTTONS;
        private final Wrapper mySouthPanel = new Wrapper();
        private final JButton myRefresh = new JButton("Refresh");
        private final JCheckBox myHasOKAction = new JCheckBox("OK action", true);
        private final JCheckBox myHasCancelAction = new JCheckBox("Cancel action", true);
        private final JCheckBox myHasHelpAction = new JCheckBox("Help action", true);
        private final JCheckBox myHasOptionAction = new JCheckBox("Option action", false);
        private final JCheckBox myHasLeftAction = new JCheckBox("Left action", true);
        private final JCheckBox myHasDoNotShowCheckbox = new JCheckBox("'Do not show' checkbox", true);
        private final JCheckBox myAllowMergeButtons = new JCheckBox("Allow merge buttons", false);
        private final JCheckBox myCompact = new JCheckBox("Compact style", false);
        private final JCheckBox myErrorText = new JCheckBox("Error text", false);
        private final JCheckBox myMoveErrorTextToButtons = new JCheckBox("Move error text to the buttons", false);
        private final JCheckBox myCenterButtons = new JCheckBox("Center buttons", false);

        MyDialogWrapper(Project project) {
            super(project);
            this.ORIGINAL_ALLOW_MERGE_BUTTONS = UISettings.getShadowInstance().getAllowMergeButtons();
            this.init();
        }

        protected void dispose() {
            UISettings.getShadowInstance().setAllowMergeButtons(this.ORIGINAL_ALLOW_MERGE_BUTTONS);
            super.dispose();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            this.myRefresh.addActionListener(e -> this.refreshSouthPanel());
            this.myAllowMergeButtons.setSelected(this.ORIGINAL_ALLOW_MERGE_BUTTONS);
            this.myAllowMergeButtons.addActionListener(e -> UISettings.getShadowInstance().setAllowMergeButtons(this.myAllowMergeButtons.isSelected()));
            this.myErrorText.addActionListener(e -> this.setErrorText(this.myErrorText.isSelected() ? "Error text" : null, this.myErrorText));
            this.myCenterButtons.addActionListener(e -> this.setButtonsAlignment(this.myCenterButtons.isSelected() ? 0 : 4));
            panel2.add(this.myRefresh);
            panel2.add(this.myHasOKAction);
            panel2.add(this.myHasCancelAction);
            panel2.add(this.myHasHelpAction);
            panel2.add(this.myHasOptionAction);
            panel2.add(this.myHasLeftAction);
            panel2.add(this.myHasDoNotShowCheckbox);
            panel2.add(this.myAllowMergeButtons);
            panel2.add(this.myCompact);
            panel2.add(this.myErrorText);
            panel2.add(this.myMoveErrorTextToButtons);
            panel2.add(this.myCenterButtons);
            return panel2;
        }

        protected JComponent createSouthPanel() {
            this.refreshSouthPanel();
            return this.mySouthPanel;
        }

        private void refreshSouthPanel() {
            this.mySouthPanel.setContent(super.createSouthPanel());
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.myHasOKAction.isSelected() ? this.getOKAction() : null, this.myHasCancelAction.isSelected() ? this.getCancelAction() : null, this.myHasHelpAction.isSelected() ? this.getHelpAction() : null, this.myHasOptionAction.isSelected() ? new MyOptionAction() : null};
        }

        @NotNull
        protected Action[] createLeftSideActions() {
            Action[] actionArray;
            if (this.myHasLeftAction.isSelected()) {
                Action[] actionArray2 = new Action[1];
                actionArray = actionArray2;
                actionArray2[0] = new MyAction("Left");
            } else {
                actionArray = new Action[]{};
            }
            return actionArray;
        }

        @NotNull
        protected DialogWrapper.DialogStyle getStyle() {
            return this.myCompact.isSelected() ? DialogWrapper.DialogStyle.COMPACT : DialogWrapper.DialogStyle.NO_STYLE;
        }

        @Nullable
        protected JComponent createDoNotAskCheckbox() {
            return this.myHasDoNotShowCheckbox.isSelected() ? new JCheckBox("Do not show again") : null;
        }

        protected boolean shouldAddErrorNearButtons() {
            return this.myMoveErrorTextToButtons.isSelected();
        }

        private static class MyAction
        extends AbstractAction {
            MyAction(String name) {
                super(name);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }

        private static class MyOptionAction
        extends MyAction
        implements OptionAction {
            private final Action[] myActions = new Action[]{new MyAction("Option #1"), new MyAction("Option #2"), new MyAction("Option #3")};

            MyOptionAction() {
                super("Option Button");
            }

            @NotNull
            public Action[] getOptions() {
                return this.myActions;
            }
        }
    }
}

