/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.ProjectGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.wm.impl.welcomeScreen.RecentProjectsWelcomeScreenActionBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoveProjectToGroupAction
extends RecentProjectsWelcomeScreenActionBase {
    private final ProjectGroup myGroup;

    public MoveProjectToGroupAction(ProjectGroup group) {
        this.myGroup = group;
        this.getTemplatePresentation().setText(group.getName());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<AnAction> elements = MoveProjectToGroupAction.getSelectedElements(e);
        for (AnAction element : elements) {
            if (!(element instanceof ReopenProjectAction)) continue;
            String path = ((ReopenProjectAction)element).getProjectPath();
            for (ProjectGroup group : RecentProjectsManager.getInstance().getGroups()) {
                group.removeProject(path);
                this.myGroup.addProject(path);
            }
        }
        MoveProjectToGroupAction.rebuildRecentProjectsList(e);
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(!MoveProjectToGroupAction.hasGroupSelected(e));
    }
}

