/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.BottomLineBorder;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenColors;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentProjectPanel
extends JPanel {
    public static final String RECENT_PROJECTS_LABEL = "Recent Projects";
    protected final JBList myList;
    protected final UniqueNameBuilder<ReopenProjectAction> myPathShortener;
    protected AnAction removeRecentProjectAction;
    private int myHoverIndex = -1;
    private final int closeButtonInset = JBUI.scale((int)7);
    private Icon currentIcon = RecentProjectPanel.toSize(AllIcons.Welcome.Project.Remove);
    private static final Logger LOG = Logger.getInstance(RecentProjectPanel.class);
    Set<ReopenProjectAction> projectsWithLongPathes = new HashSet<ReopenProjectAction>(0);
    private final JPanel myCloseButtonForEditor = new JPanel(){
        {
            this.setPreferredSize(new Dimension(RecentProjectPanel.this.currentIcon.getIconWidth(), RecentProjectPanel.this.currentIcon.getIconHeight()));
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            RecentProjectPanel.this.currentIcon.paintIcon(this, g, 0, 0);
        }
    };
    protected FilePathChecker myChecker;

    private boolean rectInListCoordinatesContains(Rectangle listCellBounds, Point p) {
        int realCloseButtonInset = UIUtil.isJreHiDPI((Component)this) ? (int)((float)this.closeButtonInset * JBUI.sysScale((Component)this)) : this.closeButtonInset;
        Rectangle closeButtonRect = new Rectangle(this.myCloseButtonForEditor.getX() - realCloseButtonInset, this.myCloseButtonForEditor.getY() - realCloseButtonInset, this.myCloseButtonForEditor.getWidth() + realCloseButtonInset * 2, this.myCloseButtonForEditor.getHeight() + realCloseButtonInset * 2);
        Rectangle rectInListCoordinates = new Rectangle(new Point(closeButtonRect.x + listCellBounds.x, closeButtonRect.y + listCellBounds.y), closeButtonRect.getSize());
        return rectInListCoordinates.contains(p);
    }

    public RecentProjectPanel(@NotNull Disposable parentDisposable) {
        super(new BorderLayout());
        AnAction[] recentProjectActions = RecentProjectsManager.getInstance().getRecentProjectsActions(false, this.isUseGroups());
        this.myPathShortener = new UniqueNameBuilder(SystemProperties.getUserHome(), File.separator, 40);
        HashSet pathsToCheck = ContainerUtil.newHashSet();
        for (AnAction action : recentProjectActions) {
            if (!(action instanceof ReopenProjectAction)) continue;
            ReopenProjectAction item = (ReopenProjectAction)action;
            this.myPathShortener.addPath((Object)item, item.getProjectPath());
            pathsToCheck.add(item.getProjectPath());
        }
        if (Registry.is((String)"autocheck.availability.welcome.screen.projects")) {
            this.myChecker = new FilePathChecker(new Runnable(){

                @Override
                public void run() {
                    if (RecentProjectPanel.this.myList.isShowing()) {
                        RecentProjectPanel.this.myList.revalidate();
                        RecentProjectPanel.this.myList.repaint();
                    }
                }
            }, pathsToCheck);
            Disposer.register((Disposable)parentDisposable, (Disposable)this.myChecker);
        }
        this.myList = this.createList(recentProjectActions, this.getPreferredScrollableViewportSize());
        this.myList.setCellRenderer(this.createRenderer(this.myPathShortener));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                Rectangle cellBounds;
                int selectedIndex = RecentProjectPanel.this.myList.getSelectedIndex();
                if (selectedIndex >= 0 && (cellBounds = RecentProjectPanel.this.myList.getCellBounds(selectedIndex, selectedIndex)).contains(event.getPoint())) {
                    Object selection = RecentProjectPanel.this.myList.getSelectedValue();
                    if (Registry.is((String)"removable.welcome.screen.projects") && RecentProjectPanel.this.rectInListCoordinatesContains(cellBounds, event.getPoint())) {
                        RecentProjectPanel.this.removeRecentProject();
                    } else if (selection != null) {
                        AnAction selectedAction = (AnAction)selection;
                        AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((AnAction)selectedAction, (InputEvent)event, (String)"WelcomeScreen");
                        selectedAction.actionPerformed(actionEvent);
                        if (selectedAction instanceof ReopenProjectAction && ((ReopenProjectAction)selectedAction).isRemoved()) {
                            ListUtil.removeSelectedItems((JList)RecentProjectPanel.this.myList);
                        }
                    }
                }
                return true;
            }
        }.installOn((Component)this.myList);
        this.myList.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedValued = RecentProjectPanel.this.myList.getSelectedValues();
                if (selectedValued != null) {
                    for (Object selection : selectedValued) {
                        AnActionEvent event = AnActionEvent.createFromInputEvent((AnAction)((AnAction)selection), null, (String)"WelcomeScreen");
                        ((AnAction)selection).actionPerformed(event);
                    }
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.removeRecentProjectAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                RecentProjectPanel.this.removeRecentProject();
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(true);
            }
        };
        this.removeRecentProjectAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), (JComponent)this.myList, parentDisposable);
        this.addMouseMotionListener();
        this.myList.setSelectedIndex(0);
        JBScrollPane scroll = new JBScrollPane((Component)this.myList, 20, 31);
        scroll.setBorder(null);
        JBList list2 = recentProjectActions.length == 0 ? this.myList : ListWithFilter.wrap((JList)this.myList, (JScrollPane)scroll, o -> {
            if (o instanceof ReopenProjectAction) {
                ReopenProjectAction item = (ReopenProjectAction)((Object)((Object)o));
                String home = SystemProperties.getUserHome();
                String path = item.getProjectPath();
                if (FileUtil.startsWith((String)path, (String)home)) {
                    path = path.substring(home.length());
                }
                return item.getProjectName() + " " + path;
            }
            if (o instanceof ProjectGroupActionGroup) {
                return ((ProjectGroupActionGroup)((Object)((Object)o))).getGroup().getName();
            }
            return o.toString();
        });
        this.add((Component)list2, "Center");
        JPanel title = this.createTitle();
        if (title != null) {
            this.add((Component)title, "North");
        }
        this.setBorder(new LineBorder(WelcomeScreenColors.BORDER_COLOR));
    }

    private void removeRecentProject() {
        int rc;
        Object[] selection = this.myList.getSelectedValues();
        if (selection != null && selection.length > 0 && (rc = Messages.showOkCancelDialog((Component)this, (String)("Remove '" + StringUtil.join((Object[])selection, action -> ((AnAction)action).getTemplatePresentation().getText(), (String)"'\n'") + "' from recent projects list?"), (String)"Remove Recent Project", (Icon)Messages.getQuestionIcon())) == 0) {
            for (Object projectAction : selection) {
                RecentProjectPanel.removeRecentProjectElement(projectAction);
            }
            ListUtil.removeSelectedItems((JList)this.myList);
        }
    }

    protected boolean isPathValid(String path) {
        return this.myChecker == null || this.myChecker.isValid(path);
    }

    protected static void removeRecentProjectElement(Object element) {
        RecentProjectsManager manager = RecentProjectsManager.getInstance();
        if (element instanceof ReopenProjectAction) {
            manager.removePath(((ReopenProjectAction)((Object)element)).getProjectPath());
        } else if (element instanceof ProjectGroupActionGroup) {
            ProjectGroup group = ((ProjectGroupActionGroup)((Object)element)).getGroup();
            for (String path : group.getProjects()) {
                manager.removePath(path);
            }
            manager.removeGroup(group);
        }
    }

    protected boolean isUseGroups() {
        return false;
    }

    protected Dimension getPreferredScrollableViewportSize() {
        return JBUI.size((int)250, (int)400);
    }

    protected void addMouseMotionListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner == null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)RecentProjectPanel.this.myList, true));
                }
                if (RecentProjectPanel.this.myList.getSelectedIndices().length > 1) {
                    return;
                }
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !(focusOwner instanceof JRootPane)) {
                    Point point = e.getPoint();
                    int index = RecentProjectPanel.this.myList.locationToIndex(point);
                    RecentProjectPanel.this.myList.setSelectedIndex(index);
                    Rectangle cellBounds = RecentProjectPanel.this.myList.getCellBounds(index, index);
                    if (cellBounds != null && cellBounds.contains(point)) {
                        UIUtil.setCursor((Component)RecentProjectPanel.this.myList, (Cursor)Cursor.getPredefinedCursor(12));
                        if (RecentProjectPanel.this.rectInListCoordinatesContains(cellBounds, point)) {
                            RecentProjectPanel.this.currentIcon = RecentProjectPanel.toSize(AllIcons.Welcome.Project.Remove_hover);
                        } else {
                            RecentProjectPanel.this.currentIcon = RecentProjectPanel.toSize(AllIcons.Welcome.Project.Remove);
                        }
                        RecentProjectPanel.this.myHoverIndex = index;
                        RecentProjectPanel.this.myList.repaint(cellBounds);
                    } else {
                        UIUtil.setCursor((Component)RecentProjectPanel.this.myList, (Cursor)Cursor.getPredefinedCursor(0));
                        RecentProjectPanel.this.myHoverIndex = -1;
                        RecentProjectPanel.this.myList.repaint();
                    }
                } else {
                    this.myIsEngaged = true;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RecentProjectPanel.this.myHoverIndex = -1;
                RecentProjectPanel.this.currentIcon = RecentProjectPanel.toSize(AllIcons.Welcome.Project.Remove);
                RecentProjectPanel.this.myList.repaint();
            }
        };
        this.myList.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        this.myList.addMouseListener((MouseListener)mouseAdapter);
    }

    protected JBList createList(AnAction[] recentProjectActions, Dimension size) {
        return new MyList(size, recentProjectActions);
    }

    protected ListCellRenderer createRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
        return new RecentProjectItemRenderer(pathShortener);
    }

    @Nullable
    protected JPanel createTitle() {
        JPanel title = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, JBUI.scale((int)28));
            }
        };
        title.setBorder(new BottomLineBorder());
        JLabel titleLabel = new JLabel(RECENT_PROJECTS_LABEL);
        title.add(titleLabel);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.setForeground(WelcomeScreenColors.CAPTION_FOREGROUND);
        title.setBackground(WelcomeScreenColors.CAPTION_BACKGROUND);
        return title;
    }

    private static boolean isFileAvailable(File file2) {
        List<File> roots = Arrays.asList(File.listRoots());
        for (File tmp = file2; tmp != null; tmp = tmp.getParentFile()) {
            if (!roots.contains(tmp)) continue;
            return file2.exists();
        }
        return false;
    }

    @NotNull
    private static Icon toSize(@NotNull Icon icon) {
        return IconUtil.toSize((Icon)icon, (int)((int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getWidth()), (int)((int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getHeight()));
    }

    public static boolean isFileSystemPath(String path) {
        return path.indexOf(47) != -1 || path.indexOf(92) != -1;
    }

    private static class FilePathChecker
    implements Disposable,
    ApplicationActivationListener,
    PowerSaveMode.Listener {
        private static final int MIN_AUTO_UPDATE_MILLIS = 2500;
        private ScheduledExecutorService myService = null;
        private final Set<String> myInvalidPaths = Collections.synchronizedSet(new HashSet());
        private final Runnable myCallback;
        private final Collection<String> myPaths;

        FilePathChecker(Runnable callback2, Collection<String> paths) {
            this.myCallback = callback2;
            this.myPaths = paths;
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)this);
            connection.subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.onAppStateChanged();
        }

        boolean isValid(String path) {
            return !this.myInvalidPaths.contains(path);
        }

        public void applicationActivated(@NotNull IdeFrame ideFrame) {
            this.onAppStateChanged();
        }

        public void delayedApplicationDeactivated(@NotNull IdeFrame ideFrame) {
            this.onAppStateChanged();
        }

        public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        }

        public void powerSaveStateChanged() {
            this.onAppStateChanged();
        }

        private void onAppStateChanged() {
            boolean everythingIsOK;
            boolean settingsAreOK = Registry.is((String)"autocheck.availability.welcome.screen.projects") && !PowerSaveMode.isEnabled();
            boolean bl = everythingIsOK = settingsAreOK && ApplicationManager.getApplication().isActive();
            if (this.myService == null && everythingIsOK) {
                this.myService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"CheckRecentProjectPaths Service", (int)2);
                for (String path : this.myPaths) {
                    this.scheduleCheck(path, 0L);
                }
                ApplicationManager.getApplication().invokeLater(this.myCallback);
            }
            if (this.myService != null && !everythingIsOK) {
                if (!settingsAreOK) {
                    this.myInvalidPaths.clear();
                }
                if (!this.myService.isShutdown()) {
                    this.myService.shutdown();
                    this.myService = null;
                }
                ApplicationManager.getApplication().invokeLater(this.myCallback);
            }
        }

        public void dispose() {
            if (this.myService != null) {
                this.myService.shutdownNow();
            }
        }

        private void scheduleCheck(String path, long delay) {
            if (this.myService == null || this.myService.isShutdown()) {
                return;
            }
            this.myService.schedule(() -> {
                boolean pathIsValid;
                long startTime = System.currentTimeMillis();
                try {
                    pathIsValid = !RecentProjectPanel.isFileSystemPath(path) ? true : RecentProjectPanel.isFileAvailable(new File(path));
                }
                catch (Exception e) {
                    pathIsValid = false;
                }
                if (this.myInvalidPaths.contains(path) == pathIsValid) {
                    if (pathIsValid) {
                        this.myInvalidPaths.remove(path);
                    } else {
                        this.myInvalidPaths.add(path);
                    }
                    ApplicationManager.getApplication().invokeLater(this.myCallback);
                }
                this.scheduleCheck(path, Math.max(2500L, 10L * (System.currentTimeMillis() - startTime)));
            }, delay, TimeUnit.MILLISECONDS);
        }
    }

    protected class RecentProjectItemRenderer
    extends JPanel
    implements ListCellRenderer {
        protected final JLabel myName;
        protected final JLabel myPath;
        protected boolean myHovered;
        protected JPanel myCloseThisItem;
        private final UniqueNameBuilder<ReopenProjectAction> myShortener;

        protected RecentProjectItemRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
            super((LayoutManager)new VerticalFlowLayout());
            this.myName = new JLabel();
            this.myPath = new JLabel();
            this.myCloseThisItem = RecentProjectPanel.this.myCloseButtonForEditor;
            this.myShortener = pathShortener;
            this.myPath.setFont((Font)JBUI.Fonts.label((float)(SystemInfo.isMac ? 10.0f : 11.0f)));
            this.setFocusable(true);
            this.layoutComponents();
        }

        protected void layoutComponents() {
            this.add(this.myName);
            this.add(this.myPath);
        }

        protected Color getListBackground(boolean isSelected, boolean hasFocus) {
            return UIUtil.getListBackground((boolean)isSelected);
        }

        protected Color getListForeground(boolean isSelected, boolean hasFocus) {
            return UIUtil.getListForeground((boolean)isSelected);
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.myHovered = RecentProjectPanel.this.myHoverIndex == index;
            Color fore = this.getListForeground(isSelected, list2.hasFocus());
            Color back = this.getListBackground(isSelected, list2.hasFocus());
            this.myName.setForeground(fore);
            this.myPath.setForeground(isSelected ? fore : UIUtil.getInactiveTextColor());
            this.setBackground(back);
            if (value instanceof ReopenProjectAction) {
                ReopenProjectAction item = (ReopenProjectAction)((Object)value);
                this.myName.setText(item.getTemplatePresentation().getText());
                this.myPath.setText(this.getTitle2Text(item, this.myPath, JBUI.scale((int)40)));
            } else if (value instanceof ProjectGroupActionGroup) {
                ProjectGroupActionGroup group = (ProjectGroupActionGroup)((Object)value);
                this.myName.setText(group.getGroup().getName());
                this.myPath.setText("");
            }
            AccessibleContextUtil.setCombinedName((Component)this, (Component)this.myName, (String)" - ", (Component)this.myPath);
            AccessibleContextUtil.setCombinedDescription((Component)this, (Component)this.myName, (String)" - ", (Component)this.myPath);
            return this;
        }

        protected String getTitle2Text(ReopenProjectAction action, JComponent pathLabel, int leftOffset) {
            String fullText = action.getProjectPath();
            if (fullText == null || fullText.length() == 0) {
                return " ";
            }
            fullText = FileUtil.getLocationRelativeToUserHome((String)PathUtil.toSystemDependentName((String)fullText), (boolean)false);
            try {
                FontMetrics fm = pathLabel.getFontMetrics(pathLabel.getFont());
                int maxWidth = RecentProjectPanel.this.getWidth() - leftOffset - (int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getWidth() - JBUI.scale((int)10);
                if (maxWidth > 0 && fm.stringWidth(fullText) > maxWidth) {
                    return this.truncateDescription(fullText, fm, maxWidth, this.isTutorial(action));
                }
            }
            catch (Exception e) {
                LOG.error("Path label font: " + pathLabel.getFont());
                LOG.error("Panel width: " + RecentProjectPanel.this.getWidth());
                LOG.error((Throwable)e);
            }
            return fullText;
        }

        private boolean isTutorial(ReopenProjectAction action) {
            List groups = RecentProjectsManager.getInstance().getGroups();
            for (ProjectGroup group : groups) {
                if (!group.isTutorials()) continue;
                for (String project : group.getProjects()) {
                    if (!project.contains(action.getProjectPath())) continue;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private String truncateDescription(String fullText, FontMetrics fm, int maxWidth, boolean isTutorial) {
            if (isTutorial) {
                String tutorialTruncated = fullText;
                while (fm.stringWidth(tutorialTruncated) > maxWidth) {
                    tutorialTruncated = tutorialTruncated.substring(0, tutorialTruncated.length() - 1);
                }
                return tutorialTruncated + "...";
            }
            int left = 1;
            int right = 1;
            int center = fullText.length() / 2;
            String s = fullText.substring(0, center - left) + "..." + fullText.substring(center + right);
            while (fm.stringWidth(s) > maxWidth) {
                if (left == right) {
                    ++left;
                } else {
                    ++right;
                }
                if (center - left < 0 || center + right >= fullText.length()) {
                    return "";
                }
                s = fullText.substring(0, center - left) + "..." + fullText.substring(center + right);
            }
            return s;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.min(size.width, JBUI.scale((int)245)), size.height);
        }

        @Override
        @NotNull
        public Dimension getSize() {
            return this.getPreferredSize();
        }
    }

    private class MyList
    extends JBList<AnAction> {
        private final Dimension mySize;
        private Point myMousePoint;

        private MyList(@NotNull Dimension size, AnAction[] listData) {
            super((Object[])listData);
            this.mySize = size;
            this.setExpandableItemsEnabled(false);
            this.setEmptyText("  No Project Open Yet  ");
            this.setSelectionMode(2);
            this.getAccessibleContext().setAccessibleName(RecentProjectPanel.RECENT_PROJECTS_LABEL);
            MouseHandler handler2 = new MouseHandler();
            this.addMouseListener(handler2);
            this.addMouseMotionListener(handler2);
        }

        public Rectangle getCloseIconRect(int index) {
            Rectangle bounds2 = this.getCellBounds(index, index);
            Icon icon = RecentProjectPanel.toSize(AllIcons.Welcome.Project.Remove);
            return new Rectangle(bounds2.width - icon.getIconWidth() - JBUI.scale((int)10), bounds2.y + (bounds2.height - icon.getIconHeight()) / 2, icon.getIconWidth(), icon.getIconHeight());
        }

        public void paint(Graphics g) {
            int index;
            super.paint(g);
            if (this.myMousePoint != null && (index = this.locationToIndex(this.myMousePoint)) != -1) {
                Rectangle iconRect = this.getCloseIconRect(index);
                Icon icon = RecentProjectPanel.toSize(iconRect.contains(this.myMousePoint) ? AllIcons.Welcome.Project.Remove_hover : AllIcons.Welcome.Project.Remove);
                icon.paintIcon((Component)((Object)this), g, iconRect.x, iconRect.y);
            }
        }

        public String getToolTipText(MouseEvent event) {
            String path;
            boolean valid;
            Object elem;
            int i = this.locationToIndex(event.getPoint());
            if (i != -1 && (elem = this.getModel().getElementAt(i)) instanceof ReopenProjectAction && (!(valid = RecentProjectPanel.this.isPathValid(path = ((ReopenProjectAction)((Object)elem)).getProjectPath())) || RecentProjectPanel.this.projectsWithLongPathes.contains(elem))) {
                String suffix = valid ? "" : " (unavailable)";
                return PathUtil.toSystemDependentName((String)path) + suffix;
            }
            return super.getToolTipText(event);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.mySize == null ? super.getPreferredScrollableViewportSize() : this.mySize;
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MyList.this.myMousePoint = e.getPoint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MyList.this.myMousePoint = null;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                MyList.this.myMousePoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MyList list2 = MyList.this;
                Point point = e.getPoint();
                int index = list2.locationToIndex(point);
                if (index != -1 && MyList.this.getCloseIconRect(index).contains(point)) {
                    ProjectGroup group;
                    e.consume();
                    Object element = MyList.this.getModel().getElementAt(index);
                    if (element instanceof ProjectGroupActionGroup && (group = ((ProjectGroupActionGroup)((Object)element)).getGroup()).isTutorials()) {
                        this.removeTutorialChildren(group);
                    }
                    RecentProjectPanel.removeRecentProjectElement(element);
                    ListUtil.removeSelectedItems((JList)((Object)MyList.this));
                }
            }

            private void removeTutorialChildren(ProjectGroup group) {
                int currentIndex = MyList.this.getSelectedIndex();
                List projects = group.getProjects();
                int[] childIndices = new int[projects.size()];
                for (int i = 0; i < projects.size(); ++i) {
                    childIndices[i] = currentIndex + 1;
                    ++currentIndex;
                }
                ListUtil.removeIndices((JList)((Object)MyList.this), (int[])childIndices);
                ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)new Notification("Tutorials", "Tutorials have been removed from the recent list", "You can still find them in the Help menu", NotificationType.INFORMATION)));
            }
        }
    }
}

