/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.packageDependencies.ChangeListScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeListsScopesProvider
extends CustomScopesProviderEx {
    @NotNull
    private final Project myProject;

    public static ChangeListsScopesProvider getInstance(Project project) {
        return (ChangeListsScopesProvider)((Object)Extensions.findExtension((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)project, ChangeListsScopesProvider.class));
    }

    public ChangeListsScopesProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<NamedScope> getCustomScopes() {
        boolean skipSingleDefaultCL;
        if (this.myProject.isDefault() || !ProjectLevelVcsManager.getInstance((Project)this.myProject).hasAnyMappings()) {
            return Collections.emptyList();
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        ArrayList<NamedScope> result2 = new ArrayList<NamedScope>();
        result2.add((NamedScope)new ChangeListScope(changeListManager));
        List changeLists = changeListManager.getChangeListsCopy();
        boolean bl = skipSingleDefaultCL = Registry.is((String)"vcs.skip.single.default.changelist") && changeLists.size() == 1 && ((LocalChangeList)changeLists.get(0)).isBlank();
        if (!skipSingleDefaultCL) {
            for (ChangeList list2 : changeLists) {
                result2.add((NamedScope)new ChangeListScope(changeListManager, list2.getName()));
            }
        }
        return result2;
    }

    public NamedScope getCustomScope(@NotNull String name) {
        if (this.myProject.isDefault()) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        if (ChangeListScope.NAME.equals(name)) {
            return new ChangeListScope(changeListManager);
        }
        LocalChangeList changeList = changeListManager.findChangeList(name);
        if (changeList != null) {
            return new ChangeListScope(changeListManager, changeList.getName());
        }
        return null;
    }

    public boolean isVetoed(NamedScope scope, CustomScopesProviderEx.ScopePlace place) {
        if (place == CustomScopesProviderEx.ScopePlace.SETTING) {
            if (this.myProject.isDefault()) {
                return false;
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            return changeListManager.findChangeList(scope.getName()) != null;
        }
        return false;
    }
}

