/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DependenciesBuilder {
    private final Project myProject;
    private final AnalysisScope myScope;
    private final Map<PsiFile, Set<PsiFile>> myDependencies = new HashMap<PsiFile, Set<PsiFile>>();
    protected int myTotalFileCount;
    protected int myFileCount = 0;

    protected DependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        this.myProject = project;
        this.myScope = scope;
        this.myTotalFileCount = scope.getFileCount();
    }

    public void setInitialFileCount(int fileCount) {
        this.myFileCount = fileCount;
    }

    public void setTotalFileCount(int totalFileCount) {
        this.myTotalFileCount = totalFileCount;
    }

    public int getTotalFileCount() {
        return this.myTotalFileCount;
    }

    public Map<PsiFile, Set<PsiFile>> getDependencies() {
        return this.myDependencies;
    }

    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        return this.getDependencies();
    }

    public AnalysisScope getScope() {
        return this.myScope;
    }

    @Deprecated
    public AnalysisScope getScopeOfInterest() {
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public abstract String getRootNodeNameInUsageView();

    public abstract String getInitialUsagesPosition();

    public abstract boolean isBackward();

    public abstract void analyze();

    public Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> getIllegalDependencies() {
        HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>> result2 = new HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>>();
        DependencyValidationManager validator = DependencyValidationManager.getInstance((Project)this.myProject);
        for (PsiFile file2 : this.getDirectDependencies().keySet()) {
            Set<PsiFile> deps = this.getDirectDependencies().get(file2);
            HashMap<DependencyRule, HashSet<PsiFile>> illegal = null;
            for (PsiFile dependency : deps) {
                HashSet<PsiFile> illegalFilesByRule;
                DependencyRule rule = this.isBackward() ? validator.getViolatorDependencyRule(dependency, file2) : validator.getViolatorDependencyRule(file2, dependency);
                if (rule == null) continue;
                if (illegal == null) {
                    illegal = new HashMap<DependencyRule, HashSet<PsiFile>>();
                    result2.put(file2, illegal);
                }
                if ((illegalFilesByRule = (HashSet<PsiFile>)illegal.get(rule)) == null) {
                    illegalFilesByRule = new HashSet<PsiFile>();
                }
                illegalFilesByRule.add(dependency);
                illegal.put(rule, illegalFilesByRule);
            }
        }
        return result2;
    }

    public List<List<PsiFile>> findPaths(PsiFile from, PsiFile to) {
        return this.findPaths(from, to, new HashSet());
    }

    private List<List<PsiFile>> findPaths(PsiFile from, PsiFile to, Set<? super PsiFile> processed2) {
        ArrayList<List<PsiFile>> result2 = new ArrayList<List<PsiFile>>();
        Set<PsiFile> reachable = this.getDirectDependencies().get(from);
        if (reachable != null) {
            if (reachable.contains(to)) {
                result2.add(new ArrayList());
                return result2;
            }
            if (processed2.add((PsiFile)from)) {
                for (PsiFile file2 : reachable) {
                    if (this.getScope().contains((PsiElement)file2)) continue;
                    List<List<PsiFile>> paths = this.findPaths(file2, to, processed2);
                    for (List<PsiFile> path : paths) {
                        path.add(0, file2);
                    }
                    result2.addAll(paths);
                }
            }
        }
        return result2;
    }

    @Deprecated
    public boolean isTransitive() {
        return false;
    }

    @Deprecated
    public int getTransitiveBorder() {
        return 0;
    }

    public String getRelativeToProjectPath(@NotNull VirtualFile virtualFile) {
        return ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)this.getProject(), (boolean)true, (boolean)false);
    }

    public static void analyzeFileDependencies(@NotNull PsiFile file2, @NotNull DependencyProcessor processor2) {
        DependenciesBuilder.analyzeFileDependencies(file2, processor2, DependencyVisitorFactory.VisitorOptions.fromSettings(file2.getProject()));
    }

    public static void analyzeFileDependencies(@NotNull PsiFile file2, @NotNull DependencyProcessor processor2, @NotNull DependencyVisitorFactory.VisitorOptions options) {
        file2.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
        file2.accept(DependencyVisitorFactory.createVisitor(file2, processor2, options));
        file2.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, null);
    }

    public static interface DependencyProcessor {
        public void process(PsiElement var1, PsiElement var2);
    }
}

