/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DependencyValidationManager", storages={@Storage(value="scopes", stateSplitter=ScopesStateSplitter.class)})
public class DependencyValidationManagerImpl
extends DependencyValidationManager {
    private static final Icon ourSharedScopeIcon = new IconLoader.LazyIcon(){

        protected Icon compute() {
            return new LayeredIcon(new Icon[]{AllIcons.Ide.LocalScope, AllIcons.Nodes.Shared});
        }
    };
    private State myState = new State();
    private final NamedScopeManager myNamedScopeManager;
    private boolean mySkipImportStatements;
    private boolean mySkipImportStatementsWasSpecified;
    @NonNls
    private static final String DENY_RULE_KEY = "deny_rule";
    @NonNls
    private static final String FROM_SCOPE_KEY = "from_scope";
    @NonNls
    private static final String TO_SCOPE_KEY = "to_scope";
    @NonNls
    private static final String IS_DENY_KEY = "is_deny";
    @NonNls
    private static final String UNNAMED_SCOPE = "unnamed_scope";
    @NonNls
    private static final String VALUE = "value";
    private final List<Pair<NamedScope, NamedScopesHolder>> myScopePairs = ContainerUtil.createLockFreeCopyOnWriteList();

    public DependencyValidationManagerImpl(@NotNull Project project, @NotNull NamedScopeManager namedScopeManager) {
        super(project);
        this.myNamedScopeManager = namedScopeManager;
        namedScopeManager.addScopeListener(() -> this.reloadScopes());
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        return CustomScopesAggregator.getAllCustomScopes(this.myProject);
    }

    public NamedScope getPredefinedScope(@NotNull String name) {
        for (CustomScopesProvider scopesProvider : (CustomScopesProvider[])CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions((AreaInstance)this.myProject)) {
            NamedScope scope;
            NamedScope namedScope = scope = scopesProvider instanceof CustomScopesProviderEx ? ((CustomScopesProviderEx)scopesProvider).getCustomScope(name) : CustomScopesProviderEx.findPredefinedScope((String)name, (List)scopesProvider.getFilteredScopes());
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    public boolean hasRules() {
        return !this.myState.rules.isEmpty();
    }

    @Nullable
    public DependencyRule getViolatorDependencyRule(@NotNull PsiFile from, @NotNull PsiFile to) {
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            return dependencyRule;
        }
        return null;
    }

    @NotNull
    public DependencyRule[] getViolatorDependencyRules(@NotNull PsiFile from, @NotNull PsiFile to) {
        ArrayList<DependencyRule> result2 = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            result2.add(dependencyRule);
        }
        return result2.toArray(new DependencyRule[0]);
    }

    @NotNull
    public DependencyRule[] getApplicableRules(@NotNull PsiFile file2) {
        ArrayList<DependencyRule> result2 = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isApplicable(file2)) continue;
            result2.add(dependencyRule);
        }
        return result2.toArray(new DependencyRule[0]);
    }

    public boolean skipImportStatements() {
        return this.mySkipImportStatements;
    }

    public void setSkipImportStatements(boolean skip) {
        this.mySkipImportStatements = skip;
    }

    @NotNull
    public Map<String, PackageSet> getUnnamedScopes() {
        return this.myState.unnamedScopes;
    }

    @NotNull
    public DependencyRule[] getAllRules() {
        List rules = this.myState.rules;
        return rules.toArray(new DependencyRule[0]);
    }

    public void removeAllRules() {
        this.myState.rules.clear();
    }

    private void addRule(@NotNull DependencyRule rule, @NotNull State state) {
        this.appendUnnamedScope(rule.getFromScope(), state);
        this.appendUnnamedScope(rule.getToScope(), state);
        state.rules.add(rule);
    }

    public void addRule(@NotNull DependencyRule rule) {
        this.addRule(rule, this.myState);
    }

    private void appendUnnamedScope(@NotNull NamedScope fromScope, @NotNull State state) {
        PackageSet packageSet;
        if (this.getScope(fromScope.getName()) == null && (packageSet = fromScope.getValue()) != null && !state.unnamedScopes.containsKey(packageSet.getText())) {
            state.unnamedScopes.put(packageSet.getText(), packageSet);
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"shared.scopes.node.text", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return ourSharedScopeIcon;
    }

    public void loadState(@NotNull Element element) {
        Element option2 = element.getChild("option");
        if (option2 != null && "SKIP_IMPORT_STATEMENTS".equals(option2.getAttributeValue("name"))) {
            this.mySkipImportStatementsWasSpecified = !this.myProject.isDefault();
            this.mySkipImportStatements = Boolean.parseBoolean(option2.getAttributeValue(VALUE));
        }
        super.loadState(element);
        NamedScope[] scopes = this.getEditableScopes();
        Arrays.sort(scopes, (s1, s2) -> {
            int i2;
            String name2;
            String name1 = s1.getName();
            if (Comparing.equal((String)name1, (String)(name2 = s2.getName()))) {
                return 0;
            }
            List order = this.myNamedScopeManager.myOrderState.myOrder;
            int i1 = order.indexOf(name1);
            return i1 > (i2 = order.indexOf(name2)) ? 1 : -1;
        });
        super.setScopes(scopes);
        State state = new State();
        PackageSetFactory packageSetFactory = PackageSetFactory.getInstance();
        for (Element unnamedScope : element.getChildren(UNNAMED_SCOPE)) {
            try {
                String packageSet = unnamedScope.getAttributeValue(VALUE);
                state.unnamedScopes.put(packageSet, packageSetFactory.compile(packageSet));
            }
            catch (ParsingException parsingException) {}
        }
        this.readRules(element, state);
        this.myState = state;
    }

    private void readRules(@NotNull Element element, State state) {
        for (Element rule1 : element.getChildren(DENY_RULE_KEY)) {
            DependencyRule rule = this.readRule(rule1);
            if (rule == null) continue;
            this.addRule(rule, state);
        }
    }

    @NotNull
    public Element getState() {
        State state;
        Element element = super.getState();
        if (this.mySkipImportStatements || this.mySkipImportStatementsWasSpecified) {
            element.addContent(new Element("option").setAttribute("name", "SKIP_IMPORT_STATEMENTS").setAttribute(VALUE, Boolean.toString(this.mySkipImportStatements)));
        }
        if (!(state = this.myState).unnamedScopes.isEmpty()) {
            Object[] unnamedScopes = ArrayUtil.toStringArray(state.unnamedScopes.keySet());
            Arrays.sort(unnamedScopes);
            for (Object unnamedScope : unnamedScopes) {
                element.addContent(new Element(UNNAMED_SCOPE).setAttribute(VALUE, (String)unnamedScope));
            }
        }
        DependencyValidationManagerImpl.writeRules(element, state);
        return element;
    }

    private static void writeRules(@NotNull Element element, @NotNull State state) {
        for (DependencyRule rule : state.rules) {
            Element ruleElement = DependencyValidationManagerImpl.writeRule(rule);
            if (ruleElement == null) continue;
            element.addContent(ruleElement);
        }
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        return this.getScope(name, this.myState);
    }

    private NamedScope getScope(@Nullable String name, @NotNull State state) {
        PackageSet packageSet;
        NamedScope scope = super.getScope(name);
        if (scope == null && (packageSet = (PackageSet)state.unnamedScopes.get(name)) != null) {
            return new NamedScope.UnnamedScope(packageSet);
        }
        if (scope == null && Comparing.strEqual((String)name, (String)"Project")) {
            return super.getScope("All");
        }
        return scope;
    }

    @Nullable
    private static Element writeRule(DependencyRule rule) {
        NamedScope fromScope = rule.getFromScope();
        NamedScope toScope = rule.getToScope();
        if (fromScope == null || toScope == null) {
            return null;
        }
        Element ruleElement = new Element(DENY_RULE_KEY);
        ruleElement.setAttribute(FROM_SCOPE_KEY, fromScope.getName());
        ruleElement.setAttribute(TO_SCOPE_KEY, toScope.getName());
        ruleElement.setAttribute(IS_DENY_KEY, Boolean.valueOf(rule.isDenyRule()).toString());
        return ruleElement;
    }

    @Nullable
    private DependencyRule readRule(@NotNull Element ruleElement) {
        String fromScope = ruleElement.getAttributeValue(FROM_SCOPE_KEY);
        String toScope = ruleElement.getAttributeValue(TO_SCOPE_KEY);
        String denyRule = ruleElement.getAttributeValue(IS_DENY_KEY);
        if (fromScope == null || toScope == null || denyRule == null) {
            return null;
        }
        NamedScope fromNamedScope = this.getScope(fromScope);
        NamedScope toNamedScope = this.getScope(toScope);
        if (fromNamedScope == null || toNamedScope == null) {
            return null;
        }
        return new DependencyRule(fromNamedScope, toNamedScope, Boolean.valueOf(denyRule).booleanValue());
    }

    private void reloadScopes() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            ArrayList scopeList = new ArrayList();
            DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)this);
            DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)this.myNamedScopeManager);
            this.myScopePairs.clear();
            this.myScopePairs.addAll(scopeList);
            Element element = new Element("rules_2_reload");
            DependencyValidationManagerImpl.writeRules(element, this.myState);
            State state = new State();
            this.readRules(element, state);
            this.myState = state;
        });
    }

    private static void addScopesToList(@NotNull List<? super Pair<NamedScope, NamedScopesHolder>> scopeList, @NotNull NamedScopesHolder holder) {
        for (NamedScope scope : holder.getScopes()) {
            scopeList.add((Pair<NamedScope, NamedScopesHolder>)Pair.create((Object)scope, (Object)holder));
        }
    }

    @NotNull
    public List<Pair<NamedScope, NamedScopesHolder>> getScopeBasedHighlightingCachedScopes() {
        return this.myScopePairs;
    }

    public void fireScopeListeners() {
        super.fireScopeListeners();
        this.reloadScopes();
    }

    public void setScopes(@NotNull NamedScope[] scopes) {
        super.setScopes(scopes);
        List order = this.myNamedScopeManager.myOrderState.myOrder;
        order.clear();
        for (NamedScope scope : scopes) {
            order.add(scope.getName());
        }
    }

    static final class ScopesStateSplitter
    extends MainConfigurationStateSplitter {
        ScopesStateSplitter() {
        }

        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            return element.getAttributeValue("name");
        }

        @NotNull
        protected String getComponentStateFileName() {
            return "scope_settings";
        }

        @NotNull
        protected String getSubStateTagName() {
            return "scope";
        }
    }

    private static class State {
        private final List<DependencyRule> rules = new ArrayList<DependencyRule>();
        private final Map<String, PackageSet> unnamedScopes = new THashMap();

        private State() {
        }
    }
}

