/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.packageDependencies.actions.DependenciesHandlerBase;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnalyzeDependenciesHandler
extends DependenciesHandlerBase {
    private final int myTransitiveBorder;

    public AnalyzeDependenciesHandler(@NotNull Project project, List<? extends AnalysisScope> scopes, int transitiveBorder, Set<PsiFile> excluded) {
        super(project, scopes, excluded);
        this.myTransitiveBorder = transitiveBorder;
    }

    public AnalyzeDependenciesHandler(Project project, AnalysisScope scope, int transitiveBorder) {
        this(project, Collections.singletonList(scope), transitiveBorder, new HashSet<PsiFile>());
    }

    @Override
    protected DependenciesBuilder createDependenciesBuilder(AnalysisScope scope) {
        return new ForwardDependenciesBuilder(this.myProject, scope, this.myTransitiveBorder);
    }

    @Override
    protected String getPanelDisplayName(AnalysisScope scope) {
        return AnalysisScopeBundle.message((String)"package.dependencies.toolwindow.title", (Object[])new Object[]{scope.getDisplayName()});
    }

    @Override
    protected String getProgressTitle() {
        return AnalysisScopeBundle.message((String)"package.dependencies.progress.title", (Object[])new Object[0]);
    }
}

