/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependenciesToolWindow;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class DependenciesHandlerBase {
    @NotNull
    protected final Project myProject;
    private final List<? extends AnalysisScope> myScopes;
    private final Set<PsiFile> myExcluded;

    public DependenciesHandlerBase(@NotNull Project project, List<? extends AnalysisScope> scopes, Set<PsiFile> excluded) {
        this.myScopes = scopes;
        this.myExcluded = excluded;
        this.myProject = project;
    }

    public void analyze() {
        final ArrayList builders = new ArrayList();
        Object task2 = this.canStartInBackground() ? new Task.Backgroundable(this.myProject, this.getProgressTitle(), true, new PerformAnalysisInBackgroundOption(this.myProject)){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                DependenciesHandlerBase.this.perform(builders, indicator);
            }

            public void onSuccess() {
                DependenciesHandlerBase.this.onSuccess(builders);
            }
        } : new Task.Modal(this.myProject, this.getProgressTitle(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                DependenciesHandlerBase.this.perform(builders, indicator);
            }

            public void onSuccess() {
                DependenciesHandlerBase.this.onSuccess(builders);
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    protected boolean canStartInBackground() {
        return true;
    }

    protected boolean shouldShowDependenciesPanel(List<? extends DependenciesBuilder> builders) {
        return true;
    }

    protected abstract String getProgressTitle();

    protected abstract String getPanelDisplayName(AnalysisScope var1);

    protected abstract DependenciesBuilder createDependenciesBuilder(AnalysisScope var1);

    private void perform(List<DependenciesBuilder> builders, @NotNull ProgressIndicator indicator) {
        try {
            PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
            for (AnalysisScope analysisScope : this.myScopes) {
                builders.add(this.createDependenciesBuilder(analysisScope));
            }
            for (DependenciesBuilder dependenciesBuilder : builders) {
                dependenciesBuilder.analyze();
            }
            snapshot.logResponsivenessSinceCreation("Dependency analysis");
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Analyze dependencies is not available until indices are ready");
            throw new ProcessCanceledException();
        }
    }

    private void onSuccess(List<DependenciesBuilder> builders) {
        SwingUtilities.invokeLater(() -> {
            if (this.shouldShowDependenciesPanel(builders)) {
                String displayName = this.getPanelDisplayName(builders);
                DependenciesPanel panel2 = new DependenciesPanel(this.myProject, builders, this.myExcluded);
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, displayName, false);
                content.setDisposer((Disposable)panel2);
                panel2.setContent(content);
                DependenciesToolWindow.getInstance(this.myProject).addContent(content);
            }
        });
    }

    protected String getPanelDisplayName(List<? extends DependenciesBuilder> builders) {
        return this.getPanelDisplayName(builders.get(0).getScope());
    }
}

