/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;

public class RefactoringScopeElementListenerProvider
implements RefactoringElementListenerProvider {
    private static final Logger LOG = Logger.getInstance(RefactoringScopeElementListenerProvider.class);

    public RefactoringElementListener getListener(PsiElement element) {
        if (!(element instanceof PsiQualifiedNamedElement) && !(element instanceof PsiDirectory)) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        RefactoringElementListenerComposite composite = new RefactoringElementListenerComposite();
        RefactoringScopeElementListenerProvider.registerListeners(element, composite, containingFile, ReferenceKind.FILE_PATH);
        RefactoringScopeElementListenerProvider.registerListeners(element, composite, containingFile, ReferenceKind.QUALIFIED_NAME);
        return composite;
    }

    private static void registerListeners(PsiElement element, RefactoringElementListenerComposite result2, PsiFile containingFile, ReferenceKind referenceKind) {
        String oldName = RefactoringScopeElementListenerProvider.getQualifiedName(element, referenceKind);
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)element.getProject())) {
            NamedScope[] scopes = holder.getEditableScopes();
            for (int i = 0; i < scopes.length; ++i) {
                NamedScope scope = scopes[i];
                PackageSet packageSet = scope.getValue();
                if (packageSet == null || containingFile != null && !packageSet.contains(containingFile, holder)) continue;
                RefactoringScopeElementListenerProvider.registerListeners(packageSet, result2, new OldScopeDescriptor(scope, i, holder), oldName, referenceKind);
            }
        }
    }

    private static String getQualifiedName(PsiElement element, ReferenceKind referenceKind) {
        if (referenceKind == ReferenceKind.QUALIFIED_NAME) {
            return element instanceof PsiQualifiedNamedElement ? ((PsiQualifiedNamedElement)element).getQualifiedName() : null;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        Project project = element.getProject();
        return FilePatternPackageSet.getRelativePath((VirtualFile)virtualFile, (ProjectFileIndex)ProjectRootManager.getInstance((Project)project).getFileIndex(), (boolean)true, (VirtualFile)project.getBaseDir());
    }

    private static PackageSet updateNameInPattern(PackageSet packageSet, String oldName, String newName) {
        if (packageSet instanceof PatternBasedPackageSet && ((PatternBasedPackageSet)packageSet).isOn(oldName)) {
            return ((PatternBasedPackageSet)packageSet).updatePattern(oldName, newName);
        }
        return packageSet;
    }

    private static void registerListeners(PackageSet packageSet, RefactoringElementListenerComposite result2, final OldScopeDescriptor descriptor, final String oldQualifiedName, final ReferenceKind referenceKind) {
        final NamedScope oldScope = descriptor.getOldScope();
        final PackageSet oldSet = oldScope.getValue();
        if (oldSet != null && packageSet.anyMatches(set2 -> set2 instanceof PatternBasedPackageSet && ((PatternBasedPackageSet)set2).isOn(oldQualifiedName))) {
            result2.addListener((RefactoringElementListener)new RefactoringElementAdapter(){

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    PackageSet newSet;
                    LOG.assertTrue(newElement instanceof PsiQualifiedNamedElement || newElement instanceof PsiDirectory);
                    String newName = RefactoringScopeElementListenerProvider.getQualifiedName(newElement, referenceKind);
                    if (newName != null && (newSet = oldSet.map(set2 -> RefactoringScopeElementListenerProvider.updateNameInPattern(set2, oldQualifiedName, newName))) != oldSet) {
                        descriptor.replaceScope(new NamedScope(oldScope.getName(), oldScope.getIcon(), newSet));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName2) {
                    LOG.assertTrue(newElement instanceof PsiQualifiedNamedElement || newElement instanceof PsiDirectory);
                    descriptor.replaceScope(oldScope);
                }
            });
        }
    }

    private static class OldScopeDescriptor {
        private final NamedScopesHolder myHolder;
        private final int myIndex;
        private final NamedScope myOldScope;

        private OldScopeDescriptor(NamedScope oldScope, int index, NamedScopesHolder holder) {
            this.myHolder = holder;
            this.myIndex = index;
            this.myOldScope = oldScope;
        }

        public NamedScope getOldScope() {
            return this.myOldScope;
        }

        public void replaceScope(NamedScope newScope) {
            NamedScope[] currentScopes = this.myHolder.getEditableScopes();
            if (this.myIndex < currentScopes.length) {
                currentScopes[this.myIndex] = newScope;
                this.myHolder.setScopes(currentScopes);
            }
        }
    }

    private static enum ReferenceKind {
        QUALIFIED_NAME,
        FILE_PATH;

    }
}

