/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.peer.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.RemoteFilePath;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class VcsContextFactoryImpl
implements VcsContextFactory {
    @NotNull
    public VcsContext createCachedContextOn(@NotNull AnActionEvent event) {
        return VcsContextWrapper.createCachedInstanceOn(event);
    }

    @NotNull
    public VcsContext createContextOn(@NotNull AnActionEvent event) {
        return new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile virtualFile) {
        return this.createFilePath(virtualFile.getPath(), virtualFile.isDirectory());
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file2) {
        String path = file2.getPath();
        VirtualFile vf = LocalFileSystem.getInstance().findFileByPath(path);
        return this.createFilePath(path, vf != null ? vf.isDirectory() : file2.isDirectory());
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull File file2, boolean isDirectory) {
        return this.createFilePath(file2.getPath(), isDirectory);
    }

    @NotNull
    public FilePath createFilePathOnNonLocal(@NotNull String path, boolean isDirectory) {
        return new RemoteFilePath(path, isDirectory);
    }

    @NotNull
    public FilePath createFilePathOnDeleted(@NotNull File file2, boolean isDirectory) {
        return this.createFilePathOn(file2, isDirectory);
    }

    @NotNull
    public FilePath createFilePathOn(@NotNull VirtualFile parent, @NotNull String name) {
        return this.createFilePath(parent, name, false);
    }

    @NotNull
    public FilePath createFilePath(@NotNull VirtualFile parent, @NotNull String fileName2, boolean isDirectory) {
        return this.createFilePath(parent.getPath() + "/" + fileName2, isDirectory);
    }

    @NotNull
    public LocalChangeList createLocalChangeList(@NotNull Project project, @NotNull String name) {
        return LocalChangeListImpl.createEmptyChangeListImpl(project, name, null);
    }

    @NotNull
    public FilePath createFilePath(@NotNull String path, boolean isDirectory) {
        return new LocalFilePath(path, isDirectory);
    }
}

