/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor;", "Lcom/intellij/projectImport/ProjectAttachProcessor;", "()V", "attachToProject", "", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "Companion", "intellij.platform.lang.impl"})
public final class ModuleAttachProcessor
extends ProjectAttachProcessor {
    public static final Companion Companion = new Companion(null);

    public boolean attachToProject(@NotNull Project project, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback2) {
        boolean isAttached;
        Path dotIdeaDir = projectDir.resolve(".idea");
        if (!PathKt.exists((Path)dotIdeaDir)) {
            Project project2 = ProjectManagerEx.getInstanceEx().newProject(((Object)projectDir.getFileName()).toString(), ((Object)projectDir).toString(), true, false);
            if (project2 == null) {
                return false;
            }
            Project newProject = project2;
            VirtualFile baseDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)projectDir));
            PlatformProjectOpenProcessor.runDirectoryProjectConfigurators(baseDir, newProject);
            newProject.save();
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(newProject){
                final /* synthetic */ Project $newProject$inlined;
                {
                    this.$newProject$inlined = project;
                }

                public final T compute() {
                    boolean bl = false;
                    Disposer.dispose((Disposable)((Disposable)this.$newProject$inlined));
                    return (T)Unit.INSTANCE;
                }
            });
        }
        if (!(isAttached = ModuleAttachProcessorKt.access$findMainModule(project, dotIdeaDir, callback2))) {
            isAttached = ModuleAttachProcessorKt.access$findMainModule(project, projectDir, callback2);
        }
        if (isAttached) {
            return true;
        }
        return Messages.showYesNoDialog((Project)project, (String)("The project at " + projectDir + " uses a non-standard layout and cannot be attached to this project. Would you like to open it in a new window?"), (String)"Open Project", (Icon)Messages.getQuestionIcon()) != 0;
    }

    @JvmStatic
    @Nullable
    public static final Module findModuleInBaseDir(@NotNull Project project) {
        return Companion.findModuleInBaseDir(project);
    }

    @JvmStatic
    @Nullable
    public static final Module getPrimaryModule(@NotNull Project project) {
        return Companion.getPrimaryModule(project);
    }

    @JvmStatic
    @NotNull
    public static final List<Module> getSortedModules(@NotNull Project project) {
        return Companion.getSortedModules(project);
    }

    @JvmStatic
    @Nullable
    public static final String getMultiProjectDisplayName(@NotNull Project project) {
        return Companion.getMultiProjectDisplayName(project);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor$Companion;", "", "()V", "findModuleInBaseDir", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getMultiProjectDisplayName", "", "getPrimaryModule", "getSortedModules", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Module findModuleInBaseDir(@NotNull Project project) {
            Module module;
            block3: {
                Module[] $receiver$iv;
                VirtualFile baseDir = project.getBaseDir();
                Module[] moduleArray = $receiver$iv = ModuleManager.getInstance((Project)project).getModules();
                int n = moduleArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    Module element$iv;
                    block2: {
                        VirtualFile[] $receiver$iv2;
                        Module it = element$iv = moduleArray[i];
                        boolean bl2 = false;
                        VirtualFile[] virtualFileArray = $receiver$iv2 = ProjectUtil.getRootManager((Module)it).getContentRoots();
                        int n2 = virtualFileArray.length;
                        for (int j = 0; j < n2; ++j) {
                            VirtualFile element$iv2;
                            VirtualFile it2 = element$iv2 = virtualFileArray[j];
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it2, (Object)baseDir)) continue;
                            bl = true;
                            break block2;
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    module = element$iv;
                    break block3;
                }
                module = null;
            }
            return module;
        }

        @JvmStatic
        @Nullable
        public final Module getPrimaryModule(@NotNull Project project) {
            return ProjectAttachProcessor.canAttachToProject() ? this.findModuleInBaseDir(project) : null;
        }

        @JvmStatic
        @NotNull
        public final List<Module> getSortedModules(@NotNull Project project) {
            ArrayList<Module> result2;
            block2: {
                Module module;
                Module primaryModule = this.getPrimaryModule(project);
                result2 = new ArrayList<Module>();
                Object $receiver$iv = ModuleManager.getInstance((Project)project).getModules();
                Object object = $receiver$iv;
                int n = ((Module[])object).length;
                for (int i = 0; i < n; ++i) {
                    Module element$iv;
                    Module it = element$iv = object[i];
                    boolean bl = false;
                    if (!(it != primaryModule)) continue;
                    ((Collection)result2).add(element$iv);
                }
                $receiver$iv = result2;
                if ($receiver$iv.size() > 1) {
                    object = $receiver$iv;
                    Comparator comparator2 = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            Module p1 = (Module)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)p1.getName());
                            p1 = (Module)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            String string = p1.getName();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                        }
                    };
                    CollectionsKt.sortWith((List)object, (Comparator)comparator2);
                }
                Module module2 = primaryModule;
                if (module2 == null) break block2;
                Module it = module = module2;
                boolean bl = false;
                result2.add(0, it);
            }
            return result2;
        }

        @JvmStatic
        @Nullable
        public final String getMultiProjectDisplayName(@NotNull Project project) {
            if (!ProjectAttachProcessor.canAttachToProject()) {
                return null;
            }
            Object[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length <= 1) {
                return null;
            }
            Module module = this.getPrimaryModule(project);
            if (module == null) {
                module = (Module)ArraysKt.first((Object[])modules);
            }
            Module primaryModule = module;
            StringBuilder result2 = new StringBuilder(primaryModule.getName());
            result2.append(", ");
            for (Object module2 : modules) {
                if (module2 == primaryModule) continue;
                result2.append(module2.getName());
                break;
            }
            if (modules.length > 2) {
                result2.append("...");
            }
            return result2.toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

