/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;

public class PlatformProjectViewOpener
implements DirectoryProjectConfigurator {
    public PlatformProjectViewOpener() {
        if (PlatformUtils.isPyCharmEducational() || PlatformUtils.isDataGrip()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @Override
    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        ToolWindowManagerEx manager = (ToolWindowManagerEx)ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = manager.getToolWindow(ToolWindowId.PROJECT_VIEW);
        if (toolWindow == null) {
            project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new MyListener(manager, project));
        } else {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> PlatformProjectViewOpener.activateProjectToolWindow(project, toolWindow)));
        }
    }

    private static void activateProjectToolWindow(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project.isDisposed()) {
                return;
            }
            if (toolWindow.getType() != ToolWindowType.SLIDING) {
                toolWindow.activate(null);
            }
        }, ModalityState.NON_MODAL);
    }

    private static class MyListener
    implements ToolWindowManagerListener {
        private final ToolWindowManagerEx myManager;
        private final Project myProject;

        MyListener(ToolWindowManagerEx manager, Project project) {
            this.myManager = manager;
            this.myProject = project;
        }

        @Override
        public void toolWindowRegistered(@NotNull String id) {
            if (id.equals(ToolWindowId.PROJECT_VIEW)) {
                this.myManager.removeToolWindowManagerListener(this);
                PlatformProjectViewOpener.activateProjectToolWindow(this.myProject, this.myManager.getToolWindow(id));
            }
        }
    }
}

