/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchivedTemplatesFactory
extends ProjectTemplatesFactory {
    private static final Logger LOG = Logger.getInstance(ArchivedTemplatesFactory.class);
    static final String ZIP = ".zip";

    @NotNull
    private static URL getCustomTemplatesURL() {
        try {
            return new File(ArchivedTemplatesFactory.getCustomTemplatesPath()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    static String getCustomTemplatesPath() {
        return PathManager.getConfigPath() + "/projectTemplates";
    }

    @NotNull
    public static Path getTemplateFile(String name) {
        return Paths.get(ArchivedTemplatesFactory.getCustomTemplatesPath(), name + ZIP);
    }

    @Override
    @NotNull
    public String[] getGroups() {
        return new String[]{"User-defined"};
    }

    @Override
    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        if (!"User-defined".equals(group)) {
            return ProjectTemplate.EMPTY_ARRAY;
        }
        List templates = null;
        URL url = ArchivedTemplatesFactory.getCustomTemplatesURL();
        try {
            for (String child2 : UrlUtil.getChildrenRelativePaths(url)) {
                if (!child2.endsWith(ZIP)) continue;
                if (templates == null) {
                    templates = new SmartList();
                }
                templates.add(new LocalArchivedTemplate(new URL(url.toExternalForm() + '/' + child2), ClassLoader.getSystemClassLoader()));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return ContainerUtil.isEmpty(templates) ? ProjectTemplate.EMPTY_ARRAY : templates.toArray(ProjectTemplate.EMPTY_ARRAY);
    }

    @Override
    public int getGroupWeight(String group) {
        return "User-defined".equals(group) ? -2 : 0;
    }

    @Override
    public Icon getGroupIcon(String group) {
        return "User-defined".equals(group) ? AllIcons.General.User : super.getGroupIcon(group);
    }
}

