/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.SaveProjectAsTemplateDialog;
import com.intellij.project.ProjectKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveProjectAsTemplateAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(SaveProjectAsTemplateAction.class);
    private static final String PROJECT_TEMPLATE_XML = "project-template.xml";
    static final String FILE_HEADER_TEMPLATE_PLACEHOLDER = "<IntelliJ_File_Header>";

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        assert (project != null);
        if (!ProjectKt.isDirectoryBased(project)) {
            Messages.showErrorDialog((Project)project, (String)"Project templates do not support old .ipr (file-based) format.\nPlease convert your project via File->Save as Directory-Based format.", (String)CommonBundle.getErrorTitle());
            return;
        }
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project, ".idea/description.html");
        final SaveProjectAsTemplateDialog dialog2 = new SaveProjectAsTemplateDialog(project, descriptionFile);
        if (dialog2.showAndGet()) {
            final Module moduleToSave = dialog2.getModuleToSave();
            final Path file2 = dialog2.getTemplateFile();
            final String description = dialog2.getDescription();
            FileDocumentManager.getInstance().saveAllDocuments();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Saving Project as Template", true, PerformInBackgroundOption.DEAF){

                public void run(@NotNull ProgressIndicator indicator) {
                    SaveProjectAsTemplateAction.saveProject(project, file2, moduleToSave, description, dialog2.isReplaceParameters(), indicator, SaveProjectAsTemplateAction.shouldEscape());
                }

                public void onSuccess() {
                    AnAction newProjectAction = ActionManager.getInstance().getAction(SaveProjectAsTemplateAction.getNewProjectActionId());
                    newProjectAction.getTemplatePresentation().setText(ActionsBundle.actionText((String)"NewDirectoryProject"));
                    AnAction manageAction = ActionManager.getInstance().getAction("ManageProjectTemplates");
                    Notification notification = new Notification("Project Template", "Template Created", FileUtil.getNameWithoutExtension((String)file2.getFileName().toString()) + " was successfully created", NotificationType.INFORMATION);
                    notification.addAction(newProjectAction);
                    if (manageAction != null) {
                        notification.addAction(manageAction);
                    }
                    notification.notify(this.getProject());
                }

                public boolean shouldStartInBackground() {
                    return true;
                }

                public void onCancel() {
                    PathKt.delete((Path)file2);
                }
            });
        }
    }

    public static VirtualFile getDescriptionFile(Project project, String path) {
        VirtualFile baseDir = project.getBaseDir();
        return baseDir != null ? baseDir.findFileByRelativePath(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveProject(Project project, @NotNull Path zipFile, Module moduleToSave, String description, boolean replaceParameters, ProgressIndicator indicator, boolean shouldEscape) {
        Map<String, String> parameters = SaveProjectAsTemplateAction.computeParameters(project, replaceParameters);
        indicator.setText("Saving project...");
        StoreUtil.saveSettings((ComponentManager)project, true);
        indicator.setText("Processing project files...");
        ZipOutputStream stream = null;
        try {
            stream = new ZipOutputStream(PathKt.outputStream((Path)zipFile));
            VirtualFile dir = SaveProjectAsTemplateAction.getDirectoryToSave(project, moduleToSave);
            List<LocalArchivedTemplate.RootDescription> roots = SaveProjectAsTemplateAction.collectStructure(project, moduleToSave);
            LocalArchivedTemplate.RootDescription basePathRoot = SaveProjectAsTemplateAction.findOrAddBaseRoot(roots, dir);
            SaveProjectAsTemplateAction.writeFile(".idea/description.html", description, project, basePathRoot.myRelativePath, stream, true);
            if (replaceParameters) {
                String text = SaveProjectAsTemplateAction.getInputFieldsText(parameters);
                SaveProjectAsTemplateAction.writeFile(".idea/project-template.xml", text, project, basePathRoot.myRelativePath, stream, false);
            }
            String metaDescription = SaveProjectAsTemplateAction.getTemplateMetaText(shouldEscape, roots);
            SaveProjectAsTemplateAction.writeFile(".idea/template-meta.xml", metaDescription, project, basePathRoot.myRelativePath, stream, true);
            ProjectFileIndex index = moduleToSave == null ? ProjectRootManager.getInstance((Project)project).getFileIndex() : ModuleRootManager.getInstance((Module)moduleToSave).getFileIndex();
            ZipOutputStream finalStream = stream;
            MyContentIterator iterator = new MyContentIterator(indicator, finalStream, project, parameters, shouldEscape);
            for (LocalArchivedTemplate.RootDescription root : roots) {
                String prefix = "root" + root.myIndex;
                VirtualFile rootFile = root.myFile;
                iterator.setRootAndPrefix(rootFile, prefix);
                index.iterateContentUnderDirectory(rootFile, (ContentIterator)iterator);
            }
        }
        catch (ProcessCanceledException dir) {
            StreamUtil.closeStream(stream);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project, (String)"Can't save project as template", (String)"Internal Error"));
            {
                catch (Throwable throwable) {
                    StreamUtil.closeStream(stream);
                    throw throwable;
                }
            }
            StreamUtil.closeStream((Closeable)stream);
        }
        StreamUtil.closeStream((Closeable)stream);
    }

    private static LocalArchivedTemplate.RootDescription findOrAddBaseRoot(List<LocalArchivedTemplate.RootDescription> roots, VirtualFile dirToSave) {
        for (LocalArchivedTemplate.RootDescription root : roots) {
            if (!root.myRelativePath.isEmpty()) continue;
            return root;
        }
        LocalArchivedTemplate.RootDescription root = new LocalArchivedTemplate.RootDescription(dirToSave, "", roots.size());
        roots.add(root);
        return root;
    }

    static String getFileHeaderTemplateName() {
        if (PlatformUtils.isIntelliJ()) {
            return FileTemplateBase.getQualifiedName("File Header", "java");
        }
        if (PlatformUtils.isPhpStorm()) {
            return FileTemplateBase.getQualifiedName("PHP File Header", "php");
        }
        if (PlatformUtils.isWebStorm()) {
            return FileTemplateBase.getQualifiedName("JavaScript File", "js");
        }
        throw new IllegalStateException("Provide file header template for your IDE");
    }

    static String getNewProjectActionId() {
        if (PlatformUtils.isIntelliJ()) {
            return "NewProject";
        }
        if (PlatformUtils.isPhpStorm()) {
            return "NewDirectoryProject";
        }
        if (PlatformUtils.isWebStorm()) {
            return "NewWebStormDirectoryProject";
        }
        throw new IllegalStateException("Provide new project action id for your IDE");
    }

    private static void writeFile(String path, String text, Project project, String prefix, ZipOutputStream stream, boolean overwrite) throws IOException {
        VirtualFile descriptionFile = SaveProjectAsTemplateAction.getDescriptionFile(project, path);
        if (descriptionFile == null) {
            stream.putNextEntry(new ZipEntry(prefix + "/" + path));
            stream.write(text.getBytes(StandardCharsets.UTF_8));
            stream.closeEntry();
        } else if (overwrite) {
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(() -> {
                try {
                    VfsUtil.saveText((VirtualFile)descriptionFile, (String)text);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }));
        }
    }

    public static Map<String, String> computeParameters(Project project, boolean replaceParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (replaceParameters) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (ProjectTemplateParameterFactory extension : ProjectTemplateParameterFactory.EP_NAME.getExtensionList()) {
                    String value = extension.detectParameterValue(project);
                    if (value == null) continue;
                    parameters.put(value, extension.getParameterId());
                }
            });
        }
        return parameters;
    }

    public static String getEncodedContent(VirtualFile virtualFile, Project project, Map<String, String> parameters) throws IOException {
        return SaveProjectAsTemplateAction.getEncodedContent(virtualFile, project, parameters, FileTemplateBase.getQualifiedName("File Header", "java"), true);
    }

    private static String getEncodedContent(VirtualFile virtualFile, Project project, Map<String, String> parameters, String fileHeaderTemplateName, boolean shouldEscape) throws IOException {
        String text = VfsUtilCore.loadText((VirtualFile)virtualFile);
        FileTemplate template = FileTemplateManager.getInstance(project).getDefaultTemplate(fileHeaderTemplateName);
        String templateText = template.getText();
        Pattern pattern = FileTemplateUtil.getTemplatePattern(template, project, (TIntObjectHashMap<String>)new TIntObjectHashMap());
        String result2 = SaveProjectAsTemplateAction.convertTemplates(text, pattern, templateText, shouldEscape);
        result2 = ProjectTemplateFileProcessor.encodeFile(result2, virtualFile, project);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            result2 = result2.replace(entry.getKey(), "${" + entry.getValue() + "}");
        }
        return result2;
    }

    private static VirtualFile getDirectoryToSave(Project project, @Nullable Module module) {
        if (module == null) {
            return project.getBaseDir();
        }
        VirtualFile moduleFile = module.getModuleFile();
        assert (moduleFile != null);
        return moduleFile.getParent();
    }

    @NotNull
    private static List<LocalArchivedTemplate.RootDescription> collectStructure(Project project, Module moduleToSave) {
        ArrayList<LocalArchivedTemplate.RootDescription> result2 = new ArrayList<LocalArchivedTemplate.RootDescription>();
        if (moduleToSave != null) {
            PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)moduleToSave);
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)moduleToSave);
            int i = 0;
            for (VirtualFile file2 : rootManager.getContentRoots()) {
                result2.add(i, SaveProjectAsTemplateAction.describeRoot(file2, i, macroManager));
                ++i;
            }
        } else {
            PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project);
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            int i = 0;
            for (VirtualFile file3 : rootManager.getContentRoots()) {
                result2.add(i, SaveProjectAsTemplateAction.describeRoot(file3, i, macroManager));
                ++i;
            }
        }
        return result2;
    }

    private static LocalArchivedTemplate.RootDescription describeRoot(VirtualFile root, int rootIndex, PathMacroManager pathMacroManager) {
        return new LocalArchivedTemplate.RootDescription(root, SaveProjectAsTemplateAction.getRelativePath(pathMacroManager, root), rootIndex);
    }

    private static String getRelativePath(PathMacroManager pathMacroManager, VirtualFile moduleRoot) {
        String path = pathMacroManager.collapsePath(moduleRoot.getPath());
        path = StringUtil.trimStart((String)path, (String)"$PROJECT_DIR$");
        path = StringUtil.trimStart((String)path, (String)"$MODULE_DIR$");
        path = StringUtil.trimStart((String)path, (String)"/");
        return path;
    }

    public static String convertTemplates(String input, Pattern pattern, String template, boolean shouldEscape) {
        int start2;
        Matcher matcher = pattern.matcher(input);
        int n = start2 = matcher.matches() ? matcher.start(1) : -1;
        if (!shouldEscape) {
            if (start2 == -1) {
                return input;
            }
            return input.substring(0, start2) + FILE_HEADER_TEMPLATE_PLACEHOLDER + input.substring(matcher.end(1));
        }
        StringBuilder builder2 = new StringBuilder(input.length() + 10);
        for (int i = 0; i < input.length(); ++i) {
            char c;
            if (start2 == i) {
                builder2.append(template);
                i = matcher.end(1);
            }
            if ((c = input.charAt(i)) == '$') {
                builder2.append("#[[\\$]]#");
                continue;
            }
            if (c == '#') {
                builder2.append('\\');
            }
            builder2.append(c);
        }
        return builder2.toString();
    }

    private static String getInputFieldsText(Map<String, String> parameters) {
        Element element = new Element("template");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            Element field = new Element("input-field");
            field.setText(entry.getValue());
            field.setAttribute("default", entry.getKey());
            element.addContent(field);
        }
        return JDOMUtil.writeElement((Element)element);
    }

    private static String getTemplateMetaText(boolean shouldEncode, List<LocalArchivedTemplate.RootDescription> roots) {
        Element element = new Element("template");
        element.setAttribute("unencoded", String.valueOf(!shouldEncode));
        LocalArchivedTemplate.RootDescription.writeRoots(element, roots);
        return JDOMUtil.writeElement((Element)element);
    }

    private static boolean shouldEscape() {
        return !PlatformUtils.isPhpStorm();
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = SaveProjectAsTemplateAction.getEventProject((AnActionEvent)e);
        e.getPresentation().setEnabled(project != null && !project.isDefault());
    }

    private static class MyContentIterator
    implements ContentIterator {
        private final ProgressIndicator myIndicator;
        private VirtualFile myRootDir;
        private String myPrefix;
        private final ZipOutputStream myFinalStream;
        private final Project myProject;
        private final Map<String, String> myParameters;
        private final boolean myShouldEscape;

        MyContentIterator(ProgressIndicator indicator, ZipOutputStream finalStream, Project project, Map<String, String> parameters, boolean shouldEscape) {
            this.myIndicator = indicator;
            this.myFinalStream = finalStream;
            this.myProject = project;
            this.myParameters = parameters;
            this.myShouldEscape = shouldEscape;
        }

        public void setRootAndPrefix(VirtualFile root, String prefix) {
            this.myRootDir = root;
            this.myPrefix = prefix;
        }

        public boolean processFile(final @NotNull VirtualFile virtualFile) {
            if (!virtualFile.isDirectory()) {
                String fileName2 = virtualFile.getName();
                this.myIndicator.setText2(fileName2);
                try {
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)this.myRootDir, (char)'/');
                    if (relativePath == null) {
                        throw new RuntimeException("Can't find relative path for " + virtualFile + " in " + this.myRootDir);
                    }
                    boolean system = ".idea".equals(virtualFile.getParent().getName());
                    if (!(!system || fileName2.equals("description.html") || fileName2.equals(SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML) || fileName2.equals("template-meta.xml") || fileName2.equals("misc.xml") || fileName2.equals("modules.xml") || fileName2.equals("workspace.xml") || fileName2.endsWith(".iml"))) {
                        return true;
                    }
                    ZipUtil.addFileToZip((ZipOutputStream)this.myFinalStream, (File)new File(virtualFile.getPath()), (String)(this.myPrefix + "/" + relativePath), null, null, (ZipUtil.FileContentProcessor)new ZipUtil.FileContentProcessor(){

                        public InputStream getContent(@NotNull File file2) throws IOException {
                            if (virtualFile.getFileType().isBinary() || SaveProjectAsTemplateAction.PROJECT_TEMPLATE_XML.equals(virtualFile.getName())) {
                                return STANDARD.getContent(file2);
                            }
                            String result2 = SaveProjectAsTemplateAction.getEncodedContent(virtualFile, myProject, myParameters, SaveProjectAsTemplateAction.getFileHeaderTemplateName(), myShouldEscape);
                            return new ByteArrayInputStream(result2.getBytes(StandardCharsets.UTF_8));
                        }
                    }, (boolean)false);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            this.myIndicator.checkCanceled();
            return true;
        }
    }
}

